/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.project;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.bridge.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectCreator {
    private static final String Sun = "SunStudio";
    private static final String GNU = "GNU";
    private static final String MAKEFILE_NAME = "Makefile";
    private static final String TYPE = "org.netbeans.modules.cnd.makeproject";
    private static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/make-project/1";
    private String workingDir;
    private String buildCommand;
    private String cleanCommand;
    private String output;
    private String makefileName = "Makefile";
    private List<File> sourceFiles;
    private List<String> requiredProjects;
    private String makefilePath;
    private String projectFolder;
    private String baseDir;
    private String buildScript;
    private Folder rootFolder;
    private DiscoveryDescriptor discovery;

    public ProjectCreator(DiscoveryDescriptor discovery) {
        this.discovery = discovery;
    }

    public void init(String newProjectFolder, String newWorkingDir, String newMakefilePath, String buildScript) {
        this.projectFolder = newProjectFolder;
        this.workingDir = newWorkingDir;
        this.makefilePath = newMakefilePath;
        this.buildScript = buildScript;
    }

    public void setBuildCommand(String com) {
        this.buildCommand = com;
    }

    public void setCleanCommand(String com) {
        this.cleanCommand = com;
    }

    public void setOutput(String out) {
        this.output = out;
    }

    public void setSourceFiles(List<File> p) {
        this.sourceFiles = p;
    }

    public void setRequiredProjects(List<String> p) {
        this.requiredProjects = p;
    }

    public List<String> getProjectLevelInludes() {
        return Collections.emptyList();
    }

    public List<String> getProjectLevelMacros() {
        return Collections.emptyList();
    }

    public AntProjectHelper createProject(String name, String displayName, Set<String> folders, Set<String> libs) throws IOException {
        File dirF = CndFileUtils.createLocalFile((String)this.projectFolder);
        if (dirF != null) {
            dirF = CndFileUtils.normalizeFile((File)dirF);
        }
        String target = "Default";
        MakeConfiguration extConf = new MakeConfiguration(dirF.getPath(), target, 0, "localhost");
        String workingDirRel = CndPathUtilitities.toRelativePath((String)dirF.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.workingDir));
        workingDirRel = CndPathUtilitities.normalizeSlashes((String)workingDirRel);
        extConf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(workingDirRel);
        if (displayName.indexOf(".lib.") > 0 || displayName.indexOf(".cmd.") > 0) {
            extConf.getMakefileConfiguration().getBuildCommand().setValue("bldenv -d ../../../../" + this.buildScript + " 'dmake all'");
            extConf.getMakefileConfiguration().getCleanCommand().setValue("bldenv -d ../../../../" + this.buildScript + " 'dmake clobber'");
        } else {
            extConf.getMakefileConfiguration().getBuildCommand().setValue("bldenv -d ../../../" + this.buildScript + " 'dmake all'");
            extConf.getMakefileConfiguration().getCleanCommand().setValue("bldenv -d ../../../" + this.buildScript + " 'dmake clobber'");
        }
        extConf.getMakefileConfiguration().getOutput().setValue(this.output);
        if (this.requiredProjects != null) {
            for (String sub : this.requiredProjects) {
                extConf.getRequiredProjectsConfiguration().add((Object)new LibraryItem.ProjectItem(new MakeArtifact(sub, 0, "Default", true, false, sub, "${MAKE}  -f " + sub + "-Makefile.mk CONF=Default", "${MAKE}  -f " + sub + "-Makefile.mk CONF=Default clean", "", extConf)));
            }
        }
        if (Utilities.getOperatingSystem() == 8) {
            extConf.getCompilerSet().setCompilerSetName(new StringConfiguration(null, Sun));
        } else {
            extConf.getCompilerSet().setCompilerSetName(new StringConfiguration(null, GNU));
        }
        extConf.getCCCompilerConfiguration().getIncludeDirectories().setValue(this.getProjectLevelInludes());
        extConf.getCCompilerConfiguration().getIncludeDirectories().setValue(this.getProjectLevelInludes());
        extConf.getCCCompilerConfiguration().getPreprocessorConfiguration().setValue(this.getProjectLevelMacros());
        extConf.getCCompilerConfiguration().getPreprocessorConfiguration().setValue(this.getProjectLevelMacros());
        Iterator<String> importantItemsIterator = null;
        if (this.makefilePath != null && this.makefilePath.length() > 0) {
            ArrayList<String> importantItems = new ArrayList<String>();
            this.makefilePath = CndPathUtilitities.toRelativePath((String)dirF.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.makefilePath));
            this.makefilePath = CndPathUtilitities.normalizeSlashes((String)this.makefilePath);
            importantItems.add(this.makefilePath);
            importantItemsIterator = importantItems.iterator();
        }
        Iterator<File> it = null;
        if (this.sourceFiles != null) {
            it = this.sourceFiles.iterator();
        }
        AntProjectHelper h1 = null;
        this.makefileName = name + "-" + this.makefileName + ".mk";
        h1 = this.createProject(dirF, displayName, this.makefileName, (Configuration[])new MakeConfiguration[]{extConf}, it, importantItemsIterator, folders, libs);
        return h1;
    }

    public AntProjectHelper createProject(File dir, String displayName, String makefileName, Configuration[] confs, Iterator<File> sourceFiles, Iterator<String> importantItems, Set<String> folders, Set<String> libs) throws IOException {
        FileObject dirFO = ProjectCreator.createProjectDir(dir);
        AntProjectHelper h = this.createProject(dirFO, displayName, makefileName, confs, sourceFiles, importantItems);
        Project p = ProjectManager.getDefault().findProject(dirFO);
        boolean successful = this.applyDiscovery(p, displayName, folders, libs);
        ProjectManager.getDefault().saveProject(p);
        if (!successful) {
            this.removeProjectDir(dir);
            return null;
        }
        ProjectManager.getDefault().clearNonProjectCache();
        return h;
    }

    private AntProjectHelper createProject(FileObject dirFO, String displayName, String makefileName, Configuration[] confs, Iterator<File> sourceFiles, Iterator<String> importantItems) throws IOException {
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)TYPE);
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS(PROJECT_CONFIGURATION_NAMESPACE, "name");
        nameEl.appendChild(doc.createTextNode(displayName));
        data.appendChild(nameEl);
        Element nativeProjectType = doc.createElementNS(PROJECT_CONFIGURATION_NAMESPACE, "make-project-type");
        nativeProjectType.appendChild(doc.createTextNode("0"));
        data.appendChild(nativeProjectType);
        h.putPrimaryConfigurationData(data, true);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        h.putProperties("nbproject/project.properties", ep);
        ep = h.getProperties("nbproject/private/private.properties");
        h.putProperties("nbproject/private/private.properties", ep);
        MakeConfigurationDescriptor projectDescriptor = new MakeConfigurationDescriptor(dirFO);
        projectDescriptor.setState(ConfigurationDescriptor.State.READY);
        projectDescriptor.setProjectMakefileName(makefileName);
        projectDescriptor.init(confs);
        this.baseDir = projectDescriptor.getBaseDir();
        projectDescriptor.initLogicalFolders(null, false, null, importantItems, null, false);
        this.rootFolder = projectDescriptor.getLogicalFolders();
        projectDescriptor.addSourceRootRaw(CndPathUtilitities.toRelativePath((String)this.baseDir, (String)this.workingDir));
        this.addFiles(sourceFiles);
        projectDescriptor.save();
        this.copyURLFile("/org/netbeans/modules/cnd/makeproject/resources/MasterMakefile", projectDescriptor.getBaseDir() + File.separator + projectDescriptor.getProjectMakefileName());
        return h;
    }

    private boolean applyDiscovery(Project project, String displayName, Set<String> folders, Set<String> libs) throws IOException {
        this.discovery.setProject(project);
        new DiscoveryProjectGenerator(this.discovery).process();
        this.createAdditionalRequiredProjects(project, displayName, folders, libs);
        return true;
    }

    private void addFiles(Iterator<File> filelist) {
        if (filelist == null) {
            return;
        }
        while (filelist.hasNext()) {
            File f = filelist.next();
            String path = CndPathUtilitities.toRelativePath((String)this.workingDir, (String)f.getPath());
            StringTokenizer tok = new StringTokenizer(path, File.separator);
            String relativePath = CndPathUtilitities.toRelativePath((String)this.baseDir, (String)f.getPath());
            this.addFile(this.rootFolder, tok, f.getPath(), relativePath);
        }
    }

    private void addFile(Folder fld, StringTokenizer tok, String path, String relativePath) {
        if (tok.countTokens() == 1) {
            String t = path.substring(0, path.lastIndexOf(File.separator));
            String name = t.substring(t.lastIndexOf(File.separator) + 1);
            Folder top = null;
            top = fld.findFolderByName(name);
            if (top == null) {
                top = new Folder(fld.getConfigurationDescriptor(), fld, name, name, true, null);
                fld.addFolder(top, true);
            }
            fld = top;
        }
        while (tok.hasMoreElements()) {
            String part = tok.nextToken();
            if (part.contains(":") || part.equals("..")) continue;
            if (part.contains(".")) {
                fld.addItem(new Item(relativePath));
                continue;
            }
            Folder top = null;
            top = fld.findFolderByName(part);
            if (top == null) {
                top = new Folder(fld.getConfigurationDescriptor(), fld, part, part, true, null);
                fld.addFolder(top, true);
            }
            fld = top;
        }
    }

    private void copyURLFile(String resource, String toFile) throws IOException {
        String fromURL = "nbresloc:" + resource;
        InputStream is = null;
        try {
            URL url = new URL(fromURL);
            is = url.openStream();
        }
        catch (Exception e) {
            is = MakeConfigurationDescriptor.class.getResourceAsStream(resource);
        }
        if (is != null) {
            FileOutputStream os = new FileOutputStream(toFile);
            FileUtil.copy((InputStream)is, (OutputStream)os);
            is.close();
            os.close();
        }
    }

    static FileObject createProjectDir(File dir) throws IOException {
        FileObject dirFO = CndFileUtils.toFileObject((File)dir);
        if (!(dirFO != null && dirFO.isValid() || dir.exists())) {
            ProjectCreator.refreshFileSystem(dir);
            if (!dir.mkdirs()) {
                throw new IOException("Can not create project folder.");
            }
            ProjectCreator.refreshFileSystem(dir);
        }
        dirFO = CndFileUtils.toFileObject((File)dir);
        assert (dirFO != null) : "No such dir on disk: " + dir;
        assert (dirFO.isValid()) : "No such dir on disk: " + dir;
        assert (dirFO.isFolder()) : "Not really a dir: " + dir;
        return dirFO;
    }

    static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File rootF = dir;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        FileObject dirFO = CndFileUtils.toFileObject((File)rootF);
        assert (dirFO != null) : "At least disk roots must be mounted! " + rootF;
        assert (dirFO.isValid()) : "At least disk roots must be mounted! " + rootF;
        dirFO.getFileSystem().refresh(false);
    }

    private void createAdditionalRequiredProjects(Project project, String displayName, Set<String> folders, Set<String> libraries) {
        if (displayName.indexOf(".sources") > 0 || displayName.indexOf(".libraries") > 0 || displayName.indexOf(".uts") > 0 || displayName.indexOf(".commands") > 0) {
            return;
        }
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        MakeConfiguration conf = makeConfigurationDescriptor.getActiveConfiguration();
        String name = displayName;
        if (displayName.indexOf(46) > 0) {
            name = displayName.substring(displayName.lastIndexOf(46) + 1);
        }
        HashSet<String> libs = new HashSet<String>();
        if (name.equals("libc")) {
            libraries.remove("c");
        } else {
            libraries.add("c");
        }
        for (String lib : libraries) {
            int i;
            lib = "lib" + lib;
            String folder = null;
            for (String f : folders) {
                if (!f.endsWith("/" + lib)) continue;
                folder = f;
                break;
            }
            if (folder == null) continue;
            String[] prj = this.workingDir.substring(this.workingDir.indexOf("/usr/src/") + 9).split("/");
            String[] lbr = folder.split("/");
            int start = 0;
            for (int i2 = 0; i2 < prj.length && prj[i2].equals(lbr[i2]); ++i2) {
                ++start;
            }
            StringBuilder res = new StringBuilder();
            for (i = start; i < prj.length; ++i) {
                res.append("../");
            }
            for (i = start; i < lbr.length; ++i) {
                if (res.length() == 0 || res.charAt(res.length() - 1) != '/') {
                    res.append('/');
                }
                res.append(lbr[i]);
            }
            libs.add(res.toString());
        }
        for (String sub : libs) {
            makeConfigurationDescriptor.setModified();
            conf.getRequiredProjectsConfiguration().add((Object)new LibraryItem.ProjectItem(new MakeArtifact(sub, 0, "Default", true, false, sub, "${MAKE}  -f " + sub + "-Makefile.mk CONF=Default", "${MAKE}  -f " + sub + "-Makefile.mk CONF=Default clean", "", conf)));
        }
        makeConfigurationDescriptor.save();
    }

    private void removeProjectDir(File dir) {
        if (dir.exists() && dir.canRead() && dir.isDirectory()) {
            File[] ff = dir.listFiles();
            if (ff != null) {
                for (File file : ff) {
                    if (!file.isDirectory()) continue;
                    this.removeProjectDir(file);
                }
            }
            if ((ff = dir.listFiles()) != null) {
                for (File file : ff) {
                    file.delete();
                }
            }
            dir.delete();
        }
    }
}

