/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.makeproject.api.ui.BrokenIncludes;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FollowUp
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(FollowUp.class.getName(), 2);
    private CsmProject csmProject;
    private JLabel codeAssistance;
    private JLabel configureDone;
    private JLabel details;
    private JScrollPane detailsPane;
    private JTextPane detailsTextPane;
    private JLabel make;
    private JLabel makeClean;
    private JLabel projectCreated;

    private FollowUp(ImportProject importProject, NativeProject nativeProject) {
        this.initComponents();
        this.details.setVisible(false);
        this.detailsPane.setVisible(false);
        Map<ImportProject.Step, ImportProject.State> map = importProject.getImportResult();
        this.showState(ImportProject.Step.Project, map.get((Object)ImportProject.Step.Project), this.projectCreated);
        this.showState(ImportProject.Step.Configure, map.get((Object)ImportProject.Step.Configure), this.configureDone);
        this.showState(ImportProject.Step.MakeClean, map.get((Object)ImportProject.Step.MakeClean), this.makeClean);
        this.showState(ImportProject.Step.Make, map.get((Object)ImportProject.Step.Make), this.make);
        this.showCodeAssistanceState(map, nativeProject);
        CsmModel csmModel = CsmModelAccessor.getModel();
        if (csmModel != null && nativeProject != null) {
            this.csmProject = csmModel.getProject((Object)nativeProject);
            this.initDetails();
        }
    }

    private void showState(ImportProject.Step step, ImportProject.State state, JLabel jLabel) {
        if (state == null) {
            jLabel.setVisible(false);
            return;
        }
        switch (state) {
            case Successful: {
                break;
            }
            case Fail: {
                switch (step) {
                    case Project: {
                        jLabel.setText(FollowUp.getString("ProjectCreatedFailedText", new String[0]));
                        break;
                    }
                    case Configure: {
                        jLabel.setText(FollowUp.getString("ConfigureFailedText", new String[0]));
                        break;
                    }
                    case MakeClean: {
                        jLabel.setText(FollowUp.getString("MakeCleanFailedText", new String[0]));
                        break;
                    }
                    case Make: {
                        jLabel.setText(FollowUp.getString("MakeFailedText", new String[0]));
                    }
                }
                jLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/error.png")));
                break;
            }
            case Skiped: {
                jLabel.setVisible(false);
            }
        }
    }

    private void showCodeAssistanceState(Map<ImportProject.Step, ImportProject.State> map, NativeProject nativeProject) {
        if (FollowUp.hasBrokenIncludes(nativeProject)) {
            this.codeAssistance.setText(FollowUp.getString("CodeAssistanceFailedText", new String[0]));
            this.codeAssistance.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/error.png")));
        } else {
            ImportProject.State state = map.get((Object)ImportProject.Step.Make);
            if (state == ImportProject.State.Fail) {
                this.codeAssistance.setText(FollowUp.getString("CodeAssistanceInfoText", new String[0]));
                this.codeAssistance.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/info.png")));
            }
        }
    }

    private static boolean hasBrokenIncludes(NativeProject nativeProject) {
        BrokenIncludes brokenIncludes = (BrokenIncludes)Lookup.getDefault().lookup(BrokenIncludes.class);
        if (brokenIncludes != null) {
            return brokenIncludes.isBroken(nativeProject);
        }
        return false;
    }

    private void initDetails() {
        Object object = this.csmProject.getPlatformProject();
        if (object instanceof NativeProject) {
            NativeProject nativeProject = (NativeProject)object;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (NativeFileItem nativeFileItem : nativeProject.getAllFiles()) {
                switch (nativeFileItem.getLanguage()) {
                    case C: 
                    case CPP: {
                        ++n;
                        if (!nativeFileItem.isExcluded()) break;
                        ++n2;
                        break;
                    }
                    case C_HEADER: {
                        ++n3;
                        if (!nativeFileItem.isExcluded()) break;
                        ++n4;
                    }
                }
            }
            String string = MessageFormat.format(FollowUp.getString("Details.String", new String[0]), n2, n, n4, n3);
            this.detailsTextPane.setContentType("text/html");
            this.detailsTextPane.setText(string);
            this.details.setVisible(true);
            this.detailsPane.setVisible(true);
        }
    }

    public static void showFollowUp(final ImportProject importProject, final NativeProject nativeProject) {
        ImportProject.State state;
        ImageIcon imageIcon;
        String string;
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (importProject.isProjectOpened()) {
                    FollowUp followUp = new FollowUp(importProject, nativeProject);
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)followUp, FollowUp.getString("Dialog_Title", new String[0]), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                    try {
                        dialog.setVisible(true);
                    }
                    catch (Throwable throwable) {
                        if (!(throwable.getCause() instanceof InterruptedException)) {
                            throw new RuntimeException(throwable);
                        }
                        dialogDescriptor.setValue(DialogDescriptor.CANCEL_OPTION);
                    }
                    finally {
                        dialog.dispose();
                    }
                }
            }
        };
        if (FollowUp.hasBrokenIncludes(nativeProject)) {
            string = FollowUp.getString("Configure_Fail", new String[0]);
            imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/discovery/wizard/resources/info.png", (boolean)false);
        } else {
            state = importProject.getImportResult().get((Object)ImportProject.Step.Make);
            if (state == ImportProject.State.Fail) {
                string = FollowUp.getString("Configure_Info", new String[0]);
                imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/discovery/wizard/resources/info.png", (boolean)false);
            } else {
                string = FollowUp.getString("Configure_Success", new String[0]);
                imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/discovery/wizard/resources/check.png", (boolean)false);
            }
        }
        state = NotificationDisplayer.getDefault().notify(string, (Icon)imageIcon, FollowUp.getString("Dialog_Action", new String[0]), actionListener, NotificationDisplayer.Priority.HIGH);
        RP.post(new Runnable((Notification)state){
            final /* synthetic */ Notification val$notification;
            {
                this.val$notification = notification;
            }

            @Override
            public void run() {
                this.val$notification.clear();
            }
        }, 15000);
    }

    private void initComponents() {
        this.projectCreated = new JLabel();
        this.configureDone = new JLabel();
        this.makeClean = new JLabel();
        this.make = new JLabel();
        this.codeAssistance = new JLabel();
        this.detailsPane = new JScrollPane();
        this.detailsTextPane = new JTextPane();
        this.details = new JLabel();
        this.setEnabled(false);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(320, 280));
        this.setLayout(new GridBagLayout());
        this.projectCreated.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/check.png")));
        this.projectCreated.setText(NbBundle.getMessage(FollowUp.class, (String)"ProjectCreatedText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.projectCreated, gridBagConstraints);
        this.configureDone.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/check.png")));
        this.configureDone.setText(NbBundle.getMessage(FollowUp.class, (String)"ConfigureDoneText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 10);
        this.add((Component)this.configureDone, gridBagConstraints);
        this.makeClean.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/check.png")));
        this.makeClean.setText(NbBundle.getMessage(FollowUp.class, (String)"MakeCleanText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 10);
        this.add((Component)this.makeClean, gridBagConstraints);
        this.make.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/check.png")));
        this.make.setText(NbBundle.getMessage(FollowUp.class, (String)"MakeText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 10);
        this.add((Component)this.make, gridBagConstraints);
        this.codeAssistance.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/check.png")));
        this.codeAssistance.setText(NbBundle.getMessage(FollowUp.class, (String)"CodeAssistanceText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 10, 10);
        this.add((Component)this.codeAssistance, gridBagConstraints);
        this.detailsPane.setBorder(null);
        this.detailsPane.setOpaque(false);
        this.detailsPane.setPreferredSize(new Dimension(100, 100));
        this.detailsTextPane.setEditable(false);
        this.detailsTextPane.setOpaque(false);
        this.detailsPane.setViewportView(this.detailsTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.detailsPane, gridBagConstraints);
        this.details.setLabelFor(this.detailsTextPane);
        this.details.setText(NbBundle.getMessage(FollowUp.class, (String)"FollowUp.details.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.details, gridBagConstraints);
    }

    private static String getString(String string, String ... stringArray) {
        return NbBundle.getMessage(FollowUp.class, (String)string, (Object[])stringArray);
    }
}

