/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.actions.CMakeAction;
import org.netbeans.modules.cnd.actions.MakeAction;
import org.netbeans.modules.cnd.actions.QMakeAction;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.builds.CMakeExecSupport;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.builds.QMakeExecSupport;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.projectimport.FollowUp;
import org.netbeans.modules.cnd.discovery.projectimport.ImportExecutable;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationPanel;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.bridge.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.discovery.wizard.bridge.ProjectBridge;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.remote.api.RfsListener;
import org.netbeans.modules.cnd.remote.api.RfsListenerSupport;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ImportProject
implements PropertyChangeListener {
    private static boolean TRACE = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.discovery.projectimport.ImportProject");
    private static final RequestProcessor RP = new RequestProcessor(ImportProject.class.getName(), 2);
    private String nativeProjectPath;
    private FileObject nativeProjectFO;
    private File projectFolder;
    private String projectName;
    private String makefilePath;
    private String configurePath;
    private String configureRunFolder;
    private String configureArguments;
    private boolean runConfigure = false;
    private boolean manualCA = false;
    private boolean buildArifactWasAnalyzed = false;
    private boolean setAsMain;
    private final String hostUID;
    private final ExecutionEnvironment executionEnvironment;
    private final ExecutionEnvironment fileSystemExecutionEnvironment;
    private final boolean fullRemote;
    private final MakeProjectOptions.PathMode pathMode;
    private CompilerSet toolchain;
    private boolean defaultToolchain;
    private String workingDir;
    private String buildCommand = "${MAKE} -f Makefile";
    private String cleanCommand = "${MAKE} -f Makefile clean";
    private String buildResult = "";
    private Project makeProject;
    private boolean runMake;
    private String includeDirectories = "";
    private String macros = "";
    private String consolidationStrategy = "file";
    private Iterator<SourceFolderInfo> sources;
    private Iterator<SourceFolderInfo> tests;
    private String sourceFoldersFilter = null;
    private FileObject configureFileObject;
    private Map<Step, State> importResult = new EnumMap<Step, State>(Step.class);
    private static final String configureCteatePattern = " creating ";
    private boolean isFinished = false;
    private boolean isUILessMode = false;
    private File configureLog = null;
    private File makeLog = null;
    private Map<String, Item> normalizedItems;
    private static final Map<CsmProject, CsmProgressListener> listeners = new WeakHashMap<CsmProject, CsmProgressListener>();

    public ImportProject(WizardDescriptor wizardDescriptor) {
        Boolean bl;
        if (TRACE) {
            logger.setLevel(Level.ALL);
        }
        this.fullRemote = (bl = (Boolean)wizardDescriptor.getProperty("fullRemote")) == null ? false : bl;
        MakeProjectOptions.PathMode pathMode = this.pathMode = this.fullRemote ? MakeProjectOptions.PathMode.ABS : MakeProjectOptions.getPathMode();
        if (Boolean.TRUE.equals(wizardDescriptor.getProperty("simpleMode"))) {
            this.simpleSetup(wizardDescriptor);
        } else {
            this.customSetup(wizardDescriptor);
        }
        this.hostUID = (String)wizardDescriptor.getProperty("hostUID");
        this.executionEnvironment = this.hostUID == null ? ServerList.getDefaultRecord().getExecutionEnvironment() : ExecutionEnvironmentFactory.fromUniqueID((String)this.hostUID);
        ExecutionEnvironment executionEnvironment = this.fileSystemExecutionEnvironment = this.fullRemote ? this.executionEnvironment : ExecutionEnvironmentFactory.getLocal();
        assert (this.nativeProjectPath != null);
    }

    private void simpleSetup(WizardDescriptor wizardDescriptor) {
        this.projectFolder = (File)wizardDescriptor.getProperty("projdir");
        this.nativeProjectPath = (String)wizardDescriptor.getProperty("nativeProjDir");
        this.nativeProjectFO = (FileObject)wizardDescriptor.getProperty("nativeProjFO");
        this.projectName = this.projectFolder.getName();
        this.workingDir = this.nativeProjectPath;
        this.configurePath = (String)wizardDescriptor.getProperty("configureName");
        if (this.configurePath != null) {
            this.configureArguments = (String)wizardDescriptor.getProperty("realFlags");
            this.runConfigure = true;
            this.makefilePath = (String)wizardDescriptor.getProperty("makefileName");
            if (this.makefilePath == null) {
                this.makefilePath = this.nativeProjectPath + "/Makefile";
            }
            this.configureRunFolder = (String)wizardDescriptor.getProperty("configureRunFolder");
        } else {
            this.makefilePath = (String)wizardDescriptor.getProperty("makefileName");
        }
        this.runMake = Boolean.TRUE.equals(wizardDescriptor.getProperty("buildProject"));
        this.setAsMain = Boolean.TRUE.equals(wizardDescriptor.getProperty("setMain"));
        this.toolchain = (CompilerSet)wizardDescriptor.getProperty("toolchain");
        this.defaultToolchain = Boolean.TRUE.equals(wizardDescriptor.getProperty("toolchainDefault"));
        ArrayList<1> arrayList = new ArrayList<1>();
        arrayList.add(new SourceFolderInfo(){

            public FileObject getFileObject() {
                return ImportProject.this.nativeProjectFO;
            }

            public String getFolderName() {
                return ImportProject.this.nativeProjectFO.getNameExt();
            }

            public boolean isAddSubfoldersSelected() {
                return true;
            }
        });
        this.sources = arrayList.iterator();
        this.sourceFoldersFilter = "^(nbproject)$";
    }

    private void customSetup(WizardDescriptor wizardDescriptor) {
        Iterator iterator;
        Iterator iterator2;
        this.projectFolder = (File)wizardDescriptor.getProperty("projdir");
        this.nativeProjectPath = (String)wizardDescriptor.getProperty("nativeProjDir");
        this.nativeProjectFO = (FileObject)wizardDescriptor.getProperty("nativeProjFO");
        this.projectFolder = (File)wizardDescriptor.getProperty("projdir");
        this.projectName = (String)wizardDescriptor.getProperty("name");
        this.workingDir = (String)wizardDescriptor.getProperty("buildCommandWorkingDirTextField");
        this.buildCommand = (String)wizardDescriptor.getProperty("buildCommandTextField");
        this.cleanCommand = (String)wizardDescriptor.getProperty("cleanCommandTextField");
        this.buildResult = (String)wizardDescriptor.getProperty("outputTextField");
        this.includeDirectories = (String)wizardDescriptor.getProperty("includeTextField");
        this.macros = (String)wizardDescriptor.getProperty("macroTextField");
        this.makefilePath = (String)wizardDescriptor.getProperty("makefileName");
        this.configurePath = (String)wizardDescriptor.getProperty("configureName");
        this.configureRunFolder = (String)wizardDescriptor.getProperty("configureRunFolder");
        this.configureArguments = (String)wizardDescriptor.getProperty("configureArguments");
        this.runConfigure = "true".equals(wizardDescriptor.getProperty("runConfigure"));
        this.consolidationStrategy = (String)wizardDescriptor.getProperty("consolidationLevel");
        this.sources = iterator2 = (Iterator)wizardDescriptor.getProperty("sourceFolders");
        this.tests = iterator = (Iterator)wizardDescriptor.getProperty("testFolders");
        this.sourceFoldersFilter = (String)wizardDescriptor.getProperty("sourceFoldersFilter");
        this.runConfigure = "true".equals(wizardDescriptor.getProperty("runConfigure"));
        this.runMake = this.runConfigure ? true : "true".equals(wizardDescriptor.getProperty("makeProject"));
        this.manualCA = "true".equals(wizardDescriptor.getProperty("manualCA"));
        this.setAsMain = Boolean.TRUE.equals(wizardDescriptor.getProperty("setAsMain"));
        this.toolchain = (CompilerSet)wizardDescriptor.getProperty("toolchain");
        this.defaultToolchain = Boolean.TRUE.equals(wizardDescriptor.getProperty("toolchainDefault"));
    }

    public Set<FileObject> create() throws IOException {
        String string;
        Object object;
        Object object2;
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        this.projectFolder = CndFileUtils.normalizeFile((File)this.projectFolder);
        MakeConfiguration makeConfiguration = new MakeConfiguration(this.projectFolder.getPath(), "Default", 0, this.hostUID, this.toolchain, this.defaultToolchain);
        String string2 = this.fullRemote ? this.nativeProjectFO.getPath() : ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.workingDir), (MakeProjectOptions.PathMode)this.pathMode);
        string2 = CndPathUtilitities.normalizeSlashes((String)string2);
        makeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(string2);
        makeConfiguration.getMakefileConfiguration().getBuildCommand().setValue(this.buildCommand);
        makeConfiguration.getMakefileConfiguration().getCleanCommand().setValue(this.cleanCommand);
        if (this.buildResult != null && this.buildResult.length() > 0) {
            this.buildResult = ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.buildResult), (MakeProjectOptions.PathMode)this.pathMode);
            this.buildResult = CndPathUtilitities.normalizeSlashes((String)this.buildResult);
            makeConfiguration.getMakefileConfiguration().getOutput().setValue(this.buildResult);
        }
        if (this.includeDirectories != null && this.includeDirectories.length() > 0) {
            object2 = new StringTokenizer(this.includeDirectories, ";");
            object = new ArrayList();
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string = ((StringTokenizer)object2).nextToken();
                string = CndPathUtilitities.toRelativePath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)string));
                string = CndPathUtilitities.normalizeSlashes((String)string);
                object.add(string);
            }
            makeConfiguration.getCCompilerConfiguration().getIncludeDirectories().setValue(object);
            makeConfiguration.getCCCompilerConfiguration().getIncludeDirectories().setValue(new ArrayList(object));
        }
        if (this.macros != null && this.macros.length() > 0) {
            object2 = new StringTokenizer(this.macros, "; ");
            object = new ArrayList<String>();
            while (((StringTokenizer)object2).hasMoreTokens()) {
                ((ArrayList)object).add(((StringTokenizer)object2).nextToken());
            }
            makeConfiguration.getCCompilerConfiguration().getPreprocessorConfiguration().getValue().addAll(object);
            makeConfiguration.getCCCompilerConfiguration().getPreprocessorConfiguration().getValue().addAll(object);
        }
        object2 = new ArrayList();
        if (this.makefilePath != null && this.makefilePath.length() > 0) {
            if (this.fullRemote) {
                CndUtils.assertAbsolutePathInConsole((String)this.makefilePath);
            } else {
                this.makefilePath = ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.makefilePath), (MakeProjectOptions.PathMode)this.pathMode);
                this.makefilePath = CndPathUtilitities.normalizeSlashes((String)this.makefilePath);
            }
        }
        if (this.configurePath != null && this.configurePath.length() > 0) {
            object = RemoteFileUtil.normalizeAbsolutePath((String)this.configurePath, (ExecutionEnvironment)this.fileSystemExecutionEnvironment);
            this.configureFileObject = RemoteFileUtil.getFileObject((String)object, (ExecutionEnvironment)this.fileSystemExecutionEnvironment);
            this.configurePath = ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.configurePath), (MakeProjectOptions.PathMode)this.pathMode);
            this.configurePath = CndPathUtilitities.normalizeSlashes((String)this.configurePath);
            ((ArrayList)object2).add(this.configurePath);
        }
        if (!(object = ((ArrayList)object2).iterator()).hasNext()) {
            object = null;
        }
        string = new ProjectGenerator.ProjectParameters(this.projectName, this.projectFolder);
        string.setConfiguration(makeConfiguration).setSourceFolders(this.sources).setSourceFoldersFilter(this.sourceFoldersFilter).setTestFolders(this.tests).setImportantFiles((Iterator)object).setFullRemote(this.fullRemote).setHostUID(this.hostUID);
        if (this.makefilePath != null) {
            string.setMakefileName(this.makefilePath);
        } else {
            string.setMakefileName("");
        }
        this.makeProject = ProjectGenerator.createProject((ProjectGenerator.ProjectParameters)string);
        FileObject fileObject = CndFileUtils.toFileObject((File)this.projectFolder);
        this.importResult.put(Step.Project, State.Successful);
        this.switchModel(false);
        hashSet.add(fileObject);
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        return hashSet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("openProjects") && propertyChangeEvent.getNewValue() instanceof Project[]) {
            Project[] projectArray = (Project[])propertyChangeEvent.getNewValue();
            if (projectArray.length == 0) {
                return;
            }
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ImportProject.this.doWork();
                }
            });
        }
    }

    boolean isProjectOpened() {
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            if (project != this.makeProject) continue;
            return true;
        }
        return false;
    }

    private void doWork() {
        try {
            if (this.makeProject instanceof Runnable) {
                ((Runnable)this.makeProject).run();
            }
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
            configurationDescriptorProvider.getConfigurationDescriptor();
            if (configurationDescriptorProvider.gotDescriptor()) {
                if (this.runConfigure && this.configurePath != null && this.configurePath.length() > 0 && this.configureFileObject != null && this.configureFileObject.isValid()) {
                    this.postConfigure();
                } else if (this.runMake) {
                    this.makeProject(true, null);
                } else {
                    this.discovery(0, null);
                }
            } else {
                this.isFinished = true;
            }
        }
        catch (Throwable throwable) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)throwable);
        }
    }

    private File createTempFile(String string) {
        try {
            File file = File.createTempFile(string, ".log");
            file.deleteOnExit();
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void postConfigure() {
        try {
            Object object;
            ExecutionListener executionListener;
            if (!this.isProjectOpened()) {
                this.isFinished = true;
                return;
            }
            if (this.configureLog == null) {
                this.configureLog = this.createTempFile("configure");
            }
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(this.configureLog));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            DataObject dataObject = DataObject.find((FileObject)this.configureFileObject);
            Node node = dataObject.getNodeDelegate();
            String string = FileUtil.getMIMEType((FileObject)this.configureFileObject);
            if (this.configureArguments != null) {
                if ("text/sh".equals(string)) {
                    executionListener = (ShellExecSupport)node.getCookie(ShellExecSupport.class);
                    try {
                        FileObject fileObject;
                        executionListener.setArguments(new String[]{this.configureArguments});
                        object = ImportUtils.parseEnvironment((String)this.configureArguments);
                        executionListener.setEnvironmentVariables(object.toArray(new String[object.size()]));
                        if (this.configureRunFolder != null && (fileObject = this.mkDir(this.configureFileObject.getParent(), this.configureRunFolder)) != null) {
                            executionListener.setRunDirectory(fileObject.getPath());
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                } else if ("text/x-cmake".equals(string)) {
                    executionListener = (CMakeExecSupport)node.getCookie(CMakeExecSupport.class);
                    try {
                        object = ImportUtils.parseEnvironment((String)this.configureArguments);
                        FileObject fileObject = ImportUtils.quoteList((List)object).iterator();
                        while (fileObject.hasNext()) {
                            String string2 = (String)fileObject.next();
                            int n = this.configureArguments.indexOf(string2);
                            if (n < 0) continue;
                            this.configureArguments = this.configureArguments.substring(0, n) + this.configureArguments.substring(n + string2.length());
                        }
                        executionListener.setArguments(new String[]{this.configureArguments});
                        executionListener.setEnvironmentVariables(object.toArray(new String[object.size()]));
                        if (this.configureRunFolder != null && (fileObject = this.mkDir(this.configureFileObject.getParent(), this.configureRunFolder)) != null) {
                            executionListener.setRunDirectory(fileObject.getPath());
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                } else if ("text/x-qtproject".equals(string)) {
                    executionListener = (QMakeExecSupport)node.getCookie(QMakeExecSupport.class);
                    try {
                        executionListener.setArguments(new String[]{this.configureArguments});
                        if (this.configureRunFolder != null && (object = this.mkDir(this.configureFileObject.getParent(), this.configureRunFolder)) != null) {
                            executionListener.setRunDirectory(object.getPath());
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
            executionListener = new ExecutionListener(){
                private RfsListenerImpl listener;

                public void executionStarted(int n) {
                    if (ImportProject.this.executionEnvironment.isRemote()) {
                        this.listener = new RfsListenerImpl(ImportProject.this.executionEnvironment);
                        RfsListenerSupport.addListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                    }
                }

                public void executionFinished(int n) {
                    if (n == 0) {
                        ImportProject.this.importResult.put(Step.Configure, State.Successful);
                    } else {
                        ImportProject.this.importResult.put(Step.Configure, State.Fail);
                    }
                    if (this.listener != null) {
                        this.listener.download();
                        RfsListenerSupport.removeListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                    }
                    if (ImportProject.this.runMake && n == 0) {
                        ImportProject.this.makeProject(true, ImportProject.this.configureLog);
                    } else {
                        ImportProject.this.switchModel(true);
                        ImportProject.this.postModelDiscovery(true);
                    }
                }
            };
            if (TRACE) {
                logger.log(Level.INFO, "#{0} {1}", new Object[]{this.configureFileObject, this.configureArguments});
            }
            if ("text/sh".equals(string)) {
                object = ShellRunAction.performAction((Node)node, (ExecutionListener)executionListener, (Writer)bufferedWriter, (Project)this.makeProject, null);
                if (object == null) {
                    throw new Exception("Cannot execute configure script");
                }
            } else if ("text/x-cmake".equals(string)) {
                object = CMakeAction.performAction((Node)node, (ExecutionListener)executionListener, null, (Project)this.makeProject, null);
                if (object == null) {
                    throw new Exception("Cannot execute cmake");
                }
            } else if ("text/x-qtproject".equals(string)) {
                object = QMakeAction.performAction((Node)node, (ExecutionListener)executionListener, null, (Project)this.makeProject, null);
                if (object == null) {
                    throw new Exception("Cannot execute qmake");
                }
            } else {
                if (TRACE) {
                    logger.log(Level.INFO, "#Configure script does not supported");
                }
                this.importResult.put(Step.Configure, State.Fail);
                this.importResult.put(Step.MakeClean, State.Skiped);
                this.switchModel(true);
                this.postModelDiscovery(true);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            logger.log(Level.INFO, "Cannot configure project", dataObjectNotFoundException);
            this.isFinished = true;
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "Cannot configure project", throwable);
            this.isFinished = true;
        }
    }

    private FileObject mkDir(FileObject fileObject, String string) {
        if (string != null) {
            try {
                string = string.replace('\\', '/');
                for (String string2 : string.split("/")) {
                    FileObject fileObject2;
                    if (fileObject == null) {
                        return null;
                    }
                    if (string2.isEmpty() || ".".equals(string2)) continue;
                    fileObject = "..".equals(string2) ? fileObject.getParent() : ((fileObject2 = fileObject.getFileObject(string2, null)) != null ? fileObject2 : fileObject.createFolder(string2));
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
            return fileObject;
        }
        return null;
    }

    private void downloadRemoteFile(File file) {
        if (file != null && !file.exists() && this.executionEnvironment.isRemote()) {
            String string = HostInfoProvider.getMapper((ExecutionEnvironment)this.executionEnvironment).getRemotePath(file.getAbsolutePath());
            try {
                if (HostInfoUtils.fileExists((ExecutionEnvironment)this.executionEnvironment, (String)string)) {
                    Future future = CommonTasksSupport.downloadFile((String)string, (ExecutionEnvironment)this.executionEnvironment, (String)file.getAbsolutePath(), null);
                    if (TRACE) {
                        logger.log(Level.INFO, "#download file {0}", file.getAbsolutePath());
                    }
                    future.get();
                }
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (Throwable throwable) {
                Exceptions.printStackTrace((Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanConfigureLog(File file) {
        if (file != null && file.exists() && file.canRead()) {
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    int n = string.indexOf(configureCteatePattern);
                    if (n <= 0) continue;
                    String string2 = string.substring(n + configureCteatePattern.length()).trim();
                    this.downloadRemoteFile(CndFileUtils.createLocalFile((File)this.projectFolder, (String)string2));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void makeProject(boolean bl, File file) {
        block13: {
            if (!this.isProjectOpened()) {
                this.isFinished = true;
                return;
            }
            FileObject fileObject = null;
            if (this.makefilePath != null && this.makefilePath.length() > 0) {
                if (this.fullRemote) {
                    CndUtils.assertAbsolutePathInConsole((String)this.makefilePath);
                    fileObject = RemoteFileUtil.getFileObject((String)this.makefilePath, (ExecutionEnvironment)this.executionEnvironment);
                } else {
                    fileObject = CndFileUtils.toFileObject((CharSequence)CndPathUtilitities.toAbsolutePath((String)this.projectFolder.getAbsolutePath(), (String)this.makefilePath));
                }
            }
            if (!this.fullRemote) {
                this.downloadRemoteFile(CndFileUtils.createLocalFile((String)fileObject.getPath()));
                fileObject = CndFileUtils.toFileObject((CharSequence)CndPathUtilitities.toAbsolutePath((String)this.projectFolder.getAbsolutePath(), (String)this.makefilePath));
            }
            this.scanConfigureLog(file);
            if (fileObject != null && fileObject.isValid()) {
                try {
                    DataObject dataObject = DataObject.find(fileObject);
                    Node node = dataObject.getNodeDelegate();
                    if (bl) {
                        this.postClean(node);
                        break block13;
                    }
                    this.postMake(node);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    this.isFinished = true;
                }
            } else {
                String string = this.nativeProjectPath;
                File file2 = new File(string + "/Makefile");
                if (file2.exists() && file2.isFile() && file2.canRead()) {
                    this.makefilePath = file2.getAbsolutePath();
                } else {
                    file2 = new File(string + "/makefile");
                    if (file2.exists() && file2.isFile() && file2.canRead()) {
                        this.makefilePath = file2.getAbsolutePath();
                    }
                }
                this.switchModel(true);
                this.postModelDiscovery(true);
            }
        }
    }

    private void postClean(final Node node) {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        ExecutionListener executionListener = new ExecutionListener(){

            public void executionStarted(int n) {
            }

            public void executionFinished(int n) {
                if (n == 0) {
                    ImportProject.this.importResult.put(Step.MakeClean, State.Successful);
                } else {
                    ImportProject.this.importResult.put(Step.MakeClean, State.Fail);
                }
                ImportProject.this.postMake(node);
            }
        };
        String string = "";
        if (this.cleanCommand != null) {
            string = this.getArguments(this.cleanCommand);
        }
        if (string.length() == 0) {
            string = "clean";
        }
        if (TRACE) {
            logger.log(Level.INFO, "#make {0}", string);
        }
        try {
            Future future = MakeAction.execute((Node)node, (String)string, (ExecutionListener)executionListener, null, (Project)this.makeProject, null, null);
            if (future == null) {
                logger.log(Level.INFO, "Cannot execute make clean");
                this.isFinished = true;
            }
        }
        catch (Throwable throwable) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)throwable);
        }
    }

    private void postMake(Node node) {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        if (this.makeLog == null) {
            this.makeLog = this.createTempFile("make");
        }
        ExecutionListener executionListener = new ExecutionListener(){
            private RfsListenerImpl listener;

            public void executionStarted(int n) {
                if (ImportProject.this.executionEnvironment.isRemote()) {
                    this.listener = new RfsListenerImpl(ImportProject.this.executionEnvironment);
                    RfsListenerSupport.addListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                }
            }

            public void executionFinished(int n) {
                if (this.listener != null) {
                    this.listener.download();
                    RfsListenerSupport.removeListener((ExecutionEnvironment)ImportProject.this.executionEnvironment, (RfsListener)this.listener);
                }
                if (n == 0) {
                    ImportProject.this.importResult.put(Step.Make, State.Successful);
                } else {
                    ImportProject.this.importResult.put(Step.Make, State.Fail);
                }
                ImportProject.this.discovery(n, ImportProject.this.makeLog);
            }
        };
        BufferedWriter bufferedWriter = null;
        if (this.makeLog != null) {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(this.makeLog));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        String string = "";
        if (this.buildCommand != null) {
            string = this.getArguments(this.buildCommand);
        }
        ExecutionSupport executionSupport = (ExecutionSupport)node.getCookie(ExecutionSupport.class);
        List list = ImportUtils.parseEnvironment((String)this.configureArguments);
        if (executionSupport != null) {
            try {
                executionSupport.setEnvironmentVariables(list.toArray(new String[list.size()]));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (TRACE) {
            logger.log(Level.INFO, "#make {0}", string);
        }
        try {
            Future future = MakeAction.execute((Node)node, (String)string, (ExecutionListener)executionListener, (Writer)bufferedWriter, (Project)this.makeProject, (List)list, null);
            if (future == null) {
                logger.log(Level.INFO, "Cannot execute make");
                this.isFinished = true;
            }
        }
        catch (Throwable throwable) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)throwable);
        }
    }

    private String getArguments(String string) {
        String string2 = this._getArguments(string);
        int n = string2.indexOf("-f ");
        if (n >= 0) {
            String string3 = string2.substring(0, n);
            int n2 = (string2 = string2.substring(n + 3).trim()).indexOf(32);
            if (n2 < 0) {
                return string3;
            }
            return string3 + string2.substring(n2).trim();
        }
        return string2;
    }

    private String _getArguments(String string) {
        if (string.startsWith("\"")) {
            int n = string.indexOf(34, 1);
            if (n > 0) {
                return string.substring(n).trim();
            }
            return "";
        }
        if (string.startsWith("'")) {
            int n = string.indexOf(39, 1);
            if (n > 0) {
                return string.substring(n).trim();
            }
            return "";
        }
        int n = string.indexOf(32);
        if (n > 0) {
            return string.substring(n).trim();
        }
        return "";
    }

    private DiscoveryProvider getProvider(String string) {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(DiscoveryProvider.class));
        for (DiscoveryProvider discoveryProvider : result.allInstances()) {
            discoveryProvider.clean();
            if (!string.equals(discoveryProvider.getID())) continue;
            return discoveryProvider;
        }
        return null;
    }

    private void waitConfigurationDescriptor() {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        configurationDescriptorProvider.getConfigurationDescriptor(true);
    }

    private void discovery(int n, File file) {
        try {
            if (!this.isProjectOpened()) {
                this.isFinished = true;
                return;
            }
            this.waitConfigurationDescriptor();
            boolean bl = false;
            if (!this.manualCA) {
                Object object;
                HashMap<String, Object> hashMap;
                DiscoveryExtensionInterface discoveryExtensionInterface = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class);
                if (n == 0 && discoveryExtensionInterface != null) {
                    block33: {
                        hashMap = new HashMap<String, Object>();
                        hashMap.put("DW:rootFolder", this.nativeProjectPath);
                        hashMap.put("DW:consolidationLevel", this.consolidationStrategy);
                        if (discoveryExtensionInterface.canApply(hashMap, this.makeProject)) {
                            object = (DiscoveryProvider)hashMap.get("DW:provider");
                            if (object != null && "make-log".equals(object.getID())) {
                                if (TRACE) {
                                    logger.log(Level.INFO, "#start discovery by log file {0}", object.getProperty("make-log-file").getValue());
                                }
                            } else if (TRACE) {
                                logger.log(Level.INFO, "#start discovery by object files");
                            }
                            try {
                                bl = true;
                                discoveryExtensionInterface.apply(hashMap, this.makeProject);
                                if (object != null && "make-log".equals(object.getID())) {
                                    this.importResult.put(Step.DiscoveryLog, State.Successful);
                                    break block33;
                                }
                                this.importResult.put(Step.DiscoveryDwarf, State.Successful);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        } else if (TRACE) {
                            logger.log(Level.INFO, "#no dwarf information found in object files");
                        }
                    }
                    this.buildArifactWasAnalyzed = true;
                }
                if (!bl && file != null) {
                    if (discoveryExtensionInterface != null) {
                        hashMap = new HashMap();
                        hashMap.put("DW:rootFolder", this.nativeProjectPath);
                        hashMap.put("DW:logFile", file.getAbsolutePath());
                        hashMap.put("DW:consolidationLevel", this.consolidationStrategy);
                        if (discoveryExtensionInterface.canApply(hashMap, this.makeProject)) {
                            if (TRACE) {
                                logger.log(Level.INFO, "#start discovery by log file {0}", file.getAbsolutePath());
                            }
                            try {
                                bl = true;
                                discoveryExtensionInterface.apply(hashMap, this.makeProject);
                                this.importResult.put(Step.DiscoveryLog, State.Successful);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        } else if (TRACE) {
                            logger.log(Level.INFO, "#discovery cannot be done by log file {0}", file.getAbsolutePath());
                        }
                    }
                } else if (bl && file != null) {
                    if (!this.isProjectOpened()) {
                        return;
                    }
                    if (discoveryExtensionInterface != null) {
                        hashMap = new HashMap();
                        hashMap.put("DW:rootFolder", this.nativeProjectPath);
                        hashMap.put("DW:logFile", file.getAbsolutePath());
                        hashMap.put("DW:consolidationLevel", this.consolidationStrategy);
                        if (discoveryExtensionInterface.canApply(hashMap, this.makeProject)) {
                            if (TRACE) {
                                logger.log(Level.INFO, "#start fix macros by log file {0}", file.getAbsolutePath());
                            }
                            object = (List)hashMap.get("DW:configurations");
                            this.fixMacros((List<ProjectConfiguration>)object);
                            this.importResult.put(Step.FixMacros, State.Successful);
                        } else if (TRACE) {
                            logger.log(Level.INFO, "#fix macros cannot be done by log file {0}", file.getAbsolutePath());
                        }
                    }
                }
            }
            this.switchModel(true);
            if (!bl) {
                this.postModelDiscovery(true);
            } else {
                this.postModelDiscovery(false);
            }
        }
        catch (Throwable throwable) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)throwable);
        }
    }

    private void fixMacros(List<ProjectConfiguration> list) {
        for (ProjectConfiguration projectConfiguration : list) {
            List<FileConfiguration> list2 = projectConfiguration.getFiles();
            for (FileConfiguration fileConfiguration : list2) {
                Item item;
                if (fileConfiguration.getUserMacros().size() <= 0 || (item = this.findByNormalizedName(new File(fileConfiguration.getFilePath()))) == null) continue;
                if (TRACE) {
                    logger.log(Level.FINE, "#fix macros for file {0}", fileConfiguration.getFilePath());
                }
                ProjectBridge.fixFileMacros(fileConfiguration.getUserMacros(), item);
            }
        }
        this.saveMakeConfigurationDescriptor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMakeConfigurationDescriptor(ProjectBase projectBase) {
        if (projectBase != null) {
            projectBase.enableProjectListeners(false);
        }
        try {
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
            MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
            makeConfigurationDescriptor.setModified();
            makeConfigurationDescriptor.save();
            makeConfigurationDescriptor.checkForChangedItems(this.makeProject, null, null);
        }
        finally {
            if (projectBase != null) {
                projectBase.enableProjectListeners(true);
            }
        }
        if (TRACE) {
            logger.log(Level.INFO, "#save configuration descriptor");
        }
    }

    private void postModelDiscovery(final boolean bl) {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        CsmModel csmModel = CsmModelAccessor.getModel();
        if (csmModel instanceof ModelImpl && this.makeProject != null) {
            final NativeProject nativeProject = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
            final CsmProject csmProject = csmModel.getProject((Object)nativeProject);
            if (csmProject == null) {
                if (TRACE) {
                    logger.log(Level.INFO, "#discovery cannot be done by model");
                }
                this.isFinished = true;
                return;
            }
            CsmProgressAdapter csmProgressAdapter = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject csmProject2) {
                    if (csmProject2.equals(csmProject)) {
                        try {
                            listeners.remove(csmProject);
                            CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                            if (TRACE) {
                                logger.log(Level.INFO, "#model ready, explore model");
                            }
                            if (bl) {
                                ImportProject.this.modelDiscovery();
                            } else {
                                ImportProject.this.fixExcludedHeaderFiles();
                            }
                            ImportProject.this.showFollwUp(nativeProject);
                        }
                        catch (Throwable throwable) {
                            ImportProject.this.isFinished = true;
                            Exceptions.printStackTrace((Throwable)throwable);
                        }
                    }
                }
            };
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)csmProgressAdapter);
            listeners.put(csmProject, (CsmProgressListener)csmProgressAdapter);
        } else {
            this.isFinished = true;
        }
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public Map<Step, State> getState() {
        return new EnumMap<Step, State>(this.importResult);
    }

    public Project getProject() {
        return this.makeProject;
    }

    public void setUILessMode() {
        this.isUILessMode = true;
    }

    public void setConfigureLog(File file) {
        this.configureLog = file;
    }

    public void setMakeLog(File file) {
        this.makeLog = file;
    }

    private void showFollwUp(final NativeProject nativeProject) {
        this.isFinished = true;
        if (this.isUILessMode) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FollowUp.showFollowUp(ImportProject.this, nativeProject);
            }
        });
    }

    Project getMakeProject() {
        return this.makeProject;
    }

    Map<Step, State> getImportResult() {
        return this.importResult;
    }

    private void fixExcludedHeaderFiles() {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        if (TRACE) {
            logger.log(Level.INFO, "#start fixing excluded header files by model");
        }
        ImportExecutable.fixExcludedHeaderFiles(this.makeProject, TRACE ? logger : null);
        this.importResult.put(Step.FixExcluded, State.Successful);
    }

    private Item findByNormalizedName(File file) {
        if (this.normalizedItems == null) {
            this.normalizedItems = ImportProject.initNormalizedNames(this.makeProject);
        }
        String string = CndFileUtils.normalizeFile((File)file).getAbsolutePath();
        return this.normalizedItems.get(string);
    }

    static HashMap<String, Item> initNormalizedNames(Project project) {
        MakeConfigurationDescriptor makeConfigurationDescriptor;
        HashMap<String, Item> hashMap = new HashMap<String, Item>();
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (configurationDescriptorProvider != null && (makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor()) != null) {
            for (Item item : makeConfigurationDescriptor.getProjectItems()) {
                hashMap.put(item.getNormalizedPath(), item);
            }
        }
        return hashMap;
    }

    private void modelDiscovery() {
        Object object;
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("DW:rootFolder", this.nativeProjectPath);
        hashMap.put("DW:invokeProvider", Boolean.TRUE);
        hashMap.put("DW:consolidationLevel", this.consolidationStrategy);
        boolean bl = false;
        if (!this.manualCA && !this.buildArifactWasAnalyzed && (object = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class)) != null) {
            if (object.canApply(hashMap, this.makeProject)) {
                if (TRACE) {
                    logger.log(Level.INFO, "#start discovery by object files");
                }
                try {
                    object.apply(hashMap, this.makeProject);
                    this.importResult.put(Step.DiscoveryDwarf, State.Successful);
                    bl = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (TRACE) {
                logger.log(Level.INFO, "#no dwarf information found in object files");
            }
        }
        if (!bl) {
            if (!this.isProjectOpened() || !this.isModelAvaliable()) {
                this.isFinished = true;
                return;
            }
            if (TRACE) {
                logger.log(Level.INFO, "#start discovery by model");
            }
            hashMap.put("DW:rootFolder", this.nativeProjectPath);
            object = this.getProvider("model-folder");
            object.getProperty("folder").setValue(this.nativeProjectPath);
            if (this.manualCA) {
                object.getProperty("prefer-local").setValue(Boolean.TRUE);
            }
            hashMap.put("DW:provider", object);
            hashMap.put("DW:invokeProvider", Boolean.TRUE);
            DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(hashMap);
            discoveryDescriptor.setProject(this.makeProject);
            SelectConfigurationPanel.buildModel(discoveryDescriptor);
            try {
                DiscoveryProjectGenerator discoveryProjectGenerator = new DiscoveryProjectGenerator(discoveryDescriptor);
                discoveryProjectGenerator.makeProject();
                this.importResult.put(Step.DiscoveryModel, State.Successful);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void switchModel(boolean bl) {
        CsmModel csmModel = CsmModelAccessor.getModel();
        if (csmModel instanceof ModelImpl && this.makeProject != null) {
            NativeProject nativeProject = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
            if (bl) {
                if (TRACE) {
                    logger.log(Level.INFO, "#enable model for {0}", nativeProject.getProjectDisplayName());
                }
                ((ModelImpl)csmModel).enableProject(nativeProject);
            } else {
                if (TRACE) {
                    logger.log(Level.INFO, "#disable model for {0}", nativeProject.getProjectDisplayName());
                }
                ((ModelImpl)csmModel).disableProject(nativeProject);
            }
        }
    }

    private boolean isModelAvaliable() {
        CsmModel csmModel = CsmModelAccessor.getModel();
        if (csmModel != null && this.makeProject != null) {
            return CsmModelAccessor.getModel().getProject((Object)this.makeProject) != null;
        }
        return false;
    }

    private static final class RfsListenerImpl
    implements RfsListener {
        private final Map<String, File> storage = new HashMap<String, File>();
        private final ExecutionEnvironment execEnv;

        private RfsListenerImpl(ExecutionEnvironment executionEnvironment) {
            this.execEnv = executionEnvironment;
        }

        public void fileChanged(ExecutionEnvironment executionEnvironment, File file, String string) {
            if (executionEnvironment.equals(this.execEnv)) {
                this.storage.put(string, file);
            }
        }

        private void download() {
            HashMap<String, File> hashMap = new HashMap<String, File>(this.storage);
            for (Map.Entry entry : hashMap.entrySet()) {
                this.downloadImpl((String)entry.getKey(), (File)entry.getValue());
            }
        }

        private void downloadImpl(String string, File file) {
            try {
                Future future = CommonTasksSupport.downloadFile((String)string, (ExecutionEnvironment)this.execEnv, (String)file.getAbsolutePath(), null);
                if (TRACE) {
                    logger.log(Level.INFO, "#download file {0}", file.getAbsolutePath());
                }
                future.get();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
        }
    }

    public static enum Step {
        Project,
        Configure,
        MakeClean,
        Make,
        DiscoveryDwarf,
        DiscoveryLog,
        FixMacros,
        DiscoveryModel,
        FixExcluded;

    }

    public static enum State {
        Successful,
        Fail,
        Skiped;

    }
}

