/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JTabbedPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardAction;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardIterator;
import org.netbeans.modules.cnd.discovery.wizard.SimpleConfigurationWizard;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class BuildActionsProviderImpl
extends BuildActionsProvider {
    public List<BuildActionsProvider.BuildAction> getActions(String ioTabName, ProjectActionEvent[] events) {
        ArrayList<BuildActionsProvider.BuildAction> res = new ArrayList<BuildActionsProvider.BuildAction>();
        if (events != null && events.length == 2 && events[0].getType() == ProjectActionEvent.PredefinedType.CLEAN && events[1].getType() == ProjectActionEvent.PredefinedType.BUILD && events[1].getConfiguration() != null && events[1].getConfiguration().getConfigurationType().getValue() == 0) {
            res.add(new ConfigureAction(ioTabName, events));
        }
        return res;
    }

    private static final class ConfigureAction
    extends AbstractAction
    implements BuildActionsProvider.BuildAction {
        private String ioTabName;
        private ProjectActionEvent[] events;
        private int step = -1;

        public ConfigureAction(String ioTabName, ProjectActionEvent[] events) {
            this.ioTabName = ioTabName;
            this.events = events;
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("SmallIcon")) {
                return new ImageIcon(BuildActionsProviderImpl.class.getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/configure.png"));
            }
            if (key.equals("ShortDescription")) {
                return NbBundle.getBundle(BuildActionsProviderImpl.class).getString("OUTPUT_LOG_ACTION_TEXT");
            }
            return super.getValue(key);
        }

        public void executionStarted(int pid) {
            this.setEnabled(false);
        }

        public void executionFinished(int rc) {
            if (this.step == 1 && rc == 0) {
                this.setEnabled(true);
            }
        }

        public void setStep(int step) {
            this.step = step;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            JEditorPane pane = this.findPane();
            if (pane != null && this.step >= 0 && this.step < this.events.length) {
                Project project = this.events[this.step].getProject();
                String fileName = this.saveLog(pane);
                if (fileName != null) {
                    this.invokeWizard(project, fileName);
                }
            }
        }

        private String saveLog(JEditorPane pane) {
            BufferedWriter bw = null;
            String name = null;
            try {
                File file = File.createTempFile("tmplog", ".log");
                if (file.exists()) {
                    file.delete();
                }
                file.deleteOnExit();
                name = file.getAbsolutePath();
                bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                Document doc = pane.getDocument();
                int nleft = doc.getLength();
                Segment text = new Segment();
                int offs = 0;
                text.setPartialReturn(true);
                while (nleft > 0) {
                    try {
                        doc.getText(offs, nleft, text);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    for (char c : text.array) {
                        if (c == '\u0000') continue;
                        bw.append(c);
                    }
                    nleft -= text.count;
                    offs += text.count;
                }
                bw.flush();
                bw.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException ex1) {
                        Exceptions.printStackTrace((Throwable)ex1);
                    }
                }
                name = null;
            }
            return name;
        }

        private void invokeWizard(Project project, String fileName) {
            boolean cancelled;
            DiscoveryProvider provider = DiscoveryExtension.findProvider("make-log");
            if (provider == null) {
                return;
            }
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)this.getString("OUTPUT_LOG_DILOG_COMTENT_TEXT"), this.getString("OUTPUT_LOG_DILOG_TITLE_TEXT"), 0)) != NotifyDescriptor.YES_OPTION) {
                return;
            }
            DiscoveryWizardDescriptor wizardDescriptor = new DiscoveryWizardDescriptor((WizardDescriptor.Iterator)this.getPanels());
            wizardDescriptor.setSimpleMode(true);
            wizardDescriptor.setProvider(provider);
            wizardDescriptor.setProject(project);
            wizardDescriptor.setRootFolder(DiscoveryWizardAction.findSourceRoot(project));
            wizardDescriptor.setBuildLog(fileName);
            wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
            wizardDescriptor.setTitle(this.getString("WIZARD_TITLE_TXT"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
            dialog.setVisible(true);
            dialog.toFront();
            boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
            if (!cancelled) {
                // empty if block
            }
            dialog.dispose();
        }

        private String getString(String key) {
            return NbBundle.getBundle(BuildActionsProviderImpl.class).getString(key);
        }

        private WizardDescriptor.InstantiatingIterator<WizardDescriptor> getPanels() {
            WizardDescriptor.Panel[] simple = new WizardDescriptor.Panel[]{new SimpleConfigurationWizard()};
            String[] steps = new String[simple.length];
            for (int i = 0; i < simple.length; ++i) {
                Component c = simple[i].getComponent();
                steps[i] = c.getName();
                DiscoveryWizardAction.setupComponent(steps, null, i, c);
            }
            return new DiscoveryWizardIterator(simple, simple);
        }

        private JEditorPane findPane() {
            TopComponent component = TopComponent.getRegistry().getActivated();
            return this.findPane((Container)component);
        }

        private JEditorPane findPane(Container container) {
            for (Component component : container.getComponents()) {
                JEditorPane res;
                if (component instanceof JEditorPane) {
                    return (JEditorPane)component;
                }
                if (component instanceof JTabbedPane) {
                    JEditorPane res2;
                    JTabbedPane jt = (JTabbedPane)component;
                    if (jt.getComponentCount() <= 0) continue;
                    Component t = jt.getSelectedComponent();
                    if (t instanceof JEditorPane) {
                        return (JEditorPane)t;
                    }
                    if (!(t instanceof Container) || (res2 = this.findPane((Container)t)) == null) continue;
                    return res2;
                }
                if (!(component instanceof Container) || (res = this.findPane((Container)component)) == null) continue;
                return res;
            }
            return null;
        }
    }
}

