/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.bridge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.bridge.ProjectBridge;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.AbstractRoot;
import org.netbeans.modules.cnd.discovery.wizard.checkedtree.UnusedFactory;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Utilities;

public class DiscoveryProjectGenerator {
    private static boolean DEBUG = Boolean.getBoolean("cnd.discovery.trace.project_update");
    private static boolean TRUNCATE_BEGINNING_PATH = true;
    private ProjectBridge projectBridge;
    private DiscoveryDescriptor wizard;
    private String baseFolder;
    private String level;

    public DiscoveryProjectGenerator(DiscoveryDescriptor wizard) throws IOException {
        this.wizard = wizard;
        this.baseFolder = wizard.getRootFolder();
        Project project = wizard.getProject();
        this.projectBridge = project != null ? new ProjectBridge(project) : new ProjectBridge(this.baseFolder);
    }

    public void process() {
        List<ProjectConfiguration> projectConfigurations = this.wizard.getConfigurations();
        Folder sourceRoot = this.projectBridge.getRoot();
        this.createFolderStructure(projectConfigurations, sourceRoot);
        this.level = this.wizard.getLevel();
        HashSet<Item> used = new HashSet<Item>();
        for (ProjectConfiguration config : projectConfigurations) {
            this.setupCompilerConfiguration(config);
            this.addConfiguration(sourceRoot, config, used);
        }
        this.addAdditional(sourceRoot, this.baseFolder, used);
        if (TRUNCATE_BEGINNING_PATH) {
            this.packRoot(sourceRoot);
        }
        if ("file".equals(this.level)) {
            this.upConfiguration(sourceRoot, ItemProperties.LanguageKind.CPP);
            this.upConfiguration(sourceRoot, ItemProperties.LanguageKind.C);
            this.downConfiguration(sourceRoot, ItemProperties.LanguageKind.CPP);
            this.downConfiguration(sourceRoot, ItemProperties.LanguageKind.C);
        }
        this.projectBridge.save();
        this.projectBridge.dispose();
    }

    private void packRoot(Folder root) {
        for (Object item : root.getElements()) {
            if (item instanceof Folder) continue;
            return;
        }
        HashMap<Folder, Folder> res = new HashMap<Folder, Folder>();
        for (Folder folder : root.getFolders()) {
            if (folder.getKind() == Folder.Kind.IMPORTANT_FILES_FOLDER) {
                res.put(folder, folder);
                continue;
            }
            if (folder.isDiskFolder()) {
                res.put(folder, folder);
                continue;
            }
            Folder packFolder = this.packFolder(folder);
            res.put(folder, packFolder);
        }
        boolean isFullNames = false;
        for (int i = 0; i < 3; ++i) {
            isFullNames = false;
            HashMap names = new HashMap();
            for (Map.Entry entry : res.entrySet()) {
                String folderName = ((Folder)entry.getValue()).getName();
                ArrayList list = (ArrayList)names.get(folderName);
                if (list == null) {
                    list = new ArrayList();
                    names.put(folderName, list);
                }
                list.add(entry);
                if (list.size() <= 1) continue;
                isFullNames = true;
            }
            if (!isFullNames) break;
            for (Map.Entry entry : names.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                for (Map.Entry e : (List)entry.getValue()) {
                    Folder beg = (Folder)e.getKey();
                    Folder end = (Folder)e.getValue();
                    Folder up = end.getParent();
                    if (up != null && up != beg) {
                        res.put(beg, up);
                        continue;
                    }
                    return;
                }
            }
        }
        if (isFullNames) {
            return;
        }
        root.reset();
        for (Map.Entry entry : res.entrySet()) {
            File folderFile;
            if (((Folder)entry.getKey()).getKind() == Folder.Kind.IMPORTANT_FILES_FOLDER) {
                root.addFolder((Folder)entry.getValue(), true);
                continue;
            }
            if (((Folder)entry.getValue()).isDiskFolder()) {
                root.addFolder((Folder)entry.getValue(), true);
                continue;
            }
            if (((Folder)entry.getValue()).getRoot() == null && (folderFile = this.getFolderFile((Folder)entry.getValue())) != null) {
                ((Folder)entry.getValue()).setRoot(this.projectBridge.getRelativepath(folderFile.getAbsolutePath()));
            }
            root.addFolder((Folder)entry.getValue(), true);
        }
    }

    private File getFolderFile(Folder folder) {
        for (Item item : folder.getItemsAsArray()) {
            File parent = item.getNormalizedFile().getParentFile();
            if (parent == null) continue;
            return parent;
        }
        for (Folder f : folder.getFolders()) {
            File parent = this.getFolderFile(f);
            if (parent == null) continue;
            return parent.getParentFile();
        }
        return null;
    }

    private Folder packFolder(Folder folder) {
        while (folder.getElements().size() <= 1) {
            List folders = folder.getFolders();
            if (folders.isEmpty()) {
                return folder;
            }
            folder = (Folder)folders.get(0);
        }
        return folder;
    }

    private void downConfiguration(Folder folder, ItemProperties.LanguageKind lang) {
        CCCCompilerConfiguration cccc = this.projectBridge.getFolderConfiguration(lang, folder);
        if (cccc != null) {
            List commonFoldersIncludes = cccc.getIncludeDirectories().getValue();
            List commonFoldersMacros = cccc.getPreprocessorConfiguration().getValue();
            this.projectBridge.setupProject(commonFoldersIncludes, commonFoldersMacros, lang);
            this.projectBridge.setupFolder(Collections.<String>emptyList(), true, Collections.<String>emptyList(), true, lang, folder);
            this.downConfiguration(folder, lang, commonFoldersIncludes, commonFoldersMacros);
        }
    }

    private void downConfiguration(Folder folder, ItemProperties.LanguageKind lang, List<String> commonFoldersIncludes, List<String> commonFoldersMacros) {
        for (Folder subFolder : folder.getFoldersAsArray()) {
            CCCCompilerConfiguration cccc = this.projectBridge.getFolderConfiguration(lang, subFolder);
            if (cccc == null) continue;
            ArrayList<String> aCommonFoldersIncludes = new ArrayList<String>(commonFoldersIncludes);
            ArrayList<String> cCommonFoldersMacros = new ArrayList<String>(commonFoldersMacros);
            ArrayList<String> foldersIncludes = new ArrayList<String>();
            ArrayList<String> foldersMacros = new ArrayList<String>();
            for (String s : cccc.getIncludeDirectories().getValue()) {
                if (aCommonFoldersIncludes.contains(s)) continue;
                foldersIncludes.add(s);
                aCommonFoldersIncludes.add(s);
            }
            for (String s : cccc.getPreprocessorConfiguration().getValue()) {
                if (cCommonFoldersMacros.contains(s)) continue;
                foldersMacros.add(s);
                cCommonFoldersMacros.add(s);
            }
            this.projectBridge.setupFolder(foldersIncludes, true, foldersMacros, true, lang, subFolder);
            this.downConfiguration(subFolder, lang, aCommonFoldersIncludes, cCommonFoldersMacros);
        }
    }

    private Folder getOrCreateFolder(Folder folder, String name, AbstractRoot used) {
        Folder added = folder.findFolderByName(name);
        if (added == null) {
            added = this.projectBridge.createFolder(folder, name);
            folder.addFolder(added, true);
        } else if (added.isDiskFolder()) {
            String additionalPath = used.getFolder();
            String folderPath = CndPathUtilitities.toAbsolutePath((String)folder.getConfigurationDescriptor().getBaseDir(), (String)added.getRootPath());
            Folder logicalCandidate = null;
            if (!additionalPath.equals(folderPath)) {
                for (Folder candidate : folder.getFolders()) {
                    if (candidate.isDiskFolder()) {
                        folderPath = CndPathUtilitities.toAbsolutePath((String)folder.getConfigurationDescriptor().getBaseDir(), (String)candidate.getRootPath());
                        if (!additionalPath.equals(folderPath)) continue;
                        added = candidate;
                        break;
                    }
                    if (logicalCandidate != null || !candidate.getName().equals(name)) continue;
                    logicalCandidate = candidate;
                }
            }
            if (!additionalPath.equals(folderPath)) {
                if (logicalCandidate == null) {
                    added = this.projectBridge.createFolder(folder, name);
                    folder.addFolder(added, true);
                } else {
                    added = logicalCandidate;
                }
            }
        }
        return added;
    }

    private boolean upConfiguration(Folder folder, ItemProperties.LanguageKind lang) {
        CCCCompilerConfiguration cccc;
        CCCCompilerConfiguration cccc2;
        HashSet commonFoldersIncludes = new HashSet();
        HashSet commonFoldersMacros = new HashSet();
        boolean haveSubFolders = false;
        for (Folder subFolder : folder.getFolders()) {
            CCCCompilerConfiguration cccc3;
            if (!this.upConfiguration(subFolder, lang)) continue;
            if (!haveSubFolders) {
                cccc3 = this.projectBridge.getFolderConfiguration(lang, subFolder);
                if (cccc3 == null) continue;
                commonFoldersIncludes.addAll(cccc3.getIncludeDirectories().getValue());
                commonFoldersMacros.addAll(cccc3.getPreprocessorConfiguration().getValue());
                haveSubFolders = true;
                continue;
            }
            if (commonFoldersIncludes.size() > 0 && (cccc3 = this.projectBridge.getFolderConfiguration(lang, subFolder)) != null) {
                commonFoldersIncludes.retainAll(cccc3.getIncludeDirectories().getValue());
            }
            if (commonFoldersMacros.size() <= 0 || (cccc3 = this.projectBridge.getFolderConfiguration(lang, subFolder)) == null) continue;
            commonFoldersMacros.retainAll(cccc3.getPreprocessorConfiguration().getValue());
        }
        HashSet commonFilesIncludes = new HashSet();
        HashSet commonFilesMacros = new HashSet();
        boolean first = true;
        if (haveSubFolders) {
            commonFilesIncludes = new HashSet(commonFoldersIncludes);
            commonFilesMacros = new HashSet(commonFoldersMacros);
            first = false;
        }
        for (Item item : folder.getItemsAsArray()) {
            if (item.isExcluded()) continue;
            cccc2 = this.projectBridge.getItemConfiguration(item);
            if (lang != ItemProperties.LanguageKind.CPP ? lang != ItemProperties.LanguageKind.C || !(cccc2 instanceof CCompilerConfiguration) : !(cccc2 instanceof CCCompilerConfiguration)) continue;
            if (first) {
                commonFilesIncludes.addAll(cccc2.getIncludeDirectories().getValue());
                commonFilesMacros.addAll(cccc2.getPreprocessorConfiguration().getValue());
                first = false;
                continue;
            }
            if (commonFilesIncludes.size() > 0) {
                commonFilesIncludes.retainAll(cccc2.getIncludeDirectories().getValue());
            }
            if (commonFilesMacros.size() <= 0) continue;
            commonFilesMacros.retainAll(cccc2.getPreprocessorConfiguration().getValue());
        }
        if (commonFilesIncludes.size() > 0 || commonFilesMacros.size() > 0) {
            for (Item item : folder.getItemsAsArray()) {
                ArrayList list;
                cccc2 = this.projectBridge.getItemConfiguration(item);
                if (lang != ItemProperties.LanguageKind.CPP ? lang != ItemProperties.LanguageKind.C || !(cccc2 instanceof CCompilerConfiguration) : !(cccc2 instanceof CCCompilerConfiguration)) continue;
                if (commonFilesIncludes.size() > 0) {
                    list = new ArrayList(cccc2.getIncludeDirectories().getValue());
                    list.removeAll(commonFilesIncludes);
                    cccc2.getIncludeDirectories().setValue(list);
                }
                if (commonFilesMacros.size() <= 0) continue;
                list = new ArrayList(cccc2.getPreprocessorConfiguration().getValue());
                list.removeAll(commonFilesMacros);
                cccc2.getPreprocessorConfiguration().setValue(list);
            }
        }
        if (commonFilesIncludes.size() > 0 && (cccc = this.projectBridge.getFolderConfiguration(lang, folder)) != null) {
            cccc.getIncludeDirectories().setValue(new ArrayList(commonFilesIncludes));
        }
        if (commonFilesMacros.size() > 0 && (cccc = this.projectBridge.getFolderConfiguration(lang, folder)) != null) {
            cccc.getPreprocessorConfiguration().setValue(new ArrayList(commonFilesMacros));
        }
        return !first;
    }

    public Set<Project> makeProject() {
        if (this.projectBridge.isValid()) {
            this.process();
            return this.projectBridge.getResult();
        }
        return Collections.emptySet();
    }

    private Set<String> getSourceFolders() {
        HashSet<String> used = new HashSet<String>();
        List<ProjectConfiguration> projectConfigurations = this.wizard.getConfigurations();
        for (ProjectConfiguration conf : projectConfigurations) {
            for (FileConfiguration file : conf.getFiles()) {
                int i;
                String path = file.getFilePath();
                if (Utilities.isWindows()) {
                    path = path.replace('\\', '/');
                }
                if ((i = path.lastIndexOf(47)) > 0) {
                    path = path.substring(0, i + 1);
                }
                used.add(path);
            }
        }
        used.addAll(this.compureRoots(used));
        return used;
    }

    private Set<String> compureRoots(Set<String> roots) {
        HashSet<String> res = new HashSet<String>();
        ArrayList<String> root = null;
        block0: for (String s : roots) {
            if (root == null) {
                root = new ArrayList<String>();
                root.addAll(Arrays.asList(s.split("/")));
                continue;
            }
            int i = 0;
            for (String segment : s.split("/")) {
                if (i >= root.size()) continue block0;
                if (!segment.equals(root.get(i))) {
                    while (root.size() > i) {
                        root.remove(root.size() - 1);
                    }
                }
                ++i;
            }
        }
        if (root != null && root.size() > 1) {
            StringBuilder buf = new StringBuilder();
            for (String s : root) {
                buf.append(s);
                buf.append('/');
            }
            res.add(buf.toString());
        }
        return res;
    }

    private void addAdditional(Folder folder, String base, Set<Item> usedItems) {
        Set<String> folders = this.getSourceFolders();
        HashSet<String> used = new HashSet<String>();
        HashSet<String> needAdd = new HashSet<String>();
        HashSet<String> needCheck = new HashSet<String>();
        List<String> list = this.wizard.getIncludedFiles();
        Map<String, Folder> preffered = this.projectBridge.prefferedFolders();
        for (String name : list) {
            used.add(name);
            String path = this.projectBridge.getRelativepath(name);
            Item item = this.projectBridge.getProjectItem(path);
            if (item == null) {
                String folderPath;
                Folder prefferedFolder;
                int i;
                path = name;
                if (Utilities.isWindows()) {
                    path = path.replace('\\', '/');
                }
                boolean bl = false;
                if (path.startsWith(base)) {
                    bl = true;
                } else {
                    for (String dir : folders) {
                        if (!path.startsWith(dir)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl && (i = path.lastIndexOf(47)) >= 0 && (prefferedFolder = preffered.get(folderPath = path.substring(0, i))) != null) {
                    item = this.projectBridge.createItem(name);
                    item = prefferedFolder.addItem(item);
                    ProjectBridge.setHeaderTool(item);
                    if (!MIMENames.isCppOrCOrFortran((String)item.getMIMEType())) {
                        needCheck.add(path);
                    } else if (DEBUG) {
                        System.err.println("Source is header:" + item.getAbsPath());
                    }
                    bl = false;
                }
                if (!bl) continue;
                needCheck.add(path);
                needAdd.add(name);
                continue;
            }
            if (!usedItems.contains(item)) {
                ProjectBridge.setExclude(item, false);
                ProjectBridge.setHeaderTool(item);
                continue;
            }
            if (MIMENames.isCppOrCOrFortran((String)item.getMIMEType())) continue;
            needCheck.add(path);
        }
        if (needAdd.size() > 0) {
            AbstractRoot additional = UnusedFactory.createRoot(needAdd);
            if (additional.getName().isEmpty()) {
                for (AbstractRoot aRoot : additional.getChildren()) {
                    this.addAdditionalPreferedFolder(folder, aRoot);
                }
            } else {
                this.addAdditionalPreferedFolder(folder, additional);
            }
        }
        List<ProjectConfiguration> projectConfigurations = this.wizard.getConfigurations();
        for (ProjectConfiguration conf : projectConfigurations) {
            for (FileConfiguration fileConfiguration : conf.getFiles()) {
                used.add(fileConfiguration.getFilePath());
            }
        }
        HashSet<String> relatives = new HashSet<String>();
        for (String name : used) {
            relatives.add(this.projectBridge.getRelativepath(name));
        }
        TreeMap<String, Item> sorted = new TreeMap<String, Item>();
        for (Item item : this.projectBridge.getAllSources()) {
            if (usedItems.contains(item)) continue;
            sorted.put(item.getPath(), item);
        }
        for (Map.Entry entry : sorted.entrySet()) {
            Item item;
            String path = (String)entry.getKey();
            item = (Item)entry.getValue();
            String canonicalPath = item.getNormalizedPath();
            if (relatives.contains(path) || used.contains(path) || relatives.contains(canonicalPath) || used.contains(canonicalPath)) continue;
            if (DEBUG) {
                System.out.println("Exclude Item " + path);
            }
            ProjectBridge.setExclude(item, true);
        }
        if (needCheck.size() > 0) {
            this.projectBridge.checkForNewExtensions(needCheck);
        }
    }

    private void addAdditionalPreferedFolder(Folder folder, AbstractRoot additional) {
        Folder rootCandidate = null;
        String root = additional.getFolder();
        int i = root.lastIndexOf(47);
        if (i > 0) {
            Map<String, Folder> prefferedFolders = this.projectBridge.prefferedFolders();
            root = root.substring(0, i);
            rootCandidate = prefferedFolders.get(root);
        }
        if (rootCandidate == null) {
            rootCandidate = folder;
        }
        this.addAdditionalFolder(rootCandidate, additional);
    }

    private void addAdditionalFolder(Folder folder, AbstractRoot used) {
        String name = used.getName();
        Folder added = this.getOrCreateFolder(folder, name, used);
        if (added == null) {
            added = this.projectBridge.createFolder(folder, name);
            folder.addFolder(added, true);
        }
        for (AbstractRoot sub : used.getChildren()) {
            this.addAdditionalFolder(added, sub);
        }
        List<String> files = used.getFiles();
        if (files != null) {
            for (String file : files) {
                String path = this.projectBridge.getRelativepath(file);
                Item item = this.projectBridge.getProjectItem(path);
                if (item != null) {
                    if (item.getFolder() != added) {
                        Object old = this.projectBridge.getAuxObject(item);
                        item.getFolder().removeItem(item);
                        item = added.addItem(item);
                        if (old != null) {
                            this.projectBridge.setAuxObject(item, old);
                        }
                    }
                    ProjectBridge.setExclude(item, false);
                    ProjectBridge.setHeaderTool(item);
                    continue;
                }
                item = this.projectBridge.createItem(file);
                item = added.addItem(item);
                ProjectBridge.setExclude(item, false);
                ProjectBridge.setHeaderTool(item);
            }
        }
    }

    private void setupCompilerConfiguration(ProjectConfiguration config) {
        if ("project".equals(this.level)) {
            HashSet<String> set = new HashSet<String>();
            HashMap<String, String> macros = new HashMap<String, String>();
            for (FileConfiguration file : config.getFiles()) {
                this.reConsolidatePaths(set, file);
                macros.putAll(file.getUserMacros());
            }
            ArrayList<String> vector = new ArrayList<String>(set);
            List<String> buf = this.buildMacrosString(macros);
            this.projectBridge.setupProject(vector, buf, config.getLanguageKind());
        } else {
            List<String> vector = Collections.emptyList();
            List<String> buf = Collections.emptyList();
            this.projectBridge.setupProject(vector, buf, config.getLanguageKind());
        }
    }

    private List<String> buildMacrosString(Map<String, String> map) {
        ArrayList<String> vector = new ArrayList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() != null) {
                vector.add(entry.getKey() + "=" + entry.getValue());
                continue;
            }
            vector.add(entry.getKey());
        }
        return vector;
    }

    private void setupFile(FileConfiguration config, Item item, ItemProperties.LanguageKind lang) {
        this.projectBridge.setSourceTool(item, lang, config.getLanguageStandard());
        if ("file".equals(this.level)) {
            HashSet<String> set = new HashSet<String>();
            HashMap<String, String> macros = new HashMap<String, String>();
            this.reConsolidatePaths(set, config);
            macros.putAll(config.getUserMacros());
            ArrayList<String> vector = new ArrayList<String>(set);
            List<String> buf = this.buildMacrosString(macros);
            this.projectBridge.setupFile(config.getCompilePath(), vector, !config.overrideIncludes(), buf, !config.overrideMacros(), item);
        } else {
            List<String> vector = Collections.emptyList();
            List<String> buf = Collections.emptyList();
            this.projectBridge.setupFile(config.getCompilePath(), vector, true, buf, true, item);
        }
    }

    private void reConsolidatePaths(Set<String> set, FileConfiguration file) {
        String compilePath = file.getCompilePath();
        for (String path : file.getUserInludePaths()) {
            if (!(path.startsWith("/") || path.length() > 1 && path.charAt(1) == ':')) {
                path = path.equals(".") ? compilePath : compilePath + File.separator + path;
                File f = new File(path);
                path = CndFileUtils.normalizeFile((File)f).getAbsolutePath();
            }
            set.add(this.projectBridge.getRelativepath(path));
        }
        if (this.isDifferentCompilePath(file.getFilePath(), compilePath)) {
            set.add(this.projectBridge.getRelativepath(compilePath));
        }
    }

    private boolean isDifferentCompilePath(String name, String path) {
        int i;
        if (Utilities.isWindows()) {
            name = name.replace('\\', '/');
        }
        return (i = name.lastIndexOf(47)) > 0 && !(name = name.substring(0, i)).equals(path);
    }

    private void createFolderStructure(List<ProjectConfiguration> projectConfigurations, Folder sourceRoot) {
        HashMap<String, Set<Pair>> configurationStructure = new HashMap<String, Set<Pair>>();
        for (ProjectConfiguration config : projectConfigurations) {
            this.analyzeConfigurationStructure(config.getFiles(), config.getLanguageKind(), configurationStructure);
        }
        List<Pair> orphan = this.detectOrphan(configurationStructure, null);
        if (orphan.size() > 0) {
            this.createOrphan(sourceRoot, orphan, null);
        }
    }

    private void addConfiguration(Folder sourceRoot, ProjectConfiguration conf, Set<Item> used) {
        Folder folder;
        Set files;
        Cloneable folders;
        ItemProperties.LanguageKind lang = conf.getLanguageKind();
        HashMap<String, Set<Pair>> configurationStructure = new HashMap<String, Set<Pair>>();
        this.analyzeConfigurationStructure(conf.getFiles(), lang, configurationStructure);
        List<Pair> orphan = this.detectOrphan(configurationStructure, lang);
        if (orphan.size() > 0) {
            this.createOrphan(sourceRoot, orphan, lang);
        }
        if ("folder".equals(this.level)) {
            folders = new HashMap();
            for (Map.Entry entry : configurationStructure.entrySet()) {
                files = (Set)entry.getValue();
                for (Pair pair : files) {
                    if (pair.item != null) {
                        folder = pair.item.getFolder();
                        HashSet<FileConfiguration> content = (HashSet<FileConfiguration>)folders.get(folder);
                        if (content == null) {
                            content = new HashSet<FileConfiguration>();
                            folders.put(folder, content);
                        }
                        content.add(pair.fileConfiguration);
                        continue;
                    }
                    if (!DEBUG) continue;
                    System.err.println("Cannot find pair by path " + pair.fileConfiguration.getFilePath());
                }
            }
            for (Map.Entry entry : folders.entrySet()) {
                Folder folder2 = (Folder)entry.getKey();
                Set confs = (Set)entry.getValue();
                HashSet<String> inludes = new HashSet<String>();
                HashMap<String, String> macros = new HashMap<String, String>();
                for (FileConfiguration file : confs) {
                    this.reConsolidatePaths(inludes, file);
                    macros.putAll(file.getUserMacros());
                }
                List<String> buf = this.buildMacrosString(macros);
                ArrayList<String> vector = new ArrayList<String>(inludes);
                this.projectBridge.setupFolder(vector, false, buf, false, conf.getLanguageKind(), folder2);
            }
        } else {
            folders = new HashSet();
            for (Map.Entry entry : configurationStructure.entrySet()) {
                files = (Set)entry.getValue();
                for (Pair pair : files) {
                    if (pair.item == null) continue;
                    folder = pair.item.getFolder();
                    folders.add(folder);
                }
            }
            Iterator i$ = folders.iterator();
            while (i$.hasNext()) {
                Folder folder3 = (Folder)i$.next();
                List<String> buf = Collections.emptyList();
                List<String> vector = Collections.emptyList();
                this.projectBridge.setupFolder(vector, true, buf, true, conf.getLanguageKind(), folder3);
            }
        }
        for (Set set : configurationStructure.values()) {
            for (Pair pair : set) {
                if (pair.item == null) continue;
                used.add(pair.item);
            }
        }
    }

    private void createOrphan(Folder sourceRoot, List<Pair> orphan, ItemProperties.LanguageKind lang) {
        HashMap<String, Pair> folders = new HashMap<String, Pair>();
        for (Pair pair : orphan) {
            String path = pair.fileConfiguration.getFilePath();
            folders.put(path, pair);
        }
        AbstractRoot additional = UnusedFactory.createRoot(folders.keySet());
        if (additional.getName().isEmpty()) {
            for (AbstractRoot aRoot : additional.getChildren()) {
                this.addFolder(sourceRoot, aRoot, folders, lang);
            }
        } else {
            this.addFolder(sourceRoot, additional, folders, lang);
        }
    }

    private void addFolder(Folder folder, AbstractRoot additional, Map<String, Pair> folders, ItemProperties.LanguageKind lang) {
        String name = additional.getName();
        Folder added = this.getOrCreateFolder(folder, name, additional);
        for (AbstractRoot sub : additional.getChildren()) {
            this.addFolder(added, sub, folders, lang);
        }
        for (String file : additional.getFiles()) {
            Pair pair = folders.get(file);
            if (pair != null) {
                String path = this.projectBridge.getRelativepath(file);
                Item item = this.projectBridge.getProjectItem(path);
                if (item == null) {
                    item = this.projectBridge.createItem(file);
                    added.addItem(item);
                } else if (DEBUG) {
                    System.err.println("Orphan pair found by path " + file);
                }
                pair.item = item;
                if (lang == null) continue;
                this.setupFile(pair.fileConfiguration, pair.item, lang);
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("Cannot find pair by path " + file);
        }
    }

    private List<Pair> detectOrphan(Map<String, Set<Pair>> configurationStructure, ItemProperties.LanguageKind lang) {
        Map<String, Folder> preffered = this.projectBridge.prefferedFolders();
        ArrayList<Pair> orphan = new ArrayList<Pair>();
        for (Map.Entry<String, Set<Pair>> entry : configurationStructure.entrySet()) {
            Set<Pair> files = entry.getValue();
            Folder folder = null;
            ArrayList<Pair> list = new ArrayList<Pair>();
            for (Pair pair : files) {
                int i;
                Item item = pair.item;
                if (item != null) {
                    if (folder == null) continue;
                    folder = item.getFolder();
                    continue;
                }
                String prefferedFolder = pair.fileConfiguration.getFilePath();
                if (Utilities.isWindows()) {
                    prefferedFolder = prefferedFolder.replace('\\', '/');
                }
                if ((i = prefferedFolder.lastIndexOf(47)) >= 0) {
                    prefferedFolder = prefferedFolder.substring(0, i);
                    folder = preffered.get(prefferedFolder);
                }
                list.add(pair);
            }
            if (folder != null) {
                for (Pair pair : list) {
                    String relPath = this.projectBridge.getRelativepath(pair.fileConfiguration.getFilePath());
                    Item item = this.projectBridge.getProjectItem(relPath);
                    if (item == null) {
                        item = this.projectBridge.createItem(pair.fileConfiguration.getFilePath());
                        pair.item = item;
                        folder.addItem(item);
                    }
                    if (lang == null) continue;
                    this.setupFile(pair.fileConfiguration, item, lang);
                }
                continue;
            }
            for (Pair pair : list) {
                orphan.add(pair);
            }
        }
        return orphan;
    }

    private void analyzeConfigurationStructure(List<FileConfiguration> files, ItemProperties.LanguageKind lang, Map<String, Set<Pair>> folders) {
        for (FileConfiguration file : files) {
            this.analyzeConfigurationStructure(file.getFilePath(), folders, file, lang);
        }
    }

    private void analyzeConfigurationStructure(String aPath, Map<String, Set<Pair>> folders, FileConfiguration file, ItemProperties.LanguageKind lang) {
        String path = Utilities.isWindows() ? aPath.replace('\\', '/') : aPath;
        int i = path.lastIndexOf(47);
        if (i >= 0) {
            String relPath;
            Item item;
            String folder = path.substring(0, i);
            Set<Pair> set = folders.get(folder);
            if (set == null) {
                set = new HashSet<Pair>();
                folders.put(folder, set);
            }
            if ((item = this.projectBridge.getProjectItem(relPath = this.projectBridge.getRelativepath(path))) != null && lang != null) {
                this.setupFile(file, item, lang);
            }
            set.add(new Pair(file, item));
        }
    }

    private static class Pair {
        private FileConfiguration fileConfiguration;
        private Item item;

        private Pair(FileConfiguration fileConfiguration, Item item) {
            this.fileConfiguration = fileConfiguration;
            this.item = item;
        }
    }
}

