/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.wizard.api.NodeConfiguration;

public abstract class NodeConfigurationImpl
implements NodeConfiguration {
    private boolean isOverrideIncludes;
    private boolean isOverrideMacros;
    private NodeConfigurationImpl parent;
    private Set<String> userIncludes = new LinkedHashSet<String>();
    private Map<String, String> userMacros = new HashMap<String, String>();

    @Override
    public boolean overrideIncludes() {
        return this.isOverrideIncludes;
    }

    public void setOverrideIncludes(boolean overrideIncludes) {
        this.isOverrideIncludes = overrideIncludes;
    }

    @Override
    public boolean overrideMacros() {
        return this.isOverrideMacros;
    }

    public void setOverrideMacros(boolean overrideMacros) {
        this.isOverrideMacros = overrideMacros;
    }

    public void setParent(NodeConfigurationImpl parent) {
        this.parent = parent;
    }

    public NodeConfigurationImpl getParent() {
        return this.parent;
    }

    @Override
    public Set<String> getUserInludePaths(boolean resulting) {
        if (resulting) {
            return this.countUserInludePaths();
        }
        return this.userIncludes;
    }

    public void setUserInludePaths(Collection<String> set) {
        this.userIncludes.clear();
        if (set != null) {
            this.userIncludes.addAll(set);
        }
    }

    @Override
    public Map<String, String> getUserMacros(boolean resulting) {
        if (resulting) {
            return this.countUserMacros();
        }
        return this.userMacros;
    }

    public void setUserMacros(Map<String, String> map) {
        this.userMacros.clear();
        if (map != null) {
            this.userMacros.putAll(map);
        }
    }

    public Set<String> countUserInludePaths() {
        if (this.overrideIncludes()) {
            return this.userIncludes;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (NodeConfigurationImpl current = this; current != null; current = current.getParent()) {
            result.addAll(current.getUserInludePaths(false));
            if (current.overrideIncludes()) break;
        }
        return result;
    }

    public Map<String, String> countUserMacros() {
        if (this.overrideMacros()) {
            return this.userMacros;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (NodeConfigurationImpl current = this; current != null; current = current.getParent()) {
            result.putAll(current.getUserMacros(false));
            if (current.overrideMacros()) break;
        }
        return result;
    }
}

