/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.DynamicPieChartModel;
import org.netbeans.lib.profiler.ui.charts.PieChartModel;

public class PieChart
extends JComponent
implements ComponentListener,
ChartModelListener,
Accessible {
    private static Color evenSelectionSegmentsColor = Color.WHITE;
    private static Stroke evenSelectionSegmentsStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private static Color oddSelectionSegmentColor = Color.BLACK;
    private static Stroke oddSelectionSegmentStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 5.0f}, 5.0f);
    private AccessibleContext accessibleContext;
    private Area pieArea;
    private Graphics2D offScreenGraphics;
    private Image offScreenImage;
    private Insets insets = new Insets(0, 0, 0, 0);
    private PieChartModel model;
    private Vector arcs = new Vector();
    private Vector bottoms = new Vector();
    private Vector selectedItems = new Vector();
    private boolean draw3D = true;
    private boolean offScreenImageInvalid;
    private boolean offScreenImageSizeInvalid = true;
    private int chartHeight = 15;
    private int drawHeight;
    private int drawWidth;
    private int focusedItem = -1;
    private int initialAngle = 0;
    private int pieCenterY;
    private int pieHeight;

    public PieChart() {
        this.addComponentListener(this);
    }

    public void setAccessibleContext(AccessibleContext accessibleContext) {
        this.accessibleContext = accessibleContext;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public void setChartHeight(int chartHeight) {
        this.chartHeight = chartHeight;
        this.draw3D = chartHeight > 0;
    }

    public int getChartHeight() {
        return this.chartHeight;
    }

    public void setFocusedItem(int focusedItem) {
        if (this.focusedItem != focusedItem) {
            this.focusedItem = focusedItem;
            this.offScreenImageInvalid = true;
            this.repaint();
        }
    }

    public int getItemIndexAt(int x, int y) {
        int i;
        x -= this.insets.left;
        y -= this.insets.top;
        for (i = 0; i < this.arcs.size(); ++i) {
            if (!((Arc2D)this.arcs.get(i)).contains(x, y)) continue;
            return i;
        }
        if (this.draw3D) {
            for (i = 0; i < this.bottoms.size(); ++i) {
                Area area = (Area)this.bottoms.get(i);
                if (area == null || !area.contains(x, y)) continue;
                return i;
            }
        }
        return -1;
    }

    public void setModel(PieChartModel model) {
        if (this.model != null) {
            this.model.removeChartModelListener(this);
        }
        if (model != null) {
            model.addChartModelListener(this);
        }
        this.model = model;
        this.chartDataChanged();
    }

    public PieChartModel getModel() {
        return this.model;
    }

    public void setSelectedItem(int selectedItem) {
        if (this.selectedItems.contains(selectedItem) && this.selectedItems.size() == 1) {
            return;
        }
        this.selectedItems.clear();
        this.selectedItems.add(selectedItem);
        this.offScreenImageInvalid = true;
        this.repaint();
    }

    public int[] getSelectedItems() {
        int[] items = new int[this.selectedItems.size()];
        for (int i = 0; i < this.selectedItems.size(); ++i) {
            items[i] = (Integer)this.selectedItems.get(i);
        }
        return items;
    }

    public void setStartAngle(int initialAngle) {
        this.initialAngle = initialAngle;
    }

    public int getStartAngle() {
        return this.initialAngle;
    }

    public void addSelectedItem(int selectedItem) {
        if (this.selectedItems.contains(selectedItem)) {
            return;
        }
        this.selectedItems.add(selectedItem);
        this.offScreenImageInvalid = true;
        this.repaint();
    }

    @Override
    public void chartDataChanged() {
        this.selectAllItems();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.offScreenImageSizeInvalid = true;
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void deselectAllItems() {
        this.selectedItems.clear();
        this.offScreenImageInvalid = true;
        this.repaint();
    }

    public static void main(String[] args) {
        final PieChart pieChart = new PieChart();
        pieChart.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        pieChart.setPreferredSize(new Dimension(300, 200));
        DynamicPieChartModel pieChartModel = new DynamicPieChartModel();
        pieChartModel.setupModel(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}, new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW});
        pieChartModel.setItemValues(new double[]{10.0, 5.0, 15.0, 7.0});
        JFrame frame = new JFrame("PieChart Tester");
        frame.getContentPane().add(pieChart);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
        pieChart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickedItem = pieChart.getItemIndexAt(e.getX(), e.getY());
                pieChart.toggleItemSelection(clickedItem);
            }
        });
        pieChart.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int focusedItem = pieChart.getItemIndexAt(e.getX(), e.getY());
                if (focusedItem != -1) {
                    pieChart.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    pieChart.setCursor(Cursor.getDefaultCursor());
                }
                pieChart.setFocusedItem(focusedItem);
            }
        });
        pieChart.setModel(pieChartModel);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.model == null) {
            return;
        }
        if (this.offScreenImageSizeInvalid) {
            this.updateOffScreenImageSize();
        }
        if (this.offScreenImageInvalid) {
            this.drawChart(this.offScreenGraphics);
        }
        g.drawImage(this.offScreenImage, this.insets.left, this.insets.top, this);
    }

    public void removeSelectedItem(int selectedItem) {
        if (!this.selectedItems.contains(selectedItem)) {
            return;
        }
        this.selectedItems.remove((Object)selectedItem);
        this.offScreenImageInvalid = true;
        this.repaint();
    }

    public void resetFocusedItem() {
        if (this.focusedItem != -1) {
            this.focusedItem = -1;
            this.offScreenImageInvalid = true;
            this.repaint();
        }
    }

    public void selectAllItems() {
        for (int i = 0; i < this.model.getItemCount(); ++i) {
            this.selectedItems.add(i);
        }
        this.offScreenImageInvalid = true;
        this.repaint();
    }

    public void toggleItemSelection(int selectedItem) {
        if (this.selectedItems.contains(selectedItem)) {
            this.removeSelectedItem(selectedItem);
        } else {
            this.addSelectedItem(selectedItem);
        }
    }

    protected Color getDisabledColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return new Color(r, g, b, 50);
    }

    protected void drawChart(Graphics2D g2) {
        this.arcs.clear();
        this.bottoms.clear();
        Area focusedItemArea = null;
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.drawWidth + 1, this.drawHeight + 1);
        g2.setStroke(new BasicStroke(0.5f));
        if (!this.model.hasData()) {
            Area rectAreaUpper = new Area(new Rectangle2D.Double(0.0, this.pieCenterY + 1, this.drawWidth - 1, this.pieCenterY + this.pieHeight));
            rectAreaUpper.subtract(this.pieArea);
            Area rectAreaLower = new Area(rectAreaUpper);
            rectAreaLower.transform(AffineTransform.getTranslateInstance(0.0, this.chartHeight));
            rectAreaUpper.subtract(rectAreaLower);
            g2.setPaint(Color.BLACK);
            g2.draw(rectAreaUpper);
            g2.drawArc(0, 0, this.drawWidth - 1, this.pieHeight, 0, 180);
        } else {
            int startAngle = this.initialAngle;
            double left = 0.0;
            double right = 0.0;
            double width = 0.0;
            double top = 0.0;
            double bottom = 0.0;
            double height = 0.0;
            int pieParts = this.model.getItemCount();
            for (int i = 0; i < pieParts; ++i) {
                int extentAngle;
                if (this.model.getItemValueRel(i) == 0.0 || (extentAngle = (int)Math.min(Math.ceil(this.model.getItemValueRel(i) * 360.0), (double)(360 - startAngle))) == 0) continue;
                Arc2D.Double arc = new Arc2D.Double(0.0, 1.0, this.drawWidth - 1, this.pieHeight, startAngle, extentAngle, 2);
                this.arcs.add(arc);
                if (i == this.focusedItem) {
                    focusedItemArea = pieParts == 1 ? new Area(new Ellipse2D.Double(0.0, 1.0, this.drawWidth - 1, this.pieHeight)) : new Area(arc);
                }
                if (this.draw3D) {
                    Area bottomArea;
                    boolean endPointVisible;
                    Point2D startPoint = arc.getStartPoint();
                    Point2D endPoint = arc.getEndPoint();
                    boolean startPointVisible = startAngle < 0 || startAngle > 180;
                    boolean bl = endPointVisible = startAngle + extentAngle < 0 || startAngle + extentAngle > 180;
                    if (startPointVisible && endPointVisible) {
                        if (startPoint.getX() < endPoint.getX()) {
                            left = startPoint.getX();
                            right = endPoint.getX();
                            width = right - left;
                            top = Math.min(startPoint.getY(), endPoint.getY()) - 1.0;
                            bottom = this.drawHeight;
                            height = bottom - top;
                            bottomArea = this.drawChartPartSide(g2, this.pieArea, left, top, width, height, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                            this.bottoms.add(bottomArea);
                            if (i == this.focusedItem && focusedItemArea != null) {
                                focusedItemArea.add(bottomArea);
                            }
                        } else {
                            left = startPoint.getX();
                            right = this.drawWidth - 1;
                            width = right - left;
                            top = this.pieCenterY + 1;
                            bottom = this.drawHeight;
                            height = bottom - top;
                            bottomArea = this.drawChartPartSide(g2, this.pieArea, left, top, width, height, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                            left = 0.0;
                            right = endPoint.getX();
                            width = right - left;
                            top = this.pieCenterY + 1;
                            bottom = this.drawHeight;
                            height = bottom - top;
                            Area bottomArea2 = this.drawChartPartSide(g2, this.pieArea, left, top, width, height, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                            bottomArea.add(bottomArea2);
                            this.bottoms.add(bottomArea);
                            if (i == this.focusedItem && focusedItemArea != null) {
                                focusedItemArea.add(bottomArea);
                            }
                        }
                    } else if (startPointVisible || endPointVisible) {
                        if (startPointVisible && !endPointVisible) {
                            left = startPoint.getX();
                            right = this.drawWidth - 1;
                            width = right - left;
                            top = this.pieCenterY + 1;
                            bottom = this.drawHeight;
                            height = bottom - top;
                            bottomArea = this.drawChartPartSide(g2, this.pieArea, left, top, width, height, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                            this.bottoms.add(bottomArea);
                            if (i == this.focusedItem && focusedItemArea != null) {
                                focusedItemArea.add(bottomArea);
                            }
                        } else {
                            left = 0.0;
                            right = endPoint.getX();
                            width = right - left;
                            top = this.pieCenterY + 1;
                            bottom = this.drawHeight;
                            height = bottom - top;
                            bottomArea = this.drawChartPartSide(g2, this.pieArea, left, top, width, height, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                            this.bottoms.add(bottomArea);
                            if (i == this.focusedItem && focusedItemArea != null) {
                                focusedItemArea.add(bottomArea);
                            }
                        }
                    } else if (extentAngle >= 180) {
                        left = 0.0;
                        right = this.drawWidth - 1;
                        width = right - left;
                        top = this.pieCenterY + 1;
                        bottom = this.drawHeight;
                        height = bottom - top;
                        bottomArea = this.drawChartPartSide(g2, this.pieArea, left, top, width, height, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                        this.bottoms.add(bottomArea);
                        if (i == this.focusedItem && focusedItemArea != null) {
                            focusedItemArea.add(bottomArea);
                        }
                    } else {
                        this.bottoms.add(null);
                    }
                }
                g2.setPaint(this.selectedItems.contains(i) ? this.model.getItemColor(i) : this.getDisabledColor(this.model.getItemColor(i)));
                g2.fill(arc);
                startAngle += extentAngle;
            }
        }
        if (focusedItemArea != null) {
            g2.setColor(evenSelectionSegmentsColor);
            g2.setStroke(evenSelectionSegmentsStroke);
            g2.draw(focusedItemArea);
            g2.setColor(oddSelectionSegmentColor);
            g2.setStroke(oddSelectionSegmentStroke);
            g2.draw(focusedItemArea);
        }
        this.offScreenImageInvalid = false;
    }

    protected Area drawChartPartSide(Graphics2D g2, Area pieArea, double left, double top, double width, double height, Color color) {
        Area rectAreaUpper = new Area(new Rectangle2D.Double(left, top, width, height));
        rectAreaUpper.subtract(pieArea);
        Area rectAreaLower = new Area(rectAreaUpper);
        rectAreaLower.transform(AffineTransform.getTranslateInstance(0.0, this.chartHeight));
        rectAreaUpper.subtract(rectAreaLower);
        rectAreaUpper.transform(AffineTransform.getTranslateInstance(0.0, -1.0));
        rectAreaUpper.subtract(pieArea);
        g2.setPaint(color);
        g2.fill(rectAreaUpper);
        return rectAreaUpper;
    }

    protected void updateOffScreenImageSize() {
        this.insets = this.getInsets();
        this.drawWidth = this.getWidth() - this.insets.left - this.insets.right;
        this.drawHeight = this.getHeight() - this.insets.top - this.insets.bottom - 1;
        this.pieHeight = this.drawHeight - this.chartHeight;
        this.pieCenterY = this.pieHeight / 2;
        this.offScreenImage = this.createImage(this.drawWidth + 1, this.drawHeight + 1);
        this.offScreenGraphics = (Graphics2D)this.offScreenImage.getGraphics();
        this.offScreenGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.offScreenImageSizeInvalid = false;
        this.offScreenImageInvalid = true;
        this.pieArea = new Area(new Ellipse2D.Double(0.0, 0.0, this.drawWidth - 1, this.pieHeight));
    }
}

