/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Graphics;
import javax.swing.JViewport;
import org.netbeans.lib.profiler.ui.threads.ThreadsPanel;
import org.netbeans.lib.profiler.ui.threads.TimeLineUtils;

public class CustomTimeLineViewport
extends JViewport {
    private ThreadsPanel viewManager;
    private int paintWidth;
    private int paintX;
    private long dataEnd;
    private long dataStart;
    private long viewEnd;
    private long viewStart;

    public CustomTimeLineViewport(ThreadsPanel viewManager) {
        this.viewManager = viewManager;
        this.syncViewVariables();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setClip(this.paintX, this.getEmptySpaceY(), this.paintWidth, this.getHeight() - this.getEmptySpaceY());
        this.paintTimeMarks(g);
    }

    private int getEmptySpaceY() {
        if (this.getView() == null) {
            return 0;
        }
        return this.getView().getHeight();
    }

    private void paintTimeMarks(Graphics g) {
        this.syncViewVariables();
        if (this.viewEnd - this.viewStart > 0L) {
            int firstValue = (int)(this.viewStart - this.dataStart);
            int lastValue = (int)(this.viewEnd - this.dataStart);
            float factor = (float)this.paintWidth / (float)(this.viewEnd - this.viewStart);
            int optimalUnits = TimeLineUtils.getOptimalUnits(factor);
            int firstMark = Math.max((int)(Math.ceil((double)firstValue / (double)optimalUnits) * (double)optimalUnits), 0);
            for (int currentMark = firstMark - optimalUnits; currentMark <= lastValue + optimalUnits; currentMark += optimalUnits) {
                if (currentMark < 0) continue;
                float currentMarkRel = currentMark - firstValue;
                int markPosition = (int)(currentMarkRel * factor);
                this.paintTimeTicks(g, (int)(currentMarkRel * factor), (int)((currentMarkRel + (float)optimalUnits) * factor), TimeLineUtils.getTicksCount(optimalUnits));
                g.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                g.drawLine(this.paintX + markPosition, this.getEmptySpaceY(), this.paintX + markPosition, this.getHeight() - 1);
            }
        }
    }

    private void paintTimeTicks(Graphics g, int startPos, int endPos, int count) {
        float factor = (float)(endPos - startPos) / (float)count;
        g.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
        for (int i = 1; i < count; ++i) {
            int x = startPos + (int)((float)i * factor);
            g.drawLine(this.paintX + x, this.getEmptySpaceY(), this.paintX + x, this.getHeight() - 1);
        }
    }

    private void syncViewVariables() {
        this.viewStart = this.viewManager.getViewStart();
        this.viewEnd = this.viewManager.getViewEnd();
        this.dataStart = this.viewManager.getDataStart();
        this.dataEnd = this.viewManager.getDataEnd();
        this.paintWidth = this.viewManager.getDisplayColumnWidth();
        this.paintX = this.getWidth() - this.paintWidth;
    }
}

