/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.flow.visual;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.action.AcceptProvider;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.ConnectDecorator;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.MoveControlPointProvider;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.ReconnectDecorator;
import org.netbeans.api.visual.action.ReconnectProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.graph.layout.GridGraphLayout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.router.ConnectionWidgetCollisionsCollector;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.vmd.api.flow.FlowPinOrderPresenter;
import org.netbeans.modules.vmd.api.flow.FlowPresenter;
import org.netbeans.modules.vmd.api.flow.FlowScenePresenter;
import org.netbeans.modules.vmd.api.flow.visual.FlowBadgeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowEdgeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowNodeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowPinDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.OrthogonalCollisionsCollector;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.netbeans.modules.vmd.api.palette.PaletteSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public final class FlowScene
extends GraphPinScene<FlowNodeDescriptor, FlowEdgeDescriptor, FlowPinDescriptor> {
    private static Paint PAINT_BACKGROUND;
    private DesignDocument document;
    private LayerWidget backgroundLayer;
    private LayerWidget mainLayer;
    private LayerWidget connectionLayer;
    private LayerWidget interractionLayer;
    private WidgetAction moveAction;
    private WidgetAction acceptAction;
    private WidgetAction connectAction;
    private WidgetAction reconnectAction;
    private WidgetAction moveControlPointAction;
    private WidgetAction renameAction;
    private WidgetAction popupMenuAction;
    private WidgetAction editAction;
    private WidgetAction sceneSelectAction;
    private WidgetAction sceneKeyAction;
    private Router edgeRouter;
    private HashMap<CacheNodeDescriptor, Point> preferredNodeLocationCache = new HashMap();
    private HashMap<Long, Point> preferredNodeLocationMap = new HashMap();
    private Long eventID;
    private HashMap<FlowNodeDescriptor, FlowPresenter.FlowUIResolver> nodeUIregistry = new HashMap();
    private HashMap<FlowPinDescriptor, FlowPresenter.FlowUIResolver> pinUIregistry = new HashMap();
    private HashMap<FlowEdgeDescriptor, FlowPresenter.FlowUIResolver> edgeUIregistry = new HashMap();
    private HashMap<FlowBadgeDescriptor, FlowPresenter.FlowUIResolver> pinBadgeUIregistry = new HashMap();
    private HashMap<FlowDescriptor, ArrayList<FlowBadgeDescriptor>> badges = new HashMap();
    private HashSet<FlowNodeDescriptor> nodesForOrdering = new HashSet();
    private GridGraphLayout<FlowNodeDescriptor, FlowEdgeDescriptor> graphLayout;
    private SceneLayout sceneLayout;

    public FlowScene(DesignDocument document) {
        this.document = document;
        this.setOpaque(true);
        this.setBackground(PAINT_BACKGROUND);
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.backgroundLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.backgroundLayer);
        this.mainLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.mainLayer);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.connectionLayer);
        this.interractionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.interractionLayer);
        this.moveAction = ActionFactory.createMoveAction(null, (MoveProvider)new FlowMoveProvider());
        this.acceptAction = ActionFactory.createAcceptAction((AcceptProvider)new FlowAcceptProvider());
        FlowConnectDecoratorProvider flowConnectDecoratorProvider = new FlowConnectDecoratorProvider();
        this.connectAction = ActionFactory.createConnectAction((ConnectDecorator)flowConnectDecoratorProvider, (LayerWidget)this.interractionLayer, (ConnectProvider)flowConnectDecoratorProvider);
        FlowReconnectDecoratorProvider flowReconnectDecoratorProvider = new FlowReconnectDecoratorProvider();
        this.reconnectAction = ActionFactory.createReconnectAction((ReconnectDecorator)flowReconnectDecoratorProvider, (ReconnectProvider)flowReconnectDecoratorProvider);
        this.moveControlPointAction = ActionFactory.createMoveControlPointAction((MoveControlPointProvider)ActionFactory.createOrthogonalMoveControlPointProvider(), (ConnectionWidget.RoutingPolicy)ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED);
        this.renameAction = ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new FlowRenameEditor());
        this.editAction = ActionFactory.createEditAction((EditProvider)new FlowEditProvider());
        this.popupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new FlowPopupMenuProvider());
        this.sceneSelectAction = new FlowSceneSelectAction();
        this.sceneKeyAction = new FlowSceneKeyAction();
        this.edgeRouter = NbPreferences.forModule(RouterFactory.class).getBoolean("vmd.direct.routing", false) ? RouterFactory.createDirectRouter() : RouterFactory.createOrthogonalSearchRouter((ConnectionWidgetCollisionsCollector)new OrthogonalCollisionsCollector(this.mainLayer, this.connectionLayer));
        this.getActions().addAction(ActionFactory.createMouseCenteredZoomAction((double)1.2));
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(this.sceneSelectAction);
        this.getActions().addAction(this.createSelectAction());
        this.getActions().addAction(this.createAcceptAction());
        this.getActions().addAction(this.popupMenuAction);
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((ObjectScene)this, (LayerWidget)this.backgroundLayer));
        this.getActions().addAction(ActionFactory.createCycleObjectSceneFocusAction());
        this.getActions().addAction(this.sceneKeyAction);
        this.graphLayout = new GridGraphLayout().setChecker(true);
        this.sceneLayout = LayoutFactory.createSceneGraphLayout((GraphPinScene)this, this.graphLayout);
        this.addObjectSceneListener(new FlowObjectSceneListener(), new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
    }

    public DesignDocument getDocument() {
        return this.document;
    }

    public void setCurrentEventIDForPreferredNodeLocationProcessing(Long eventID) {
        this.eventID = eventID;
        if (eventID != null) {
            Iterator<Map.Entry<Long, Point>> iterator = this.preferredNodeLocationMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, Point> entry = iterator.next();
                if (entry.getKey() >= eventID) continue;
                iterator.remove();
            }
        }
    }

    protected Widget attachNodeWidget(FlowNodeDescriptor node) {
        Widget widget = this.getDecorator(node).createWidget(node, this);
        Point preferredLocation = this.preferredNodeLocationCache.get(new CacheNodeDescriptor(node));
        if (preferredLocation == null) {
            Point point = preferredLocation = this.eventID != null ? this.preferredNodeLocationMap.get(this.eventID) : null;
        }
        if (preferredLocation == null) {
            preferredLocation = new Point(50, 50);
        }
        widget.setPreferredLocation(preferredLocation);
        this.mainLayer.addChild(widget);
        return widget;
    }

    protected void detachNodeWidget(FlowNodeDescriptor descriptor, Widget widget) {
        if (widget != null) {
            this.preferredNodeLocationCache.put(new CacheNodeDescriptor(descriptor), widget.getPreferredLocation());
        }
        super.detachNodeWidget((Object)descriptor, widget);
    }

    protected Widget attachPinWidget(FlowNodeDescriptor node, FlowPinDescriptor pin) {
        FlowPinDescriptor.PinDecorator decorator = this.getDecorator(pin);
        Widget widget = decorator.createWidget(pin, this);
        if (widget != null) {
            this.getDecorator((FlowNodeDescriptor)this.findStoredObject(node)).attachPinWidget(node, this, widget);
        }
        return widget;
    }

    protected Widget attachEdgeWidget(FlowEdgeDescriptor edge) {
        Widget widget = this.getDecorator(edge).create(edge, this);
        assert (widget instanceof ConnectionWidget);
        this.connectionLayer.addChild(widget);
        return widget;
    }

    protected void attachEdgeSourceAnchor(FlowEdgeDescriptor edge, FlowPinDescriptor oldSourcePin, FlowPinDescriptor sourcePin) {
        Anchor anchor = null;
        if (sourcePin != null) {
            anchor = this.getDecorator(sourcePin).createAnchor(sourcePin, this);
        }
        this.getDecorator(edge).setSourceAnchor(edge, this, anchor);
    }

    protected void attachEdgeTargetAnchor(FlowEdgeDescriptor edge, FlowPinDescriptor oldTargetPin, FlowPinDescriptor targetPin) {
        Anchor anchor = null;
        if (targetPin != null) {
            anchor = this.getDecorator(targetPin).createAnchor(targetPin, this);
        }
        this.getDecorator(edge).setTargetAnchor(edge, this, anchor);
    }

    public Router createEdgeRouter() {
        return this.edgeRouter;
    }

    public WidgetAction createMoveAction() {
        return this.moveAction;
    }

    public WidgetAction createAcceptAction() {
        return this.acceptAction;
    }

    public WidgetAction createMoveControlPointAction() {
        return this.moveControlPointAction;
    }

    public WidgetAction createRenameAction() {
        return this.renameAction;
    }

    public WidgetAction createConnectAction() {
        return this.connectAction;
    }

    public WidgetAction createReconnectAction() {
        return this.reconnectAction;
    }

    public WidgetAction createPopupMenuAction() {
        return this.popupMenuAction;
    }

    public WidgetAction createEditAction() {
        return this.editAction;
    }

    public void userSelectionSuggested(Set<? extends Object> suggestedSelectedObjects, boolean invertSelection) {
        super.userSelectionSuggested(suggestedSelectedObjects, invertSelection);
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent rootComponent;
                ArrayList<DesignComponent> selection = new ArrayList<DesignComponent>();
                for (Object object : FlowScene.this.getSelectedObjects()) {
                    DesignComponent component = object instanceof FlowDescriptor ? ((FlowDescriptor)object).getRepresentedComponent() : null;
                    if (component == null) continue;
                    selection.add(component);
                }
                if (selection.isEmpty() && (rootComponent = FlowScene.this.document.getRootComponent()) != null) {
                    selection.add(rootComponent);
                }
                FlowScene.this.document.setSelectedComponents("flow", selection);
            }
        });
    }

    public void addNodeCommonActions(Widget widget) {
        WidgetAction.Chain actions = widget.getActions();
        actions.addAction(this.createObjectHoverAction());
        actions.addAction(this.createSelectAction());
        actions.addAction(this.createMoveAction());
        actions.addAction(this.createAcceptAction());
        actions.addAction(this.createPopupMenuAction());
        actions.addAction(this.createEditAction());
    }

    public void addEdgeCommonActions(ConnectionWidget widget) {
        WidgetAction.Chain actions = widget.getActions();
        actions.addAction(this.createObjectHoverAction());
        actions.addAction(this.createSelectAction());
        actions.addAction(this.createReconnectAction());
        actions.addAction(this.createPopupMenuAction());
        actions.addAction(this.createEditAction());
    }

    public void addPinCommonActions(Widget widget) {
        WidgetAction.Chain actions = widget.getActions();
        actions.addAction(this.createObjectHoverAction());
        widget.getActions().addAction(this.createSelectAction());
        widget.getActions().addAction(this.createAcceptAction());
        widget.getActions().addAction(this.createConnectAction());
        actions.addAction(this.createPopupMenuAction());
        actions.addAction(this.createEditAction());
    }

    public void addBadge(FlowDescriptor descriptor, FlowBadgeDescriptor badge) {
        if (badge == null) {
            return;
        }
        ArrayList<FlowBadgeDescriptor> list = this.badges.get(descriptor);
        if (list == null) {
            list = new ArrayList();
            this.badges.put(descriptor, list);
        }
        list.add(badge);
    }

    public void removeBadge(FlowDescriptor descriptor, FlowBadgeDescriptor badge) {
        ArrayList<FlowBadgeDescriptor> list = this.badges.get(descriptor);
        if (list == null) {
            return;
        }
        list.remove(badge);
        if (list.isEmpty()) {
            this.badges.remove(descriptor);
        }
    }

    public void updateBadges(FlowDescriptor descriptor) {
        FlowDescriptor.BadgeDecorator decorator = this.getAbstractDecorator(descriptor, FlowDescriptor.BadgeDecorator.class);
        if (decorator == null) {
            return;
        }
        ArrayList<FlowBadgeDescriptor> list = this.badges.get(descriptor);
        if (list != null) {
            Collections.sort(list, new Comparator<FlowBadgeDescriptor>(){

                @Override
                public int compare(FlowBadgeDescriptor o1, FlowBadgeDescriptor o2) {
                    return FlowScene.this.getDecorator(o1).getOrder(o1) - FlowScene.this.getDecorator(o2).getOrder(o2);
                }
            });
            decorator.updateBadges(descriptor, this, list);
        } else {
            decorator.updateBadges(descriptor, this, Collections.<FlowBadgeDescriptor>emptyList());
        }
    }

    public void registerUI(FlowNodeDescriptor descriptor, FlowPresenter.FlowUIResolver resolver) {
        assert (resolver != null);
        this.nodeUIregistry.put(descriptor, resolver);
    }

    public void unregisterUI(FlowNodeDescriptor descriptor, FlowPresenter.FlowUIResolver resolver) {
        FlowPresenter.FlowUIResolver resolver2 = this.nodeUIregistry.remove(descriptor);
        assert (resolver == resolver2);
    }

    public FlowNodeDescriptor.NodeDecorator getDecorator(FlowNodeDescriptor node) {
        return (FlowNodeDescriptor.NodeDecorator)this.nodeUIregistry.get(node).getDecorator();
    }

    public FlowNodeDescriptor.NodeBehaviour getBehaviour(FlowNodeDescriptor node) {
        return (FlowNodeDescriptor.NodeBehaviour)this.nodeUIregistry.get(node).getBehaviour();
    }

    public void registerUI(FlowPinDescriptor descriptor, FlowPresenter.FlowUIResolver resolver) {
        assert (resolver != null);
        this.pinUIregistry.put(descriptor, resolver);
    }

    public void unregisterUI(FlowPinDescriptor descriptor, FlowPresenter.FlowUIResolver resolver) {
        FlowPresenter.FlowUIResolver resolver2 = this.pinUIregistry.remove(descriptor);
        assert (resolver == resolver2);
    }

    public FlowPinDescriptor.PinDecorator getDecorator(FlowPinDescriptor pin) {
        return (FlowPinDescriptor.PinDecorator)this.pinUIregistry.get(pin).getDecorator();
    }

    public FlowPinDescriptor.PinBehaviour getBehaviour(FlowPinDescriptor pin) {
        return (FlowPinDescriptor.PinBehaviour)this.pinUIregistry.get(pin).getBehaviour();
    }

    public void registerUI(FlowEdgeDescriptor descriptor, FlowPresenter.FlowUIResolver resolver) {
        assert (resolver != null);
        this.edgeUIregistry.put(descriptor, resolver);
    }

    public void unregisterUI(FlowEdgeDescriptor descriptor, FlowPresenter.FlowUIResolver resolver) {
        FlowPresenter.FlowUIResolver resolver2 = this.edgeUIregistry.remove(descriptor);
        assert (resolver == resolver2);
    }

    public FlowEdgeDescriptor.EdgeDecorator getDecorator(FlowEdgeDescriptor edge) {
        return (FlowEdgeDescriptor.EdgeDecorator)this.edgeUIregistry.get(edge).getDecorator();
    }

    public FlowEdgeDescriptor.EdgeBehaviour getBehaviour(FlowEdgeDescriptor edge) {
        return (FlowEdgeDescriptor.EdgeBehaviour)this.edgeUIregistry.get(edge).getBehaviour();
    }

    public void registerUI(FlowBadgeDescriptor descriptor, FlowPresenter.FlowUIResolver resolver) {
        assert (resolver != null);
        this.pinBadgeUIregistry.put(descriptor, resolver);
    }

    public void unregisterUI(FlowBadgeDescriptor descriptor, FlowPresenter.FlowUIResolver resolver) {
        FlowPresenter.FlowUIResolver resolver2 = this.pinBadgeUIregistry.remove(descriptor);
        assert (resolver == resolver2);
    }

    public FlowBadgeDescriptor.BadgeDecorator getDecorator(FlowBadgeDescriptor pinBadge) {
        return (FlowBadgeDescriptor.BadgeDecorator)this.pinBadgeUIregistry.get(pinBadge).getDecorator();
    }

    public FlowBadgeDescriptor.BadgeBehaviour getBehaviour(FlowBadgeDescriptor pinBadge) {
        return (FlowBadgeDescriptor.BadgeBehaviour)this.pinBadgeUIregistry.get(pinBadge).getBehaviour();
    }

    private <T extends FlowDescriptor.Decorator> T getAbstractDecorator(FlowDescriptor descriptor, Class<T> clazz) {
        if (descriptor == null) {
            return null;
        }
        FlowPresenter.FlowUIResolver presenter = this.nodeUIregistry.get(descriptor);
        if (presenter == null && (presenter = this.pinUIregistry.get(descriptor)) == null && (presenter = this.edgeUIregistry.get(descriptor)) == null && (presenter = this.pinBadgeUIregistry.get(descriptor)) == null) {
            return null;
        }
        FlowDescriptor.Decorator decorator = presenter.getDecorator();
        return (T)(clazz.isInstance(decorator) ? decorator : null);
    }

    private <T extends FlowDescriptor.Behaviour> T getAbstractBehaviour(FlowDescriptor descriptor, Class<T> clazz) {
        if (descriptor == null) {
            return null;
        }
        FlowPresenter.FlowUIResolver presenter = this.nodeUIregistry.get(descriptor);
        if (presenter == null && (presenter = this.pinUIregistry.get(descriptor)) == null && (presenter = this.edgeUIregistry.get(descriptor)) == null && (presenter = this.pinBadgeUIregistry.get(descriptor)) == null) {
            return null;
        }
        FlowDescriptor.Behaviour behaviour = presenter.getBehaviour();
        return (T)(clazz.isInstance(behaviour) ? behaviour : null);
    }

    public void scheduleNodeDescriptorForOrdering(FlowNodeDescriptor node) {
        this.nodesForOrdering.add(node);
    }

    public void resolveOrderInNodeDescriptors() {
        for (FlowNodeDescriptor node : this.nodesForOrdering) {
            if (!this.isNode(node)) continue;
            FlowNodeDescriptor.NodeDecorator decorator = this.getDecorator(node);
            DesignComponent orderComponent = decorator.getComponentWithPinOrderPresenters();
            if (orderComponent == null) {
                decorator.orderPins(node, this, Collections.<String, List<FlowPinDescriptor>>emptyMap());
                continue;
            }
            Collection presenters = orderComponent.getPresenters(FlowPinOrderPresenter.class);
            if (presenters.isEmpty()) {
                decorator.orderPins(node, this, Collections.<String, List<FlowPinDescriptor>>emptyMap());
                continue;
            }
            HashMap<String, ArrayList<FlowPinDescriptor>> categories = new HashMap<String, ArrayList<FlowPinDescriptor>>();
            for (FlowPinDescriptor pin : this.getNodePins(node)) {
                String category = this.getDecorator(pin).getOrderCategory(pin);
                ArrayList<FlowPinDescriptor> list = (ArrayList<FlowPinDescriptor>)categories.get(category);
                if (list == null) {
                    list = new ArrayList<FlowPinDescriptor>();
                    categories.put(category, list);
                }
                list.add(pin);
            }
            HashMap<String, List<FlowPinDescriptor>> order = new HashMap<String, List<FlowPinDescriptor>>();
            for (FlowPinOrderPresenter presenter : presenters) {
                String category = presenter.getCategoryID();
                ArrayList descriptors = (ArrayList)categories.get(category);
                if (descriptors == null) continue;
                order.put(presenter.getCategoryDisplayName(), presenter.sortCategory(descriptors));
            }
            decorator.orderPins(node, this, order);
        }
        this.nodesForOrdering.clear();
    }

    public void layoutScene() {
        this.sceneLayout.invokeLayout();
    }

    private Anchor createAnchorForDescriptor(FlowDescriptor descriptor) {
        Anchor anchor = null;
        if (descriptor != null) {
            FlowPinDescriptor pin;
            FlowPinDescriptor.PinDecorator decorator;
            if (descriptor instanceof FlowNodeDescriptor) {
                FlowNodeDescriptor node = (FlowNodeDescriptor)descriptor;
                FlowNodeDescriptor.NodeDecorator decorator2 = this.getDecorator(node);
                if (decorator2 != null) {
                    anchor = decorator2.createAnchor(node, this);
                }
            } else if (descriptor instanceof FlowPinDescriptor && (decorator = this.getDecorator(pin = (FlowPinDescriptor)descriptor)) != null) {
                anchor = decorator.createAnchor(pin, this);
            }
        }
        return anchor;
    }

    static {
        Image sourceImage = ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/flow/resources/paper_grid.png");
        int width = sourceImage.getWidth(null);
        int height = sourceImage.getHeight(null);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage(sourceImage, 0, 0, null);
        graphics.dispose();
        PAINT_BACKGROUND = new TexturePaint(image, new Rectangle(0, 0, width, height));
    }

    private static final class CacheNodeDescriptor {
        private long componentid;
        private String descriptorid;

        public CacheNodeDescriptor(FlowNodeDescriptor node) {
            this.componentid = node.getRepresentedComponent().getComponentID();
            this.descriptorid = node.getDescriptorID();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheNodeDescriptor desc = (CacheNodeDescriptor)o;
            return this.componentid == desc.componentid && this.descriptorid.equals(desc.descriptorid);
        }

        public int hashCode() {
            int result = (int)(this.componentid ^ this.componentid >>> 32);
            result = 29 * result + (this.descriptorid != null ? this.descriptorid.hashCode() : 0);
            return result;
        }
    }

    private class FlowMoveProvider
    implements MoveProvider {
        private HashMap<Widget, Point> originals = new HashMap();
        private Point original;

        private FlowMoveProvider() {
        }

        public void movementStarted(Widget widget) {
            Object object = FlowScene.this.findObject(widget);
            if (FlowScene.this.isNode(object)) {
                for (Object o : FlowScene.this.getSelectedObjects()) {
                    Widget w;
                    if (!FlowScene.this.isNode(o) || (w = FlowScene.this.findWidget(o)) == null) continue;
                    this.originals.put(w, w.getPreferredLocation());
                }
            } else {
                this.originals.put(widget, widget.getPreferredLocation());
            }
        }

        public void movementFinished(Widget widget) {
            this.originals.clear();
            this.original = null;
        }

        public Point getOriginalLocation(Widget widget) {
            this.original = widget.getPreferredLocation();
            return this.original;
        }

        public void setNewLocation(Widget widget, Point location) {
            int dx = location.x - this.original.x;
            int dy = location.y - this.original.y;
            for (Map.Entry<Widget, Point> entry : this.originals.entrySet()) {
                Point point = entry.getValue();
                entry.getKey().setPreferredLocation(new Point(point.x + dx, point.y + dy));
            }
        }
    }

    private class FlowEditProvider
    implements EditProvider {
        private FlowEditProvider() {
        }

        public void edit(final Widget widget) {
            FlowDescriptor descriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
            if (descriptor == null) {
                return;
            }
            FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    FlowDescriptor descriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                    FlowDescriptor.EditActionBehaviour behaviour = (FlowDescriptor.EditActionBehaviour)FlowScene.this.getAbstractBehaviour(descriptor, FlowDescriptor.EditActionBehaviour.class);
                    if (behaviour != null) {
                        behaviour.edit(descriptor);
                    }
                }
            });
        }
    }

    private class FlowRenameEditor
    implements TextFieldInplaceEditor {
        private FlowRenameEditor() {
        }

        public boolean isEnabled(final Widget widget) {
            FlowDescriptor descriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
            if (descriptor == null) {
                return false;
            }
            final boolean[] ret = new boolean[]{false};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    FlowDescriptor descriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                    FlowDescriptor.RenameActionBehaviour behaviour = (FlowDescriptor.RenameActionBehaviour)FlowScene.this.getAbstractBehaviour(descriptor, FlowDescriptor.RenameActionBehaviour.class);
                    if (behaviour != null) {
                        ret[0] = behaviour.isEditable(descriptor);
                    }
                }
            });
            return ret[0];
        }

        public String getText(final Widget widget) {
            FlowDescriptor descriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
            if (descriptor == null) {
                return null;
            }
            final String[] ret = new String[]{null};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    FlowDescriptor descriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                    FlowDescriptor.RenameActionBehaviour behaviour = (FlowDescriptor.RenameActionBehaviour)FlowScene.this.getAbstractBehaviour(descriptor, FlowDescriptor.RenameActionBehaviour.class);
                    if (behaviour != null) {
                        ret[0] = behaviour.getText(descriptor);
                    }
                }
            });
            return ret[0];
        }

        public void setText(final Widget widget, final String text) {
            FlowDescriptor descriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
            if (descriptor == null) {
                return;
            }
            FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    FlowDescriptor descriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                    FlowDescriptor.RenameActionBehaviour behaviour = (FlowDescriptor.RenameActionBehaviour)FlowScene.this.getAbstractBehaviour(descriptor, FlowDescriptor.RenameActionBehaviour.class);
                    if (behaviour != null) {
                        behaviour.setText(descriptor, text);
                    }
                }
            });
        }
    }

    private class FlowSceneKeyAction
    extends WidgetAction.Adapter {
        private FlowSceneKeyAction() {
        }

        public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent event) {
            final FlowDescriptor.KeyActionBehaviour[] ret = new FlowDescriptor.KeyActionBehaviour[1];
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    FlowDescriptor.Behaviour behavior;
                    FlowScenePresenter presenter;
                    DesignComponent root = FlowScene.this.document.getRootComponent();
                    if (root != null && (presenter = (FlowScenePresenter)root.getPresenter(FlowScenePresenter.class)) != null && (behavior = presenter.getBehavior()) instanceof FlowDescriptor.KeyActionBehaviour) {
                        ret[0] = (FlowDescriptor.KeyActionBehaviour)behavior;
                    }
                }
            });
            return ret[0] != null && ret[0].keyPressed(event) ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
        }
    }

    private class FlowPopupMenuProvider
    implements PopupMenuProvider {
        private FlowPopupMenuProvider() {
        }

        public JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
            JComponent component = FlowScene.this.getView();
            if (widget == FlowScene.this) {
                final DesignComponent[] ret = new DesignComponent[1];
                FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        ret[0] = FlowScene.this.document.getRootComponent();
                    }
                });
                if (!FlowScene.this.getSelectedObjects().isEmpty()) {
                    FlowScene.this.userSelectionSuggested(Collections.emptySet(), false);
                }
                return Utilities.actionsToPopup((Action[])ActionsSupport.createActionsArray((DesignComponent)ret[0]), (Component)component);
            }
            FlowDescriptor descriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
            if (descriptor == null) {
                return null;
            }
            FlowScene.this.setFocusedObject(descriptor);
            if (!FlowScene.this.getSelectedObjects().contains(descriptor)) {
                FlowScene.this.userSelectionSuggested(Collections.singleton(descriptor), false);
            }
            return Utilities.actionsToPopup((Action[])ActionsSupport.createActionsArray((DesignComponent)descriptor.getRepresentedComponent()), (Component)component);
        }
    }

    private class FlowReconnectDecoratorProvider
    implements ReconnectDecorator,
    ReconnectProvider {
        private FlowDescriptor replacement = null;

        private FlowReconnectDecoratorProvider() {
        }

        public Anchor createReplacementWidgetAnchor(Widget replacementWidget) {
            return FlowScene.this.createAnchorForDescriptor(this.replacement);
        }

        public Anchor createFloatAnchor(Point point) {
            return ActionFactory.createDefaultReconnectDecorator().createFloatAnchor(point);
        }

        public boolean isSourceReconnectable(final ConnectionWidget connectionWidget) {
            final boolean[] ret = new boolean[]{false};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    Object object = FlowScene.this.findObject((Widget)connectionWidget);
                    if (!FlowScene.this.isEdge(object)) {
                        return;
                    }
                    FlowEdgeDescriptor edge = (FlowEdgeDescriptor)object;
                    ret[0] = FlowScene.this.getBehaviour(edge).isSourceReconnectable(edge);
                }
            });
            return ret[0];
        }

        public boolean isTargetReconnectable(final ConnectionWidget connectionWidget) {
            final boolean[] ret = new boolean[]{false};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    Object object = FlowScene.this.findObject((Widget)connectionWidget);
                    if (!FlowScene.this.isEdge(object)) {
                        return;
                    }
                    FlowEdgeDescriptor edge = (FlowEdgeDescriptor)object;
                    ret[0] = FlowScene.this.getBehaviour(edge).isTargetReconnectable(edge);
                }
            });
            return ret[0];
        }

        public void reconnectingStarted(ConnectionWidget connectionWidget, boolean b) {
        }

        public void reconnectingFinished(ConnectionWidget connectionWidget, boolean b) {
        }

        public ConnectorState isReplacementWidget(final ConnectionWidget connectionWidget, final Widget replacementWidget, final boolean reconnectingSource) {
            final ConnectorState[] ret = new ConnectorState[1];
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    Object object = FlowScene.this.findObject((Widget)connectionWidget);
                    if (!FlowScene.this.isEdge(object)) {
                        return;
                    }
                    FlowEdgeDescriptor edge = (FlowEdgeDescriptor)object;
                    FlowReconnectDecoratorProvider.this.replacement = (FlowDescriptor)FlowScene.this.findObject(replacementWidget);
                    ret[0] = FlowScene.this.getBehaviour(edge).isReplacement(edge, FlowReconnectDecoratorProvider.this.replacement, reconnectingSource) ? ConnectorState.ACCEPT : ConnectorState.REJECT;
                }
            });
            return ret[0];
        }

        public boolean hasCustomReplacementWidgetResolver(Scene scene) {
            return false;
        }

        public Widget resolveReplacementWidget(Scene scene, Point point) {
            return null;
        }

        public void reconnect(final ConnectionWidget connectionWidget, final Widget replacementWidget, final boolean reconnectingSource) {
            FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    Object object = FlowScene.this.findObject((Widget)connectionWidget);
                    if (!FlowScene.this.isEdge(object)) {
                        return;
                    }
                    FlowEdgeDescriptor edge = (FlowEdgeDescriptor)object;
                    FlowReconnectDecoratorProvider.this.replacement = (FlowDescriptor)FlowScene.this.findObject(replacementWidget);
                    FlowEdgeDescriptor.EdgeBehaviour behaviour = FlowScene.this.getBehaviour(edge);
                    if (behaviour.isReplacement(edge, FlowReconnectDecoratorProvider.this.replacement, reconnectingSource)) {
                        behaviour.setReplacement(edge, FlowReconnectDecoratorProvider.this.replacement, reconnectingSource);
                    }
                }
            });
        }
    }

    private class FlowConnectDecoratorProvider
    implements ConnectDecorator,
    ConnectProvider {
        private FlowPinDescriptor source = null;
        private FlowDescriptor target = null;

        private FlowConnectDecoratorProvider() {
        }

        public ConnectionWidget createConnectionWidget(Scene scene) {
            return ActionFactory.createDefaultConnectDecorator().createConnectionWidget(scene);
        }

        public Anchor createSourceAnchor(Widget sourceWidget) {
            return FlowScene.this.createAnchorForDescriptor(this.source);
        }

        public Anchor createTargetAnchor(Widget targetWidget) {
            return FlowScene.this.createAnchorForDescriptor(this.target);
        }

        public Anchor createFloatAnchor(Point point) {
            return ActionFactory.createDefaultConnectDecorator().createFloatAnchor(point);
        }

        public boolean isSourceWidget(final Widget sourceWidget) {
            final boolean[] ret = new boolean[]{false};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    Object object = FlowScene.this.findObject(sourceWidget);
                    if (FlowScene.this.isPin(object)) {
                        FlowConnectDecoratorProvider.this.source = (FlowPinDescriptor)object;
                        ret[0] = FlowScene.this.getBehaviour(FlowConnectDecoratorProvider.this.source).isConnectionSource(FlowConnectDecoratorProvider.this.source);
                    } else {
                        ret[0] = false;
                    }
                }
            });
            return ret[0];
        }

        public ConnectorState isTargetWidget(Widget sourceWidget, final Widget targetWidget) {
            final ConnectorState[] ret = new ConnectorState[]{ConnectorState.REJECT};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    FlowConnectDecoratorProvider.this.target = (FlowDescriptor)FlowScene.this.findObject(targetWidget);
                    ret[0] = FlowScene.this.getBehaviour(FlowConnectDecoratorProvider.this.source).isConnectionTarget(FlowConnectDecoratorProvider.this.source, FlowConnectDecoratorProvider.this.target) ? ConnectorState.ACCEPT : ConnectorState.REJECT;
                }
            });
            return ret[0];
        }

        public boolean hasCustomTargetWidgetResolver(Scene scene) {
            return false;
        }

        public Widget resolveTargetWidget(Scene scene, Point point) {
            return null;
        }

        public void createConnection(Widget sourceWidget, Widget targetWidget) {
            FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    FlowPinDescriptor.PinBehaviour behaviour = FlowScene.this.getBehaviour(FlowConnectDecoratorProvider.this.source);
                    if (behaviour.isConnectionTarget(FlowConnectDecoratorProvider.this.source, FlowConnectDecoratorProvider.this.target)) {
                        behaviour.createConnection(FlowConnectDecoratorProvider.this.source, FlowConnectDecoratorProvider.this.target);
                    }
                }
            });
        }
    }

    private class FlowSceneSelectAction
    extends WidgetAction.Adapter {
        private FlowSceneSelectAction() {
        }

        public WidgetAction.State mousePressed(final Widget widget, final WidgetAction.WidgetMouseEvent event) {
            final boolean[] ret = new boolean[]{false};
            long eventID = FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    if (widget == FlowScene.this) {
                        DesignComponent rootComponent = FlowScene.this.document.getRootComponent();
                        if (rootComponent == null) {
                            return;
                        }
                        FlowDescriptor rootDescriptor = new FlowDescriptor(rootComponent, "select"){};
                        Collection presenters = rootComponent.getPresenters(FlowScenePresenter.class);
                        for (FlowScenePresenter presenter : presenters) {
                            FlowDescriptor.SelectActionBehaviour selectBehaviour;
                            FlowDescriptor.Behaviour behavior = presenter.getBehavior();
                            if (!(behavior instanceof FlowDescriptor.SelectActionBehaviour) || !(selectBehaviour = (FlowDescriptor.SelectActionBehaviour)behavior).select(rootDescriptor, event.getModifiers())) continue;
                            ret[0] = true;
                            return;
                        }
                    }
                }
            });
            FlowScene.this.preferredNodeLocationMap.put(eventID, widget.convertLocalToScene(event.getPoint()));
            return ret[0] ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
        }
    }

    private class FlowAcceptProvider
    implements AcceptProvider {
        private FlowAcceptProvider() {
        }

        public ConnectorState isAcceptable(final Widget widget, Point point, final Transferable transferable) {
            if (widget == null) {
                return ConnectorState.REJECT_AND_STOP;
            }
            final ConnectorState[] ret = new ConnectorState[]{ConnectorState.REJECT};
            FlowScene.this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    if (widget == FlowScene.this) {
                        DesignComponent rootComponent = FlowScene.this.document.getRootComponent();
                        FlowDescriptor rootDescriptor = new FlowDescriptor(rootComponent, "accept"){};
                        Collection presenters = rootComponent.getPresenters(FlowScenePresenter.class);
                        for (FlowScenePresenter presenter : presenters) {
                            FlowDescriptor.AcceptActionBehaviour acceptBehaviour;
                            FlowDescriptor.Behaviour behavior = presenter.getBehavior();
                            if (!(behavior instanceof FlowDescriptor.AcceptActionBehaviour) || !(acceptBehaviour = (FlowDescriptor.AcceptActionBehaviour)behavior).isAcceptable(rootDescriptor, transferable)) continue;
                            ret[0] = ConnectorState.ACCEPT;
                            break;
                        }
                    } else {
                        FlowDescriptor descriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                        FlowDescriptor.AcceptActionBehaviour behaviour = (FlowDescriptor.AcceptActionBehaviour)FlowScene.this.getAbstractBehaviour(descriptor, FlowDescriptor.AcceptActionBehaviour.class);
                        if (behaviour != null && behaviour.isAcceptable(descriptor, transferable)) {
                            ret[0] = ConnectorState.ACCEPT;
                        }
                    }
                }
            });
            return ret[0];
        }

        public void accept(final Widget widget, Point point, final Transferable transferable) {
            if (widget == null) {
                return;
            }
            long eventID = FlowScene.this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    if (widget == FlowScene.this) {
                        DesignComponent rootComponent = FlowScene.this.document.getRootComponent();
                        FlowDescriptor rootDescriptor = new FlowDescriptor(rootComponent, "accept"){};
                        Collection presenters = rootComponent.getPresenters(FlowScenePresenter.class);
                        for (FlowScenePresenter presenter : presenters) {
                            FlowDescriptor.AcceptActionBehaviour acceptBehaviour;
                            FlowDescriptor.Behaviour behavior = presenter.getBehavior();
                            if (!(behavior instanceof FlowDescriptor.AcceptActionBehaviour) || !(acceptBehaviour = (FlowDescriptor.AcceptActionBehaviour)behavior).isAcceptable(rootDescriptor, transferable)) continue;
                            acceptBehaviour.accept(rootDescriptor, transferable);
                        }
                    } else {
                        FlowDescriptor descriptor = (FlowDescriptor)FlowScene.this.findObject(widget);
                        FlowDescriptor.AcceptActionBehaviour behaviour = (FlowDescriptor.AcceptActionBehaviour)FlowScene.this.getAbstractBehaviour(descriptor, FlowDescriptor.AcceptActionBehaviour.class);
                        if (behaviour != null) {
                            behaviour.accept(descriptor, transferable);
                        }
                    }
                }
            });
            FlowScene.this.preferredNodeLocationMap.put(eventID, widget.convertLocalToScene(point));
            PaletteSupport.getPaletteController((DesignDocument)FlowScene.this.document).clearSelection();
        }
    }

    private class FlowObjectSceneListener
    implements ObjectSceneListener {
        private FlowObjectSceneListener() {
        }

        public void objectAdded(ObjectSceneEvent event, Object addedObject) {
        }

        public void objectRemoved(ObjectSceneEvent event, Object removedObject) {
        }

        public void objectStateChanged(ObjectSceneEvent event, Object changedObject, ObjectState previousState, ObjectState newState) {
        }

        public void selectionChanged(ObjectSceneEvent event, Set<Object> previousSelection, Set<Object> newSelection) {
            HashSet set = new HashSet();
            for (Object object : newSelection) {
                if (FlowScene.this.isNode(object)) {
                    for (FlowPinDescriptor pin : FlowScene.this.getNodePins((FlowNodeDescriptor)object)) {
                        set.addAll(FlowScene.this.findPinEdges(pin, true, true));
                    }
                    continue;
                }
                if (!FlowScene.this.isPin(object)) continue;
                set.addAll(FlowScene.this.findPinEdges((FlowPinDescriptor)object, true, true));
            }
            FlowScene.this.setHighlightedObjects(set);
        }

        public void highlightingChanged(ObjectSceneEvent event, Set<Object> previousHighlighting, Set<Object> newHighlighting) {
        }

        public void hoverChanged(ObjectSceneEvent event, Object previousHoveredObject, Object newHoveredObject) {
        }

        public void focusChanged(ObjectSceneEvent event, Object previousFocusedObject, Object newFocusedObject) {
        }
    }
}

