/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.dd.api.web.RelativeOrdering;
import org.netbeans.modules.j2ee.dd.api.web.RelativeOrderingItems;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.OrderingItemPanel;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RelativeOrderingPanel
extends SectionInnerPanel
implements ItemListener {
    private DDDataObject dObj;
    private WebApp webApp;
    private DefaultListModel listModelAfter;
    private DefaultListModel listModelBefore;
    private JButton bAddAfter;
    private JButton bAddBefore;
    private JButton bDownAfter;
    private JButton bDownBefore;
    private JButton bEditAfter;
    private JButton bEditBefore;
    private JButton bRemoveAfter;
    private JButton bRemoveBefore;
    private JButton bUpAfter;
    private JButton bUpBefore;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JList listAfter;
    private JList listBefore;
    private JPanel pAfter;
    private JPanel pBefore;

    public RelativeOrderingPanel(SectionView sectionView, DDDataObject dObj) {
        super(sectionView);
        WebFragment webFrag;
        RelativeOrdering[] orderings;
        this.dObj = dObj;
        this.webApp = dObj.getWebApp();
        this.initComponents();
        this.listModelAfter = new DefaultListModel();
        this.listAfter.setModel(this.listModelAfter);
        this.listModelBefore = new DefaultListModel();
        this.listBefore.setModel(this.listModelBefore);
        if (this.webApp instanceof WebFragment && (orderings = (webFrag = (WebFragment)this.webApp).getOrdering()) != null) {
            for (RelativeOrdering ordering : orderings) {
                this.addItems(this.listModelAfter, ordering.getAfter());
                this.addItems(this.listModelBefore, ordering.getBefore());
            }
        }
    }

    private void addItems(DefaultListModel model, RelativeOrderingItems items) {
        if (items != null) {
            for (String name : items.getName()) {
                model.addElement(name);
            }
            if (items.getOthers() != null) {
                model.addElement("<others>");
            }
        }
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }

    public void setValue(JComponent source, Object value) {
    }

    public void linkButtonPressed(Object obj, String id) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.pAfter = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.listAfter = new JList();
        this.bAddAfter = new JButton();
        this.bEditAfter = new JButton();
        this.bRemoveAfter = new JButton();
        this.bUpAfter = new JButton();
        this.bDownAfter = new JButton();
        this.pBefore = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.listBefore = new JList();
        this.bAddBefore = new JButton();
        this.bEditBefore = new JButton();
        this.bRemoveBefore = new JButton();
        this.bUpBefore = new JButton();
        this.bDownBefore = new JButton();
        this.setMinimumSize(new Dimension(250, 150));
        this.jLabel1.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"LBL_RelativeOrder"));
        this.pAfter.setOpaque(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"LBL_After"));
        this.listAfter.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.listAfter);
        Mnemonics.setLocalizedText((AbstractButton)this.bAddAfter, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"BTN_Add"));
        this.bAddAfter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelativeOrderingPanel.this.bAddAfterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bEditAfter, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"BTN_Edit"));
        this.bEditAfter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelativeOrderingPanel.this.bEditAfterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bRemoveAfter, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"BTN_Remove"));
        this.bRemoveAfter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelativeOrderingPanel.this.bRemoveAfterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bUpAfter, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"BTN_Up"));
        this.bUpAfter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelativeOrderingPanel.this.bUpAfterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bDownAfter, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"BTN_Down"));
        this.bDownAfter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelativeOrderingPanel.this.bDownAfterActionPerformed(evt);
            }
        });
        GroupLayout pAfterLayout = new GroupLayout((Container)this.pAfter);
        this.pAfter.setLayout((LayoutManager)pAfterLayout);
        pAfterLayout.setHorizontalGroup((GroupLayout.Group)pAfterLayout.createParallelGroup(1).add((GroupLayout.Group)pAfterLayout.createSequentialGroup().add((GroupLayout.Group)pAfterLayout.createParallelGroup(1).add((Component)this.jLabel2).add((GroupLayout.Group)pAfterLayout.createSequentialGroup().add((Component)this.jScrollPane2, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)pAfterLayout.createParallelGroup(1, false).add((Component)this.bRemoveAfter, -1, -1, Short.MAX_VALUE).add((Component)this.bEditAfter, -1, -1, Short.MAX_VALUE).add((Component)this.bAddAfter, -1, -1, Short.MAX_VALUE).add((Component)this.bUpAfter, -1, -1, Short.MAX_VALUE).add((Component)this.bDownAfter, -1, -1, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        pAfterLayout.setVerticalGroup((GroupLayout.Group)pAfterLayout.createParallelGroup(1).add((GroupLayout.Group)pAfterLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)pAfterLayout.createParallelGroup(1, false).add((GroupLayout.Group)pAfterLayout.createSequentialGroup().add((Component)this.bAddAfter).addPreferredGap(0).add((Component)this.bEditAfter).addPreferredGap(0).add((Component)this.bRemoveAfter).addPreferredGap(0).add((Component)this.bUpAfter).addPreferredGap(0).add((Component)this.bDownAfter)).add((Component)this.jScrollPane2)).addContainerGap(31, Short.MAX_VALUE)));
        this.pBefore.setOpaque(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"LBL_Before"));
        this.listBefore.setSelectionMode(0);
        this.jScrollPane3.setViewportView(this.listBefore);
        Mnemonics.setLocalizedText((AbstractButton)this.bAddBefore, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"BTN_Add"));
        this.bAddBefore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelativeOrderingPanel.this.bAddBeforeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bEditBefore, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"BTN_Edit"));
        this.bEditBefore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelativeOrderingPanel.this.bEditBeforeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bRemoveBefore, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"BTN_Remove"));
        this.bRemoveBefore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelativeOrderingPanel.this.bRemoveBeforeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bUpBefore, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"BTN_Up"));
        this.bUpBefore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelativeOrderingPanel.this.bUpBeforeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bDownBefore, (String)NbBundle.getMessage(RelativeOrderingPanel.class, (String)"BTN_Down"));
        this.bDownBefore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelativeOrderingPanel.this.bDownBeforeActionPerformed(evt);
            }
        });
        GroupLayout pBeforeLayout = new GroupLayout((Container)this.pBefore);
        this.pBefore.setLayout((LayoutManager)pBeforeLayout);
        pBeforeLayout.setHorizontalGroup((GroupLayout.Group)pBeforeLayout.createParallelGroup(1).add((GroupLayout.Group)pBeforeLayout.createSequentialGroup().add((GroupLayout.Group)pBeforeLayout.createParallelGroup(1).add((Component)this.jLabel3).add((GroupLayout.Group)pBeforeLayout.createSequentialGroup().add((Component)this.jScrollPane3, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)pBeforeLayout.createParallelGroup(1, false).add((Component)this.bRemoveBefore, -1, -1, Short.MAX_VALUE).add((Component)this.bEditBefore, -1, -1, Short.MAX_VALUE).add((Component)this.bAddBefore, -1, -1, Short.MAX_VALUE).add((Component)this.bUpBefore, -1, -1, Short.MAX_VALUE).add((Component)this.bDownBefore, -1, -1, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)));
        pBeforeLayout.setVerticalGroup((GroupLayout.Group)pBeforeLayout.createParallelGroup(1).add((GroupLayout.Group)pBeforeLayout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((GroupLayout.Group)pBeforeLayout.createParallelGroup(1, false).add((GroupLayout.Group)pBeforeLayout.createSequentialGroup().add((Component)this.bAddBefore).addPreferredGap(0).add((Component)this.bEditBefore).addPreferredGap(0).add((Component)this.bRemoveBefore).addPreferredGap(0).add((Component)this.bUpBefore).addPreferredGap(0).add((Component)this.bDownBefore)).add((Component)this.jScrollPane3)).addContainerGap(31, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pAfter, -2, -1, -2).add(18, 18, 18).add((Component)this.pBefore, -2, -1, -2)).add((Component)this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.pBefore, -2, -1, -2).add((Component)this.pAfter, -2, -1, -2)).addContainerGap(76, Short.MAX_VALUE)));
    }

    private void bAddAfterActionPerformed(ActionEvent evt) {
        String name = this.getOrderItemFromUser("");
        if (name != null) {
            this.listModelAfter.addElement(name);
            this.refreshDdModel();
        }
    }

    private void bEditAfterActionPerformed(ActionEvent evt) {
        String name;
        int x = this.listAfter.getSelectedIndex();
        if (x >= 0 && (name = this.getOrderItemFromUser((String)this.listModelAfter.get(x))) != null) {
            this.listModelAfter.set(x, name);
            this.refreshDdModel();
        }
    }

    private void bRemoveAfterActionPerformed(ActionEvent evt) {
        int x = this.listAfter.getSelectedIndex();
        if (x >= 0) {
            this.listModelAfter.remove(x);
            this.refreshDdModel();
        }
    }

    private void bUpAfterActionPerformed(ActionEvent evt) {
        int x = this.listAfter.getSelectedIndex();
        if (x > 0) {
            this.exchange(this.listModelAfter, x - 1);
        }
        this.listAfter.setSelectedIndex(x - 1);
        this.refreshDdModel();
    }

    private void bDownAfterActionPerformed(ActionEvent evt) {
        int x = this.listAfter.getSelectedIndex();
        if (x >= 0 && x < this.listModelAfter.size() - 1) {
            this.exchange(this.listModelAfter, x);
        }
        this.listAfter.setSelectedIndex(x + 1);
        this.refreshDdModel();
    }

    private void bAddBeforeActionPerformed(ActionEvent evt) {
        String name = this.getOrderItemFromUser("");
        if (name != null) {
            this.listModelBefore.addElement(name);
            this.refreshDdModel();
        }
    }

    private void bEditBeforeActionPerformed(ActionEvent evt) {
        String name;
        int x = this.listBefore.getSelectedIndex();
        if (x >= 0 && (name = this.getOrderItemFromUser((String)this.listModelBefore.get(x))) != null) {
            this.listModelBefore.set(x, name);
            this.refreshDdModel();
        }
    }

    private void bRemoveBeforeActionPerformed(ActionEvent evt) {
        int x = this.listBefore.getSelectedIndex();
        if (x >= 0) {
            this.listModelBefore.remove(x);
            this.refreshDdModel();
        }
    }

    private void bUpBeforeActionPerformed(ActionEvent evt) {
        int x = this.listBefore.getSelectedIndex();
        if (x > 0) {
            this.exchange(this.listModelBefore, x - 1);
        }
        this.listBefore.setSelectedIndex(x - 1);
        this.refreshDdModel();
    }

    private void bDownBeforeActionPerformed(ActionEvent evt) {
        int x = this.listBefore.getSelectedIndex();
        if (x >= 0 && x < this.listModelBefore.size() - 1) {
            this.exchange(this.listModelBefore, x);
        }
        this.listBefore.setSelectedIndex(x + 1);
        this.refreshDdModel();
    }

    private String getOrderItemFromUser(String value) {
        OrderingItemPanel p = new OrderingItemPanel(value);
        DialogDescriptor dd = new DialogDescriptor((Object)p, NbBundle.getMessage(RelativeOrderingPanel.class, (String)"TTL_Ordering"));
        dd.createNotificationLineSupport();
        p.setDlgSupport(dd);
        dd.setOptionType(2);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd))) {
            return p.getResult();
        }
        return null;
    }

    private void exchange(DefaultListModel model, int x) {
        Object tmp1 = model.get(x);
        Object tmp2 = model.get(x + 1);
        model.set(x, tmp2);
        model.set(x + 1, tmp1);
    }

    private void refreshDdModel() {
        if (!(this.webApp instanceof WebFragment)) {
            Logger.global.log(Level.SEVERE, "refreshDdModel failed, not a WebFragment instance of DD passed!");
            return;
        }
        WebFragment webFrag = (WebFragment)this.webApp;
        RelativeOrdering ordering = webFrag.newRelativeOrdering();
        RelativeOrderingItems after = ordering.newRelativeOrderingItems();
        ordering.setAfter(after);
        int maxi = this.listModelAfter.size();
        for (int i = 0; i < maxi; ++i) {
            String item = (String)this.listModelAfter.get(i);
            if (item.equals("<others>")) {
                after.setOthers(after.newRelativeOrderingOthersItem());
                continue;
            }
            after.addName(item);
        }
        RelativeOrderingItems before = ordering.newRelativeOrderingItems();
        ordering.setBefore(before);
        int maxi2 = this.listModelBefore.size();
        for (int i = 0; i < maxi2; ++i) {
            String item = (String)this.listModelBefore.get(i);
            if (item.equals("<others>")) {
                before.setOthers(before.newRelativeOrderingOthersItem());
                continue;
            }
            before.addName(item);
        }
        RelativeOrdering[] orderings = new RelativeOrdering[]{ordering};
        webFrag.setOrdering(orderings);
        this.dObj.modelUpdatedFromUI();
    }
}

