/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.options.AnnotationColorProvider;
import org.netbeans.modules.mercurial.ui.annotate.AnnotateAction;
import org.netbeans.modules.mercurial.ui.clone.CloneAction;
import org.netbeans.modules.mercurial.ui.clone.CloneExternalAction;
import org.netbeans.modules.mercurial.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.mercurial.ui.create.CreateAction;
import org.netbeans.modules.mercurial.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.ui.diff.ImportDiffAction;
import org.netbeans.modules.mercurial.ui.ignore.IgnoreAction;
import org.netbeans.modules.mercurial.ui.log.LogAction;
import org.netbeans.modules.mercurial.ui.menu.ExportMenu;
import org.netbeans.modules.mercurial.ui.menu.MergeMenu;
import org.netbeans.modules.mercurial.ui.menu.RecoverMenu;
import org.netbeans.modules.mercurial.ui.menu.ShareMenu;
import org.netbeans.modules.mercurial.ui.menu.ShowMenu;
import org.netbeans.modules.mercurial.ui.properties.PropertiesAction;
import org.netbeans.modules.mercurial.ui.pull.FetchAction;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.ui.update.ConflictResolvedAction;
import org.netbeans.modules.mercurial.ui.update.ResolveConflictsAction;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.ui.update.UpdateAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class MercurialAnnotator
extends VCSAnnotator {
    private static final int INITIAL_ACTION_ARRAY_LENGTH = 25;
    private static final int STATUS_TEXT_ANNOTABLE = 6494;
    private static final Pattern lessThan = Pattern.compile("<");
    private static final int STATUS_BADGEABLE = 28;
    private static int STATUS_IS_IMPORTANT = 6622;
    public static final String ANNOTATION_STATUS = "status";
    public static final String ANNOTATION_FOLDER = "folder";
    public static final String PROP_ICON_BADGE_CHANGED = "event.badgeChanged";
    public static String[] LABELS = new String[]{"status", "folder"};
    private FileStatusCache cache;
    private MessageFormat format;
    private String emptyFormat;
    private final PropertyChangeSupport support = new PropertyChangeSupport((Object)this);
    private static final String badgeModified = "org/netbeans/modules/mercurial/resources/icons/modified-badge.png";
    private static final String badgeConflicts = "org/netbeans/modules/mercurial/resources/icons/conflicts-badge.png";
    private static final String toolTipModified = "<img src=\"" + MercurialAnnotator.class.getClassLoader().getResource("org/netbeans/modules/mercurial/resources/icons/modified-badge.png") + "\">&nbsp;" + NbBundle.getMessage(MercurialAnnotator.class, (String)"MSG_Contains_Modified_Locally");
    private static final String toolTipConflict = "<img src=\"" + MercurialAnnotator.class.getClassLoader().getResource("org/netbeans/modules/mercurial/resources/icons/conflicts-badge.png") + "\">&nbsp;" + NbBundle.getMessage(MercurialAnnotator.class, (String)"MSG_Contains_Conflicts");

    public MercurialAnnotator() {
        this.cache = Mercurial.getInstance().getFileStatusCache();
        this.initDefaults();
    }

    private void initDefaults() {
        this.refresh();
    }

    public void refresh() {
        String string = HgModuleConfig.getDefault().getAnnotationFormat();
        if (string != null && !string.trim().equals("")) {
            if (!HgUtils.isAnnotationFormatValid(string = HgUtils.createAnnotationFormat(string))) {
                Mercurial.LOG.log(Level.WARNING, "Bad annotation format, switching to defaults");
                string = NbBundle.getMessage(MercurialAnnotator.class, (String)"MercurialAnnotator.defaultFormat");
            }
            this.format = new MessageFormat(string);
            this.emptyFormat = this.format.format(new String[]{"", "", ""}, new StringBuffer(), (FieldPosition)null).toString().trim();
        }
    }

    private static MessageFormat getFormat(String key) {
        String format = NbBundle.getMessage(MercurialAnnotator.class, (String)key);
        return new MessageFormat(format);
    }

    public String annotateName(String name, VCSContext context) {
        FileInformation mostImportantInfo = null;
        File mostImportantFile = null;
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getCachedStatus(file);
            int status = info.getStatus();
            if ((status & STATUS_IS_IMPORTANT) == 0 || !this.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
            mostImportantFile = file;
            folderAnnotation = file.isDirectory();
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !Utils.isFromMultiFileDataObject((VCSContext)context);
        }
        if (mostImportantInfo == null) {
            return null;
        }
        return folderAnnotation ? this.annotateFolderNameHtml(name, context, mostImportantInfo, mostImportantFile) : this.annotateNameHtml(name, mostImportantInfo, mostImportantFile);
    }

    public Image annotateIcon(Image icon, VCSContext context) {
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            if (!file.isDirectory()) continue;
            folderAnnotation = true;
            Utils.addFolderToLog((File)file);
            break;
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !Utils.isFromMultiFileDataObject((VCSContext)context);
        }
        if (!folderAnnotation) {
            return this.annotateFileIcon(context, icon);
        }
        return this.annotateFolderIcon(context, icon);
    }

    private Image annotateFileIcon(VCSContext context, Image icon) throws IllegalArgumentException {
        FileInformation mostImportantInfo = null;
        File mostImportantFile = null;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getCachedStatus(file);
            int status = info.getStatus();
            if ((status & STATUS_IS_IMPORTANT) == 0 || !this.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
            mostImportantFile = file;
        }
        if (mostImportantInfo == null) {
            return null;
        }
        String statusText = null;
        int status = mostImportantInfo.getStatus();
        if (0 != (status & 2)) {
            statusText = this.getAnnotationProvider().EXCLUDED_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x800)) {
            statusText = this.getAnnotationProvider().DELETED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x100)) {
            statusText = this.getAnnotationProvider().REMOVED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 4)) {
            statusText = this.getAnnotationProvider().NEW_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x1000)) {
            FileStatus fileStatus = mostImportantInfo.getStatus(mostImportantFile);
            statusText = fileStatus != null && fileStatus.isCopied() ? this.getAnnotationProvider().COPIED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()}) : this.getAnnotationProvider().ADDED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x10)) {
            statusText = this.getAnnotationProvider().MODIFIED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 8)) {
            statusText = null;
        } else if (0 != (status & 0x40)) {
            statusText = this.getAnnotationProvider().CONFLICT_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 1)) {
            statusText = null;
        } else if (status == 0) {
            statusText = null;
        } else {
            throw new IllegalArgumentException("Uncomparable status: " + status);
        }
        return statusText != null ? ImageUtilities.addToolTipToImage((Image)icon, (String)statusText) : null;
    }

    private Image annotateFolderIcon(VCSContext context, Image icon) {
        boolean isVersioned = false;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getCachedStatus(file);
            if (info == null || (info.getStatus() & 0x1C) == 0) continue;
            isVersioned = true;
            break;
        }
        if (!isVersioned) {
            return null;
        }
        Image badge = null;
        if (this.cache.containsFileOfStatus(context, 64, true)) {
            badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeConflicts, (boolean)true), (String)toolTipConflict);
        } else if (this.cache.containsFileOfStatus(context, 6612, true)) {
            badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeModified, (boolean)true), (String)toolTipModified);
        }
        if (badge != null) {
            return ImageUtilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
        }
        return icon;
    }

    public Action[] getActions(VCSContext ctx, VCSAnnotator.ActionDestination destination) {
        ResourceBundle loc = NbBundle.getBundle(MercurialAnnotator.class);
        Node[] nodes = ctx.getElements().lookupAll(Node.class).toArray(new Node[0]);
        File[] files = ctx.getRootFiles().toArray(new File[ctx.getRootFiles().size()]);
        Set<File> roots = HgUtils.getRepositoryRoots(ctx);
        boolean noneVersioned = roots == null || roots.isEmpty();
        boolean onlyFolders = this.onlyFolders(files);
        boolean onlyProjects = MercurialAnnotator.onlyProjects(nodes);
        ArrayList<Object> actions = new ArrayList<Object>(25);
        if (destination == VCSAnnotator.ActionDestination.MainMenu) {
            actions.add(SystemAction.get(CreateAction.class));
            actions.add(null);
            actions.add(SystemAction.get(StatusAction.class));
            actions.add(SystemAction.get(DiffAction.class));
            actions.add(SystemAction.get(UpdateAction.class));
            actions.add(SystemAction.get(CommitAction.class));
            actions.add(null);
            actions.add(new ExportMenu());
            actions.add(SystemAction.get(ImportDiffAction.class));
            actions.add(null);
            if (!noneVersioned) {
                actions.add(SystemAction.get(CloneAction.class));
            }
            actions.add(SystemAction.get(CloneExternalAction.class));
            actions.add(SystemAction.get(FetchAction.class));
            actions.add(new ShareMenu());
            actions.add(new MergeMenu(false));
            actions.add(null);
            actions.add(SystemAction.get(LogAction.class));
            if (!onlyProjects && !onlyFolders) {
                AnnotateAction tempA = (AnnotateAction)SystemAction.get(AnnotateAction.class);
                if (tempA.visible(nodes)) {
                    actions.add(new ShowMenu(true, true));
                } else {
                    actions.add(new ShowMenu(true, false));
                }
            } else {
                actions.add(new ShowMenu(false, false));
            }
            actions.add(null);
            actions.add(SystemAction.get(RevertModificationsAction.class));
            actions.add(new RecoverMenu());
            if (!onlyProjects) {
                actions.add(SystemAction.get(IgnoreAction.class));
            }
            actions.add(null);
            actions.add(SystemAction.get(PropertiesAction.class));
        } else {
            Lookup context = ctx.getElements();
            if (noneVersioned) {
                actions.add(SystemActionBridge.createAction((Action)((CreateAction)SystemAction.get(CreateAction.class)).createContextAwareInstance(context), (String)loc.getString("CTL_PopupMenuItem_Create"), (Lookup)context));
            } else {
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(StatusAction.class), (String)loc.getString("CTL_PopupMenuItem_Status"), (Lookup)context));
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(DiffAction.class), (String)loc.getString("CTL_PopupMenuItem_Diff"), (Lookup)context));
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)loc.getString("CTL_PopupMenuItem_Commit"), (Lookup)context));
                actions.add(null);
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(ResolveConflictsAction.class), (String)loc.getString("CTL_PopupMenuItem_Resolve"), (Lookup)context));
                if (!onlyProjects && !onlyFolders) {
                    actions.add(SystemActionBridge.createAction((Action)SystemAction.get(ConflictResolvedAction.class), (String)loc.getString("CTL_PopupMenuItem_MarkResolved"), (Lookup)context));
                }
                actions.add(null);
                if (!onlyProjects && !onlyFolders) {
                    actions.add(SystemActionBridge.createAction((Action)SystemAction.get(AnnotateAction.class), (String)(((AnnotateAction)SystemAction.get(AnnotateAction.class)).visible(nodes) ? loc.getString("CTL_PopupMenuItem_HideAnnotations") : loc.getString("CTL_PopupMenuItem_ShowAnnotations")), (Lookup)context));
                }
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(LogAction.class), (String)loc.getString("CTL_PopupMenuItem_Log"), (Lookup)context));
                actions.add(null);
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(RevertModificationsAction.class), (String)loc.getString("CTL_PopupMenuItem_Revert"), (Lookup)context));
                if (!onlyProjects) {
                    actions.add(SystemActionBridge.createAction((Action)SystemAction.get(IgnoreAction.class), (String)loc.getString("CTL_PopupMenuItem_Ignore"), (Lookup)context));
                }
                if (!onlyProjects && !onlyFolders) {
                    ExcludeFromCommitAction exclude;
                    actions.add(SystemActionBridge.createAction((Action)((Object)exclude), (String)((exclude = (ExcludeFromCommitAction)SystemAction.get(ExcludeFromCommitAction.class)).getActionStatus(null) == 2 ? loc.getString("CTL_PopupMenuItem_IncludeInCommit") : loc.getString("CTL_PopupMenuItem_ExcludeFromCommit")), (Lookup)context));
                }
                actions.add(null);
                actions.add(new ShareMenu());
                actions.add(null);
                actions.add(SystemActionBridge.createAction((Action)SystemAction.get(PropertiesAction.class), (String)loc.getString("CTL_PopupMenuItem_Properties"), (Lookup)context));
            }
        }
        return actions.toArray(new Action[actions.size()]);
    }

    private String formatAnnotation(FileInformation info, File file) {
        Object[] arguments;
        String annotation;
        String stickyString;
        String statusString = "";
        int status = info.getStatus();
        if (status != 8) {
            statusString = info.getShortStatusText();
        }
        if ((stickyString = null) == null) {
            stickyString = "";
        }
        if ((annotation = this.format.format(arguments = new Object[]{statusString, stickyString}, new StringBuffer(), (FieldPosition)null).toString().trim()).equals(this.emptyFormat)) {
            return "";
        }
        return " " + annotation;
    }

    public String annotateNameHtml(File file, FileInformation info) {
        return this.annotateNameHtml(file.getName(), info, file);
    }

    public String annotateNameHtml(String name, FileInformation mostImportantInfo, File mostImportantFile) {
        String textAnnotation;
        name = this.htmlEncode(name);
        boolean annotationsVisible = VersioningSupport.getPreferences().getBoolean("textAnnotationsVisible", false);
        int status = mostImportantInfo.getStatus();
        if (annotationsVisible && mostImportantFile != null && (status & 0x195E) != 0) {
            if (this.format != null) {
                textAnnotation = this.formatAnnotation(mostImportantInfo, mostImportantFile);
            } else {
                String statusText;
                String sticky = null;
                textAnnotation = status == 8 && sticky == null ? "" : (status == 8 ? " [" + sticky + "]" : (sticky == null ? (!(statusText = mostImportantInfo.getShortStatusText()).equals("") ? " [" + mostImportantInfo.getShortStatusText() + "]" : "") : " [" + mostImportantInfo.getShortStatusText() + "; " + sticky + "]"));
            }
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = NbBundle.getMessage(MercurialAnnotator.class, (String)"textAnnotation", (Object)textAnnotation);
        }
        if (0 != (status & 2)) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x800)) {
            return this.getAnnotationProvider().DELETED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x100)) {
            return this.getAnnotationProvider().REMOVED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 4)) {
            return this.getAnnotationProvider().NEW_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x1000)) {
            FileStatus fileStatus = mostImportantInfo.getStatus(mostImportantFile);
            if (fileStatus != null && fileStatus.isCopied()) {
                return this.getAnnotationProvider().COPIED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
            }
            return this.getAnnotationProvider().ADDED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x10)) {
            return this.getAnnotationProvider().MODIFIED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 8)) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x40)) {
            return this.getAnnotationProvider().CONFLICT_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 1)) {
            return name;
        }
        if (status == 0) {
            return name;
        }
        throw new IllegalArgumentException("Uncomparable status: " + status);
    }

    private String htmlEncode(String name) {
        if (name.indexOf(60) == -1) {
            return name;
        }
        return lessThan.matcher(name).replaceAll("&lt;");
    }

    private String annotateFolderNameHtml(String name, VCSContext context, FileInformation mostImportantInfo, File mostImportantFile) {
        String nameHtml = this.htmlEncode(name);
        if (mostImportantInfo.getStatus() == 2) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{nameHtml, ""});
        }
        MessageFormat uptodateFormat = this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat();
        String fileName = mostImportantFile.getName();
        if (fileName.equals(name)) {
            return uptodateFormat.format(new Object[]{nameHtml, ""});
        }
        Set rootFiles = context.getRootFiles();
        File repo = null;
        String folderAnotation = null;
        if (rootFiles.size() == 1) {
            File root = null;
            for (File file : rootFiles) {
                repo = Mercurial.getInstance().getRepositoryRoot(file);
                if (repo == null) {
                    Mercurial.LOG.warning("Couldn't find repository root for file " + file);
                    continue;
                }
                root = file;
                break;
            }
            if (repo == null || !repo.getAbsolutePath().equals(root.getAbsolutePath())) {
                return uptodateFormat.format(new Object[]{nameHtml, ""});
            }
        } else {
            File parentFile = null;
            for (File file : rootFiles) {
                if (parentFile == null) {
                    parentFile = file.getParentFile();
                    continue;
                }
                File p = file.getParentFile();
                if (p != null && parentFile.getAbsolutePath().equals(p.getAbsolutePath())) continue;
                return uptodateFormat.format(new Object[]{nameHtml, ""});
            }
            for (File file : rootFiles) {
                repo = Mercurial.getInstance().getRepositoryRoot(file);
                if (repo == null) {
                    Mercurial.LOG.warning("Couldn't find repository root for file " + file);
                    continue;
                }
                if (repo.getAbsolutePath().equals(parentFile.getAbsolutePath())) break;
                return uptodateFormat.format(new Object[]{nameHtml, ""});
            }
        }
        if (repo != null && !repo.getName().equals(name)) {
            folderAnotation = repo.getName();
        }
        return uptodateFormat.format(new Object[]{nameHtml, folderAnotation != null ? " [" + folderAnotation + "]" : ""});
    }

    private boolean isMoreImportant(FileInformation a, FileInformation b) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return MercurialAnnotator.getComparableStatus(a.getStatus()) < MercurialAnnotator.getComparableStatus(b.getStatus());
    }

    public static int getComparableStatus(int status) {
        if (0 != (status & 0x40)) {
            return 0;
        }
        if (0 != (status & 0x80)) {
            return 1;
        }
        if (0 != (status & 0x800)) {
            return 10;
        }
        if (0 != (status & 0x100)) {
            return 11;
        }
        if (0 != (status & 4)) {
            return 12;
        }
        if (0 != (status & 0x1000)) {
            return 13;
        }
        if (0 != (status & 0x10)) {
            return 14;
        }
        if (0 != (status & 0x400)) {
            return 30;
        }
        if (0 != (status & 0x200)) {
            return 31;
        }
        if (0 != (status & 0x20)) {
            return 32;
        }
        if (0 != (status & 8)) {
            return 50;
        }
        if (0 != (status & 2)) {
            return 100;
        }
        if (0 != (status & 1)) {
            return 101;
        }
        if (status == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + status);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private static boolean onlyProjects(Node[] nodes) {
        if (nodes == null) {
            return false;
        }
        for (Node node : nodes) {
            if (node.getLookup().lookup(Project.class) != null) continue;
            return false;
        }
        return true;
    }

    private boolean onlyFolders(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                return false;
            }
            FileInformation status = this.cache.getCachedStatus(files[i]);
            if (status != null && (files[i].exists() || status.isDirectory())) continue;
            return false;
        }
        return true;
    }

    private AnnotationColorProvider getAnnotationProvider() {
        return AnnotationColorProvider.getInstance();
    }
}

