/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.hints;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.apisupport.hints.Bundle;
import org.netbeans.modules.apisupport.hints.Hinter;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbCollections;

public class ActionRegistrationHinter
implements Hinter {
    private static final String[] EAGER_INTERFACES = new String[]{"org.openide.util.actions.Presenter.Menu", "org.openide.util.actions.Presenter.Toolbar", "org.openide.util.actions.Presenter.Popup", "org.openide.util.ContextAwareAction", "org.openide.awt.DynamicMenuContent"};

    @Override
    public void process(final Hinter.Context ctx) throws Exception {
        final FileObject file = ctx.file();
        if (!file.isData() || !file.hasExt("instance")) {
            return;
        }
        final Object instanceCreate = file.getAttribute("literal:instanceCreate");
        if ("method:org.openide.awt.Actions.alwaysEnabled".equals(instanceCreate)) {
            ctx.addStandardAnnotationHint(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (!ActionRegistrationHinter.this.annotationsAvailable(ctx)) {
                        return null;
                    }
                    ctx.findAndModifyDeclaration(file.getAttribute("literal:delegate"), new RegisterAction(ctx));
                    return null;
                }
            });
        } else if (!"method:org.openide.awt.Actions.checkbox".equals(instanceCreate)) {
            if ("method:org.openide.awt.Actions.callback".equals(instanceCreate) || "method:org.openide.awt.Actions.context".equals(instanceCreate)) {
                ctx.addHint(Severity.WARNING, ctx.standardAnnotationDescription(), new Fix[0]);
            } else if (!"method:org.openide.windows.TopComponent.openAction".equals(instanceCreate) && file.getPath().startsWith("Actions/")) {
                ctx.addStandardAnnotationHint(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Object clazz;
                        if (!ActionRegistrationHinter.this.annotationsAvailable(ctx)) {
                            return null;
                        }
                        Object action = instanceCreate != null ? instanceCreate : ((clazz = file.getAttribute("instanceClass")) != null ? "new:" + clazz : "new:" + file.getName().replace('-', '.'));
                        ctx.findAndModifyDeclaration(action, new RegisterAction(ctx){

                            @Override
                            public void run(WorkingCopy wc, Element declaration, ModifiersTree modifiers) throws Exception {
                                TypeMirror type = declaration.getKind() == ElementKind.CLASS ? ((TypeElement)declaration).asType() : ((ExecutableElement)declaration).getReturnType();
                                boolean ok = false;
                                for (String xface : EAGER_INTERFACES) {
                                    TypeElement xfaceEl = wc.getElements().getTypeElement(xface);
                                    if (xfaceEl == null || !wc.getTypes().isAssignable(type, xfaceEl.asType())) continue;
                                    ok = true;
                                    break;
                                }
                                if (!ok) {
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ActionRegistrationHinter_not_presenter(type), 2));
                                    return;
                                }
                                super.run(wc, declaration, modifiers);
                            }
                        });
                        return null;
                    }
                });
            }
        }
    }

    private boolean annotationsAvailable(Hinter.Context ctx) {
        if (ctx.canAccess("org.openide.awt.ActionReferences")) {
            return true;
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ActionRegistrationHinter_missing_org_openide_awt(), 2));
        return false;
    }

    private static class RegisterAction
    implements Hinter.Context.ModifyDeclarationTask {
        private final Hinter.Context ctx;

        RegisterAction(Hinter.Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run(WorkingCopy wc, Element declaration, ModifiersTree modifiers) throws Exception {
            HashMap<String, Object> params = new HashMap<String, Object>();
            FileObject file = this.ctx.file();
            params.put("category", file.getParent().getPath().substring("Actions/".length()));
            params.put("id", file.getName().replace('-', '.'));
            ModifiersTree nue = this.ctx.addAnnotation(wc, modifiers, "org.openide.awt.ActionID", params);
            params.clear();
            String displayName = this.ctx.bundlevalue(file.getAttribute("literal:displayName"), declaration);
            if (displayName == null) {
                displayName = "#TODO";
            }
            params.put("displayName", displayName);
            params.put("iconBase", file.getAttribute("iconBase"));
            Boolean noIconInMenu = (Boolean)file.getAttribute("noIconInMenu");
            if (noIconInMenu != null) {
                params.put("iconInMenu", noIconInMenu == false);
            }
            params.put("asynchronous", file.getAttribute("asynchronous"));
            nue = this.ctx.addAnnotation(wc, nue, "org.openide.awt.ActionRegistration", params);
            this.ctx.delete(file);
            TreeMaker make = wc.getTreeMaker();
            ArrayList<AnnotationTree> anns = new ArrayList<AnnotationTree>();
            for (FileObject shadow : NbCollections.iterable((Enumeration)file.getFileSystem().getRoot().getData(true))) {
                TypeElement ann;
                Integer pos;
                if (!shadow.hasExt("shadow") || !file.getPath().equals(shadow.getAttribute("originalFile"))) continue;
                ArrayList<AssignmentTree> arguments = new ArrayList<AssignmentTree>();
                arguments.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"path"), (ExpressionTree)make.Literal((Object)shadow.getParent().getPath())));
                String name = shadow.getName();
                if (!name.equals(file.getName())) {
                    arguments.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"name"), (ExpressionTree)make.Literal((Object)name)));
                }
                if ((pos = (Integer)shadow.getAttribute("position")) != null) {
                    arguments.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"position"), (ExpressionTree)make.Literal((Object)pos)));
                }
                if ((ann = wc.getElements().getTypeElement("org.openide.awt.ActionReference")) == null) {
                    throw new IllegalArgumentException("Could not find ActionReference in classpath");
                }
                anns.add(make.Annotation((Tree)make.QualIdent((Element)ann), arguments));
                this.ctx.delete(shadow);
            }
            if (anns.size() == 1) {
                nue = make.addModifiersAnnotation(nue, (AnnotationTree)anns.get(0));
            } else if (!anns.isEmpty()) {
                TypeElement ann = wc.getElements().getTypeElement("org.openide.awt.ActionReferences");
                if (ann == null) {
                    throw new IllegalArgumentException("Could not find ActionReferences in classpath");
                }
                nue = make.addModifiersAnnotation(nue, make.Annotation((Tree)make.QualIdent((Element)ann), Collections.singletonList(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"value"), (ExpressionTree)make.NewArray(null, Collections.emptyList(), anns)))));
            }
            wc.rewrite((Tree)modifiers, GeneratorUtilities.get((WorkingCopy)wc).importFQNs((Tree)nue));
        }
    }
}

