/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.SyntaxColoringPanel;
import org.netbeans.modules.options.colors.spi.FontsColorsController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HighlightingPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
FontsColorsController {
    private ColorModel colorModel = null;
    private boolean listen = false;
    private String currentProfile;
    private Map<String, Vector<AttributeSet>> profileToCategories = new HashMap<String, Vector<AttributeSet>>();
    private Set<String> toBeSaved = new HashSet<String>();
    private boolean changed = false;
    private JComboBox cbBackground;
    private JComboBox cbForeground;
    private JScrollPane cpCategories;
    private JLabel lBackground;
    private JList lCategories;
    private JLabel lCategory;
    private JLabel lForeground;
    private Map<String, Vector<AttributeSet>> profileToDefaults = new HashMap<String, Vector<AttributeSet>>();

    public HighlightingPanel() {
        this.initComponents();
        this.setName(HighlightingPanel.loc("Editor_tab"));
        this.lCategories.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Categories"));
        this.cbForeground.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Foreground_Chooser"));
        this.cbForeground.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Foreground_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Background_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Background_Chooser"));
        ColorComboBox.init(this.cbForeground);
        ColorComboBox.init(this.cbBackground);
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!HighlightingPanel.this.listen) {
                    return;
                }
                HighlightingPanel.this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.cbForeground.addActionListener(this);
        ((JComponent)((Object)this.cbForeground.getEditor())).addPropertyChangeListener(this);
        this.cbBackground.addActionListener(this);
        ((JComponent)((Object)this.cbBackground.getEditor())).addPropertyChangeListener(this);
        this.lCategory.setLabelFor(this.lCategories);
        HighlightingPanel.loc(this.lCategory, "CTL_Category");
        HighlightingPanel.loc(this.lForeground, "CTL_Foreground_label");
        HighlightingPanel.loc(this.lBackground, "CTL_Background_label");
    }

    private void initComponents() {
        this.lCategory = new JLabel();
        this.cpCategories = new JScrollPane();
        this.lCategories = new JList();
        this.lForeground = new JLabel();
        this.lBackground = new JLabel();
        this.cbBackground = new JComboBox();
        this.cbForeground = new JComboBox();
        this.lCategory.setText("Category:");
        this.cpCategories.setViewportView(this.lCategories);
        this.lForeground.setText("Foreground:");
        this.lBackground.setText("Background:");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cpCategories, -1, 211, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lBackground).add((Component)this.lForeground)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.cbBackground, 0, 53, Short.MAX_VALUE).add(2, (Component)this.cbForeground, 0, 53, Short.MAX_VALUE))).add((Component)this.lCategory)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lCategory).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lForeground).add((Component)this.cbForeground, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lBackground).add((Component)this.cbBackground, -2, -1, -2))).add((Component)this.cpCategories, -1, 189, Short.MAX_VALUE)).addContainerGap()));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!this.listen) {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.listen) {
            return;
        }
        if ("color".equals(evt.getPropertyName())) {
            this.updateData();
            this.changed = true;
        }
    }

    @Override
    public void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.currentProfile = colorModel.getCurrentProfile();
        this.listen = false;
        this.setCurrentProfile(this.currentProfile);
        this.lCategories.setListData(this.getCategories(this.currentProfile));
        this.lCategories.setSelectedIndex(0);
        this.refreshUI();
        this.listen = true;
        this.changed = false;
    }

    @Override
    public void cancel() {
        this.toBeSaved = new HashSet<String>();
        this.profileToCategories = new HashMap<String, Vector<AttributeSet>>();
        this.changed = false;
    }

    @Override
    public void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        for (String profile : this.toBeSaved) {
            Vector<AttributeSet> cat = null;
            if (this.profileToCategories.containsKey(profile)) {
                cat = this.getCategories(profile);
            }
            this.colorModel.setHighlightings(profile, cat);
        }
        this.toBeSaved = new HashSet<String>();
        this.profileToCategories = new HashMap<String, Vector<AttributeSet>>();
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setCurrentProfile(String currentProfile) {
        String oldScheme = this.currentProfile;
        this.currentProfile = currentProfile;
        if (!this.colorModel.getProfiles().contains(currentProfile) && !this.profileToCategories.containsKey(currentProfile)) {
            Vector<AttributeSet> categories = this.getCategories(oldScheme);
            this.profileToCategories.put(currentProfile, new Vector<AttributeSet>(categories));
            this.toBeSaved.add(currentProfile);
        }
        this.refreshUI();
    }

    @Override
    public void deleteProfile(String profile) {
        if (this.colorModel.isCustomProfile(profile)) {
            this.profileToCategories.remove(profile);
        } else {
            this.profileToCategories.put(profile, this.getDefaults(profile));
            this.refreshUI();
        }
        this.toBeSaved.add(profile);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    Collection<AttributeSet> getHighlightings() {
        return this.getCategories(this.currentProfile);
    }

    private static String loc(String key) {
        return NbBundle.getMessage(SyntaxColoringPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)HighlightingPanel.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)HighlightingPanel.loc(key));
        }
    }

    private void updateData() {
        int index = this.lCategories.getSelectedIndex();
        if (index < 0) {
            return;
        }
        Vector<AttributeSet> categories = this.getCategories(this.currentProfile);
        AttributeSet category = categories.get(this.lCategories.getSelectedIndex());
        SimpleAttributeSet c = new SimpleAttributeSet(category);
        Color color = ColorComboBox.getColor(this.cbBackground);
        if (color != null) {
            c.addAttribute(StyleConstants.Background, color);
        } else {
            c.removeAttribute(StyleConstants.Background);
        }
        color = ColorComboBox.getColor(this.cbForeground);
        if (color != null) {
            c.addAttribute(StyleConstants.Foreground, color);
        } else {
            c.removeAttribute(StyleConstants.Foreground);
        }
        categories.set(index, c);
        this.toBeSaved.add(this.currentProfile);
    }

    private void refreshUI() {
        int index = this.lCategories.getSelectedIndex();
        if (index < 0) {
            this.cbForeground.setEnabled(false);
            this.cbBackground.setEnabled(false);
            return;
        }
        this.cbForeground.setEnabled(true);
        this.cbBackground.setEnabled(true);
        Vector<AttributeSet> categories = this.getCategories(this.currentProfile);
        AttributeSet category = categories.get(index);
        this.listen = false;
        AttributeSet defAs = this.getDefaultColoring();
        if (defAs != null) {
            Color inheritedForeground = (Color)defAs.getAttribute(StyleConstants.Foreground);
            if (inheritedForeground == null) {
                inheritedForeground = Color.black;
            }
            ColorComboBox.setInheritedColor(this.cbForeground, inheritedForeground);
            Color inheritedBackground = (Color)defAs.getAttribute(StyleConstants.Background);
            if (inheritedBackground == null) {
                inheritedBackground = Color.white;
            }
            ColorComboBox.setInheritedColor(this.cbBackground, inheritedBackground);
        }
        ColorComboBox.setColor(this.cbForeground, (Color)category.getAttribute(StyleConstants.Foreground));
        ColorComboBox.setColor(this.cbBackground, (Color)category.getAttribute(StyleConstants.Background));
        this.listen = true;
    }

    private AttributeSet getDefaultColoring() {
        Collection<AttributeSet> defaults = this.colorModel.getCategories(this.currentProfile, ColorModel.ALL_LANGUAGES);
        for (AttributeSet as : defaults) {
            String name = (String)as.getAttribute(StyleConstants.NameAttribute);
            if (name == null || !"default".equals(name)) continue;
            return as;
        }
        return null;
    }

    private Vector<AttributeSet> getCategories(String profile) {
        if (this.colorModel == null) {
            return null;
        }
        if (!this.profileToCategories.containsKey(profile)) {
            Collection<AttributeSet> c = this.colorModel.getHighlightings(profile);
            if (c == null) {
                c = Collections.emptySet();
            }
            ArrayList<AttributeSet> l = new ArrayList<AttributeSet>(c);
            Collections.sort(l, new CategoryComparator());
            this.profileToCategories.put(profile, new Vector<AttributeSet>(l));
        }
        return this.profileToCategories.get(profile);
    }

    private Vector<AttributeSet> getDefaults(String profile) {
        if (!this.profileToDefaults.containsKey(profile)) {
            Collection<AttributeSet> c = this.colorModel.getHighlightingDefaults(profile);
            ArrayList<AttributeSet> l = new ArrayList<AttributeSet>(c);
            Collections.sort(l, new CategoryComparator());
            this.profileToDefaults.put(profile, new Vector<AttributeSet>(l));
        }
        return this.profileToDefaults.get(profile);
    }
}

