/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.ColorValue;
import org.netbeans.modules.options.colors.spi.FontsColorsController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SyntaxColoringPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
FontsColorsController {
    private ColorModel.Preview preview;
    private RequestProcessor.Task selectTask;
    private ColorModel colorModel = null;
    private String currentLanguage;
    private String currentProfile;
    private Map<String, Map<String, Vector<AttributeSet>>> profiles = new HashMap<String, Map<String, Vector<AttributeSet>>>();
    private Map<String, Set<String>> toBeSaved = new HashMap<String, Set<String>>();
    private boolean listen = false;
    private JButton bFont;
    private JComboBox cbBackground;
    private JComboBox cbEffectColor;
    private JComboBox cbEffects;
    private JComboBox cbForeground;
    private JComboBox cbLanguage;
    private JLabel lBackground;
    private JList lCategories;
    private JLabel lCategory;
    private JLabel lEffectColor;
    private JLabel lEffects;
    private JLabel lFont;
    private JLabel lForeground;
    private JLabel lLanguage;
    private JLabel lPreview;
    private JPanel pPreview;
    private JScrollPane spCategories;
    private JScrollPane spPreview;
    private JTextField tfFont;
    private boolean blink = true;
    private int blinkSequence = 0;
    private RequestProcessor.Task task = new RequestProcessor("SyntaxColoringPanel").create(new Runnable(){

        @Override
        public void run() {
            SyntaxColoringPanel.this.updatePreview();
            if (SyntaxColoringPanel.this.blinkSequence == 0) {
                return;
            }
            SyntaxColoringPanel.this.blinkSequence--;
            SyntaxColoringPanel.this.task.schedule(250);
        }
    });
    private Map<String, Map<String, Vector<AttributeSet>>> defaults = new HashMap<String, Map<String, Vector<AttributeSet>>>();
    private static Map<String, String> convertALC = new HashMap<String, String>();
    private static Integer defaultFontSize;

    public SyntaxColoringPanel() {
        this.initComponents();
        this.setName(SyntaxColoringPanel.loc("Syntax_coloring_tab"));
        this.cbLanguage.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Languages"));
        this.cbLanguage.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Languages"));
        this.lCategories.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Categories"));
        this.bFont.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Font"));
        this.bFont.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Font"));
        this.cbForeground.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Foreground_Chooser"));
        this.cbForeground.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Foreground_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Background_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Background_Chooser"));
        this.cbEffects.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Efects_Color_Chooser"));
        this.cbEffects.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Efects_Color_Chooser"));
        this.cbEffectColor.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Efects_Color"));
        this.cbEffectColor.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Efects_Color"));
        ColorComboBox.init(this.cbBackground);
        ColorComboBox.init(this.cbForeground);
        ColorComboBox.init(this.cbEffectColor);
        this.cbLanguage.addActionListener(this);
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!SyntaxColoringPanel.this.listen) {
                    return;
                }
                SyntaxColoringPanel.this.selectTask.schedule(200);
            }
        });
        this.lCategories.setSelectedIndex(0);
        this.tfFont.setEditable(false);
        this.bFont.addActionListener(this);
        this.bFont.setMargin(new Insets(0, 0, 0, 0));
        this.cbForeground.addActionListener(this);
        ((JComponent)((Object)this.cbForeground.getEditor())).addPropertyChangeListener(this);
        this.cbBackground.addActionListener(this);
        ((JComponent)((Object)this.cbBackground.getEditor())).addPropertyChangeListener(this);
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_None"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Underlined"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Wave_Underlined"));
        this.cbEffects.addItem(SyntaxColoringPanel.loc("CTL_Effects_Strike_Through"));
        this.cbEffects.getAccessibleContext().setAccessibleName(SyntaxColoringPanel.loc("AN_Effects"));
        this.cbEffects.getAccessibleContext().setAccessibleDescription(SyntaxColoringPanel.loc("AD_Effects"));
        this.cbEffects.addActionListener(this);
        ((JComponent)((Object)this.cbEffectColor.getEditor())).addPropertyChangeListener(this);
        this.cbEffectColor.addActionListener(this);
        SyntaxColoringPanel.loc(this.bFont, "CTL_Font_button");
        SyntaxColoringPanel.loc(this.lBackground, "CTL_Background_label");
        SyntaxColoringPanel.loc(this.lCategory, "CTL_Category");
        SyntaxColoringPanel.loc(this.lEffectColor, "CTL_Effects_color");
        SyntaxColoringPanel.loc(this.lEffects, "CTL_Effects_label");
        SyntaxColoringPanel.loc(this.lFont, "CTL_Font");
        SyntaxColoringPanel.loc(this.lForeground, "CTL_Foreground_label");
        SyntaxColoringPanel.loc(this.lLanguage, "CTL_Languages");
        SyntaxColoringPanel.loc(this.lPreview, "CTL_Preview");
        this.selectTask = new RequestProcessor("SyntaxColoringPanel1").create(new Runnable(){

            @Override
            public void run() {
                SyntaxColoringPanel.this.refreshUI();
                if (!SyntaxColoringPanel.this.blink) {
                    return;
                }
                SyntaxColoringPanel.this.startBlinking();
            }
        });
    }

    private void initComponents() {
        this.lLanguage = new JLabel();
        this.cbLanguage = new JComboBox();
        this.lCategory = new JLabel();
        this.spCategories = new JScrollPane();
        this.lCategories = new JList();
        this.lPreview = new JLabel();
        this.spPreview = new JScrollPane();
        this.pPreview = new JPanel();
        this.lFont = new JLabel();
        this.lForeground = new JLabel();
        this.lBackground = new JLabel();
        this.lEffects = new JLabel();
        this.lEffectColor = new JLabel();
        this.cbForeground = new JComboBox();
        this.cbBackground = new JComboBox();
        this.cbEffects = new JComboBox();
        this.cbEffectColor = new JComboBox();
        this.tfFont = new JTextField();
        this.bFont = new JButton();
        this.lLanguage.setLabelFor(this.cbLanguage);
        this.lLanguage.setText("Language:");
        this.lCategory.setLabelFor(this.lCategories);
        this.lCategory.setText("Category:");
        this.spCategories.setViewportView(this.lCategories);
        this.lPreview.setText("Preview:");
        this.spPreview.setBorder(BorderFactory.createEtchedBorder());
        this.spPreview.setAutoscrolls(true);
        this.pPreview.setAutoscrolls(true);
        this.pPreview.setLayout(new BorderLayout());
        this.spPreview.setViewportView(this.pPreview);
        this.lFont.setLabelFor(this.bFont);
        this.lFont.setText("Font:");
        this.lForeground.setLabelFor(this.cbForeground);
        this.lForeground.setText("Foreground:");
        this.lBackground.setLabelFor(this.cbBackground);
        this.lBackground.setText("Background:");
        this.lEffects.setLabelFor(this.cbEffects);
        this.lEffects.setText("Effects:");
        this.lEffectColor.setLabelFor(this.cbEffectColor);
        this.lEffectColor.setText("Effect Color:");
        this.bFont.setText("...");
        this.bFont.setMargin(new Insets(2, 2, 2, 2));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.spPreview, -1, 340, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lLanguage).addPreferredGap(0).add((Component)this.cbLanguage, -2, -1, -2)).add((Component)this.lCategory).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.spCategories, -1, 201, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lEffectColor).add((Component)this.lForeground).add((Component)this.lFont).add((Component)this.lEffects).add((Component)this.lBackground)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tfFont, -1, 13, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bFont)).add((Component)this.cbForeground, 0, 38, Short.MAX_VALUE).add((Component)this.cbBackground, 0, 38, Short.MAX_VALUE).add((Component)this.cbEffects, 0, 38, Short.MAX_VALUE).add((Component)this.cbEffectColor, 0, 38, Short.MAX_VALUE)).addPreferredGap(0)).add((Component)this.lPreview)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lLanguage).add((Component)this.cbLanguage, -2, -1, -2)).addPreferredGap(0).add((Component)this.lCategory).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.spCategories, -2, 130, -2).addPreferredGap(0).add((Component)this.lPreview)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lFont).add((Component)this.tfFont, -2, -1, -2).add((Component)this.bFont)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lForeground).add((Component)this.cbForeground, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lBackground).add((Component)this.cbBackground, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lEffects).add((Component)this.cbEffects, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lEffectColor).add((Component)this.cbEffectColor, -2, -1, -2)))).addPreferredGap(0).add((Component)this.spPreview, -1, 153, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!this.listen) {
            return;
        }
        if (evt.getSource() == this.cbEffects) {
            this.cbEffectColor.setEnabled(this.cbEffects.getSelectedIndex() > 0);
            if (this.cbEffects.getSelectedIndex() == 0) {
                ColorComboBox.setColor(this.cbEffectColor, null);
            }
            this.updateData();
        } else if (evt.getSource() == this.cbLanguage) {
            this.setCurrentLanguage((String)this.cbLanguage.getSelectedItem());
        } else if (evt.getSource() == this.bFont) {
            PropertyEditor pe = PropertyEditorManager.findEditor(Font.class);
            AttributeSet category = this.getCurrentCategory();
            if (category == null) {
                return;
            }
            Font f = this.getFont(category);
            pe.setValue(f);
            DialogDescriptor dd = new DialogDescriptor((Object)pe.getCustomEditor(), SyntaxColoringPanel.loc("CTL_Font_Chooser"));
            dd.setOptions(new Object[]{DialogDescriptor.OK_OPTION, SyntaxColoringPanel.loc("CTL_Font_Inherited"), DialogDescriptor.CANCEL_OPTION});
            DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                f = (Font)pe.getValue();
                category = this.modifyFont(category, f);
                this.replaceCurrrentCategory(category);
                this.setToBeSaved(this.currentProfile, this.currentLanguage);
                this.refreshUI();
            } else if (dd.getValue().equals(SyntaxColoringPanel.loc("CTL_Font_Inherited"))) {
                Integer size;
                String fontName = (String)this.getDefault(this.currentLanguage, category, StyleConstants.FontFamily);
                int style = 0;
                if (Boolean.TRUE.equals(this.getDefault(this.currentLanguage, category, StyleConstants.Bold))) {
                    ++style;
                }
                if (Boolean.TRUE.equals(this.getDefault(this.currentLanguage, category, StyleConstants.Italic))) {
                    style += 2;
                }
                f = new Font(fontName, style, (size = (Integer)this.getDefault(this.currentLanguage, category, StyleConstants.FontSize)) == null ? SyntaxColoringPanel.getDefaultFontSize() : size);
                category = this.modifyFont(category, f);
                this.replaceCurrrentCategory(category);
                this.setToBeSaved(this.currentProfile, this.currentLanguage);
                this.refreshUI();
            }
        } else if (evt.getSource() instanceof JComboBox) {
            this.updateData();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.listen || evt.getPropertyName() == null) {
            return;
        }
        if ("currentAElement".equals(evt.getPropertyName())) {
            String converted;
            String currentCategory = (String)evt.getNewValue();
            Vector<AttributeSet> categories = this.getCategories(this.currentProfile, this.currentLanguage);
            if (this.currentLanguage.equals(ColorModel.ALL_LANGUAGES) && (converted = convertALC.get(currentCategory)) != null) {
                currentCategory = converted;
            }
            for (int i = 0; i < categories.size(); ++i) {
                AttributeSet as = categories.get(i);
                if (!currentCategory.equals(as.getAttribute(StyleConstants.NameAttribute))) continue;
                this.blink = false;
                this.lCategories.setSelectedIndex(i);
                this.lCategories.ensureIndexIsVisible(i);
                this.blink = true;
                break;
            }
        } else if ("color".equals(evt.getPropertyName())) {
            this.updateData();
        }
    }

    @Override
    public void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.currentProfile = colorModel.getCurrentProfile();
        this.currentLanguage = ColorModel.ALL_LANGUAGES;
        if (this.preview != null) {
            this.preview.removePropertyChangeListener("currentAElement", this);
        }
        Component component = colorModel.getSyntaxColoringPreviewComponent(this.currentLanguage);
        this.preview = (ColorModel.Preview)component;
        this.pPreview.removeAll();
        this.pPreview.add("Center", component);
        this.preview.addPropertyChangeListener("currentAElement", this);
        this.listen = false;
        ArrayList<String> languages = new ArrayList<String>(colorModel.getLanguages());
        languages.remove("text/x-all-languages");
        Collections.sort(languages, new LanguagesComparator());
        Iterator it = languages.iterator();
        Object lastLanguage = this.cbLanguage.getSelectedItem();
        this.cbLanguage.removeAllItems();
        while (it.hasNext()) {
            this.cbLanguage.addItem(it.next());
        }
        this.listen = true;
        if (lastLanguage != null) {
            this.cbLanguage.setSelectedItem(lastLanguage);
        } else {
            this.cbLanguage.setSelectedIndex(0);
        }
    }

    @Override
    public void cancel() {
        this.toBeSaved = new HashMap<String, Set<String>>();
        this.profiles = new HashMap<String, Map<String, Vector<AttributeSet>>>();
    }

    @Override
    public void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        for (String profile : this.toBeSaved.keySet()) {
            Set<String> toBeSavedLanguages = this.toBeSaved.get(profile);
            Map<String, Vector<AttributeSet>> schemeMap = this.profiles.get(profile);
            for (String languageName : toBeSavedLanguages) {
                this.colorModel.setCategories(profile, languageName, (Collection<AttributeSet>)schemeMap.get(languageName));
            }
        }
        this.toBeSaved = new HashMap<String, Set<String>>();
        this.profiles = new HashMap<String, Map<String, Vector<AttributeSet>>>();
    }

    @Override
    public boolean isChanged() {
        return !this.toBeSaved.isEmpty();
    }

    @Override
    public void setCurrentProfile(String currentProfile) {
        String oldProfile = this.currentProfile;
        this.currentProfile = currentProfile;
        if (!this.colorModel.getProfiles().contains(currentProfile) && !this.profiles.containsKey(currentProfile)) {
            this.cloneScheme(oldProfile, currentProfile);
        }
        Vector<AttributeSet> categories = this.getCategories(currentProfile, this.currentLanguage);
        this.lCategories.setListData(categories);
        this.blink = false;
        this.lCategories.setSelectedIndex(0);
        this.blink = true;
        this.refreshUI();
    }

    @Override
    public void deleteProfile(String profile) {
        HashMap<String, Vector<AttributeSet>> m = new HashMap<String, Vector<AttributeSet>>();
        boolean custom = this.colorModel.isCustomProfile(profile);
        for (String language : this.colorModel.getLanguages()) {
            if (custom) {
                m.put(language, null);
                continue;
            }
            m.put(language, this.getDefaults(profile, language));
        }
        this.profiles.put(profile, m);
        this.toBeSaved.put(profile, new HashSet<String>(this.colorModel.getLanguages()));
        if (!custom) {
            this.refreshUI();
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private void cloneScheme(String oldScheme, String newScheme) {
        HashMap m = new HashMap();
        for (String language : this.colorModel.getLanguages()) {
            Vector<AttributeSet> v = this.getCategories(oldScheme, language);
            Vector<SimpleAttributeSet> newV = new Vector<SimpleAttributeSet>();
            for (AttributeSet attributeSet : v) {
                newV.add(new SimpleAttributeSet(attributeSet));
            }
            m.put(language, new Vector(newV));
            this.setToBeSaved(newScheme, language);
        }
        this.profiles.put(newScheme, m);
    }

    Collection<AttributeSet> getAllLanguages() {
        return this.getCategories(this.currentProfile, ColorModel.ALL_LANGUAGES);
    }

    Collection<AttributeSet> getSyntaxColorings() {
        return this.getCategories(this.currentProfile, this.currentLanguage);
    }

    private void setCurrentLanguage(String language) {
        this.currentLanguage = language;
        this.blink = false;
        this.lCategories.setListData(this.getCategories(this.currentProfile, this.currentLanguage));
        this.lCategories.setSelectedIndex(0);
        this.blink = true;
        this.refreshUI();
    }

    private static String loc(String key) {
        return NbBundle.getMessage(SyntaxColoringPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)SyntaxColoringPanel.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)SyntaxColoringPanel.loc(key));
        }
    }

    private void updateData() {
        int i = this.lCategories.getSelectedIndex();
        if (i < 0) {
            return;
        }
        AttributeSet category = this.getCurrentCategory();
        Color underline = null;
        Color wave = null;
        Color strikethrough = null;
        if (this.cbEffects.getSelectedIndex() == 1) {
            underline = ColorComboBox.getColor(this.cbEffectColor);
        }
        if (this.cbEffects.getSelectedIndex() == 2) {
            wave = ColorComboBox.getColor(this.cbEffectColor);
        }
        if (this.cbEffects.getSelectedIndex() == 3) {
            strikethrough = ColorComboBox.getColor(this.cbEffectColor);
        }
        SimpleAttributeSet c = category != null ? new SimpleAttributeSet(category) : new SimpleAttributeSet();
        Color color = ColorComboBox.getColor(this.cbBackground);
        if (color != null) {
            c.addAttribute(StyleConstants.Background, color);
        } else {
            c.removeAttribute(StyleConstants.Background);
        }
        color = ColorComboBox.getColor(this.cbForeground);
        if (color != null) {
            c.addAttribute(StyleConstants.Foreground, color);
        } else {
            c.removeAttribute(StyleConstants.Foreground);
        }
        if (underline != null) {
            c.addAttribute(StyleConstants.Underline, underline);
        } else {
            c.removeAttribute(StyleConstants.Underline);
        }
        if (strikethrough != null) {
            c.addAttribute(StyleConstants.StrikeThrough, strikethrough);
        } else {
            c.removeAttribute(StyleConstants.StrikeThrough);
        }
        if (wave != null) {
            c.addAttribute(EditorStyleConstants.WaveUnderlineColor, wave);
        } else {
            c.removeAttribute(EditorStyleConstants.WaveUnderlineColor);
        }
        this.replaceCurrrentCategory(c);
        this.setToBeSaved(this.currentProfile, this.currentLanguage);
        this.updatePreview();
    }

    private void startBlinking() {
        this.blinkSequence = 5;
        this.task.schedule(0);
    }

    private void updatePreview() {
        Collection<AttributeSet> syntaxColorings = this.getSyntaxColorings();
        Collection<AttributeSet> allLanguages = this.getAllLanguages();
        if (this.blinkSequence % 2 == 1) {
            if (ColorModel.ALL_LANGUAGES.equals(this.currentLanguage)) {
                allLanguages = this.invertCategory(allLanguages, this.getCurrentCategory());
            } else {
                syntaxColorings = this.invertCategory(syntaxColorings, this.getCurrentCategory());
            }
        }
        this.preview.setParameters(this.currentLanguage, allLanguages, Collections.<AttributeSet>emptySet(), syntaxColorings);
    }

    private Collection<AttributeSet> invertCategory(Collection<AttributeSet> c, AttributeSet category) {
        if (category == null) {
            return c;
        }
        ArrayList<AttributeSet> result = new ArrayList<AttributeSet>(c);
        int i = result.indexOf(category);
        SimpleAttributeSet as = new SimpleAttributeSet(category);
        Color highlight = (Color)this.getValue(this.currentLanguage, category, StyleConstants.Background);
        if (highlight == null) {
            return result;
        }
        Color newColor = new Color(255 - highlight.getRed(), 255 - highlight.getGreen(), 255 - highlight.getBlue());
        as.addAttribute(StyleConstants.Underline, newColor);
        result.set(i, as);
        return result;
    }

    private void refreshUI() {
        this.listen = false;
        AttributeSet category = this.getCurrentCategory();
        if (category == null) {
            this.tfFont.setText("");
            this.bFont.setEnabled(false);
            this.cbEffects.setEnabled(false);
            this.cbForeground.setEnabled(false);
            this.cbForeground.setSelectedItem(new ColorValue(null, null));
            this.cbBackground.setEnabled(false);
            this.cbBackground.setSelectedItem(new ColorValue(null, null));
            this.cbEffectColor.setEnabled(false);
            this.cbEffectColor.setSelectedItem(new ColorValue(null, null));
            this.updatePreview();
            return;
        }
        this.bFont.setEnabled(true);
        this.cbEffects.setEnabled(true);
        this.cbForeground.setEnabled(true);
        this.cbBackground.setEnabled(true);
        Color inheritedForeground = (Color)this.getDefault(this.currentLanguage, category, StyleConstants.Foreground);
        if (inheritedForeground == null) {
            inheritedForeground = Color.black;
        }
        ColorComboBox.setInheritedColor(this.cbForeground, inheritedForeground);
        Color inheritedBackground = (Color)this.getDefault(this.currentLanguage, category, StyleConstants.Background);
        if (inheritedBackground == null) {
            inheritedBackground = Color.white;
        }
        ColorComboBox.setInheritedColor(this.cbBackground, inheritedBackground);
        String font = this.fontToString(category);
        this.tfFont.setText(font);
        ColorComboBox.setColor(this.cbForeground, (Color)category.getAttribute(StyleConstants.Foreground));
        ColorComboBox.setColor(this.cbBackground, (Color)category.getAttribute(StyleConstants.Background));
        if (category.getAttribute(StyleConstants.Underline) != null) {
            this.cbEffects.setSelectedIndex(1);
            this.cbEffectColor.setEnabled(true);
            ColorComboBox.setColor(this.cbEffectColor, (Color)category.getAttribute(StyleConstants.Underline));
        } else if (category.getAttribute(EditorStyleConstants.WaveUnderlineColor) != null) {
            this.cbEffects.setSelectedIndex(2);
            this.cbEffectColor.setEnabled(true);
            ColorComboBox.setColor(this.cbEffectColor, (Color)category.getAttribute(EditorStyleConstants.WaveUnderlineColor));
        } else if (category.getAttribute(StyleConstants.StrikeThrough) != null) {
            this.cbEffects.setSelectedIndex(3);
            this.cbEffectColor.setEnabled(true);
            ColorComboBox.setColor(this.cbEffectColor, (Color)category.getAttribute(StyleConstants.StrikeThrough));
        } else if (this.getDefault(this.currentLanguage, category, StyleConstants.Underline) != null) {
            this.cbEffects.setSelectedIndex(1);
            this.cbEffectColor.setEnabled(true);
            ColorComboBox.setColor(this.cbEffectColor, (Color)this.getDefault(this.currentLanguage, category, StyleConstants.Underline));
        } else if (this.getDefault(this.currentLanguage, category, EditorStyleConstants.WaveUnderlineColor) != null) {
            this.cbEffects.setSelectedIndex(2);
            this.cbEffectColor.setEnabled(true);
            ColorComboBox.setColor(this.cbEffectColor, (Color)this.getDefault(this.currentLanguage, category, EditorStyleConstants.WaveUnderlineColor));
        } else if (this.getDefault(this.currentLanguage, category, StyleConstants.StrikeThrough) != null) {
            this.cbEffects.setSelectedIndex(3);
            this.cbEffectColor.setEnabled(true);
            ColorComboBox.setColor(this.cbEffectColor, (Color)this.getDefault(this.currentLanguage, category, StyleConstants.StrikeThrough));
        } else {
            this.cbEffects.setSelectedIndex(0);
            this.cbEffectColor.setEnabled(false);
            this.cbEffectColor.setSelectedItem(new ColorValue(null, null));
        }
        this.updatePreview();
        this.listen = true;
    }

    private void setToBeSaved(String currentProfile, String currentLanguage) {
        Set<String> s = this.toBeSaved.get(currentProfile);
        if (s == null) {
            s = new HashSet<String>();
            this.toBeSaved.put(currentProfile, s);
        }
        s.add(currentLanguage);
    }

    private Vector<AttributeSet> getCategories(String profile, String language) {
        Vector<AttributeSet> v;
        if (this.colorModel == null) {
            return null;
        }
        Map<String, Vector<AttributeSet>> m = this.profiles.get(profile);
        if (m == null) {
            m = new HashMap<String, Vector<AttributeSet>>();
            this.profiles.put(profile, m);
        }
        if ((v = m.get(language)) == null) {
            Collection<AttributeSet> c = this.colorModel.getCategories(profile, language);
            if (c == null) {
                c = Collections.emptySet();
            }
            ArrayList<AttributeSet> l = new ArrayList<AttributeSet>(c);
            Collections.sort(l, new CategoryComparator());
            v = new Vector<AttributeSet>(l);
            m.put(language, v);
        }
        return v;
    }

    private Vector<AttributeSet> getDefaults(String profile, String language) {
        Vector<AttributeSet> v;
        Map<String, Vector<AttributeSet>> m = this.defaults.get(profile);
        if (m == null) {
            m = new HashMap<String, Vector<AttributeSet>>();
            this.defaults.put(profile, m);
        }
        if ((v = m.get(language)) == null) {
            Collection<AttributeSet> c = this.colorModel.getDefaults(profile, language);
            ArrayList<AttributeSet> l = new ArrayList<AttributeSet>(c);
            Collections.sort(l, new CategoryComparator());
            v = new Vector<AttributeSet>(l);
            m.put(language, v);
        }
        return new Vector<AttributeSet>(v);
    }

    private AttributeSet getCurrentCategory() {
        int i = this.lCategories.getSelectedIndex();
        Vector<AttributeSet> c = this.getCategories(this.currentProfile, this.currentLanguage);
        return i >= 0 && i < c.size() ? c.get(i) : null;
    }

    private void replaceCurrrentCategory(AttributeSet newValues) {
        int i = this.lCategories.getSelectedIndex();
        this.getCategories(this.currentProfile, this.currentLanguage).set(i, newValues);
    }

    private AttributeSet getCategory(String profile, String language, String name) {
        Vector<AttributeSet> v = this.getCategories(profile, language);
        for (AttributeSet c : v) {
            if (!c.getAttribute(StyleConstants.NameAttribute).equals(name)) continue;
            return c;
        }
        return null;
    }

    private Object getValue(String language, AttributeSet category, Object key) {
        if (category.isDefined(key)) {
            return category.getAttribute(key);
        }
        return this.getDefault(language, category, key);
    }

    private Object getDefault(String language, AttributeSet category, Object key) {
        AttributeSet defaultAS;
        String name = (String)category.getAttribute(EditorStyleConstants.Default);
        if (name == null) {
            name = "default";
        }
        if (!name.equals(category.getAttribute(StyleConstants.NameAttribute)) && (defaultAS = this.getCategory(this.currentProfile, language, name)) != null) {
            return this.getValue(language, defaultAS, key);
        }
        if (!language.equals(ColorModel.ALL_LANGUAGES) && (defaultAS = this.getCategory(this.currentProfile, ColorModel.ALL_LANGUAGES, name)) != null) {
            return this.getValue(ColorModel.ALL_LANGUAGES, defaultAS, key);
        }
        if (key == StyleConstants.FontFamily) {
            return "Monospaced";
        }
        if (key == StyleConstants.FontSize) {
            return SyntaxColoringPanel.getDefaultFontSize();
        }
        return null;
    }

    private Font getFont(AttributeSet category) {
        int style;
        Boolean italic;
        Boolean bold;
        Integer size;
        String name = (String)this.getValue(this.currentLanguage, category, StyleConstants.FontFamily);
        if (name == null) {
            name = "Monospaced";
        }
        if ((size = (Integer)this.getValue(this.currentLanguage, category, StyleConstants.FontSize)) == null) {
            size = SyntaxColoringPanel.getDefaultFontSize();
        }
        if ((bold = (Boolean)this.getValue(this.currentLanguage, category, StyleConstants.Bold)) == null) {
            bold = Boolean.FALSE;
        }
        if ((italic = (Boolean)this.getValue(this.currentLanguage, category, StyleConstants.Italic)) == null) {
            italic = Boolean.FALSE;
        }
        int n = style = bold != false ? 1 : 0;
        if (italic.booleanValue()) {
            style += 2;
        }
        return new Font(name, style, size);
    }

    private AttributeSet modifyFont(AttributeSet category, Font f) {
        String fontName = f.getName();
        Integer fontSize = new Integer(f.getSize());
        Boolean bold = f.isBold();
        Boolean italic = f.isItalic();
        boolean isDefault = "default".equals(category.getAttribute(StyleConstants.NameAttribute));
        if (fontName.equals(this.getDefault(this.currentLanguage, category, StyleConstants.FontFamily)) && !isDefault) {
            fontName = null;
        }
        if (fontSize.equals(this.getDefault(this.currentLanguage, category, StyleConstants.FontSize)) && !isDefault) {
            fontSize = null;
        }
        if (bold.equals(this.getDefault(this.currentLanguage, category, StyleConstants.Bold))) {
            bold = null;
        } else if (bold.equals(Boolean.FALSE) && this.getDefault(this.currentLanguage, category, StyleConstants.Bold) == null) {
            bold = null;
        }
        if (italic.equals(this.getDefault(this.currentLanguage, category, StyleConstants.Italic))) {
            italic = null;
        } else if (italic.equals(Boolean.FALSE) && this.getDefault(this.currentLanguage, category, StyleConstants.Italic) == null) {
            italic = null;
        }
        SimpleAttributeSet c = new SimpleAttributeSet(category);
        if (fontName != null) {
            c.addAttribute(StyleConstants.FontFamily, fontName);
        } else {
            c.removeAttribute(StyleConstants.FontFamily);
        }
        if (fontSize != null) {
            c.addAttribute(StyleConstants.FontSize, fontSize);
        } else {
            c.removeAttribute(StyleConstants.FontSize);
        }
        if (bold != null) {
            c.addAttribute(StyleConstants.Bold, bold);
        } else {
            c.removeAttribute(StyleConstants.Bold);
        }
        if (italic != null) {
            c.addAttribute(StyleConstants.Italic, italic);
        } else {
            c.removeAttribute(StyleConstants.Italic);
        }
        return c;
    }

    private String fontToString(AttributeSet category) {
        if ("default".equals(category.getAttribute(StyleConstants.NameAttribute))) {
            Boolean italic;
            StringBuffer sb = new StringBuffer();
            sb.append(this.getValue(this.currentLanguage, category, StyleConstants.FontFamily));
            sb.append(' ');
            sb.append(this.getValue(this.currentLanguage, category, StyleConstants.FontSize));
            Boolean bold = (Boolean)this.getValue(this.currentLanguage, category, StyleConstants.Bold);
            if (bold != null && bold.booleanValue()) {
                sb.append(' ').append(SyntaxColoringPanel.loc("CTL_Bold"));
            }
            if ((italic = (Boolean)this.getValue(this.currentLanguage, category, StyleConstants.Italic)) != null && italic.booleanValue()) {
                sb.append(' ').append(SyntaxColoringPanel.loc("CTL_Italic"));
            }
            return sb.toString();
        }
        boolean def = false;
        StringBuffer sb = new StringBuffer();
        if (category.getAttribute(StyleConstants.FontFamily) != null) {
            sb.append('+').append(category.getAttribute(StyleConstants.FontFamily));
        } else {
            def = true;
        }
        if (category.getAttribute(StyleConstants.FontSize) != null) {
            sb.append('+').append(category.getAttribute(StyleConstants.FontSize));
        } else {
            def = true;
        }
        if (Boolean.TRUE.equals(category.getAttribute(StyleConstants.Bold))) {
            sb.append('+').append(SyntaxColoringPanel.loc("CTL_Bold"));
        }
        if (Boolean.FALSE.equals(category.getAttribute(StyleConstants.Bold))) {
            sb.append('-').append(SyntaxColoringPanel.loc("CTL_Bold"));
        }
        if (Boolean.TRUE.equals(category.getAttribute(StyleConstants.Italic))) {
            sb.append('+').append(SyntaxColoringPanel.loc("CTL_Italic"));
        }
        if (Boolean.FALSE.equals(category.getAttribute(StyleConstants.Italic))) {
            sb.append('-').append(SyntaxColoringPanel.loc("CTL_Italic"));
        }
        if (def) {
            sb.insert(0, SyntaxColoringPanel.loc("CTL_Inherited"));
            return sb.toString();
        }
        String result = sb.toString();
        return result.replace('+', ' ');
    }

    private static Integer getDefaultFontSize() {
        if (defaultFontSize == null && (defaultFontSize = (Integer)UIManager.get("customFontSize")) == null) {
            int s = UIManager.getFont("TextField.font").getSize();
            if (s < 12) {
                s = 12;
            }
            defaultFontSize = new Integer(s);
        }
        return defaultFontSize;
    }

    static {
        convertALC.put("character", "char");
        convertALC.put("errors", "error");
        convertALC.put("literal", "keyword");
        convertALC.put("keyword-directive", "keyword");
    }

    private static final class LanguagesComparator
    implements Comparator<String> {
        private LanguagesComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.equals(ColorModel.ALL_LANGUAGES)) {
                return o2.equals(ColorModel.ALL_LANGUAGES) ? 0 : -1;
            }
            if (o2.equals(ColorModel.ALL_LANGUAGES)) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }
}

