/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.generaleditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.generaleditor.Model;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GeneralEditorPanel
extends JPanel
implements ActionListener {
    private boolean changed = false;
    private boolean listen = false;
    private JCheckBox cbCamelCaseBehavior;
    private JCheckBox cbFoldImports;
    private JCheckBox cbFoldInitialComments;
    private JCheckBox cbFoldInnerClasses;
    private JCheckBox cbFoldJavadocComments;
    private JCheckBox cbFoldMethods;
    private JCheckBox cbFoldTags;
    private JCheckBox cbUseCodeFolding;
    private JComboBox cboRemoveTrailingWhitespace;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JLabel lCamelCaseBehavior;
    private JLabel lCamelCaseBehaviorExample;
    private JLabel lCodeFolding;
    private JLabel lCollapseByDefault;
    private JLabel lRemoveTrailingWhitespace;
    private JLabel lUseCodeFolding;
    private JLabel lWhenSavingFiles;
    private Model model;

    public GeneralEditorPanel() {
        this.initComponents();
        GeneralEditorPanel.loc(this.lCodeFolding, "Code_Folding");
        GeneralEditorPanel.loc(this.lUseCodeFolding, "Code_Folding_Section");
        GeneralEditorPanel.loc(this.lCollapseByDefault, "Fold_by_Default");
        GeneralEditorPanel.loc(this.cbUseCodeFolding, "Use_Folding");
        GeneralEditorPanel.loc(this.cbFoldMethods, "Fold_Methods");
        GeneralEditorPanel.loc(this.cbFoldInnerClasses, "Fold_Classes");
        GeneralEditorPanel.loc(this.cbFoldImports, "Fold_Imports");
        GeneralEditorPanel.loc(this.cbFoldJavadocComments, "Fold_JavaDoc");
        GeneralEditorPanel.loc(this.cbFoldInitialComments, "Fold_Licence");
        GeneralEditorPanel.loc(this.cbFoldTags, "Fold_Tags");
        GeneralEditorPanel.loc(this.lCamelCaseBehavior, "Camel_Case_Behavior");
        GeneralEditorPanel.loc(this.cbCamelCaseBehavior, "Enable_Camel_Case_In_Java");
        GeneralEditorPanel.loc(this.lCamelCaseBehaviorExample, "Camel_Case_Behavior_Example");
        GeneralEditorPanel.loc(this.lWhenSavingFiles, "When_Saving_Files");
        GeneralEditorPanel.loc(this.lRemoveTrailingWhitespace, "Remove_Trailing_Whitespace");
        GeneralEditorPanel.loc(this.cboRemoveTrailingWhitespace, "Remove_Trailing_Whitespace");
        this.cbUseCodeFolding.setMnemonic(NbBundle.getMessage(GeneralEditorPanel.class, (String)"MNEMONIC_Use_Folding").charAt(0));
        this.cboRemoveTrailingWhitespace.setRenderer(new RemoveTrailingWhitespaceRenderer(this.cboRemoveTrailingWhitespace.getRenderer()));
        this.cboRemoveTrailingWhitespace.setModel(new DefaultComboBoxModel<Object>(new Object[]{"never", "always", "modified-lines"}));
    }

    private void initComponents() {
        this.lCodeFolding = new JLabel();
        this.lUseCodeFolding = new JLabel();
        this.lCollapseByDefault = new JLabel();
        this.cbUseCodeFolding = new JCheckBox();
        this.cbFoldMethods = new JCheckBox();
        this.cbFoldInnerClasses = new JCheckBox();
        this.cbFoldImports = new JCheckBox();
        this.cbFoldJavadocComments = new JCheckBox();
        this.cbFoldInitialComments = new JCheckBox();
        this.cbFoldTags = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.lCamelCaseBehavior = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.cbCamelCaseBehavior = new JCheckBox();
        this.lCamelCaseBehaviorExample = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.lWhenSavingFiles = new JLabel();
        this.lRemoveTrailingWhitespace = new JLabel();
        this.cboRemoveTrailingWhitespace = new JComboBox();
        this.setForeground(new Color(99, 130, 191));
        this.lCodeFolding.setText("Code Folding");
        this.lUseCodeFolding.setLabelFor(this.cbUseCodeFolding);
        this.lUseCodeFolding.setText("Use Code Folding:");
        this.lCollapseByDefault.setText("Collapse by Default:");
        this.cbFoldMethods.setText("Methods");
        this.cbFoldInnerClasses.setText("Inner Classes");
        this.cbFoldImports.setText("Imports");
        this.cbFoldJavadocComments.setText("Javadoc Comments");
        this.cbFoldInitialComments.setText("Initial Comments");
        this.cbFoldTags.setText("Tags and Other Code Blocks");
        this.lCamelCaseBehavior.setText("Camel Case  Behavior");
        this.cbCamelCaseBehavior.setText("Enable Camel Case Navigation");
        this.lCamelCaseBehaviorExample.setText("Example: Caret stops at J, T, N in \"JavaTypeName\" when using next/previous word acctions");
        this.lWhenSavingFiles.setText("When Saving Files");
        this.lRemoveTrailingWhitespace.setLabelFor(this.cboRemoveTrailingWhitespace);
        this.lRemoveTrailingWhitespace.setText("Remove Trailing Whitespace:");
        this.cboRemoveTrailingWhitespace.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lUseCodeFolding).add((Component)this.lCollapseByDefault).add((Component)this.lRemoveTrailingWhitespace)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.lCamelCaseBehaviorExample).add((Component)this.cboRemoveTrailingWhitespace, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(155, 155, 155).add((Component)this.cbCamelCaseBehavior).addContainerGap(424, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(155, 155, 155).add((Component)this.cbFoldImports).addContainerGap(494, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(155, 155, 155).add((Component)this.cbFoldInnerClasses).addContainerGap(494, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(155, 155, 155).add((Component)this.cbFoldMethods).add(18, 18, 18).add((Component)this.cbFoldTags).addContainerGap(267, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(155, 155, 155).add((Component)this.cbUseCodeFolding).addContainerGap(618, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(155, 155, 155).add((Component)this.cbFoldJavadocComments).addContainerGap(494, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(155, 155, 155).add((Component)this.cbFoldInitialComments).addContainerGap(494, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lWhenSavingFiles).addPreferredGap(0).add((Component)this.jSeparator4, -1, 677, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lCamelCaseBehavior).addPreferredGap(0).add((Component)this.jSeparator3, -1, 655, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lCodeFolding).addPreferredGap(0).add((Component)this.jSeparator1, -1, 706, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.cbFoldImports, this.cbFoldInitialComments, this.cbFoldInnerClasses, this.cbFoldJavadocComments, this.cbFoldMethods}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.lCodeFolding).add((Component)this.jSeparator1, -2, 10, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lUseCodeFolding).add((Component)this.cbUseCodeFolding)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lCollapseByDefault).add((Component)this.cbFoldMethods).add((Component)this.cbFoldTags)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbFoldInnerClasses).addPreferredGap(0).add((Component)this.cbFoldImports).addPreferredGap(0).add((Component)this.cbFoldJavadocComments).addPreferredGap(0).add((Component)this.cbFoldInitialComments).add(19, 19, 19).add((Component)this.jSeparator3, -2, 10, -2)).add((Component)this.lCamelCaseBehavior)).add(2, 2, 2).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbCamelCaseBehavior).addPreferredGap(0).add((Component)this.lCamelCaseBehaviorExample).add(18, 18, 18).add((Component)this.jSeparator4, -2, 10, -2)).add((Component)this.lWhenSavingFiles)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lRemoveTrailingWhitespace).add((Component)this.cboRemoveTrailingWhitespace, -2, -1, -2)).addContainerGap(67, Short.MAX_VALUE)));
    }

    private static String loc(String key) {
        return NbBundle.getMessage(GeneralEditorPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(GeneralEditorPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(GeneralEditorPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)GeneralEditorPanel.loc("CTL_" + key));
        } else if (c instanceof JLabel) {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)GeneralEditorPanel.loc("CTL_" + key));
        }
    }

    void update() {
        this.listen = false;
        if (this.model == null) {
            this.model = new Model();
            this.cbUseCodeFolding.addActionListener(this);
            this.cbFoldMethods.addActionListener(this);
            this.cbFoldInnerClasses.addActionListener(this);
            this.cbFoldImports.addActionListener(this);
            this.cbFoldJavadocComments.addActionListener(this);
            this.cbFoldInitialComments.addActionListener(this);
            this.cbCamelCaseBehavior.addActionListener(this);
            this.cbFoldTags.addActionListener(this);
            this.cboRemoveTrailingWhitespace.addActionListener(this);
        }
        this.cbUseCodeFolding.setSelected(this.model.isShowCodeFolding());
        this.cbFoldImports.setSelected(this.model.isFoldImports());
        this.cbFoldInitialComments.setSelected(this.model.isFoldInitialComment());
        this.cbFoldInnerClasses.setSelected(this.model.isFoldInnerClasses());
        this.cbFoldJavadocComments.setSelected(this.model.isFoldJavaDocComments());
        this.cbFoldMethods.setSelected(this.model.isFoldMethods());
        this.cbFoldTags.setSelected(this.model.isFoldTag());
        Boolean ccJava = this.model.isCamelCaseJavaNavigation();
        if (ccJava == null) {
            this.cbCamelCaseBehavior.setEnabled(false);
            this.cbCamelCaseBehavior.setSelected(false);
        } else {
            this.cbCamelCaseBehavior.setEnabled(true);
            this.cbCamelCaseBehavior.setSelected(ccJava);
        }
        this.cboRemoveTrailingWhitespace.setSelectedItem(this.model.getRemoveTrailingWhitespace());
        this.updateEnabledState();
        this.listen = true;
    }

    void applyChanges() {
        if (this.model == null || !this.changed) {
            return;
        }
        this.model.setFoldingOptions(this.cbUseCodeFolding.isSelected(), this.cbFoldImports.isSelected(), this.cbFoldInitialComments.isSelected(), this.cbFoldInnerClasses.isSelected(), this.cbFoldJavadocComments.isSelected(), this.cbFoldMethods.isSelected(), this.cbFoldTags.isSelected());
        this.model.setCamelCaseNavigation(this.cbCamelCaseBehavior.isSelected());
        this.model.setRemoveTrailingWhitespace((String)this.cboRemoveTrailingWhitespace.getSelectedItem());
        this.changed = false;
    }

    void cancel() {
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        if (e.getSource() == this.cbUseCodeFolding) {
            this.updateEnabledState();
        }
        this.changed = true;
    }

    private void updateEnabledState() {
        boolean useCodeFolding = this.cbUseCodeFolding.isSelected();
        this.cbFoldImports.setEnabled(useCodeFolding);
        this.cbFoldInitialComments.setEnabled(useCodeFolding);
        this.cbFoldInnerClasses.setEnabled(useCodeFolding);
        this.cbFoldJavadocComments.setEnabled(useCodeFolding);
        this.cbFoldMethods.setEnabled(useCodeFolding);
        this.cbFoldTags.setEnabled(useCodeFolding);
    }

    private static final class RemoveTrailingWhitespaceRenderer
    implements ListCellRenderer {
        private final ListCellRenderer defaultRenderer;

        public RemoveTrailingWhitespaceRenderer(ListCellRenderer defaultRenderer) {
            this.defaultRenderer = defaultRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.defaultRenderer.getListCellRendererComponent(list, NbBundle.getMessage(GeneralEditorPanel.class, (String)("RTW_" + value)), index, isSelected, cellHasFocus);
        }
    }
}

