/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import javax.lang.model.element.ElementKind;

public class TypeAnnotations {
    private static final Context.Key<TypeAnnotations> key = new Context.Key();

    public static TypeAnnotations instance(Context context) {
        TypeAnnotations instance = context.get(key);
        if (instance == null) {
            instance = new TypeAnnotations(context);
        }
        return instance;
    }

    protected TypeAnnotations(Context context) {
        context.put(key, this);
    }

    public void taFillAndLift(JCTree.JCClassDecl tree, boolean visitBodies) {
    }

    private static class TypeAnnotationLift
    extends TreeScanner {
        List<Attribute.TypeCompound> recordedTypeAnnotations = List.nil();
        boolean isInner = false;

        private TypeAnnotationLift() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (this.isInner) {
                return;
            }
            this.isInner = true;
            List<Attribute.TypeCompound> prevTAs = this.recordedTypeAnnotations;
            this.recordedTypeAnnotations = List.nil();
            try {
                super.visitClassDef(tree);
                Object var4_3 = null;
                tree.sym.typeAnnotations = tree.sym.typeAnnotations.appendList(this.recordedTypeAnnotations);
                this.recordedTypeAnnotations = prevTAs;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                tree.sym.typeAnnotations = tree.sym.typeAnnotations.appendList(this.recordedTypeAnnotations);
                this.recordedTypeAnnotations = prevTAs;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            List<Attribute.TypeCompound> prevTAs = this.recordedTypeAnnotations;
            this.recordedTypeAnnotations = List.nil();
            try {
                super.visitMethodDef(tree);
                Object var4_3 = null;
                tree.sym.typeAnnotations = tree.sym.typeAnnotations.appendList(this.recordedTypeAnnotations);
                this.recordedTypeAnnotations = prevTAs;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                tree.sym.typeAnnotations = tree.sym.typeAnnotations.appendList(this.recordedTypeAnnotations);
                this.recordedTypeAnnotations = prevTAs;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            List<Attribute.TypeCompound> prevTAs = this.recordedTypeAnnotations;
            this.recordedTypeAnnotations = List.nil();
            ElementKind kind = tree.sym.getKind();
            if (kind == ElementKind.LOCAL_VARIABLE && tree.mods.annotations.nonEmpty()) {
                TypeAnnotationPosition position = new TypeAnnotationPosition();
                position.pos = tree.pos;
                position.type = TargetType.LOCAL_VARIABLE;
                for (Attribute.Compound attribute : tree.sym.attributes_field) {
                    Attribute.TypeCompound tc = new Attribute.TypeCompound(attribute.type, attribute.values, position);
                    this.recordedTypeAnnotations = this.recordedTypeAnnotations.append(tc);
                }
            }
            try {
                super.visitVarDef(tree);
                Object var9_8 = null;
                if (kind.isField() || kind == ElementKind.LOCAL_VARIABLE) {
                    tree.sym.typeAnnotations = tree.sym.typeAnnotations.appendList(this.recordedTypeAnnotations);
                }
                this.recordedTypeAnnotations = kind.isField() ? prevTAs : prevTAs.appendList(this.recordedTypeAnnotations);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (kind.isField() || kind == ElementKind.LOCAL_VARIABLE) {
                    tree.sym.typeAnnotations = tree.sym.typeAnnotations.appendList(this.recordedTypeAnnotations);
                }
                this.recordedTypeAnnotations = kind.isField() ? prevTAs : prevTAs.appendList(this.recordedTypeAnnotations);
                throw throwable;
            }
        }

        public void visitApply(JCTree.JCMethodInvocation tree) {
            this.scan(tree.meth);
            this.scan(tree.typeargs);
            this.scan(tree.args);
        }

        public void visitAnnotation(JCTree.JCAnnotation tree) {
            if (tree instanceof JCTree.JCTypeAnnotation) {
                this.recordedTypeAnnotations = this.recordedTypeAnnotations.append(((JCTree.JCTypeAnnotation)tree).attribute_field);
            }
            super.visitAnnotation(tree);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeAnnotationPositions
    extends TreeScanner {
        private ListBuffer<JCTree> frames = ListBuffer.lb();
        private boolean inClass = false;

        private TypeAnnotationPositions() {
        }

        private void push(JCTree t) {
            this.frames = this.frames.prepend(t);
        }

        private JCTree pop() {
            return this.frames.next();
        }

        private JCTree peek2() {
            return (JCTree)this.frames.toList().tail.head;
        }

        @Override
        public void scan(JCTree tree) {
            this.push(tree);
            super.scan(tree);
            this.pop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (!this.inClass) {
                this.inClass = true;
                try {
                    super.visitClassDef(tree);
                    Object var3_2 = null;
                    this.inClass = false;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.inClass = false;
                    throw throwable;
                }
            }
        }

        private TypeAnnotationPosition resolveFrame(JCTree tree, JCTree frame, List<JCTree> path, TypeAnnotationPosition p) {
            switch (frame.getKind()) {
                case TYPE_CAST: {
                    p.type = TargetType.TYPECAST;
                    p.pos = frame.pos;
                    return p;
                }
                case INSTANCE_OF: {
                    p.type = TargetType.INSTANCEOF;
                    p.pos = frame.pos;
                    return p;
                }
                case NEW_CLASS: {
                    p.type = TargetType.NEW;
                    p.pos = frame.pos;
                    return p;
                }
                case NEW_ARRAY: {
                    p.type = TargetType.NEW;
                    p.pos = frame.pos;
                    return p;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    p.pos = frame.pos;
                    if (((JCTree.JCClassDecl)frame).extending == tree) {
                        p.type = TargetType.CLASS_EXTENDS;
                        p.type_index = -1;
                    } else if (((JCTree.JCClassDecl)frame).implementing.contains(tree)) {
                        p.type = TargetType.CLASS_EXTENDS;
                        p.type_index = ((JCTree.JCClassDecl)frame).implementing.indexOf(tree);
                    } else if (((JCTree.JCClassDecl)frame).typarams.contains(tree)) {
                        p.type = TargetType.CLASS_TYPE_PARAMETER;
                        p.parameter_index = ((JCTree.JCClassDecl)frame).typarams.indexOf(tree);
                    } else {
                        throw new AssertionError();
                    }
                    return p;
                }
                case METHOD: {
                    JCTree.JCMethodDecl frameMethod = (JCTree.JCMethodDecl)frame;
                    p.pos = frame.pos;
                    if (frameMethod.receiverAnnotations.contains(tree)) {
                        p.type = TargetType.METHOD_RECEIVER;
                    } else if (frameMethod.thrown.contains(tree)) {
                        p.type = TargetType.THROWS;
                        p.type_index = frameMethod.thrown.indexOf(tree);
                    } else if (((JCTree.JCMethodDecl)frame).restype == tree) {
                        p.type = TargetType.METHOD_RETURN_GENERIC_OR_ARRAY;
                    } else if (frameMethod.typarams.contains(tree)) {
                        p.type = TargetType.METHOD_TYPE_PARAMETER;
                        p.parameter_index = frameMethod.typarams.indexOf(tree);
                    } else {
                        throw new AssertionError();
                    }
                    return p;
                }
                case MEMBER_SELECT: {
                    JCTree.JCFieldAccess fieldFrame = (JCTree.JCFieldAccess)frame;
                    if (!"class".contentEquals(fieldFrame.name)) {
                        throw new AssertionError();
                    }
                    p.type = TargetType.CLASS_LITERAL;
                    p.pos = TreeInfo.innermostType((JCTree)fieldFrame.selected).pos;
                    return p;
                }
                case PARAMETERIZED_TYPE: {
                    if (((JCTree.JCTypeApply)frame).clazz == tree) {
                        TypeAnnotationPosition nextP = p;
                    } else if (((JCTree.JCTypeApply)frame).arguments.contains(tree)) {
                        p.location = p.location.prepend(((JCTree.JCTypeApply)frame).arguments.indexOf(tree));
                    } else {
                        throw new AssertionError();
                    }
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                }
                case ARRAY_TYPE: {
                    p.location = p.location.prepend(0);
                    List<JCTree> newPath = path.tail;
                    return this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                }
                case TYPE_PARAMETER: {
                    if (((JCTree)path.tail.tail.head).getTag() == 3) {
                        JCTree.JCClassDecl clazz = (JCTree.JCClassDecl)path.tail.tail.head;
                        p.type = TargetType.CLASS_TYPE_PARAMETER_BOUND;
                        p.parameter_index = clazz.typarams.indexOf(path.tail.head);
                        p.bound_index = ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree);
                    } else if (((JCTree)path.tail.tail.head).getTag() == 4) {
                        JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)path.tail.tail.head;
                        p.type = TargetType.METHOD_TYPE_PARAMETER_BOUND;
                        p.parameter_index = method.typarams.indexOf(path.tail.head);
                        p.bound_index = ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree);
                    } else {
                        throw new AssertionError();
                    }
                    p.pos = frame.pos;
                    return p;
                }
                case VARIABLE: {
                    Symbol.VarSymbol v = ((JCTree.JCVariableDecl)frame).sym;
                    p.pos = frame.pos;
                    switch (v.getKind()) {
                        case LOCAL_VARIABLE: {
                            p.type = TargetType.LOCAL_VARIABLE;
                            break;
                        }
                        case FIELD: {
                            p.type = TargetType.FIELD_GENERIC_OR_ARRAY;
                            break;
                        }
                        case PARAMETER: {
                            p.type = TargetType.METHOD_PARAMETER_GENERIC_OR_ARRAY;
                            p.parameter_index = this.methodParamIndex(path, frame);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    return p;
                }
                case METHOD_INVOCATION: {
                    JCTree.JCMethodInvocation invocation = (JCTree.JCMethodInvocation)frame;
                    if (!invocation.typeargs.contains(tree)) {
                        throw new AssertionError((Object)("{" + tree + "} is not an argument in the invocation: " + invocation));
                    }
                    p.type = TargetType.METHOD_TYPE_ARGUMENT;
                    p.pos = invocation.pos;
                    p.type_index = invocation.typeargs.indexOf(tree);
                    return p;
                }
                case EXTENDS_WILDCARD: 
                case SUPER_WILDCARD: {
                    p.type = TargetType.WILDCARD_BOUND;
                    List<JCTree> newPath = path.tail;
                    TypeAnnotationPosition wildcard = this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, new TypeAnnotationPosition());
                    if (!wildcard.location.isEmpty()) {
                        wildcard.type = wildcard.type.getGenericComplement();
                    }
                    p.wildcard_position = wildcard;
                    p.pos = frame.pos;
                    return p;
                }
            }
            return p;
        }

        private void setTypeAnnotationPos(List<JCTree.JCTypeAnnotation> annotations, TypeAnnotationPosition position) {
            for (JCTree.JCTypeAnnotation anno : annotations) {
                anno.annotation_position = position;
                anno.attribute_field.position = position;
            }
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            int i;
            this.findPosition(tree, tree, tree.annotations);
            int dimAnnosCount = tree.dimAnnotations.size();
            for (i = 0; i < dimAnnosCount; ++i) {
                TypeAnnotationPosition p = new TypeAnnotationPosition();
                p.type = TargetType.NEW_GENERIC_OR_ARRAY;
                p.pos = tree.pos;
                p.location = p.location.append(i);
                this.setTypeAnnotationPos(tree.dimAnnotations.get(i), p);
            }
            i = dimAnnosCount == 0 ? 0 : dimAnnosCount - 1;
            JCTree.JCExpression elemType = tree.elemtype;
            while (elemType != null) {
                if (elemType.getTag() == 92) {
                    JCTree.JCAnnotatedType at = (JCTree.JCAnnotatedType)elemType;
                    TypeAnnotationPosition p = new TypeAnnotationPosition();
                    p.type = TargetType.NEW_GENERIC_OR_ARRAY;
                    p.pos = tree.pos;
                    p.location = p.location.append(i);
                    this.setTypeAnnotationPos(at.annotations, p);
                    elemType = at.underlyingType;
                    continue;
                }
                if (elemType.getTag() != 38) break;
                ++i;
                elemType = ((JCTree.JCArrayTypeTree)elemType).elemtype;
            }
            this.scan(tree.elems);
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
            this.findPosition(tree, this.peek2(), tree.annotations);
            super.visitAnnotatedType(tree);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            TypeAnnotationPosition p = new TypeAnnotationPosition();
            p.type = TargetType.METHOD_RECEIVER;
            this.setTypeAnnotationPos(tree.receiverAnnotations, p);
            super.visitMethodDef(tree);
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            this.findPosition(tree, this.peek2(), tree.annotations);
            super.visitTypeParameter(tree);
        }

        void findPosition(JCTree tree, JCTree frame, List<JCTree.JCTypeAnnotation> annotations) {
            if (!annotations.isEmpty()) {
                TypeAnnotationPosition p = this.resolveFrame(tree, frame, this.frames.toList(), new TypeAnnotationPosition());
                if (!p.location.isEmpty()) {
                    p.type = p.type.getGenericComplement();
                }
                this.setTypeAnnotationPos(annotations, p);
            }
        }

        private int methodParamIndex(List<JCTree> path, JCTree param) {
            List<JCTree> curr = path;
            if (curr.head != param) {
                curr = path.tail;
            }
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)curr.tail.head;
            return method.params.indexOf(param);
        }
    }
}

