/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.JavacOption;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.main.RecognizedOptions;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.MissingResourceException;
import java.util.ServiceLoader;
import javax.annotation.processing.Processor;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    String ownName;
    PrintWriter out;
    boolean fatalErrors;
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private JavacOption.Option[] recognizedOptions = RecognizedOptions.getJavaCompilerOptions(new RecognizedOptions.OptionHelper(){

        public void setOut(PrintWriter out) {
            Main.this.out = out;
        }

        public void error(String key, Object ... args) {
            Main.this.error(key, args);
        }

        public void printVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("version", Main.this.ownName, JavaCompiler.version()));
        }

        public void printFullVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("fullVersion", Main.this.ownName, JavaCompiler.fullVersion()));
        }

        public void printHelp() {
            Main.this.help();
        }

        public void printXhelp() {
            Main.this.xhelp();
        }

        public void addFile(File f) {
            if (!Main.this.filenames.contains(f)) {
                Main.this.filenames.append(f);
            }
        }

        public void addClassName(String s) {
            Main.this.classnames.append(s);
        }
    });
    private Options options = null;
    public ListBuffer<File> filenames = null;
    public ListBuffer<String> classnames = null;
    private JavaFileManager fileManager;
    private static final String javacBundleName = "com.sun.tools.javac.resources.javac";
    private static JavacMessages messages;

    public Main(String name) {
        this(name, new PrintWriter(System.err, true));
    }

    public Main(String name, PrintWriter out) {
        this.ownName = name;
        this.out = out;
    }

    void help() {
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.header", this.ownName));
        for (int i = 0; i < this.recognizedOptions.length; ++i) {
            this.recognizedOptions[i].help(this.out);
        }
        this.out.println();
    }

    void xhelp() {
        for (int i = 0; i < this.recognizedOptions.length; ++i) {
            this.recognizedOptions[i].xhelp(this.out);
        }
        this.out.println();
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.nonstandard.footer", new Object[0]));
    }

    void error(String key, Object ... args) {
        if (this.fatalErrors) {
            String msg = Main.getLocalizedString(key, args);
            throw new PropagatedException(new IllegalStateException(msg));
        }
        this.warning(key, args);
        Log.printLines(this.out, Main.getLocalizedString("msg.usage", this.ownName));
    }

    void warning(String key, Object ... args) {
        Log.printLines(this.out, this.ownName + ": " + Main.getLocalizedString(key, args));
    }

    public JavacOption.Option getOption(String flag) {
        for (JavacOption.Option option : this.recognizedOptions) {
            if (!option.matches(flag)) continue;
            return option;
        }
        return null;
    }

    public void setOptions(Options options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.options = options;
    }

    public void setFatalErrors(boolean fatalErrors) {
        this.fatalErrors = fatalErrors;
    }

    public List<File> processArgs(String[] flags) {
        Target target;
        int ac = 0;
        while (ac < flags.length) {
            String flag = flags[ac];
            ++ac;
            JavacOption.Option option = null;
            if (flag.length() > 0) {
                int firstOptionToCheck;
                for (int j = firstOptionToCheck = flag.charAt(0) == '-' ? 0 : this.recognizedOptions.length - 1; j < this.recognizedOptions.length; ++j) {
                    if (!this.recognizedOptions[j].matches(flag)) continue;
                    option = this.recognizedOptions[j];
                    break;
                }
            }
            if (option == null) {
                this.error("err.invalid.flag", flag);
                return null;
            }
            if (option.hasArg()) {
                if (ac == flags.length) {
                    this.error("err.req.arg", flag);
                    return null;
                }
                String operand = flags[ac];
                ++ac;
                if (!option.process(this.options, flag, operand)) continue;
                return null;
            }
            if (!option.process(this.options, flag)) continue;
            return null;
        }
        if (!this.checkDirectory(OptionName.D)) {
            return null;
        }
        if (!this.checkDirectory(OptionName.S)) {
            return null;
        }
        String sourceString = this.options.get(OptionName.SOURCE);
        Source source = sourceString != null ? Source.lookup(sourceString) : Source.DEFAULT;
        String targetString = this.options.get(OptionName.TARGET);
        Target target2 = target = targetString != null ? Target.lookup(targetString) : Target.DEFAULT;
        if (Character.isDigit(target.name.charAt(0))) {
            if (target.compareTo(source.requiredTarget()) < 0) {
                if (targetString != null) {
                    if (sourceString == null) {
                        this.warning("warn.target.default.source.conflict", targetString, source.requiredTarget().name);
                    } else {
                        this.warning("warn.source.target.conflict", sourceString, source.requiredTarget().name);
                    }
                    return null;
                }
                target = source.requiredTarget();
                this.options.put("-target", target.name);
            } else if (targetString == null && !source.allowGenerics()) {
                target = Target.JDK1_4;
                this.options.put("-target", target.name);
            }
        }
        if ("no".equals(this.options.get("allowTransitionalJSR292"))) {
            this.options.put("allowTransitionalJSR292", null);
        } else if (target.hasInvokedynamic() && this.options.isUnset("allowTransitionalJSR292")) {
            this.options.put("allowTransitionalJSR292", "allowTransitionalJSR292");
        }
        String showClass = this.options.get("showClass");
        if (showClass != null) {
            if (showClass.equals("showClass")) {
                showClass = "com.sun.tools.javac.Main";
            }
            this.showClass(showClass);
        }
        return this.filenames.toList();
    }

    private boolean checkDirectory(OptionName optName) {
        String value = this.options.get(optName);
        if (value == null) {
            return true;
        }
        File file = new File(value);
        if (!file.exists()) {
            this.error("err.dir.not.found", value);
            return false;
        }
        if (!file.isDirectory()) {
            this.error("err.file.not.directory", value);
            return false;
        }
        return true;
    }

    public int compile(String[] args) {
        Context context = new Context();
        JavacFileManager.preRegister(context);
        int result = this.compile(args, context);
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).close();
        }
        return result;
    }

    public int compile(String[] args, Context context) {
        return this.compile(args, context, List.<JavaFileObject>nil(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(String[] args, Context context, List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        int n;
        if (this.options == null) {
            this.options = Options.instance(context);
        }
        context.put(TaskListener.class, new ServiceBasedTaskListenerImpl());
        this.filenames = new ListBuffer();
        this.classnames = new ListBuffer();
        JavaCompiler comp = null;
        try {
            boolean batchMode;
            if (args.length == 0 && fileObjects.isEmpty()) {
                this.help();
                int n2 = 2;
                return n2;
            }
            List<File> files = this.processArgs(CommandLine.parse(args));
            if (files == null) {
                int n3 = 2;
                return n3;
            }
            if (files.isEmpty() && fileObjects.isEmpty() && this.classnames.isEmpty()) {
                if (this.options.isSet(OptionName.HELP) || this.options.isSet(OptionName.X) || this.options.isSet(OptionName.VERSION) || this.options.isSet(OptionName.FULLVERSION)) {
                    int n4 = 0;
                    return n4;
                }
                this.error("err.no.source.files", new Object[0]);
                int n5 = 2;
                return n5;
            }
            boolean forceStdOut = this.options.isSet("stdout");
            if (forceStdOut) {
                this.out.flush();
                this.out = new PrintWriter(System.out, true);
            }
            context.put(Log.outKey, this.out);
            boolean bl = batchMode = this.options.isUnset("nonBatchMode") && System.getProperty("nonBatchMode") == null;
            if (batchMode) {
                CacheFSInfo.preRegister(context);
            }
            this.fileManager = context.get(JavaFileManager.class);
            comp = JavaCompiler.instance(context);
            if (comp == null) {
                int n6 = 3;
                return n6;
            }
            Log log = Log.instance(context);
            if (!files.isEmpty()) {
                comp = JavaCompiler.instance(context);
                List<JavaFileObject> otherFiles = List.nil();
                JavacFileManager dfm = (JavacFileManager)this.fileManager;
                for (JavaFileObject javaFileObject : dfm.getJavaFileObjectsFromFiles(files)) {
                    otherFiles = otherFiles.prepend(javaFileObject);
                }
                for (JavaFileObject javaFileObject : otherFiles) {
                    fileObjects = fileObjects.prepend(javaFileObject);
                }
            }
            comp.compile(fileObjects, this.classnames.toList(), processors);
            if (log.expectDiagKeys != null) {
                if (log.expectDiagKeys.isEmpty()) {
                    Log.printLines(log.noticeWriter, "all expected diagnostics found");
                    int n7 = 0;
                    return n7;
                }
                Log.printLines(log.noticeWriter, "expected diagnostic keys not found: " + log.expectDiagKeys);
                int n8 = 1;
                return n8;
            }
            if (comp.errorCount() != 0) {
                int n9 = 1;
                return n9;
            }
        }
        catch (IOException ex) {
            this.ioMessage(ex);
            n = 3;
            return n;
        }
        catch (OutOfMemoryError ex) {
            this.resourceMessage(ex);
            n = 3;
            return n;
        }
        catch (StackOverflowError ex) {
            this.resourceMessage(ex);
            n = 3;
            return n;
        }
        catch (FatalError ex) {
            this.feMessage(ex);
            n = 3;
            return n;
        }
        catch (AnnotationProcessingError ex) {
            this.apMessage(ex);
            n = 3;
            return n;
        }
        catch (ClientCodeException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (PropagatedException ex) {
            throw ex.getCause();
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || this.options == null || this.options.isSet("dev")) {
                this.bugMessage(ex);
            }
            n = 4;
            return n;
        }
        finally {
            if (comp != null) {
                comp.close();
            }
            this.filenames = null;
            this.options = null;
        }
        return 0;
    }

    void bugMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.bug", JavaCompiler.version()));
        ex.printStackTrace(this.out);
    }

    void feMessage(Throwable ex) {
        Log.printLines(this.out, ex.getMessage());
        if (ex.getCause() != null && this.options.isSet("dev")) {
            ex.getCause().printStackTrace(this.out);
        }
    }

    void ioMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.io", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void resourceMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.resource", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void apMessage(AnnotationProcessingError ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.proc.annotation.uncaught.exception", new Object[0]));
        ex.getCause().printStackTrace(this.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showClass(String className) {
        this.out.println("javac: show class: " + className);
        URL url = this.getClass().getResource('/' + className.replace('.', '/') + ".class");
        if (url == null) {
            this.out.println("  class not found");
        } else {
            this.out.println("  " + url);
            try {
                byte[] digest;
                String algorithm = "MD5";
                MessageDigest md = MessageDigest.getInstance("MD5");
                DigestInputStream in = new DigestInputStream(url.openStream(), md);
                try {
                    int n;
                    byte[] buf = new byte[8192];
                    while ((n = in.read(buf)) > 0) {
                    }
                    digest = md.digest();
                }
                finally {
                    in.close();
                }
                StringBuilder sb = new StringBuilder();
                for (byte b : digest) {
                    sb.append(String.format("%02x", b));
                }
                this.out.println("  MD5 checksum: " + sb);
            }
            catch (Exception e) {
                this.out.println("  cannot compute digest: " + e);
            }
        }
    }

    public static String getLocalizedString(String key, Object ... args) {
        try {
            if (messages == null) {
                messages = new JavacMessages(javacBundleName);
            }
            return messages.getLocalizedString("javac." + key, args);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal Error: Resource for javac is missing", e);
        }
    }

    public static void useRawMessages(boolean enable) {
        messages = enable ? new JavacMessages(javacBundleName){

            public String getLocalizedString(String key, Object ... args) {
                return key;
            }
        } : new JavacMessages(javacBundleName);
    }

    private static final class ServiceBasedTaskListenerImpl
    implements TaskListener {
        private final Collection<TaskListener> delegates;

        public ServiceBasedTaskListenerImpl() {
            ArrayList<TaskListener> delegates = new ArrayList<TaskListener>();
            for (TaskListener l : ServiceLoader.load(TaskListener.class)) {
                delegates.add(l);
            }
            this.delegates = Collections.unmodifiableCollection(delegates);
        }

        public void started(TaskEvent e) {
            for (TaskListener delegate : this.delegates) {
                try {
                    delegate.started(e);
                }
                catch (Throwable ex) {
                    throw new ClientCodeException(ex);
                }
            }
        }

        public void finished(TaskEvent e) {
            for (TaskListener delegate : this.delegates) {
                try {
                    delegate.finished(e);
                }
                catch (Throwable ex) {
                    throw new ClientCodeException(ex);
                }
            }
        }
    }
}

