/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCDiagnostic
implements Diagnostic<JavaFileObject> {
    private final DiagnosticType type;
    private final DiagnosticSource source;
    private final DiagnosticPosition position;
    private final int line;
    private final int column;
    private final String key;
    protected final Object[] args;
    private final Set<DiagnosticFlag> flags;
    private final Lint.LintCategory lintCategory;
    private DiagnosticFormatter<JCDiagnostic> defaultFormatter;
    @Deprecated
    private static DiagnosticFormatter<JCDiagnostic> fragmentFormatter;

    @Deprecated
    public static JCDiagnostic fragment(String key, Object ... args) {
        return new JCDiagnostic(JCDiagnostic.getFragmentFormatter(), DiagnosticType.FRAGMENT, null, EnumSet.noneOf(DiagnosticFlag.class), null, null, "compiler." + DiagnosticType.FRAGMENT.key + "." + key, args);
    }

    @Deprecated
    public static DiagnosticFormatter<JCDiagnostic> getFragmentFormatter() {
        if (fragmentFormatter == null) {
            fragmentFormatter = new BasicDiagnosticFormatter(JavacMessages.getDefaultMessages());
        }
        return fragmentFormatter;
    }

    protected JCDiagnostic(DiagnosticFormatter<JCDiagnostic> formatter, DiagnosticType dt, Lint.LintCategory lc, Set<DiagnosticFlag> flags, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
        int n;
        if (source == null && pos != null && pos.getPreferredPosition() != -1) {
            throw new IllegalArgumentException();
        }
        this.defaultFormatter = formatter;
        this.type = dt;
        this.lintCategory = lc;
        this.flags = flags;
        this.source = source;
        this.position = pos;
        this.key = key;
        this.args = args;
        int n2 = n = pos == null ? -1 : pos.getPreferredPosition();
        if (n == -1 || source == null) {
            this.column = -1;
            this.line = -1;
        } else {
            this.line = source.getLineNumber(n);
            this.column = source.getColumnNumber(n, true);
        }
    }

    public DiagnosticType getType() {
        return this.type;
    }

    public List<JCDiagnostic> getSubdiagnostics() {
        return List.nil();
    }

    public boolean isMultiline() {
        return false;
    }

    public boolean isMandatory() {
        return this.flags.contains((Object)DiagnosticFlag.MANDATORY);
    }

    public boolean hasLintCategory() {
        return this.lintCategory != null;
    }

    public Lint.LintCategory getLintCategory() {
        return this.lintCategory;
    }

    @Override
    public JavaFileObject getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.getFile();
    }

    public DiagnosticSource getDiagnosticSource() {
        return this.source;
    }

    protected int getIntStartPosition() {
        return this.position == null ? -1 : this.position.getStartPosition();
    }

    protected int getIntPosition() {
        return this.position == null ? -1 : this.position.getPreferredPosition();
    }

    protected int getIntEndPosition() {
        return this.position == null ? -1 : this.position.getEndPosition(this.source.getEndPosTable());
    }

    @Override
    public long getStartPosition() {
        return this.getIntStartPosition();
    }

    @Override
    public long getPosition() {
        return this.getIntPosition();
    }

    @Override
    public long getEndPosition() {
        return this.getIntEndPosition();
    }

    public JCTree getTree() {
        return this.position == null ? null : this.position.getTree();
    }

    @Override
    public long getLineNumber() {
        return this.line;
    }

    @Override
    public long getColumnNumber() {
        return this.column;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getPrefix() {
        return this.getPrefix(this.type);
    }

    public String getPrefix(DiagnosticType dt) {
        return this.defaultFormatter.formatKind(this, Locale.getDefault());
    }

    public String toString() {
        return this.defaultFormatter.format(this, Locale.getDefault());
    }

    @Override
    public Diagnostic.Kind getKind() {
        switch (this.type) {
            case NOTE: {
                return Diagnostic.Kind.NOTE;
            }
            case WARNING: {
                return this.flags.contains((Object)DiagnosticFlag.MANDATORY) ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.WARNING;
            }
            case ERROR: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    @Override
    public String getCode() {
        return this.key;
    }

    @Override
    public String getMessage(Locale locale) {
        return this.defaultFormatter.formatMessage(this, locale);
    }

    public void setFlag(DiagnosticFlag flag) {
        this.flags.add(flag);
        if (this.type == DiagnosticType.ERROR) {
            switch (flag) {
                case SYNTAX: {
                    this.flags.remove((Object)DiagnosticFlag.RECOVERABLE);
                    break;
                }
                case RESOLVE_ERROR: {
                    this.flags.add(DiagnosticFlag.RECOVERABLE);
                }
            }
        }
    }

    public boolean isFlagSet(DiagnosticFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public boolean hasFixedPositions() {
        return this.position.getTree() == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultilineDiagnostic
    extends JCDiagnostic {
        private final List<JCDiagnostic> subdiagnostics;

        public MultilineDiagnostic(JCDiagnostic other, List<JCDiagnostic> subdiagnostics) {
            super(other.defaultFormatter, other.getType(), other.getLintCategory(), other.flags, other.getDiagnosticSource(), other.position, other.getCode(), other.getArgs());
            this.subdiagnostics = subdiagnostics;
        }

        @Override
        public List<JCDiagnostic> getSubdiagnostics() {
            return this.subdiagnostics;
        }

        @Override
        public boolean isMultiline() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiagnosticFlag {
        MANDATORY,
        RESOLVE_ERROR,
        SYNTAX,
        RECOVERABLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleDiagnosticPosition
    implements DiagnosticPosition {
        private final int pos;

        public SimpleDiagnosticPosition(int pos) {
            this.pos = pos;
        }

        @Override
        public JCTree getTree() {
            return null;
        }

        @Override
        public int getStartPosition() {
            return this.pos;
        }

        @Override
        public int getPreferredPosition() {
            return this.pos;
        }

        @Override
        public int getEndPosition(Map<JCTree, Integer> endPosTable) {
            return this.pos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DiagnosticPosition {
        public JCTree getTree();

        public int getStartPosition();

        public int getPreferredPosition();

        public int getEndPosition(Map<JCTree, Integer> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiagnosticType {
        FRAGMENT("misc"),
        NOTE("note"),
        WARNING("warn"),
        ERROR("err");

        final String key;

        private DiagnosticType(String key) {
            this.key = key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        protected static final Context.Key<Factory> diagnosticFactoryKey = new Context.Key();
        DiagnosticFormatter<JCDiagnostic> formatter;
        final String prefix;
        final Set<DiagnosticFlag> defaultErrorFlags;

        public static Factory instance(Context context) {
            Factory instance = context.get(diagnosticFactoryKey);
            if (instance == null) {
                instance = new Factory(context);
            }
            return instance;
        }

        protected Factory(Context context) {
            this(JavacMessages.instance(context), "compiler");
            context.put(diagnosticFactoryKey, this);
            Options options = Options.instance(context);
            if (options.isSet("onlySyntaxErrorsUnrecoverable")) {
                this.defaultErrorFlags.add(DiagnosticFlag.RECOVERABLE);
            }
        }

        public Factory(JavacMessages messages, String prefix) {
            this.prefix = prefix;
            this.formatter = new BasicDiagnosticFormatter(messages);
            this.defaultErrorFlags = EnumSet.of(DiagnosticFlag.MANDATORY);
        }

        public JCDiagnostic error(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.create(DiagnosticType.ERROR, null, this.defaultErrorFlags, source, pos, key, args);
        }

        public JCDiagnostic mandatoryWarning(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.create(DiagnosticType.WARNING, null, EnumSet.of(DiagnosticFlag.MANDATORY), source, pos, key, args);
        }

        public JCDiagnostic mandatoryWarning(Lint.LintCategory lc, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.create(DiagnosticType.WARNING, lc, EnumSet.of(DiagnosticFlag.MANDATORY), source, pos, key, args);
        }

        public JCDiagnostic warning(Lint.LintCategory lc, String key, Object ... args) {
            return this.create(DiagnosticType.WARNING, lc, EnumSet.noneOf(DiagnosticFlag.class), null, null, key, args);
        }

        public JCDiagnostic warning(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.create(DiagnosticType.WARNING, null, EnumSet.noneOf(DiagnosticFlag.class), source, pos, key, args);
        }

        public JCDiagnostic warning(Lint.LintCategory lc, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.create(DiagnosticType.WARNING, lc, EnumSet.noneOf(DiagnosticFlag.class), source, pos, key, args);
        }

        public JCDiagnostic mandatoryNote(DiagnosticSource source, String key, Object ... args) {
            return this.create(DiagnosticType.NOTE, null, EnumSet.of(DiagnosticFlag.MANDATORY), source, null, key, args);
        }

        public JCDiagnostic note(String key, Object ... args) {
            return this.create(DiagnosticType.NOTE, null, EnumSet.noneOf(DiagnosticFlag.class), null, null, key, args);
        }

        public JCDiagnostic note(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.create(DiagnosticType.NOTE, null, EnumSet.noneOf(DiagnosticFlag.class), source, pos, key, args);
        }

        public JCDiagnostic fragment(String key, Object ... args) {
            return this.create(DiagnosticType.FRAGMENT, null, EnumSet.noneOf(DiagnosticFlag.class), null, null, key, args);
        }

        public JCDiagnostic create(DiagnosticType kind, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.create(kind, null, EnumSet.noneOf(DiagnosticFlag.class), source, pos, key, args);
        }

        public JCDiagnostic create(DiagnosticType kind, Lint.LintCategory lc, Set<DiagnosticFlag> flags, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return new JCDiagnostic(this.formatter, kind, lc, flags, source, pos, this.qualify(kind, key), args);
        }

        protected String qualify(DiagnosticType t, String key) {
            return this.prefix + "." + t.key + "." + key;
        }
    }
}

