/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.collector.procfs.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.impl.DLightTargetAccessor;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.collector.procfs.ProcFSDCConfiguration;
import org.netbeans.modules.dlight.collector.procfs.impl.ProcFSDCConfigurationAccessor;
import org.netbeans.modules.dlight.collector.procfs.impl.ProcFSDataCollectorValidator;
import org.netbeans.modules.dlight.msa.support.MSASQLTables;
import org.netbeans.modules.dlight.procfs.api.LWPUsage;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.api.PUsage;
import org.netbeans.modules.dlight.procfs.api.SamplingData;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReader;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReaderFactory;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListener;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListenersSupport;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.spi.support.SQLDataStorage;
import org.netbeans.modules.dlight.util.Computable;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.TasksCachedProcessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Exceptions;

public class ProcFSDataCollector
extends IndicatorDataProvider<ProcFSDCConfiguration>
implements DataCollector<ProcFSDCConfiguration> {
    private static final Logger log = DLightLogger.getLogger(ProcFSDataCollector.class);
    private TasksCachedProcessor<DLightTarget, ValidationStatus> validator = new TasksCachedProcessor((Computable)new ProcFSDataCollectorValidator(), false);
    private DLightExecutorService.DLightScheduledTask mainLoop = null;
    private final boolean msaEnabled;
    private final boolean prstatEnabled;
    private SQLDataStorage sqlStorage;
    private PreparedStatement insertMSAStatement = null;
    private final List<DataTableMetadata> metadata;
    private final DataCollectorListenersSupport dclsupport = new DataCollectorListenersSupport((DataCollector)this);

    public ProcFSDataCollector(ProcFSDCConfiguration configuration) {
        super("ProcFSReader");
        ProcFSDCConfigurationAccessor access = ProcFSDCConfigurationAccessor.getDefault();
        this.msaEnabled = access.msaSampling(configuration) > 0;
        this.prstatEnabled = access.procInfoSampling(configuration) > 0;
        ArrayList<DataTableMetadata> tables = new ArrayList<DataTableMetadata>();
        if (this.prstatEnabled) {
            tables.add(MSASQLTables.prstat.tableMetadata);
        }
        if (this.msaEnabled) {
            tables.add(MSASQLTables.msa.tableMetadata);
            tables.add(MSASQLTables.lwps.tableMetadata);
        }
        this.metadata = Collections.unmodifiableList(tables);
    }

    public final void addDataCollectorListener(DataCollectorListener listener) {
        this.dclsupport.addListener(listener);
    }

    public final void removeDataCollectorListener(DataCollectorListener listener) {
        this.dclsupport.removeListener(listener);
    }

    protected final void notifyListeners(DataCollector.CollectorState state) {
        this.dclsupport.notifyListeners(state);
    }

    protected ValidationStatus doValidation(DLightTarget target) {
        ValidationStatus result = ValidationStatus.initialStatus();
        try {
            result = (ValidationStatus)this.validator.compute((Object)target);
        }
        catch (InterruptedException ex) {
            result = ValidationStatus.invalidStatus((String)ex.getMessage());
        }
        return result;
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        DataStorageTypeFactory dstf = DataStorageTypeFactory.getInstance();
        return Arrays.asList(dstf.getDataStorageType("db:sql"));
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        return this.metadata;
    }

    public void init(Map<DataStorageType, DataStorage> storages, DLightTarget target) {
        for (DataStorage ds : storages.values()) {
            SQLDataStorage storage;
            if (!(ds instanceof SQLDataStorage) || !this.prepareStatements(storage = (SQLDataStorage)ds)) continue;
            this.sqlStorage = storage;
            break;
        }
    }

    public boolean isAttachable() {
        return true;
    }

    public String getCmd() {
        throw new UnsupportedOperationException("Not supported operation.");
    }

    public String[] getArgs() {
        throw new UnsupportedOperationException("Not supported operation.");
    }

    protected synchronized void targetStarted(DLightTarget target) {
        if (!this.prstatEnabled && !this.msaEnabled) {
            return;
        }
        int pid = ((AttachableTarget)target).getPID();
        ProcReader reader = ProcReaderFactory.getReader((ExecutionEnvironment)target.getExecEnv(), (int)pid);
        DLightTargetAccessor targetAccess = DLightTargetAccessor.getDefault();
        DLightTarget.Info targetInfo = targetAccess.getDLightTargetInfo(target);
        String attachTimeString = (String)targetInfo.getInfo().get("AttachTimeNano");
        long attachTime = 0L;
        if (attachTimeString != null) {
            try {
                attachTime = Long.parseLong(attachTimeString);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.mainLoop = DLightExecutorService.scheduleAtFixedRate((Runnable)new FetchAndUpdateTask(reader, attachTime), (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"ProcFSDataCollector data fetching loop");
    }

    protected synchronized void targetFinished(DLightTarget target) {
        if (this.mainLoop != null) {
            this.mainLoop.cancel();
            this.mainLoop = null;
            try {
                if (this.insertMSAStatement != null) {
                    this.insertMSAStatement.close();
                    this.insertMSAStatement = null;
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private boolean prepareStatements(SQLDataStorage storage) {
        boolean result = false;
        try {
            this.insertMSAStatement = storage.prepareStatement(String.format("insert into %s (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", MSASQLTables.msa.tableMetadata.getName(), MSASQLTables.msa.TIMESTAMP.getColumnName(), MSASQLTables.msa.SAMPLE.getColumnName(), MSASQLTables.msa.LWP_ID.getColumnName(), MSASQLTables.msa.LWP_MSA_USR.getColumnName(), MSASQLTables.msa.LWP_MSA_SYS.getColumnName(), MSASQLTables.msa.LWP_MSA_TRP.getColumnName(), MSASQLTables.msa.LWP_MSA_TFL.getColumnName(), MSASQLTables.msa.LWP_MSA_DFL.getColumnName(), MSASQLTables.msa.LWP_MSA_KFL.getColumnName(), MSASQLTables.msa.LWP_MSA_LCK.getColumnName(), MSASQLTables.msa.LWP_MSA_SLP.getColumnName(), MSASQLTables.msa.LWP_MSA_LAT.getColumnName(), MSASQLTables.msa.LWP_MSA_STP.getColumnName()));
            result = true;
        }
        catch (SQLException ex) {
            log.warning(String.format("Exception while preparing insert statement (%s)", ex.getMessage()));
        }
        return result;
    }

    private class FetchAndUpdateTask
    implements Runnable {
        private final ProcReader reader;
        private final LWPsTracker lwpsTracker = new LWPsTracker();
        private final AtomicLong processStartTime = new AtomicLong(0L);
        private final long attachTimeNano;

        public FetchAndUpdateTask(ProcReader reader, long attachTimeNano) {
            this.reader = reader;
            this.attachTimeNano = attachTimeNano;
        }

        private long toNanoOffset(long timenano) {
            return timenano - (this.attachTimeNano > 0L ? this.attachTimeNano : this.processStartTime.get());
        }

        @Override
        public void run() {
            block8: {
                try {
                    List lwpUsageData;
                    if (ProcFSDataCollector.this.prstatEnabled) {
                        PStatus processStatus = this.reader.getProcessStatus();
                        PUsage processUsage = this.reader.getProcessUsage();
                        if (processStatus == null || processUsage == null) {
                            return;
                        }
                        this.processStartTime.compareAndSet(0L, processUsage.getUsageInfo().pr_create);
                        PStatus.ThreadsInfo tinfo = processStatus.getThreadInfo();
                        SamplingData p_samplingInfo = processUsage.getSamplingData();
                        PUsage.MSAInfo p_msaInfo = processUsage.getMSAInfo();
                        float normCoef = (float)tinfo.pr_nlwp / (float)p_msaInfo.sum_states;
                        ProcFSDataCollector.this.notifyIndicators(Arrays.asList(new DataRow(MSASQLTables.prstat.tableMetadata.getColumnNames(), Arrays.asList(this.toNanoOffset(p_samplingInfo.timestamp), p_samplingInfo.sample, tinfo.pr_nlwp, tinfo.pr_nzomb, Float.valueOf(normCoef * (float)(p_msaInfo.pr_utime + p_msaInfo.pr_stime + p_msaInfo.pr_ttime)), Float.valueOf(normCoef * (float)p_msaInfo.pr_ltime), Float.valueOf(normCoef * (float)(p_msaInfo.pr_tftime + p_msaInfo.pr_dftime + p_msaInfo.pr_kftime + p_msaInfo.pr_wtime + p_msaInfo.pr_stoptime)), Float.valueOf(normCoef * (float)p_msaInfo.pr_slptime)))));
                    }
                    if (ProcFSDataCollector.this.sqlStorage != null && ProcFSDataCollector.this.msaEnabled && (lwpUsageData = this.reader.getThreadsInfo()) != null) {
                        for (LWPUsage lwpUsage : lwpUsageData) {
                            try {
                                SamplingData lwp_samplingInfo = lwpUsage.getSamplingData();
                                PUsage.UsageInfo lwp_usageInfo = lwpUsage.getUsageInfo();
                                PUsage.MSAInfo lwp_msaInfo = lwpUsage.getMSAInfo();
                                this.lwpsTracker.update(lwpUsage);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(1, this.toNanoOffset(lwp_samplingInfo.timestamp));
                                ProcFSDataCollector.this.insertMSAStatement.setLong(2, lwp_samplingInfo.sample);
                                ProcFSDataCollector.this.insertMSAStatement.setInt(3, lwp_usageInfo.pr_lwpid);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(4, lwp_msaInfo.pr_utime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(5, lwp_msaInfo.pr_stime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(6, lwp_msaInfo.pr_ttime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(7, lwp_msaInfo.pr_tftime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(8, lwp_msaInfo.pr_dftime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(9, lwp_msaInfo.pr_kftime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(10, lwp_msaInfo.pr_ltime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(11, lwp_msaInfo.pr_slptime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(12, lwp_msaInfo.pr_wtime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(13, lwp_msaInfo.pr_stoptime);
                                ProcFSDataCollector.this.insertMSAStatement.executeUpdate();
                            }
                            catch (SQLException ex) {
                                if (!log.isLoggable(Level.FINE)) continue;
                                log.log(Level.FINE, "SQL exception", ex);
                            }
                        }
                        this.lwpsTracker.endOfUpdate();
                    }
                }
                catch (Throwable th) {
                    if (!log.isLoggable(Level.FINE)) break block8;
                    log.log(Level.FINE, "Unhandled exception!", th);
                }
            }
        }

        private final class LWPsTracker {
            private final Object lock;
            private final HashMap<Integer, LWPUsage> lastReportedLWPs;
            private final HashMap<Integer, LWPUsage> newReportedLWPs;
            private PreparedStatement insertStatement;
            private PreparedStatement updateStatement;

            public LWPsTracker() {
                block2: {
                    this.lock = LWPsTracker.class.getName() + "_lock";
                    this.lastReportedLWPs = new HashMap();
                    this.newReportedLWPs = new HashMap();
                    this.insertStatement = null;
                    this.updateStatement = null;
                    try {
                        this.insertStatement = ProcFSDataCollector.this.sqlStorage.prepareStatement(String.format("insert into %s (%s, %s, %s) values (?, ?, null)", MSASQLTables.lwps.tableMetadata.getName(), MSASQLTables.lwps.LWP_ID.getColumnName(), MSASQLTables.lwps.LWP_START.getColumnName(), MSASQLTables.lwps.LWP_END.getColumnName()));
                        this.updateStatement = ProcFSDataCollector.this.sqlStorage.prepareStatement(String.format("update %s set %s = ? where %s = ?", MSASQLTables.lwps.tableMetadata.getName(), MSASQLTables.lwps.LWP_END.getColumnName(), MSASQLTables.lwps.LWP_ID.getColumnName()));
                    }
                    catch (Throwable th) {
                        if (!log.isLoggable(Level.FINE)) break block2;
                        log.log(Level.FINE, "will not provide data...", th);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void update(LWPUsage lwp_usageInfo) {
                block8: {
                    if (this.insertStatement == null || this.updateStatement == null) {
                        return;
                    }
                    boolean thread_started = false;
                    int id = lwp_usageInfo.getUsageInfo().pr_lwpid;
                    Object object = this.lock;
                    synchronized (object) {
                        this.newReportedLWPs.put(id, lwp_usageInfo);
                        if (!this.lastReportedLWPs.containsKey(id)) {
                            thread_started = true;
                        }
                    }
                    if (thread_started) {
                        try {
                            this.insertStatement.setInt(1, id);
                            this.insertStatement.setLong(2, FetchAndUpdateTask.this.toNanoOffset(FetchAndUpdateTask.this.attachTimeNano > 0L ? FetchAndUpdateTask.this.attachTimeNano : lwp_usageInfo.getUsageInfo().pr_create));
                            this.insertStatement.executeUpdate();
                        }
                        catch (SQLException ex) {
                            if (!log.isLoggable(Level.FINE)) break block8;
                            log.log(Level.FINE, "", ex);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void endOfUpdate() {
                HashSet<LWPUsage> deadThreads = new HashSet<LWPUsage>();
                Object object = this.lock;
                synchronized (object) {
                    for (Integer id : this.lastReportedLWPs.keySet()) {
                        if (this.newReportedLWPs.containsKey(id)) continue;
                        deadThreads.add(this.lastReportedLWPs.get(id));
                    }
                    this.lastReportedLWPs.clear();
                    this.lastReportedLWPs.putAll(this.newReportedLWPs);
                    this.newReportedLWPs.clear();
                }
                for (LWPUsage deadThreadUsage : deadThreads) {
                    try {
                        this.updateStatement.setLong(1, FetchAndUpdateTask.this.toNanoOffset(deadThreadUsage.getSamplingData().timestamp));
                        this.updateStatement.setInt(2, deadThreadUsage.getUsageInfo().pr_lwpid);
                        this.updateStatement.executeUpdate();
                    }
                    catch (SQLException ex) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, "", ex);
                    }
                }
            }
        }
    }
}

