/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.MethodMarker;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.utils.formatting.Formattable;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.profiler.AbstractProjectTypeProfiler;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.j2ee.LoadGenPanel;
import org.netbeans.modules.profiler.j2ee.ServletUriPanel;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.w3c.dom.Document;

public final class J2EEProjectTypeProfiler
extends AbstractProjectTypeProfiler {
    private static final String PROFILING_NOT_SUPPORTED_MSG = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_ProfilingNotSupportedMsg");
    private static final String SKIP_BUTTON_NAME = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_SkipButtonName");
    private static final String NO_SERVER_FOUND_MSG = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_NoServerFoundMsg");
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler.j2ee");
    private static int lastAgentID = -1;
    private static int lastAgentPort = 5140;
    private SelectProfilingTask.SettingsConfigurator configurator;
    private LoadGenPanel loadGenConfig = null;
    private String loadGenPath = null;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("org.netbeans.modules.profiler.j2ee.LoadGenPanel#path")) {
                J2EEProjectTypeProfiler.this.loadGenPath = (String)evt.getNewValue();
            }
        }
    };

    public static int getLastAgentID() {
        return lastAgentID;
    }

    public static int getLastAgentPort() {
        return lastAgentPort;
    }

    public static String getServerInstanceID(Project project) {
        J2eeModuleProvider serverInstanceModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (serverInstanceModuleProvider == null) {
            return null;
        }
        return serverInstanceModuleProvider.getServerInstanceID();
    }

    public String getProfilerTargetName(Project project, FileObject buildScript, int type, FileObject profiledClass) {
        switch (type) {
            case 1: {
                return "profile";
            }
            case 3: {
                return null;
            }
            case 4: {
                return "profile-test-single";
            }
        }
        return null;
    }

    public boolean isProfilingSupported(Project project) {
        return true;
    }

    public JavaPlatform getProjectJavaPlatform(Project project) {
        String serverInstanceID = J2EEProjectTypeProfiler.getServerInstanceID(project);
        if (serverInstanceID == null) {
            return null;
        }
        return J2EEProjectTypeProfiler.getServerJavaPlatform(serverInstanceID);
    }

    public static JavaPlatform getServerJavaPlatform(String serverInstanceID) {
        J2eePlatform j2eePlatform = J2EEProjectTypeProfiler.getJ2eePlatform(serverInstanceID);
        if (j2eePlatform == null) {
            return null;
        }
        return j2eePlatform.getJavaPlatform();
    }

    public JComponent getAdditionalConfigurationComponent(Project project) {
        if (this.loadGenConfig == null) {
            this.loadGenConfig = new LoadGenPanel();
            this.loadGenConfig.addPropertyChangeListener("org.netbeans.modules.profiler.j2ee.LoadGenPanel#path", WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)this.loadGenConfig));
        }
        this.loadGenConfig.attach(project);
        return this.loadGenConfig;
    }

    public SelectProfilingTask.SettingsConfigurator getSettingsConfigurator() {
        if (this.configurator == null) {
            this.configurator = new DefaultSettingsConfigurator(){

                public LoadGenPanel getCustomSettingsPanel() {
                    if (this.isAttach() || this.isModify()) {
                        return null;
                    }
                    if (J2EEProjectTypeProfiler.this.loadGenConfig == null) {
                        J2EEProjectTypeProfiler.this.loadGenConfig = new LoadGenPanel();
                        J2EEProjectTypeProfiler.this.loadGenConfig.addPropertyChangeListener("org.netbeans.modules.profiler.j2ee.LoadGenPanel#path", WeakListeners.propertyChange((PropertyChangeListener)J2EEProjectTypeProfiler.this.pcl, (Object)J2EEProjectTypeProfiler.this.loadGenConfig));
                    }
                    J2EEProjectTypeProfiler.this.loadGenConfig.attach(this.getProject());
                    return J2EEProjectTypeProfiler.this.loadGenConfig;
                }

                public void loadCustomSettings(Properties properties) {
                    if (J2EEProjectTypeProfiler.this.loadGenConfig != null) {
                        J2EEProjectTypeProfiler.this.loadGenConfig.loadCustomSettings(properties);
                    }
                }

                public void storeCustomSettings(Properties properties) {
                    if (J2EEProjectTypeProfiler.this.loadGenConfig != null) {
                        J2EEProjectTypeProfiler.this.loadGenConfig.storeCustomSettings(properties);
                    }
                }
            };
        }
        return this.configurator;
    }

    public boolean checkProjectCanBeProfiled(Project project, FileObject profiledClassFile) {
        if (!this.isProfilingSupported(project)) {
            return false;
        }
        J2eePlatform j2eePlatform = J2EEProjectTypeProfiler.getJ2eePlatform(project);
        if (j2eePlatform == null) {
            NetBeansProfiler.getDefaultNB().displayError(NO_SERVER_FOUND_MSG);
            return false;
        }
        if (!j2eePlatform.supportsProfiling()) {
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PROFILING_NOT_SUPPORTED_MSG, 2));
            return false;
        }
        if (profiledClassFile == null) {
            return true;
        }
        return this.isFileObjectSupported(project, profiledClassFile);
    }

    public void configurePropertiesForProfiling(Properties props, Project project, FileObject profiledClassFile) {
        J2EEProjectTypeProfiler.initAntPlatform(project, props);
        props.setProperty("profiler.j2ee.serverForceRestart", "true");
        props.setProperty("profiler.j2ee.serverStartupTimeout", "300000");
        props.setProperty("profiler.j2ee.agentID", "-Dnbprofiler.agentid=" + new Integer(J2EEProjectTypeProfiler.generateAgentID()).toString());
        String jvmArgs = props.getProperty("profiler.info.jvmargs");
        if (jvmArgs != null && jvmArgs.trim().length() > 0) {
            props.setProperty("profiler.info.jvmargs.extra", jvmArgs);
        }
        JavaPlatform javaPlatform = J2EEProjectTypeProfiler.getJavaPlatformFromAntName(project, props);
        props.setProperty("profiler.info.javaPlatform", (String)javaPlatform.getProperties().get("platform.ant.name"));
        String javaVersion = IDEUtils.getPlatformJDKVersion((JavaPlatform)javaPlatform);
        String localPlatform = IntegrationUtils.getLocalPlatform((int)IDEUtils.getPlatformArchitecture((JavaPlatform)javaPlatform));
        if (javaVersion.equals("jdk15")) {
            props.setProperty("profiler.info.jvmargs.agent", IntegrationUtils.getProfilerAgentCommandLineArgs((String)localPlatform, (String)IntegrationUtils.PLATFORM_JAVA_50, (boolean)false, (int)ProfilerIDESettings.getInstance().getPortNo()));
        } else {
            props.setProperty("profiler.info.jvmargs.agent", IntegrationUtils.getProfilerAgentCommandLineArgs((String)localPlatform, (String)IntegrationUtils.PLATFORM_JAVA_60, (boolean)false, (int)ProfilerIDESettings.getInstance().getPortNo()));
        }
        J2EEProjectTypeProfiler.generateAgentPort();
        if (this.loadGenPath != null) {
            props.setProperty("profiler.loadgen.path", this.loadGenPath);
        }
        if (profiledClassFile == null) {
            return;
        }
        if (WebProjectUtils.isJSP(profiledClassFile)) {
            props.put("client.urlPart", WebProjectUtils.getJSPFileContext(project, profiledClassFile, false));
        } else if (WebProjectUtils.isHttpServlet(profiledClassFile)) {
            String servletAddress = null;
            Collection<Document> ddos = WebProjectUtils.getDeploymentDescriptorDocuments(project, true);
            for (Document dd : ddos) {
                String mapping = WebProjectUtils.getServletMapping(profiledClassFile, dd);
                if (mapping == null || mapping.length() <= 0) continue;
                servletAddress = mapping;
                break;
            }
            if (servletAddress != null) {
                ServletUriPanel uriPanel = new ServletUriPanel(servletAddress);
                DialogDescriptor desc = new DialogDescriptor((Object)uriPanel, NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"TTL_setServletExecutionUri"), true, new Object[]{DialogDescriptor.OK_OPTION, new JButton(SKIP_BUTTON_NAME){

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width + 16, super.getPreferredSize().height);
                    }
                }}, DialogDescriptor.OK_OPTION, 0, null, null);
                Object res = ProfilerDialogs.notify((NotifyDescriptor)desc);
                if (res.equals(NotifyDescriptor.YES_OPTION)) {
                    servletAddress = uriPanel.getServletUri();
                }
                props.put("client.urlPart", servletAddress);
            }
        }
        String profiledClass = SourceUtils.getToplevelClassName((FileObject)profiledClassFile);
        props.setProperty("profile.class", profiledClass);
        String clazz = FileUtil.getRelativePath((FileObject)ProjectUtilities.getRootOf((FileObject[])ProjectUtilities.getSourceRoots((Project)project), (FileObject)profiledClassFile), (FileObject)profiledClassFile);
        props.setProperty("javac.includes", clazz);
    }

    public static int generateAgentID() {
        int newAgentID = J2EEProjectTypeProfiler.generateAgentNumber();
        while (newAgentID == lastAgentID) {
            newAgentID = J2EEProjectTypeProfiler.generateAgentNumber();
        }
        lastAgentID = newAgentID;
        return J2EEProjectTypeProfiler.getLastAgentID();
    }

    public static JavaPlatform generateAgentJavaPlatform(String serverInstanceID) {
        JavaPlatform platform = IDEUtils.getJavaPlatformByName((String)ProfilerIDESettings.getInstance().getJavaPlatformForProfiling());
        JavaPlatform projectPlatform = J2EEProjectTypeProfiler.getServerJavaPlatform(serverInstanceID);
        if (!(platform != null || (platform = projectPlatform) != null && MiscUtils.isSupportedJVM((Map)platform.getSystemProperties()) || (platform = JavaPlatformSelector.getDefault().selectPlatformToUse()) != null)) {
            return null;
        }
        return platform;
    }

    public static int generateAgentPort() {
        lastAgentPort = ProfilerIDESettings.getInstance().getPortNo();
        return J2EEProjectTypeProfiler.getLastAgentPort();
    }

    public void setupProjectSessionSettings(Project project, SessionSettings ss) {
        PropertyEvaluator pp = this.getProjectProperties(project);
        ss.setMainClass("");
        String appArgs = pp.getProperty("application.args");
        ss.setMainArgs(appArgs != null ? appArgs : "");
        String runCP = pp.getProperty("build.classes.dir");
        ss.setMainClassPath(runCP != null ? MiscUtils.getAbsoluteFilePath((String)runCP, (String)FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath()) : "");
        ss.setJVMArgs("");
        ss.setWorkingDir("");
    }

    public boolean supportsSettingsOverride() {
        return true;
    }

    public boolean supportsUnintegrate(Project project) {
        return true;
    }

    public void unintegrateProfiler(Project project) {
        ProjectUtilities.unintegrateProfiler((Project)project);
    }

    private static J2eePlatform getJ2eePlatform(Project project) {
        String serverInstanceID = J2EEProjectTypeProfiler.getServerInstanceID(project);
        if (serverInstanceID == null) {
            return null;
        }
        return J2EEProjectTypeProfiler.getJ2eePlatform(serverInstanceID);
    }

    private static J2eePlatform getJ2eePlatform(String serverInstanceID) {
        return Deployment.getDefault().getJ2eePlatform(serverInstanceID);
    }

    private static JavaPlatform getJavaPlatformFromAntName(Project project, Properties props) {
        String javaPlatformAntName = props.getProperty("profiler.info.javaPlatform");
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        if (javaPlatformAntName.equals("default_platform")) {
            return jpm.getDefaultPlatform();
        }
        JavaPlatform[] platforms = jpm.getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < platforms.length; ++i) {
            JavaPlatform platform = platforms[i];
            String antName = (String)platform.getProperties().get("platform.ant.name");
            if (!antName.equals(javaPlatformAntName)) continue;
            return platform;
        }
        return null;
    }

    private static int generateAgentNumber() {
        return (int)(Math.random() * 2.147483648E9);
    }

    private static void initAntPlatform(Project project, Properties props) {
        String javaPlatformAntName = props.getProperty("profiler.info.javaPlatform");
        if (javaPlatformAntName == null) {
            JavaPlatform platform = null;
            J2eePlatform j2eepf = J2EEProjectTypeProfiler.getJ2eePlatform(project);
            platform = j2eepf == null ? JavaPlatformManager.getDefault().getDefaultPlatform() : j2eepf.getJavaPlatform();
            props.setProperty("profiler.info.javaPlatform", (String)platform.getProperties().get("platform.ant.name"));
        }
    }

    private PropertyEvaluator getProjectProperties(Project project) {
        final Properties privateProps = new Properties();
        final Properties projectProps = new Properties();
        final Properties userPropsProps = new Properties();
        final FileObject privatePropsFile = project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        final FileObject projectPropsFile = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final File userPropsFile = InstalledFileLocator.getDefault().locate("build.properties", null, false);
        ProjectManager.mutex().readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream is;
                if (privatePropsFile != null) {
                    try {
                        is = privatePropsFile.getInputStream();
                        try {
                            privateProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
                if (projectPropsFile != null) {
                    try {
                        is = projectPropsFile.getInputStream();
                        try {
                            projectProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
                if (userPropsFile != null) {
                    try {
                        is = new BufferedInputStream(new FileInputStream(userPropsFile));
                        try {
                            userPropsProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
            }
        });
        PropertyEvaluator pe = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{new MyPropertyProvider(privateProps), new MyPropertyProvider(userPropsProps), new MyPropertyProvider(projectProps)});
        return pe;
    }

    private void addJspMarker(MethodMarker marker, Mark mark, Project project) {
        ClientUtils.SourceCodeSelection[] jspmethods = WebProjectUtils.getJSPRootMethods(project, true);
        if (jspmethods != null) {
            for (int i = 0; i < jspmethods.length; ++i) {
                marker.addMethodMark(jspmethods[i].getClassName(), jspmethods[i].getMethodName(), jspmethods[i].getMethodSignature(), mark);
            }
        }
    }

    private static class MyPropertyProvider
    implements PropertyProvider {
        private Properties props;

        private MyPropertyProvider(Properties props) {
            this.props = props;
        }

        public Map getProperties() {
            return this.props;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }

    private static class JSPNameFormatter
    implements MethodNameFormatter {
        private JSPNameFormatter() {
        }

        public Formattable formatMethodName(final ClientUtils.SourceCodeSelection sourceCodeSelection) {
            return new Formattable(){

                public String toFormatted() {
                    String name = WebProjectUtils.getJSPPath(sourceCodeSelection);
                    return name;
                }
            };
        }

        public Formattable formatMethodName(final String className, final String methodName, final String signature) {
            return new Formattable(){

                public String toFormatted() {
                    ClientUtils.SourceCodeSelection tmpSelection = new ClientUtils.SourceCodeSelection(className, methodName, signature);
                    String name = WebProjectUtils.getJSPPath(tmpSelection);
                    return name;
                }
            };
        }
    }
}

