/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.selector.nodes.web.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.j2ee.selector.nodes.web.filter.FilterNode;
import org.netbeans.modules.profiler.j2ee.ui.Utils;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.GreedySelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class FiltersNode
extends ContainerNode {
    private static final String FILTERS_STRING = NbBundle.getMessage(FiltersNode.class, (String)"FiltersNode_FiltersString");

    public FiltersNode(ContainerNode parent) {
        super(FILTERS_STRING, (Icon)Utils.PACKAGE_ICON, parent);
    }

    protected SelectorChildren getChildren() {
        return new Children();
    }

    private static class Children
    extends GreedySelectorChildren<FiltersNode> {
        private final Set<ClassIndex.SearchScope> scope = new HashSet<ClassIndex.SearchScope>();

        public Children() {
            this.scope.add(ClassIndex.SearchScope.SOURCE);
            this.scope.add(ClassIndex.SearchScope.DEPENDENCIES);
        }

        protected List<SelectorNode> prepareChildren(FiltersNode parent) {
            HashSet<SelectorNode> filters = new HashSet<SelectorNode>();
            try {
                Project project = (Project)parent.getLookup().lookup(Project.class);
                ClasspathInfo cpInfo = ProjectUtilities.getClasspathInfo((Project)project);
                Collection<FileObject> dds = WebProjectUtils.getDeploymentDescriptorFileObjects(project, true);
                for (FileObject dd : dds) {
                    this.enumerateFilters(parent, cpInfo, filters, dd);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return new ArrayList<SelectorNode>(filters);
        }

        private void enumerateFilters(final FiltersNode parent, final ClasspathInfo cpInfo, final Collection<SelectorNode> filters, FileObject dd) throws IOException, IllegalArgumentException {
            final WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
            final HashMap<String, String> filter2class = new HashMap<String, String>();
            for (Filter filter : webApp.getFilter()) {
                filter2class.put(filter.getFilterName(), filter.getFilterClass());
            }
            JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    for (FilterMapping mapping : webApp.getFilterMapping()) {
                        TypeElement type;
                        String clazz = (String)filter2class.get(mapping.getFilterName());
                        TypeElement typeElement = type = clazz != null ? controller.getElements().getTypeElement(clazz) : null;
                        if (type == null) continue;
                        String urlMapping = mapping.getUrlPattern();
                        if (urlMapping == null) {
                            String servletName = mapping.getServletName();
                            for (ServletMapping servletMapping : webApp.getServletMapping()) {
                                if (!servletName.equals(servletMapping.getServletName())) continue;
                                urlMapping = servletMapping.getUrlPattern();
                                break;
                            }
                        }
                        if (urlMapping == null) continue;
                        filters.add(new FilterNode(cpInfo, type, mapping.getFilterName(), urlMapping, parent));
                    }
                }
            }, true);
        }
    }
}

