/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.io.IOException;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.netbeans.junit.NbModuleSuite;
import org.netbeans.junit.NbTestCase;
import org.openide.util.NbBundle;

public abstract class TestBundleKeys
extends NbTestCase {
    private static Properties props = new Properties();

    protected abstract String getPropertiesName();

    protected abstract ClassLoader getDescendantClassLoader();

    public TestBundleKeys(String isBundleName) {
        super(isBundleName);
    }

    protected static Properties getProperties(ClassLoader irClassLoader, String isPropertiesName) throws IOException {
        if (props.isEmpty()) {
            props.load(irClassLoader.getResourceAsStream(isPropertiesName));
        }
        return props;
    }

    protected void runTest() throws Throwable {
        String keys = TestBundleKeys.getProperties(this.getDescendantClassLoader(), this.getPropertiesName()).getProperty(this.getName());
        ResourceBundle lrBundle = NbBundle.getBundle((String)this.getName());
        String[] lrTokens = keys.split(",");
        int lnNumMissing = 0;
        StringBuffer lrBufMissing = new StringBuffer();
        for (String lsKey : lrTokens) {
            try {
                lrBundle.getObject(lsKey);
            }
            catch (MissingResourceException mre) {
                lrBufMissing.append(lsKey).append(" ");
                ++lnNumMissing;
            }
        }
        if (lnNumMissing > 0) {
            throw new AssertionFailedError("Missing " + String.valueOf(lnNumMissing) + " key(s): " + lrBufMissing.toString());
        }
    }

    protected static Test prepareSuite(Class irClass, String isPropertiesName) {
        NbModuleSuite.Configuration lrConf = NbModuleSuite.createConfiguration((Class)irClass);
        try {
            Set<Object> bundles = TestBundleKeys.getProperties(irClass.getClassLoader(), isPropertiesName).keySet();
            for (Object bundle : bundles) {
                lrConf = lrConf.addTest(new String[]{(String)bundle});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return NbModuleSuite.create((NbModuleSuite.Configuration)lrConf.clusters(".*").enableModules(".*"));
    }
}

