/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.EventQueue;
import java.io.File;
import java.util.HashSet;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class WorkingCopyAttributesCache {
    private static WorkingCopyAttributesCache instance;
    private final HashSet<String> unsupportedWorkingCopies = new HashSet(5);
    private final HashSet<String> tooOldClientForWorkingCopies = new HashSet(5);
    private final HashSet<String> tooOldWorkingCopies = new HashSet(5);

    public static WorkingCopyAttributesCache getInstance() {
        if (instance == null) {
            instance = new WorkingCopyAttributesCache();
            instance.init();
        }
        return instance;
    }

    private WorkingCopyAttributesCache() {
    }

    private void init() {
    }

    public void logSuppressed(SVNClientException ex, File file) throws SVNClientException {
        if (SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) {
            this.logUnsupportedWC(ex, file);
        } else if (SvnClientExceptionHandler.isPartOf17OrGreater(ex.getMessage())) {
            this.logTooOldClient(ex, file);
        } else if (SvnClientExceptionHandler.isTooOldWorkingCopy(ex.getMessage())) {
            this.logTooOldWC(ex, file);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public boolean isSuppressed(SVNClientException ex) {
        boolean retval = false;
        if (SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) {
            retval = true;
        } else if (SvnClientExceptionHandler.isPartOf17OrGreater(ex.getMessage())) {
            retval = true;
        } else if (SvnClientExceptionHandler.isTooOldWorkingCopy(ex.getMessage())) {
            retval = true;
        }
        return retval;
    }

    private void logUnsupportedWC(SVNClientException ex, File file) throws SVNClientException {
        this.logWC(ex, file, this.unsupportedWorkingCopies);
    }

    private void logTooOldClient(SVNClientException ex, File file) throws SVNClientException {
        this.logWC(ex, file, this.tooOldClientForWorkingCopies);
    }

    private void logTooOldWC(SVNClientException ex, File file) throws SVNClientException {
        this.logWC(ex, file, this.tooOldWorkingCopies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLogged(String fileName, HashSet<String> loggedWCs) {
        HashSet<String> hashSet = loggedWCs;
        synchronized (hashSet) {
            for (String unsupported : loggedWCs) {
                if (!fileName.startsWith(unsupported)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logWC(final SVNClientException ex, File file, HashSet<String> loggedWCs) throws SVNClientException {
        String fileName = file.getAbsolutePath();
        if (!this.isLogged(fileName, loggedWCs)) {
            File topManaged = Subversion.getInstance().getTopmostManagedAncestor(file);
            HashSet<String> hashSet = loggedWCs;
            synchronized (hashSet) {
                loggedWCs.add(topManaged.getAbsolutePath());
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                }
            });
        }
        throw ex;
    }
}

