/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.awt.Dialog;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import javax.swing.JButton;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.AcceptCertificatePanel;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.kenai.SvnKenaiAccessor;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class SvnClientCallback
implements ISVNPromptUserPassword {
    private final SVNUrl url;
    private final int handledExceptions;
    private String username = null;
    private char[] password = null;
    private String certFilePath;
    private char[] certPassword;
    private int sshPort = 22;

    public SvnClientCallback(SVNUrl url, int handledExceptions) {
        this.url = url;
        this.handledExceptions = handledExceptions;
    }

    public String getUsername() {
        this.getAuthData();
        return this.username;
    }

    public String getPassword() {
        this.getAuthData();
        String retval = "";
        if (this.password != null) {
            retval = new String(this.password);
        }
        return retval;
    }

    public int askTrustSSLServer(String certMessage, boolean allowPermanently) {
        if ((8 & this.handledExceptions) != 8) {
            return -1;
        }
        AcceptCertificatePanel acceptCertificatePanel = new AcceptCertificatePanel();
        acceptCertificatePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Error_CertFailed"));
        acceptCertificatePanel.certificatePane.setText(certMessage);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)acceptCertificatePanel, NbBundle.getMessage(SvnClientCallback.class, (String)"CTL_Error_CertFailed"));
        JButton permanentlyButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptPermanently"));
        JButton temporarilyButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_AcceptTemp"));
        JButton rejectButton = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Cert_Reject"));
        dialogDescriptor.setOptions(new Object[]{permanentlyButton, temporarilyButton, rejectButton});
        dialogDescriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.subversion.serverCertificateVerification"));
        this.showDialog(dialogDescriptor);
        if (dialogDescriptor.getValue() == permanentlyButton) {
            return 2;
        }
        if (dialogDescriptor.getValue() == temporarilyButton) {
            return 1;
        }
        return 0;
    }

    public boolean userAllowedSave() {
        return false;
    }

    public String getSSHPrivateKeyPath() {
        this.getAuthData();
        return this.certFilePath;
    }

    public String getSSHPrivateKeyPassphrase() {
        return this.getCertPassword();
    }

    public int getSSHPort() {
        return this.sshPort;
    }

    protected void setSSHPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public String getSSLClientCertPassword() {
        return this.getCertPassword();
    }

    public String getSSLClientCertPath() {
        this.getAuthData();
        return this.certFilePath;
    }

    private void getKenaiAuthData(SvnKenaiAccessor support) {
        String urlString = this.url.toString();
        PasswordAuthentication pa = support.getPasswordAuthentication(urlString, true);
        if (pa == null) {
            throw new RuntimeException(new InterruptedException(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_ActionCanceledByUser")));
        }
        String user = pa.getUserName();
        char[] psswd = pa.getPassword();
        this.username = user != null ? user : "";
        this.password = psswd;
    }

    private void showDialog(DialogDescriptor dialogDescriptor) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private void getAuthData() {
        SvnKenaiAccessor support = SvnKenaiAccessor.getInstance();
        if (support != null && support.isKenai(this.url.toString())) {
            this.getKenaiAuthData(support);
        } else {
            RepositoryConnection rc = SvnModuleConfig.getDefault().getRepositoryConnection(this.url.toString());
            if (rc != null) {
                this.username = rc.getUsername();
                this.password = rc.getPassword();
                this.certFilePath = rc.getCertFile();
                this.certPassword = rc.getCertPassword();
            }
        }
    }

    private String getCertPassword() {
        this.getAuthData();
        String certPwd = "";
        if (this.certPassword != null) {
            certPwd = new String(this.certPassword);
            Arrays.fill(this.certPassword, '\u0000');
        }
        return certPwd;
    }
}

