/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.client.cli.SvnCommand;

public class AddCommand
extends SvnCommand {
    private final boolean recursive;
    private final boolean force;
    private final File[] files;

    public AddCommand(File[] files, boolean recursive, boolean force) {
        this.recursive = recursive;
        this.force = force;
        this.files = files;
    }

    @Override
    protected int getCommand() {
        return 1;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("add");
        if (!this.recursive) {
            arguments.add("-N");
        }
        arguments.addFileArguments(this.files);
        this.setCommandWorkingDirectory(this.files);
    }

    @Override
    protected void config(File configDir, String username, String password, SvnCommand.Arguments arguments) {
        arguments.addConfigDir(configDir);
    }

    @Override
    public void errorText(String line) {
        if (line.startsWith("svn: warning:")) {
            return;
        }
        super.errorText(line);
    }
}

