/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class RepositoryRevision {
    private ISVNLogMessage message;
    private SVNUrl repositoryRootUrl;
    private final List<Event> events = new ArrayList<Event>(1);
    private EventDetails eventDetails;
    private List<Event> fakeRootEvent;

    public RepositoryRevision(ISVNLogMessage message, SVNUrl rootUrl) {
        this.message = message;
        this.repositoryRootUrl = rootUrl;
        this.initEvents();
    }

    public SVNUrl getRepositoryRootUrl() {
        return this.repositoryRootUrl;
    }

    public void setEventDetails(EventDetails filter) {
        this.eventDetails = filter;
    }

    private void initEvents() {
        ISVNLogMessageChangePath[] paths = this.message.getChangedPaths();
        if (paths == null) {
            return;
        }
        for (ISVNLogMessageChangePath path : paths) {
            this.events.add(new Event(path));
        }
    }

    public boolean showDetails() {
        return this.eventDetails != null ? this.eventDetails.showDetails() : true;
    }

    List<Event> getEvents() {
        return this.getEvents(false);
    }

    List<Event> getEvents(boolean forDiff) {
        if (this.showDetails()) {
            return this.events;
        }
        if (forDiff) {
            return this.getFakeRootEvent();
        }
        return Collections.emptyList();
    }

    public ISVNLogMessage getLog() {
        return this.message;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.getLog().getRevision().getNumber());
        text.append("\t");
        text.append(this.getLog().getDate());
        text.append("\t");
        text.append(this.getLog().getAuthor());
        text.append("\n");
        text.append(this.getLog().getMessage());
        return text.toString();
    }

    public void sort(Comparator<Event> comparator) {
        if (this.events == null) {
            return;
        }
        Collections.sort(this.events, comparator);
    }

    public List<Event> getFakeRootEvent() {
        if (this.fakeRootEvent == null) {
            Event e = new Event(new ISVNLogMessageChangePath(){
                private String path;

                public String getPath() {
                    if (this.path == null) {
                        try {
                            return SvnUtils.getRelativePath(RepositoryRevision.this.eventDetails.root);
                        }
                        catch (SVNClientException ex) {
                            Subversion.LOG.log(Level.WARNING, RepositoryRevision.this.eventDetails.root.getAbsolutePath(), ex);
                        }
                    }
                    return this.path;
                }

                public SVNRevision.Number getCopySrcRevision() {
                    return RepositoryRevision.this.message.getRevision();
                }

                public String getCopySrcPath() {
                    return "";
                }

                public char getAction() {
                    return '?';
                }
            }){

                @Override
                public boolean isFakeRoot() {
                    return true;
                }
            };
            e.setFile(this.eventDetails.root);
            this.fakeRootEvent = new LinkedList<Event>();
            this.fakeRootEvent.add(e);
        }
        return this.fakeRootEvent;
    }

    static abstract class EventDetails {
        private final File root;

        EventDetails(File root) {
            this.root = root;
        }

        protected abstract boolean showDetails();
    }

    public static class EventBaseNameComparator
    implements Comparator<Event> {
        @Override
        public int compare(Event e1, Event e2) {
            if (e1 == null || e2 == null || e1.getName() == null || e2.getName() == null) {
                return 0;
            }
            return e1.getName().compareTo(e2.getName());
        }
    }

    public static class EventFullNameComparator
    implements Comparator<Event> {
        @Override
        public int compare(Event e1, Event e2) {
            if (e1 == null || e2 == null || e1.getChangedPath() == null || e2.getChangedPath() == null) {
                return 0;
            }
            return e1.getChangedPath().getPath().compareTo(e1.getChangedPath().getPath());
        }
    }

    public class Event {
        private File file;
        private ISVNLogMessageChangePath changedPath;
        private String name;
        private String path;

        public Event(ISVNLogMessageChangePath changedPath) {
            this.changedPath = changedPath;
            this.name = changedPath.getPath().substring(changedPath.getPath().lastIndexOf(47) + 1);
            this.path = changedPath.getPath().substring(0, changedPath.getPath().lastIndexOf(47));
        }

        public RepositoryRevision getLogInfoHeader() {
            return RepositoryRevision.this;
        }

        public ISVNLogMessageChangePath getChangedPath() {
            return this.changedPath;
        }

        public boolean isFakeRoot() {
            return false;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append("\t");
            text.append(this.getPath());
            return text.toString();
        }
    }
}

