/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.jsr172.multiview;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mobility.end2end.E2EDataObject;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.ClassDescriptor;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.jsr172.multiview.WsdlUpdater;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JSR172ServicePanel
extends SectionInnerPanel
implements PropertyChangeListener {
    private transient E2EDataObject dataObject;
    private Configuration configuration;
    private WSDLService wsdlService;
    private WsdlUpdater updater;
    private JButton buttonGenerate;
    private JLabel jLabel1;
    private JButton refreshButton;
    private JTextField textUrl;

    public JSR172ServicePanel() {
        this(null, null, null);
    }

    public JSR172ServicePanel(SectionView sectionView, E2EDataObject e2EDataObject, Configuration configuration) {
        super(sectionView);
        this.dataObject = e2EDataObject;
        this.configuration = configuration;
        this.initComponents();
        if (configuration != null) {
            this.initValues();
        }
        e2EDataObject.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("generating".equals(propertyChangeEvent.getPropertyName())) {
                    JSR172ServicePanel.this.buttonGenerate.setEnabled((Boolean)propertyChangeEvent.getNewValue() == false);
                }
            }
        });
    }

    private void initValues() {
        this.wsdlService = (WSDLService)this.configuration.getServices().get(0);
        String string = this.wsdlService.getUrl();
        if (string == null || string.equals("")) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, NbBundle.getMessage(JSR172ServicePanel.class, (String)"ERR_UrlIsNotValid"), (JComponent)this.textUrl));
        }
        this.textUrl.setText(string);
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public void setValue(JComponent jComponent, Object object) {
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textUrl = new JTextField();
        this.refreshButton = new JButton();
        this.buttonGenerate = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(JSR172ServicePanel.class, (String)"WSDL_URL_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(this.jLabel1, gridBagConstraints);
        this.textUrl.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.add(this.textUrl, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(JSR172ServicePanel.class, (String)"Label_Refresh_WSDL"));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSR172ServicePanel.this.refreshButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.add(this.refreshButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonGenerate, (String)NbBundle.getMessage(JSR172ServicePanel.class, (String)"LBL_Generate"));
        this.buttonGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSR172ServicePanel.this.buttonGenerateActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.add(this.buttonGenerate, gridBagConstraints);
    }

    private void buttonGenerateActionPerformed(ActionEvent actionEvent) {
        this.buttonGenerate.setEnabled(false);
        this.dataObject.generate();
    }

    private void refreshButtonActionPerformed(ActionEvent actionEvent) {
        this.refreshButton.setEnabled(false);
        String string = this.wsdlService.getUrl();
        ClientConfiguration clientConfiguration = this.dataObject.getConfiguration().getClientConfiguration();
        ClassDescriptor classDescriptor = clientConfiguration.getClassDescriptor();
        WSDLService wSDLService = (WSDLService)this.dataObject.getConfiguration().getServices().get(0);
        String string2 = wSDLService.getFile();
        this.updater = new WsdlUpdater(string, classDescriptor.getPackageName().replace('.', '/'), string2, this.dataObject);
        this.updater.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("updateFinished".equals(propertyChangeEvent.getPropertyName())) {
            this.refreshButton.setEnabled(true);
            this.updater.removePropertyChangeListener(this);
            this.updater = null;
        }
    }
}

