/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.editor.ext.html.parser.spi.DefaultHelpItem;
import org.netbeans.editor.ext.html.parser.spi.HelpItem;
import org.netbeans.editor.ext.html.parser.spi.HelpResolver;
import org.netbeans.editor.ext.html.parser.spi.HtmlTag;
import org.netbeans.editor.ext.html.parser.spi.HtmlTagAttribute;
import org.netbeans.editor.ext.html.parser.spi.HtmlTagAttributeType;
import org.netbeans.editor.ext.html.parser.spi.HtmlTagType;
import org.netbeans.modules.html.parser.HtmlDocumentation;
import org.netbeans.modules.html.parser.model.Attribute;
import org.netbeans.modules.html.parser.model.ContentType;
import org.netbeans.modules.html.parser.model.ElementDescriptor;
import org.netbeans.modules.html.parser.model.ElementDescriptorRules;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTagProvider {
    private static HashMap<String, HtmlTag> TAGS = new HashMap();
    private static Map<Attribute, HtmlTagAttribute> ATTRS = new EnumMap<Attribute, HtmlTagAttribute>(Attribute.class);

    public static synchronized HtmlTag getTagForElement(String name) {
        assert (name != null);
        HtmlTag impl = TAGS.get(name);
        if (impl == null) {
            impl = new ElementName2HtmlTagAdapter(name);
            TAGS.put(name, impl);
        }
        return impl;
    }

    public static synchronized Collection<HtmlTag> convert(Collection<ElementDescriptor> elements) {
        LinkedList<HtmlTag> converted = new LinkedList<HtmlTag>();
        for (ElementDescriptor element : elements) {
            converted.add(HtmlTagProvider.getTagForElement(element.getName()));
        }
        return converted;
    }

    private static synchronized HtmlTagAttribute getHtmlTagAttributeInstance(Attribute attr) {
        HtmlTagAttribute htmlTagAttribute = ATTRS.get((Object)attr);
        if (htmlTagAttribute == null) {
            htmlTagAttribute = new HtmlTagAttributeAdapter(attr);
            ATTRS.put(attr, htmlTagAttribute);
        }
        return htmlTagAttribute;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HtmlTagAttributeAdapter
    implements HtmlTagAttribute {
        private Attribute attr;

        public HtmlTagAttributeAdapter(Attribute name) {
            this.attr = name;
        }

        public String getName() {
            return this.attr.getName();
        }

        public boolean isRequired() {
            return false;
        }

        public HtmlTagAttributeType getType() {
            return HtmlTagAttributeType.GENERIC;
        }

        public Collection<String> getPossibleValues() {
            return Collections.emptyList();
        }

        public HelpItem getHelp() {
            StringBuilder header = new StringBuilder();
            header.append("<h2>");
            header.append(NbBundle.getMessage(HtmlTagProvider.class, (String)"MSG_ElementPrefix"));
            header.append(" '");
            header.append(this.attr.getName());
            header.append("'</h2>");
            return new DefaultHelpItem(HtmlDocumentation.getDefault().resolveLink(this.attr.getHelpLink()), (HelpResolver)HtmlDocumentation.getDefault(), header.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementName2HtmlTagAdapter
    implements HtmlTag {
        private String elementName;
        private ElementDescriptor descriptor;
        private Map<String, HtmlTagAttribute> attrs;
        private HtmlTagType type;
        private Collection<HtmlTag> children;

        private ElementName2HtmlTagAdapter(String elementName) {
            this.elementName = elementName;
            this.descriptor = ElementDescriptor.forName(elementName);
            this.type = this.findType();
        }

        private boolean isPureHtmlTag() {
            return this.descriptor != null;
        }

        private HtmlTagType findType() {
            return this.isPureHtmlTag() ? this.descriptor.getTagType() : HtmlTagType.UNKNOWN;
        }

        private void initAttributes() {
            if (this.isPureHtmlTag()) {
                this.attrs = new HashMap<String, HtmlTagAttribute>();
                for (Attribute attr : this.descriptor.getAttributes()) {
                    this.attrs.put(attr.getName(), HtmlTagProvider.getHtmlTagAttributeInstance(attr));
                }
            } else {
                this.attrs = Collections.emptyMap();
            }
        }

        public String getName() {
            return this.elementName;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof HtmlTag)) {
                return false;
            }
            HtmlTag other = (HtmlTag)obj;
            return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
            return hash;
        }

        public String toString() {
            return String.format("ElementName2HtmlTagAdapter{name=%s}", this.getName());
        }

        public synchronized Collection<HtmlTagAttribute> getAttributes() {
            if (this.attrs == null) {
                this.initAttributes();
            }
            return this.attrs.values();
        }

        public boolean isEmpty() {
            return this.isPureHtmlTag() ? this.descriptor.isEmpty() : false;
        }

        public boolean hasOptionalOpenTag() {
            return this.isPureHtmlTag() ? this.descriptor.hasOptionalOpenTag() : false;
        }

        public boolean hasOptionalEndTag() {
            return this.isPureHtmlTag() ? this.descriptor.hasOptionalEndTag() : false;
        }

        public synchronized HtmlTagAttribute getAttribute(String name) {
            if (this.attrs == null) {
                this.initAttributes();
            }
            return this.attrs.get(name);
        }

        public HtmlTagType getTagClass() {
            return this.type;
        }

        public synchronized Collection<HtmlTag> getChildren() {
            if (this.children == null) {
                if (this.isPureHtmlTag()) {
                    Collection<ElementDescriptor> directChildren = this.descriptor.getChildrenElements();
                    this.children = new LinkedList<HtmlTag>(HtmlTagProvider.convert(directChildren));
                    for (ContentType ct : this.descriptor.getChildrenTypes()) {
                        Collection<ElementDescriptor> contentTypeChildren = ElementDescriptorRules.getElementsByContentType(ct);
                        this.children.addAll(HtmlTagProvider.convert(contentTypeChildren));
                    }
                } else {
                    this.children = Collections.emptyList();
                }
            }
            return this.children;
        }

        public HelpItem getHelp() {
            StringBuilder header = new StringBuilder();
            header.append("<h2>");
            header.append(NbBundle.getMessage(HtmlTagProvider.class, (String)"MSG_ElementPrefix"));
            header.append(" '");
            header.append(this.descriptor.getName());
            header.append("'</h2>");
            return this.isPureHtmlTag() && this.descriptor.getHelpLink() != null ? new DefaultHelpItem(HtmlDocumentation.getDefault().resolveLink(this.descriptor.getHelpLink()), (HelpResolver)HtmlDocumentation.getDefault(), header.toString()) : null;
        }
    }
}

