/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.actions;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.gizmo.GizmoConfigurationOptions;
import org.netbeans.modules.cnd.gizmo.GizmoServiceInfoAccessor;
import org.netbeans.modules.cnd.gizmo.api.GizmoOptionsProvider;
import org.netbeans.modules.cnd.gizmo.spi.GizmoOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.netbeans.modules.dlight.api.execution.DLightSessionConfiguration;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.execution.DLightToolkitManagement;
import org.netbeans.modules.dlight.api.support.NativeExecutableTarget;
import org.netbeans.modules.dlight.api.support.NativeExecutableTargetConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationOptions;
import org.netbeans.modules.dlight.spi.CppSymbolDemanglerFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminalProvider;
import org.netbeans.modules.remote.api.RemoteBinaryService;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class GizmoRunActionHandler
implements ProjectActionHandler,
DLightTargetListener {
    private static final String GNU_FAMILIY = "gc++filt";
    private static final String SS_FAMILIY = "dem";
    private ProjectActionEvent pae;
    private List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private DLightToolkitManagement.DLightSessionHandler session;
    private InputOutput io;
    private long startTimeMillis;

    public void init(ProjectActionEvent pae, ProjectActionEvent[] paes) {
        this.pae = pae;
    }

    public void execute(InputOutput io) {
        String termPath;
        CompilerSet compilerSet;
        MakeConfiguration conf = this.pae.getConfiguration();
        ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
        GizmoOptions opts = GizmoOptionsProvider.getOptions((Configuration)conf);
        opts.init((Configuration)conf);
        DLightConfiguration configuration = opts.getDLightConfiguration();
        Map envVars = this.pae.getProfile().getEnvironment().getenvAsMap();
        NativeExecutableTargetConfiguration targetConf = new NativeExecutableTargetConfiguration(this.pae.getExecutable(), this.pae.getProfile().getArgsArray(), envVars);
        String executable = this.pae.getExecutable();
        String runDirectory = this.pae.getProfile().getRunDirectory();
        boolean isSunStudio = configuration.getCollectorProviders().contains("SunStudio");
        if (execEnv.isRemote()) {
            runDirectory = ProjectSupport.convertWorkingDirToRemoteIfNeeded((ProjectActionEvent)this.pae, (String)runDirectory);
            if (isSunStudio) {
                targetConf.putInfo("GizmoProjectExecutable", executable);
            } else {
                RemoteBinaryService.RemoteBinaryID executableID = RemoteBinaryService.getRemoteBinary((ExecutionEnvironment)execEnv, (String)executable);
                targetConf.putInfo("GizmoProjectExecutable", executableID.toIDString());
                targetConf.putInfo("GizmoProjectRemoteExecutable", executable);
                targetConf.putInfo("GizmoProjectRemoteExecutableID", executable + ";" + executableID.getTimeStamp());
            }
        } else {
            targetConf.putInfo("GizmoProjectExecutable", executable);
            File file = new File(executable);
            targetConf.putInfo("GizmoProjectExecutableID", executable + ";" + file.lastModified());
        }
        targetConf.setExecutionEnvironment(execEnv);
        if (execEnv.isRemote() && ServerList.get((ExecutionEnvironment)execEnv).getX11Forwarding() && !envVars.containsKey("DISPLAY")) {
            targetConf.setX11Forwarding(true);
        }
        targetConf.putInfo("service.storage.execution.env.key", ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)execEnv));
        targetConf.putInfo(GizmoServiceInfoAccessor.getDefault().getGIZMO_RUN(), "gizmo.run");
        targetConf.putInfo("gizmo.platform", this.pae.getConfiguration().getDevelopmentHost().getBuildPlatformDisplayName());
        targetConf.putInfo("GizmoProjectFolder", FileUtil.toFile((FileObject)this.pae.getProject().getProjectDirectory()).getAbsolutePath());
        targetConf.putInfo("sunstudio.datafilter.collectedobjects", System.getProperty("sunstudio.datafilter.collectedobjects", ""));
        targetConf.putInfo("sunstudio.hotspotfunctionsfilter", System.getProperty("sunstudio.hotspotfunctionsfilter", ""));
        CompilerSet2Configuration cset = conf.getCompilerSet();
        if (cset != null && (compilerSet = cset.getCompilerSet()) != null) {
            String binDir = compilerSet.getDirectory();
            String demangle_utility = SS_FAMILIY;
            if (compilerSet.getCompilerFlavor().isGnuCompiler()) {
                demangle_utility = GNU_FAMILIY;
            }
            String dem_util_path = binDir + "/" + demangle_utility;
            targetConf.putInfo("GizmoDemangleUtility", dem_util_path);
            targetConf.putInfo("GizmoCppCompiler", compilerSet.getCompilerFlavor().isGnuCompiler() ? CppSymbolDemanglerFactory.CPPCompiler.GNU.toString() : CppSymbolDemanglerFactory.CPPCompiler.SS.toString());
            targetConf.putInfo("GizmoCppCompilerBinPath", binDir);
            targetConf.putInfo(Charset.class.getName(), compilerSet.getEncoding().name());
        }
        targetConf.setWorkingDirectory(runDirectory);
        int consoleType = this.pae.getProfile().getConsoleType().getValue();
        if (consoleType == 0) {
            consoleType = RunProfile.getDefaultConsoleType();
        }
        if (consoleType == 1 && (termPath = this.pae.getProfile().getTerminalPath()) != null) {
            String termBaseName = CndPathUtilitities.getBaseName((String)termPath);
            if (ExternalTerminalProvider.getSupportedTerminalIDs().contains(termBaseName)) {
                targetConf.useExternalTerminal(ExternalTerminalProvider.getTerminal((ExecutionEnvironment)execEnv, (String)termBaseName));
            }
        }
        this.io = io;
        targetConf.setIO(io);
        targetConf.setOutConvertorFactory((ExecutionDescriptor.LineConvertorFactory)new SimpleOutputConvertorFactory());
        DLightConfigurationOptions options = configuration.getConfigurationOptions(false);
        if (options instanceof GizmoConfigurationOptions) {
            GizmoConfigurationOptions gizmoConfigurationOptions = (GizmoConfigurationOptions)options;
            gizmoConfigurationOptions.configure(this.pae.getProject());
            Collection<String> toolNames = gizmoConfigurationOptions.getActiveToolNames();
            String collectedToolNames = "";
            Iterator<String> it = toolNames.iterator();
            while (it.hasNext()) {
                collectedToolNames = collectedToolNames + it.next() + ": ";
            }
            UIGesturesSupport.submit((String)"USG_CND_PROFILE_INDICATORS", (Object[])new Object[]{collectedToolNames});
        }
        NativeExecutableTarget target = new NativeExecutableTarget(targetConf);
        target.addTargetListener((DLightTargetListener)this);
        DLightSessionConfiguration sessionConfiguration = new DLightSessionConfiguration();
        sessionConfiguration.setDLightTarget((DLightTarget)target);
        sessionConfiguration.setDLightConfiguration(configuration);
        sessionConfiguration.setSessionName(CndPathUtilitities.getBaseName((String)this.pae.getExecutable()));
        final Future handle = DLightToolkitManagement.getInstance().createSession(sessionConfiguration);
        DLightExecutorService.submit((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    GizmoRunActionHandler.this.session = (DLightToolkitManagement.DLightSessionHandler)handle.get();
                    DLightToolkitManagement.getInstance().startSession(GizmoRunActionHandler.this.session);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, (String)("DLight Session for " + target.toString()));
    }

    public boolean canCancel() {
        return true;
    }

    public void cancel() {
        if (this.session != null) {
            DLightToolkitManagement.getInstance().stopSession(this.session);
            this.session = null;
        }
    }

    public void addExecutionListener(ExecutionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeExecutionListener(ExecutionListener l) {
        this.listeners.remove(l);
    }

    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case INIT: 
            case STARTING: {
                break;
            }
            case RUNNING: {
                this.targetStarted(event.status);
                break;
            }
            case FAILED: 
            case STOPPED: {
                this.targetFailed();
                break;
            }
            case TERMINATED: {
                this.targetTerminated();
                break;
            }
            case DONE: {
                this.targetFinished(event.status);
            }
        }
    }

    private void targetStarted(int pid) {
        this.startTimeMillis = System.currentTimeMillis();
        for (ExecutionListener l : this.listeners) {
            l.executionStarted(pid);
        }
    }

    private void targetFailed() {
        StatusDisplayer.getDefault().setStatusText(GizmoRunActionHandler.getMessage("Status.RunFailedToStart", new Object[0]));
        this.io.getErr().println(GizmoRunActionHandler.getMessage("Output.RunFailedToStart", new Object[0]));
        for (ExecutionListener l : this.listeners) {
            l.executionFinished(-1);
        }
    }

    private void targetTerminated() {
        this.io.getOut().printf("\r\n", new Object[0]);
        StatusDisplayer.getDefault().setStatusText(GizmoRunActionHandler.getMessage("Status.RunTerminated", new Object[0]));
        this.io.getErr().printf("%s\r\n", new Object[]{GizmoRunActionHandler.getMessage("Output.RunTerminated", new Object[0])});
        for (ExecutionListener l : this.listeners) {
            l.executionFinished(-1);
        }
    }

    private void targetFinished(Integer status) {
        this.io.getOut().printf("\r\n", new Object[0]);
        int exitCode = status;
        boolean success = exitCode == 0;
        StatusDisplayer.getDefault().setStatusText(GizmoRunActionHandler.getMessage(success ? "Status.RunSuccessful" : "Status.RunFailed", new Object[0]));
        String time = GizmoRunActionHandler.formatTime(System.currentTimeMillis() - this.startTimeMillis);
        if (success) {
            this.io.getOut().printf("%s\r\n", new Object[]{GizmoRunActionHandler.getMessage("Output.RunSuccessful", time)});
        } else {
            this.io.getErr().printf("%s\r\n", new Object[]{GizmoRunActionHandler.getMessage("Output.RunFailed", exitCode, time)});
        }
        for (ExecutionListener l : this.listeners) {
            l.executionFinished(exitCode);
        }
    }

    private static String formatTime(long millis) {
        StringBuilder buf = new StringBuilder();
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        if (hours > 0L) {
            buf.append(' ').append(hours).append(GizmoRunActionHandler.getMessage("Time.Hour", new Object[0]));
        }
        if (minutes > 0L) {
            buf.append(' ').append(minutes % 60L).append(GizmoRunActionHandler.getMessage("Time.Minute", new Object[0]));
        }
        if (seconds > 0L) {
            buf.append(' ').append(seconds % 60L).append(GizmoRunActionHandler.getMessage("Time.Second", new Object[0]));
        }
        if (hours == 0L && minutes == 0L && seconds == 0L) {
            buf.append(' ').append(millis).append(GizmoRunActionHandler.getMessage("Time.Millisecond", new Object[0]));
        }
        return buf.toString();
    }

    private static String getMessage(String name, Object ... params) {
        return NbBundle.getMessage(GizmoRunActionHandler.class, (String)name, (Object[])params);
    }

    private static class SimpleOutputConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        private SimpleOutputConvertorFactory() {
        }

        public LineConvertor newLineConvertor() {
            return LineConvertors.proxy((LineConvertor[])new LineConvertor[]{LineConvertors.filePattern(null, (Pattern)Pattern.compile("^file://([^:]*[^ ])(:)([0-9]*).*"), null, (int)1, (int)3), LineConvertors.httpUrl()});
        }
    }
}

