/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.options;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.gizmo.options.GizmoOptionsImpl;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.xml.sax.Attributes;

public class GizmoOptionsXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private final Logger log = DLightLogger.getLogger(GizmoOptionsXMLCodec.class);
    private GizmoOptionsImpl gizmoOptions;
    private static final String PROFILE_ON_RUN_ELEMENT = "profileOnRun";
    private static final String CONFIGURATION_NAME_ELEMENT = "configurationname";
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";
    private static final int thisversion = 3;
    private int version = 0;

    public GizmoOptionsXMLCodec(GizmoOptionsImpl gizmoOptions) {
        this.gizmoOptions = gizmoOptions;
    }

    public static int getVersion() {
        return 3;
    }

    public String tag() {
        return "gizmo_options";
    }

    public void start(Attributes atts) throws VersionException {
        String what = "gizmo options";
        int maxVersion = GizmoOptionsXMLCodec.getVersion();
        this.version = this.getVersion(atts);
        this.checkVersion(atts, what, maxVersion);
    }

    public void end() {
        this.gizmoOptions.clearChanged();
    }

    public void startElement(String element, Attributes atts) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "start element with the name " + element);
        }
    }

    public void endElement(String element, String currentText) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "end element with the name " + element);
        }
        if (element.equals(PROFILE_ON_RUN_ELEMENT)) {
            boolean b = currentText.equals(TRUE_VALUE);
            this.gizmoOptions.getProfileOnRun().setValue(b);
        } else if (element.equals(CONFIGURATION_NAME_ELEMENT)) {
            String confName = currentText;
            this.gizmoOptions.setPreferredDLightConfiguration(confName);
        }
    }

    private static void encode(XMLEncoderStream xes, GizmoOptionsImpl gizmoOptions) {
        xes.elementOpen("gizmo_options", GizmoOptionsXMLCodec.getVersion());
        if (gizmoOptions.getProfileOnRun().getModified()) {
            xes.element(PROFILE_ON_RUN_ELEMENT, "" + gizmoOptions.getProfileOnRun().getValue());
        }
        if (gizmoOptions.getDLightConfiguration() != null) {
            xes.element(CONFIGURATION_NAME_ELEMENT, "" + gizmoOptions.getDLightConfiguration().getConfigurationName());
        }
        xes.elementClose("gizmo_options");
    }

    public void encode(XMLEncoderStream xes) {
        GizmoOptionsXMLCodec.encode(xes, this.gizmoOptions);
    }
}

