/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.options;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import org.netbeans.modules.cnd.gizmo.options.GizmoStringConfiguration;
import org.netbeans.modules.dlight.toolsui.api.PanelWithApply;
import org.netbeans.modules.dlight.toolsui.api.ToolsCustomizerPanelFactory;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class GizmoStringNodeProp
extends Node.Property<String> {
    private GizmoStringConfiguration stringConfiguration;
    private String def = null;
    private boolean canWrite = true;
    private final String name;
    private final String description;
    IntEditor intEditor = null;

    public GizmoStringNodeProp(GizmoStringConfiguration stringConfiguration, String txt1, String name, String description) {
        super(String.class);
        this.name = name;
        this.description = description;
        this.stringConfiguration = stringConfiguration;
        this.setValue("title", NbBundle.getMessage(GizmoStringNodeProp.class, (String)"DLG_TITLE_ConfigurationManager"));
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return this.description;
    }

    public String getValue() {
        return this.getStringConfiguration().getValueDef(this.def);
    }

    public void setValue(String v) {
        this.getStringConfiguration().setValue(v);
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public boolean canRead() {
        return true;
    }

    public void restoreDefaultValue() {
        this.getStringConfiguration().reset();
    }

    public boolean supportsDefaultValue() {
        return false;
    }

    public boolean isDefaultValue() {
        return !this.stringConfiguration.getModified();
    }

    public void setDefaultValue(String def) {
        this.def = def;
        this.getStringConfiguration().setDefaultValue(def);
    }

    public void setCanWrite(boolean v) {
        this.canWrite = v;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.intEditor == null) {
            this.intEditor = new IntEditor();
        }
        return this.intEditor;
    }

    public GizmoStringConfiguration getStringConfiguration() {
        return this.stringConfiguration;
    }

    public void setStringConfiguration(GizmoStringConfiguration stringConfiguration) {
        this.stringConfiguration = stringConfiguration;
    }

    private class IntEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor,
    VetoableChangeListener {
        private PropertyEnv env;
        private PanelWithApply toolsManagerPanel = null;

        private IntEditor() {
        }

        @Override
        public String getJavaInitializationString() {
            return this.getAsText();
        }

        @Override
        public String getAsText() {
            return GizmoStringNodeProp.this.getStringConfiguration().getValue();
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            super.setValue(text);
        }

        @Override
        public String[] getTags() {
            List<String> list = GizmoStringNodeProp.this.getStringConfiguration().getGizmoOptionsImpl().getValidConfigurationDisplayNames();
            return list.toArray(new String[list.size()]);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            this.env.addVetoableChangeListener((VetoableChangeListener)this);
            this.toolsManagerPanel = ToolsCustomizerPanelFactory.getCustomizerByName((String)this.getAsText());
            return this.toolsManagerPanel;
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            this.toolsManagerPanel.apply();
        }
    }
}

