/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.Group;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;

public class Symbol
extends Group {
    protected float[][] viewBox;

    public Symbol(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    public String getLocalName() {
        return "symbol";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Symbol(doc);
    }

    protected Transform appendTransform(Transform tx, Transform workTx) {
        if (this.viewBox == null || this.viewBox[0][0] == 0.0f && this.viewBox[0][1] == 0.0f) {
            return tx;
        }
        tx = this.recycleTransform(tx, workTx);
        if (this.viewBox != null) {
            tx.mTranslate(-this.viewBox[0][0], -this.viewBox[0][1]);
        }
        return tx;
    }

    public SVGRect getBBox() {
        if (this.viewBox != null) {
            Transform t = new Transform(1.0f, 0.0f, 0.0f, 1.0f, -this.viewBox[0][0], -this.viewBox[0][1]);
            return this.addBBox(null, t);
        }
        return this.addBBox(null, null);
    }

    public SVGMatrix getScreenCTM() {
        SVGMatrix m = super.getScreenCTM();
        if (m != null && this.viewBox != null) {
            m = m.mTranslate(this.viewBox[0][0], this.viewBox[0][1]);
        }
        return m;
    }

    public void setViewBox(float[][] newViewBox) {
        if (newViewBox != null && (newViewBox.length != 3 || newViewBox[0] == null || newViewBox[1] == null || newViewBox[2] == null || newViewBox[0].length != 2 || newViewBox[1][0] < 0.0f || newViewBox[2][0] < 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.modifyingNode();
        if (this.viewBox == null) {
            this.viewBox = new float[3][];
            this.viewBox[0] = new float[2];
            this.viewBox[1] = new float[1];
            this.viewBox[2] = new float[1];
        }
        this.viewBox[0][0] = newViewBox[0][0];
        this.viewBox[0][1] = newViewBox[0][1];
        this.viewBox[1][0] = newViewBox[1][0];
        this.viewBox[2][0] = newViewBox[2][0];
        this.recomputeTransformState();
        this.recomputeProxyTransformState();
        this.computeCanRenderEmptyViewBoxBit(this.viewBox);
        this.modifiedNode();
    }

    public float[][] getViewBox() {
        return this.viewBox;
    }

    boolean supportsTrait(String traitName) {
        if ("viewBox" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("viewBox" == name) {
            if (this.viewBox == null) {
                return "";
            }
            return "" + this.viewBox[0][0] + ',' + this.viewBox[0][1] + ',' + this.viewBox[1][0] + ',' + this.viewBox[2][0];
        }
        return super.getTraitImpl(name);
    }

    String toStringTrait(String name, float[][] value) {
        if ("viewBox" == name) {
            float[] vb = new float[]{value[0][0], value[0][1], value[1][0], value[2][0]};
            return this.toStringTrait(vb);
        }
        return super.toStringTrait(name, value);
    }

    SVGRect getRectTraitImpl(String name) throws DOMException {
        if ("viewBox".equals(name)) {
            return this.toSVGRect(this.viewBox);
        }
        return super.getRectTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("viewBox" == traitName) {
            return new FloatTraitAnim(this, traitName, "SVGRect");
        }
        return super.createTraitAnimImpl(traitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("viewBox" == name) {
            this.setViewBox(this.toViewBox(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setRectTraitImpl(String name, SVGRect rect) throws DOMException {
        if ("viewBox".equals(name)) {
            if (rect == null) {
                throw this.illegalTraitValue(name, null);
            }
            if (rect.getWidth() < 0.0f || rect.getHeight() < 0.0f) {
                throw this.illegalTraitValue(name, this.toStringTrait(new float[]{rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()}));
            }
            this.setViewBox(new float[][]{{rect.getX(), rect.getY()}, {rect.getWidth()}, {rect.getHeight()}});
        } else {
            super.setRectTraitImpl(name, rect);
        }
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("viewBox" == name) {
            this.setViewBox(value);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("viewBox" == traitName) {
            return this.ownerDocument.viewBoxParser.parseViewBox(value);
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }
}

