/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.toolsui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.tool.impl.DLightConfigurationManagerAccessor;
import org.netbeans.modules.dlight.toolsui.DLightConfigurationUIWrapper;
import org.netbeans.modules.dlight.toolsui.DLightConfigurationUIWrapperProvider;
import org.netbeans.modules.dlight.toolsui.DLightToolUIWrapper;
import org.netbeans.modules.dlight.toolsui.ListEditorPanel;
import org.netbeans.modules.dlight.toolsui.ToolsTable;
import org.netbeans.modules.dlight.toolsui.api.PanelWithApply;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ToolsManagerPanel
extends PanelWithApply {
    private List<DLightConfigurationUIWrapper> dLightConfigurations = null;
    private List<DLightTool> allDLightTools = null;
    private static String manageConfigurations = ToolsManagerPanel.getString("ManageConfiurations", new String[0]);
    private int lastSelectedIndex = 0;
    private ToolsTable toolsTable = null;
    private JTextArea descriptionArea;
    private JLabel detailsLabel;
    private JList jList1;
    private JComboBox profileConfigurationComboBox;
    private JLabel profileConfigurationLabel;
    private JScrollPane scrollPane;
    private JLabel toolsLabel;
    private JScrollPane toolsList;

    public ToolsManagerPanel() {
        this((String)null);
    }

    public ToolsManagerPanel(String preferredConfigurationName) {
        this.initComponents();
        this.descriptionArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.descriptionArea.setOpaque(true);
        DLightConfigurationManagerAccessor accessor = DLightConfigurationManagerAccessor.getDefault();
        this.allDLightTools = accessor.getDefaultConfiguration().getToolsSet();
        this.initDialog(DLightConfigurationUIWrapperProvider.getInstance().getDLightConfigurationUIWrappers(), preferredConfigurationName);
        this.setPreferredSize(new Dimension(700, 400));
    }

    private void initDialog(List<DLightConfigurationUIWrapper> list, String preferredConfigurationName) {
        this.profileConfigurationComboBox.removeAllItems();
        this.dLightConfigurations = list;
        Collections.sort(this.dLightConfigurations, new DLightConfigurationComparator());
        DLightConfigurationUIWrapper preferredConfiguration = null;
        for (DLightConfigurationUIWrapper dlightConfigurationWrapper : this.dLightConfigurations) {
            this.profileConfigurationComboBox.addItem(dlightConfigurationWrapper);
            if (preferredConfigurationName == null || !dlightConfigurationWrapper.getDisplayName().equals(preferredConfigurationName)) continue;
            preferredConfiguration = dlightConfigurationWrapper;
        }
        this.profileConfigurationComboBox.addItem(manageConfigurations);
        if (preferredConfiguration != null) {
            this.profileConfigurationComboBox.setSelectedItem(preferredConfiguration);
        } else {
            this.profileConfigurationComboBox.setSelectedIndex(0);
        }
    }

    private void initConfigurationPanel(DLightConfigurationUIWrapper dlightConfigurationUIWrapper) {
        DLightConfiguration gizmoConfiguration = dlightConfigurationUIWrapper.getDLightConfiguration();
        assert (gizmoConfiguration != null);
        this.toolsTable = new ToolsTable(dlightConfigurationUIWrapper, dlightConfigurationUIWrapper.getTools(), new MySelectionListener());
        this.toolsList.setViewportView(this.toolsTable);
        this.toolsTable.initSelection();
        this.toolsLabel.setLabelFor(this.toolsTable);
    }

    private DLightConfigurationUIWrapper inList(String name, List<DLightConfigurationUIWrapper> list) {
        for (DLightConfigurationUIWrapper wrapper : list) {
            if (!name.equals(wrapper.getName())) continue;
            return wrapper;
        }
        return null;
    }

    @Override
    public boolean apply() {
        DLightConfiguration dlightConfiguration;
        List indicators;
        String collector;
        List platforms;
        String category;
        DLightConfiguration origDLightConfiguration;
        List<DLightConfigurationUIWrapper> oldDLightConfiguration = DLightConfigurationUIWrapperProvider.getInstance().getDLightConfigurationUIWrappers();
        ArrayList<DLightConfigurationUIWrapper> toBeDeleted = new ArrayList<DLightConfigurationUIWrapper>();
        for (DLightConfigurationUIWrapper wrapper : oldDLightConfiguration) {
            DLightConfigurationUIWrapper c = this.inList(wrapper.getName(), this.dLightConfigurations);
            if (c != null && c.getCopyOf() == null) continue;
            toBeDeleted.add(wrapper);
        }
        DLightConfigurationManagerAccessor mgrAccessor = DLightConfigurationManagerAccessor.getDefault();
        for (DLightConfigurationUIWrapper conf : toBeDeleted) {
            mgrAccessor.removeConfiguration(conf.getName());
        }
        for (DLightConfigurationUIWrapper configuration : this.dLightConfigurations) {
            if (!configuration.isCustom() || configuration.getCopyOf() != null || configuration.getName().equals(configuration.getDLightConfiguration().getConfigurationName())) continue;
            origDLightConfiguration = configuration.getDLightConfiguration();
            category = origDLightConfiguration.getCategoryName();
            platforms = origDLightConfiguration.getPlatforms();
            collector = origDLightConfiguration.getCollectorProviders();
            indicators = origDLightConfiguration.getIndicatorProviders();
            mgrAccessor.removeConfiguration(origDLightConfiguration.getConfigurationName());
            dlightConfiguration = mgrAccessor.registerConfiguration(configuration.getName(), configuration.getDisplayName(), category, platforms, collector, indicators);
            configuration.setDLightConfiguration(dlightConfiguration);
            for (DLightToolUIWrapper toolUI : configuration.getTools()) {
                toolUI.setModified(true);
            }
        }
        for (DLightConfigurationUIWrapper configuration : this.dLightConfigurations) {
            if (!configuration.isCustom() || configuration.getCopyOf() == null) continue;
            origDLightConfiguration = configuration.getCopyOf();
            category = origDLightConfiguration.getCategoryName();
            platforms = origDLightConfiguration.getPlatforms();
            collector = origDLightConfiguration.getCollectorProviders();
            indicators = origDLightConfiguration.getIndicatorProviders();
            dlightConfiguration = mgrAccessor.registerConfigurationAsACopy(configuration.getCopyOf(), configuration.getName(), configuration.getDisplayName(), category, platforms, collector, indicators);
            configuration.setDLightConfiguration(dlightConfiguration);
            for (DLightToolUIWrapper toolUI : configuration.getTools()) {
                toolUI.setModified(true);
            }
            configuration.setCopyOf(null);
        }
        for (DLightConfigurationUIWrapper configuration : this.dLightConfigurations) {
            for (DLightToolUIWrapper toolUI : configuration.getTools()) {
                if (!toolUI.isModified()) continue;
                if (!toolUI.canEnable()) {
                    mgrAccessor.deleteTool(configuration.getName(), toolUI.getDLightTool());
                    continue;
                }
                mgrAccessor.registerTool(configuration.getName(), toolUI.getDLightTool().getID(), toolUI.isEnabled());
            }
        }
        DLightConfigurationUIWrapperProvider.getInstance().setDLightConfigurationUIWrappers(this.dLightConfigurations);
        return true;
    }

    private DLightToolUIWrapper getSelectedDLightToolWrapper() {
        int row = this.toolsTable.getSelectedRow();
        DLightConfigurationUIWrapper dLightConfigurationWrapper = (DLightConfigurationUIWrapper)this.profileConfigurationComboBox.getSelectedItem();
        DLightToolUIWrapper tool = dLightConfigurationWrapper.getTools().get(row);
        return tool;
    }

    private static String getString(String key, String ... params) {
        return NbBundle.getMessage(ToolsManagerPanel.class, (String)key, (Object[])params);
    }

    private void initComponents() {
        this.profileConfigurationLabel = new JLabel();
        this.profileConfigurationComboBox = new JComboBox();
        this.toolsLabel = new JLabel();
        this.toolsList = new JScrollPane();
        this.jList1 = new JList();
        this.detailsLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.descriptionArea = new JTextArea();
        this.profileConfigurationLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/dlight/toolsui/Bundle").getString("ProfilerConfiguration_MN").charAt(0));
        this.profileConfigurationLabel.setLabelFor(this.profileConfigurationComboBox);
        this.profileConfigurationLabel.setText(NbBundle.getMessage(ToolsManagerPanel.class, (String)"ToolsManagerPanel.profileConfigurationLabel.text"));
        this.profileConfigurationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolsManagerPanel.this.profileConfigurationComboBoxActionPerformed(evt);
            }
        });
        this.toolsLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/dlight/toolsui/Bundle").getString("TOOLS_MN").charAt(0));
        this.toolsLabel.setText(NbBundle.getMessage(ToolsManagerPanel.class, (String)"ToolsManagerPanel.toolsLabel.text"));
        this.toolsList.setOpaque(false);
        this.jList1.setSelectionMode(0);
        this.jList1.setOpaque(false);
        this.toolsList.setViewportView(this.jList1);
        this.descriptionArea.setColumns(20);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setRows(5);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setFocusable(false);
        this.scrollPane.setViewportView(this.descriptionArea);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.profileConfigurationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.profileConfigurationComboBox, 0, 491, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.toolsList, -2, 288, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 327, Short.MAX_VALUE).addComponent(this.detailsLabel))).addComponent(this.toolsLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.profileConfigurationComboBox, -2, -1, -2).addComponent(this.profileConfigurationLabel)).addGap(1, 1, 1).addComponent(this.toolsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolsList, -1, 328, Short.MAX_VALUE).addComponent(this.scrollPane, -1, 328, Short.MAX_VALUE).addComponent(this.detailsLabel)).addGap(21, 21, 21)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void profileConfigurationComboBoxActionPerformed(ActionEvent evt) {
        Object item = this.profileConfigurationComboBox.getSelectedItem();
        if (item instanceof String && ((String)item).equals(manageConfigurations)) {
            this.profileConfigurationComboBox.hidePopup();
            MyListEditorPanel listEditorPanel = new MyListEditorPanel(this.dLightConfigurations);
            DialogDescriptor descriptor = new DialogDescriptor((Object)listEditorPanel, ToolsManagerPanel.getString("TXT_ConfigurationsCustomizer", new String[0]));
            Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
            try {
                dlg.setVisible(true);
                if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    Vector<DLightConfigurationUIWrapper> newList = listEditorPanel.getListData();
                    List<DLightConfigurationUIWrapper> oldList = DLightConfigurationUIWrapperProvider.getInstance().getDLightConfigurationUIWrappers();
                    oldList.clear();
                    oldList.addAll(newList);
                    this.initDialog(newList, null);
                    DLightConfigurationUIWrapper dlightConfigurationUIWrapper = (DLightConfigurationUIWrapper)this.profileConfigurationComboBox.getSelectedItem();
                    this.initConfigurationPanel(dlightConfigurationUIWrapper);
                }
                this.profileConfigurationComboBox.setSelectedIndex(this.lastSelectedIndex);
            }
            finally {
                dlg.dispose();
            }
        } else if (item instanceof DLightConfigurationUIWrapper) {
            DLightConfigurationUIWrapper dlightConfigurationUIWrapper = (DLightConfigurationUIWrapper)item;
            this.initConfigurationPanel(dlightConfigurationUIWrapper);
        } else assert (false);
        this.lastSelectedIndex = this.profileConfigurationComboBox.getSelectedIndex();
    }

    private static class DLightConfigurationComparator
    implements Comparator<DLightConfigurationUIWrapper> {
        private DLightConfigurationComparator() {
        }

        @Override
        public int compare(DLightConfigurationUIWrapper o1, DLightConfigurationUIWrapper o2) {
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        }
    }

    private class MyListEditorPanel
    extends ListEditorPanel<DLightConfigurationUIWrapper> {
        public MyListEditorPanel(List<DLightConfigurationUIWrapper> list) {
            super(list);
            this.setPreferredSize(new Dimension(400, 300));
            this.getAddButton().setVisible(false);
        }

        private String makeNameUnique(String suggestedName) {
            if (this.findDLightConfigurationUIWrapper(suggestedName) == null) {
                return suggestedName;
            }
            int i = 1;
            String newName;
            while (this.findDLightConfigurationUIWrapper(newName = suggestedName + "_" + i) != null) {
                ++i;
            }
            return newName;
        }

        private String makeNameLegal(String suggestedName) {
            String newName = suggestedName;
            newName = newName.replace("/", "_FSLASH_");
            newName = newName.replace("\\", "_BSLASH_");
            newName = newName.replace(".", "_DOT_");
            return newName.trim();
        }

        private DLightConfigurationUIWrapper findDLightConfigurationUIWrapper(String name) {
            for (DLightConfigurationUIWrapper dlightConfigurationUIWrapper : this.getListData()) {
                if (!dlightConfigurationUIWrapper.getDisplayName().equals(name)) continue;
                return dlightConfigurationUIWrapper;
            }
            return null;
        }

        @Override
        public DLightConfigurationUIWrapper copyAction(DLightConfigurationUIWrapper o) {
            String newDisplayName = this.makeNameUnique(ToolsManagerPanel.getString("CopyOf", new String[]{o.getDisplayName()}));
            String newName = this.makeNameLegal(newDisplayName);
            DLightConfigurationUIWrapper copy = new DLightConfigurationUIWrapper(newName, newDisplayName, ToolsManagerPanel.this.allDLightTools);
            List<DLightToolUIWrapper> tools = o.getTools();
            List<DLightToolUIWrapper> copyTools = copy.getTools();
            int i = 0;
            for (DLightToolUIWrapper tool : tools) {
                DLightToolUIWrapper copyTool = copyTools.get(i++);
                copyTool.setEnabled(tool.isEnabled());
                copyTool.setCanEnable(tool.canEnable());
            }
            DLightConfiguration copyOf = o.getDLightConfiguration();
            if (o.getCopyOf() != null) {
                copyOf = o.getCopyOf();
            }
            copy.setCopyOf(copyOf);
            return copy;
        }

        @Override
        public void editAction(DLightConfigurationUIWrapper o) {
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(ToolsManagerPanel.getString("EDIT_DIALOG_LABEL_TXT", new String[0]), ToolsManagerPanel.getString("EDIT_DIALOG_TITLE_TXT", new String[0]));
            notifyDescriptor.setInputText(o.getDisplayName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String newDisplayName = notifyDescriptor.getInputText();
            newDisplayName = (newDisplayName = newDisplayName.trim()).trim().length() == 0 ? o.getDisplayName() : this.makeNameUnique(newDisplayName);
            o.setDisplayName(newDisplayName);
            String newName = this.makeNameLegal(newDisplayName);
            o.setName(newName);
        }

        @Override
        protected void checkSelection(int i) {
            super.checkSelection(i);
            DLightConfigurationUIWrapper dLightConfigurationWrapper = (DLightConfigurationUIWrapper)this.getListData().elementAt(i);
            this.getEditButton().setEnabled(dLightConfigurationWrapper.isCustom());
            this.getRemoveButton().setEnabled(dLightConfigurationWrapper.isCustom());
        }
    }

    private class MySelectionListener
    implements ListSelectionListener {
        private MySelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            DLightToolUIWrapper tool = ToolsManagerPanel.this.getSelectedDLightToolWrapper();
            ToolsManagerPanel.this.detailsLabel.setText(tool.getDLightTool().getDetailedName());
            String text = tool.getDLightTool().getDescription();
            ToolsManagerPanel.this.descriptionArea.setText(text == null ? "" : text);
        }
    }
}

