/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.projectsupport.utilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProjectUtilities {
    private static final Logger LOGGER = Logger.getLogger(ProjectUtilities.class.getName());
    private static final String PROFILE_PROJECT_CLASSES_STRING = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfileProjectClassesString");
    private static final String PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfileProjectSubprojectClassesString");
    public static final SimpleFilter FILTER_PROJECT_ONLY = new SimpleFilter(PROFILE_PROJECT_CLASSES_STRING, 2, "{$project.classes.only}");
    public static final SimpleFilter FILTER_PROJECT_SUBPROJECTS_ONLY = new SimpleFilter(PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING, 2, "{$project.subprojects.classes.only}");

    public static ClasspathInfo getClasspathInfo(Project project) {
        return ProjectUtilities.getClasspathInfo(project, true);
    }

    public static ClasspathInfo getClasspathInfo(Project project, boolean includeSubprojects) {
        return ProjectUtilities.getClasspathInfo(project, includeSubprojects, true, true);
    }

    public static ClasspathInfo getClasspathInfo(Project project, boolean includeSubprojects, boolean includeSources, boolean includeLibraries) {
        FileObject[] sourceRoots = ProjectUtilities.getSourceRoots(project, includeSubprojects);
        HashSet<FileObject> srcRootSet = new HashSet<FileObject>(sourceRoots.length);
        ArrayList<URL> urlList = new ArrayList<URL>();
        srcRootSet.addAll(Arrays.asList(sourceRoots));
        if (!(sourceRoots != null && sourceRoots.length != 0 || includeSubprojects)) {
            sourceRoots = ProjectUtilities.getSourceRoots(project, true);
        }
        ClassPath cpEmpty = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        if (sourceRoots.length == 0) {
            return null;
        }
        ClassPath cpSource = ClassPathSupport.createClassPath((FileObject[])sourceRoots);
        ClassPath cpCompile = ClassPath.getClassPath((FileObject)sourceRoots[0], (String)"classpath/compile");
        for (ClassPath.Entry entry : cpCompile.entries()) {
            SourceForBinaryQuery.Result rslt = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
            FileObject[] roots = rslt.getRoots();
            if (roots != null && roots.length != 0) continue;
            urlList.add(entry.getURL());
        }
        cpCompile = ClassPathSupport.createClassPath((URL[])urlList.toArray(new URL[urlList.size()]));
        return ClasspathInfo.create((ClassPath)(includeLibraries ? ClassPath.getClassPath((FileObject)sourceRoots[0], (String)"classpath/boot") : cpEmpty), (ClassPath)(includeLibraries ? cpCompile : cpEmpty), (ClassPath)(includeSources ? cpSource : cpEmpty));
    }

    public static Project getMainProject() {
        return OpenProjects.getDefault().getMainProject();
    }

    public static Project[] getOpenedProjects() {
        return OpenProjects.getDefault().getOpenProjects();
    }

    public static Project[] getSortedProjects(Project[] projects) {
        ArrayList<Project> projectsArray = new ArrayList<Project>(projects.length);
        for (int i = 0; i < projects.length; ++i) {
            projectsArray.add(projects[i]);
        }
        try {
            Collections.sort(projectsArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Project p1 = (Project)o1;
                    Project p2 = (Project)o2;
                    return ProjectUtils.getInformation((Project)p1).getDisplayName().toLowerCase().compareTo(ProjectUtils.getInformation((Project)p2).getDisplayName().toLowerCase());
                }
            });
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(65536, e.getMessage());
        }
        projectsArray.toArray(projects);
        return projects;
    }

    public static boolean hasAction(Project project, String actionName) {
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (ap == null) {
            return false;
        }
        String[] actions = ap.getSupportedActions();
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null || !actionName.equals(actions[i])) continue;
            return true;
        }
        return false;
    }

    public static FileObject getOrCreateBuildFolder(Project project, String buildDirProp) {
        FileObject buildDir = FileUtil.toFileObject((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)buildDirProp));
        if (buildDir == null) {
            try {
                buildDir = FileUtil.createFolder((FileObject)project.getProjectDirectory(), (String)buildDirProp);
            }
            catch (IOException e) {
                MessageFormat.format(NbBundle.getMessage(ProjectUtilities.class, (String)"FailedCreateOutputFolderMsg"), e.getMessage());
                ErrorManager.getDefault().notify(65536, (Throwable)e);
                return null;
            }
        }
        return buildDir;
    }

    public static Properties getProjectProperties(Project project) {
        final Properties props = new Properties();
        final FileObject propFile = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        if (propFile != null) {
            ProjectManager.mutex().readAccess(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStream in = null;
                    try {
                        in = propFile.getInputStream();
                        props.load(in);
                    }
                    catch (IOException ex) {
                        LOGGER.finest("Could not load properties file: " + propFile.getPath());
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectBuildScript(Project project) {
        FileObject buildFile = project.getProjectDirectory().getFileObject("build.xml");
        RandomAccessFile file = null;
        byte[] data = null;
        try {
            file = new RandomAccessFile(FileUtil.toFile((FileObject)buildFile), "r");
            data = new byte[(int)buildFile.getSize()];
            file.readFully(data);
        }
        catch (FileNotFoundException e2) {
            ProfilerLogger.log((Exception)e2);
            String string = null;
            return string;
        }
        catch (IOException e2) {
            ProfilerLogger.log((Exception)e2);
            String string = null;
            return string;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e2) {
                    ProfilerLogger.log((Exception)e2);
                }
            }
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
            return null;
        }
    }

    public static List<SimpleFilter> getProjectDefaultInstrFilters(Project project) {
        ArrayList<SimpleFilter> v = new ArrayList<SimpleFilter>();
        if (ProjectUtils.getSources((Project)project).getSourceGroups("java").length > 0) {
            v.add(FILTER_PROJECT_ONLY);
        }
        if (ProjectUtilities.hasSubprojects(project)) {
            v.add(FILTER_PROJECT_SUBPROJECTS_ONLY);
        }
        return v;
    }

    public static ClientUtils.SourceCodeSelection[] getProjectDefaultRoots(Project project, String[][] projectPackagesDescr) {
        ProjectUtilities.computeProjectPackages(project, true, projectPackagesDescr);
        ClientUtils.SourceCodeSelection[] ret = new ClientUtils.SourceCodeSelection[projectPackagesDescr[1].length];
        for (int i = 0; i < projectPackagesDescr[1].length; ++i) {
            ret[i] = "".equals(projectPackagesDescr[1][i]) ? new ClientUtils.SourceCodeSelection("", "", "") : new ClientUtils.SourceCodeSelection(projectPackagesDescr[1][i] + ".", "", "");
        }
        return ret;
    }

    public static Project getProjectForBuildScript(String fileName) {
        FileObject projectFO = FileUtil.toFileObject((File)new File(fileName));
        while (projectFO != null) {
            try {
                if (projectFO.isFolder()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Trying: " + projectFO);
                    }
                    Project p = ProjectManager.getDefault().findProject(projectFO);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Got: " + (p != null ? ProjectUtilities.getProjectName(p) : null));
                    }
                    if (p != null) {
                        return p;
                    }
                }
                projectFO = projectFO.getParent();
            }
            catch (IOException e) {
                ProfilerLogger.severe((String)("Got: IOException : " + e.getMessage()));
            }
        }
        return null;
    }

    public static Icon getProjectIcon(Project project) {
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (info == null) {
            return new ImageIcon();
        }
        return info.getIcon();
    }

    public static String getProjectName(Project project) {
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        return info != null ? info.getDisplayName() : "UNKNOWN";
    }

    public static FileObject[] getSourceRoots(Project project) {
        return ProjectUtilities.getSourceRoots(project, true);
    }

    public static FileObject[] getSourceRoots(Project project, boolean traverse) {
        HashSet<FileObject> set = new HashSet<FileObject>();
        HashSet<Project> projects = new HashSet<Project>();
        projects.add(project);
        ProjectUtilities.getSourceRoots(project, traverse, projects, set);
        return set.toArray(new FileObject[set.size()]);
    }

    public static void fetchSubprojects(Project project, Set<Project> projects) {
        SubprojectProvider spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (spp != null) {
            for (Project p : spp.getSubprojects()) {
                if (!projects.add(p)) continue;
                ProjectUtilities.fetchSubprojects(p, projects);
            }
        }
    }

    public static SimpleFilter computeProjectOnlyInstrumentationFilter(Project project, SimpleFilter predefinedInstrFilter, String[][] projectPackagesDescr) {
        if (FILTER_PROJECT_ONLY.equals((Object)predefinedInstrFilter)) {
            return new SimpleFilter(PROFILE_PROJECT_CLASSES_STRING, 2, ProjectUtilities.computeProjectOnlyInstrumentationFilter(project, false, projectPackagesDescr));
        }
        if (FILTER_PROJECT_SUBPROJECTS_ONLY.equals((Object)predefinedInstrFilter)) {
            return new SimpleFilter(PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING, 2, ProjectUtilities.computeProjectOnlyInstrumentationFilter(project, true, projectPackagesDescr));
        }
        return null;
    }

    public static String computeProjectOnlyInstrumentationFilter(Project project, boolean useSubprojects, String[][] projectPackagesDescr) {
        if (!useSubprojects) {
            ProjectUtilities.computeProjectPackages(project, false, projectPackagesDescr);
            StringBuffer projectPackages = new StringBuffer();
            for (int i = 0; i < projectPackagesDescr[0].length; ++i) {
                projectPackages.append("".equals(projectPackagesDescr[0][i]) ? ProjectUtilities.getDefaultPackageClassNames(project) : projectPackagesDescr[0][i] + ". ");
            }
            return projectPackages.toString().trim();
        }
        ProjectUtilities.computeProjectPackages(project, true, projectPackagesDescr);
        StringBuffer projectPackages = new StringBuffer();
        for (int i = 0; i < projectPackagesDescr[1].length; ++i) {
            projectPackages.append("".equals(projectPackagesDescr[1][i]) ? ProjectUtilities.getDefaultPackageClassNames(project) : projectPackagesDescr[1][i] + ". ");
        }
        return projectPackages.toString().trim();
    }

    public static boolean isIncludeSubprojects(SimpleFilter filter) {
        return FILTER_PROJECT_SUBPROJECTS_ONLY.equals((Object)filter);
    }

    public static String getDefaultPackageClassNames(Project project) {
        Collection<String> classNames = SourceUtils.getDefaultPackageClassNames(project);
        StringBuffer classNamesBuf = new StringBuffer();
        for (String className : classNames) {
            classNamesBuf.append(className).append(" ");
        }
        return classNamesBuf.toString();
    }

    public static void computeProjectPackages(Project project, boolean subprojects, String[][] storage) {
        if (storage == null || storage.length != 2) {
            throw new IllegalArgumentException("Storage must be a non-null String[2][] array");
        }
        if (storage[0] == null || storage[0].length == 0) {
            ArrayList<String> packages1 = new ArrayList<String>();
            for (FileObject root : ProjectUtilities.getSourceRoots(project, false)) {
                ProjectUtilities.addSubpackages(packages1, "", root);
            }
            storage[0] = packages1.toArray(new String[0]);
        }
        if (subprojects && (storage[1] == null || storage[1].length == 0)) {
            FileObject[] srcRoots2 = ProjectUtilities.getSourceRoots(project, true);
            ArrayList<String> packages2 = new ArrayList<String>();
            for (FileObject root : srcRoots2) {
                ProjectUtilities.addSubpackages(packages2, "", root);
            }
            storage[1] = packages2.toArray(new String[0]);
        }
    }

    public static FileObject findTestForFile(FileObject selectedFO) {
        if (selectedFO == null || !selectedFO.getExt().equalsIgnoreCase("java")) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)selectedFO, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        FileObject packageRoot = cp.findOwnerRoot(selectedFO);
        if (packageRoot == null) {
            return null;
        }
        URL[] testRoots = UnitTestForSourceQuery.findUnitTests((FileObject)packageRoot);
        FileObject fileToOpen = null;
        for (int j = 0; j < testRoots.length; ++j) {
            fileToOpen = ProjectUtilities.findUnitTestInTestRoot(cp, selectedFO, testRoots[j]);
            if (fileToOpen == null) continue;
            return fileToOpen;
        }
        return null;
    }

    public static void invokeAction(Project project, String s) {
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (ap == null) {
            return;
        }
        ap.invokeAction(s, Lookup.getDefault());
    }

    public static boolean isJavaProject(Project project) {
        if (project == null) {
            return false;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        return sourceGroups.length > 0;
    }

    private static void getSourceRoots(Project project, boolean traverse, Set<Project> projects, Set<FileObject> roots) {
        SubprojectProvider spp;
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sg : sources.getSourceGroups("java")) {
            roots.add(sg.getRootFolder());
        }
        if (traverse && (spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
            for (Project p : spp.getSubprojects()) {
                if (!projects.add(p)) continue;
                ProjectUtilities.getSourceRoots(p, traverse, projects, roots);
            }
        }
    }

    private static void addSubpackages(Collection<String> packages, String prefix, FileObject packageFO) {
        FileObject child;
        int i;
        if (!packageFO.isFolder()) {
            return;
        }
        FileObject[] children = packageFO.getChildren();
        if (!packages.contains(prefix)) {
            for (i = 0; i < children.length; ++i) {
                child = children[i];
                if (!child.getExt().equals("java")) continue;
                packages.add(prefix);
                break;
            }
        }
        for (i = 0; i < children.length; ++i) {
            child = children[i];
            if (!child.isFolder()) continue;
            if ("".equals(prefix)) {
                ProjectUtilities.addSubpackages(packages, child.getName(), child);
                continue;
            }
            ProjectUtilities.addSubpackages(packages, prefix + "." + child.getName(), child);
        }
    }

    private static boolean hasSubprojects(Project project) {
        SubprojectProvider spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (spp == null) {
            return false;
        }
        return spp.getSubprojects().size() > 0;
    }

    private static FileObject findUnitTestInTestRoot(ClassPath cp, FileObject selectedFO, URL testRoot) {
        ClassPath testClassPath = null;
        if (testRoot == null) {
            testClassPath = cp;
        } else {
            try {
                ArrayList<PathResourceImplementation> cpItems = new ArrayList<PathResourceImplementation>();
                cpItems.add(ClassPathSupport.createResource((URL)testRoot));
                testClassPath = ClassPathSupport.createClassPath(cpItems);
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                testClassPath = cp;
            }
        }
        String testName = ProjectUtilities.getTestName(cp, selectedFO);
        return testClassPath.findResource(testName + ".java");
    }

    private static String getTestName(ClassPath cp, FileObject selectedFO) {
        String resource = cp.getResourceName(selectedFO, '/', false);
        String testName = null;
        testName = selectedFO.isFolder() ? ProjectUtilities.convertPackage2SuiteName(resource) : ProjectUtilities.convertClass2TestName(resource);
        return testName;
    }

    private static String convertClass2TestName(String classFileName) {
        if (classFileName == null || "".equals(classFileName)) {
            return "";
        }
        int index = classFileName.lastIndexOf(47);
        String pkg = index > -1 ? classFileName.substring(0, index) : "";
        String clazz = index > -1 ? classFileName.substring(index + 1) : classFileName;
        clazz = clazz.substring(0, 1).toUpperCase() + clazz.substring(1);
        if (pkg.length() > 0) {
            pkg = pkg + "/";
        }
        return pkg + clazz + "Test";
    }

    private static String convertPackage2SuiteName(String packageFileName) {
        if (packageFileName == null || "".equals(packageFileName)) {
            return "";
        }
        int index = packageFileName.lastIndexOf(47);
        String pkg = index > -1 ? packageFileName.substring(index + 1) : packageFileName;
        pkg = pkg.substring(0, 1).toUpperCase() + pkg.substring(1);
        return packageFileName + "/" + pkg + "Test";
    }
}

