/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Rule;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateManyToManyRelationshipHint;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateOneToManyRelationshipHint;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateUnidirOneToManyRelationshipHint;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class MVRelationshipForEntityTypeAttrDefined
extends JPAEntityAttributeCheck {
    @Override
    public ErrorDescription[] check(JPAProblemContext ctx, AttributeWrapper attrib) {
        Element typeElement;
        List<? extends TypeMirror> typeArgs;
        if (ctx.isEmbeddable()) {
            return null;
        }
        TypeMirror type = attrib.getType();
        if (type.getKind() == TypeKind.DECLARED && (typeArgs = ((DeclaredType)type).getTypeArguments()).size() == 1 && (typeElement = ctx.getCompilationInfo().getTypes().asElement(typeArgs.get(0))) != null && typeElement.getKind() == ElementKind.CLASS) {
            Entity entity = ModelUtils.getEntity(ctx.getMetaData(), (TypeElement)typeElement);
            String remoteClassName = ((TypeElement)typeElement).getQualifiedName().toString();
            if (entity != null) {
                ElementHandle classHandle = ElementHandle.create((Element)ctx.getJavaClass());
                ElementHandle elemHandle = ElementHandle.create((Element)attrib.getJavaElement());
                CreateUnidirOneToManyRelationshipHint fix1 = new CreateUnidirOneToManyRelationshipHint(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle, (ElementHandle<Element>)elemHandle);
                CreateOneToManyRelationshipHint fix2 = new CreateOneToManyRelationshipHint(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle, ctx.getAccessType(), attrib.getName(), remoteClassName);
                CreateManyToManyRelationshipHint fix3 = new CreateManyToManyRelationshipHint(ctx.getFileObject(), (ElementHandle<TypeElement>)classHandle, ctx.getAccessType(), attrib.getName(), remoteClassName);
                return new ErrorDescription[]{Rule.createProblem(attrib.getJavaElement(), (ProblemContext)ctx, NbBundle.getMessage(MVRelationshipForEntityTypeAttrDefined.class, (String)"MSG_MVEntityRelationNotDefined"), Severity.WARNING, Arrays.asList(fix1, fix2, fix3))};
            }
        }
        return null;
    }
}

