/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import java.util.ArrayList;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Rule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class ValidModifiers
extends JPAEntityAttributeCheck {
    @Override
    public ErrorDescription[] check(JPAProblemContext ctx, AttributeWrapper attrib) {
        Set<Modifier> fieldModifiers = attrib.getInstanceVariable() == null ? null : attrib.getInstanceVariable().getModifiers();
        Set<Modifier> accesorModifiers = attrib.getAccesor() == null ? null : attrib.getAccesor().getModifiers();
        Set<Modifier> mutatorModifiers = attrib.getMutator() == null ? null : attrib.getMutator().getModifiers();
        ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        if (fieldModifiers != null && fieldModifiers.contains((Object)Modifier.PUBLIC)) {
            errors.add(Rule.createProblem(attrib.getInstanceVariable(), ctx, NbBundle.getMessage(ValidModifiers.class, (String)"MSG_PublicVariable")));
        }
        if (accesorModifiers != null) {
            if (!accesorModifiers.contains((Object)Modifier.PUBLIC) && !accesorModifiers.contains((Object)Modifier.PROTECTED)) {
                errors.add(Rule.createProblem(attrib.getAccesor(), ctx, NbBundle.getMessage(ValidModifiers.class, (String)"MSG_NonPublicAccesor")));
            }
            if (accesorModifiers.contains((Object)Modifier.FINAL)) {
                errors.add(Rule.createProblem(attrib.getAccesor(), ctx, NbBundle.getMessage(ValidModifiers.class, (String)"MSG_FinalAccesor")));
            }
        }
        if (mutatorModifiers != null) {
            if (mutatorModifiers.contains((Object)Modifier.PRIVATE)) {
                errors.add(Rule.createProblem((Element)attrib.getMutator(), (ProblemContext)ctx, NbBundle.getMessage(ValidModifiers.class, (String)"MSG_NonPublicMutator"), Severity.WARNING));
            }
            if (mutatorModifiers.contains((Object)Modifier.FINAL)) {
                errors.add(Rule.createProblem(attrib.getMutator(), ctx, NbBundle.getMessage(ValidModifiers.class, (String)"MSG_FinalMutator")));
            }
        }
        return errors.toArray(new ErrorDescription[errors.size()]);
    }
}

