/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.ArrayList;
import java.util.Arrays;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.GeneratedValueIsId;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.MVRelationshipForEntityTypeAttrDefined;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.RelationshipForEntityTypeAttrDefined;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.TemporalFieldsAnnotated;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidBasicType;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidColumnName;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidModifiers;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidVersionType;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Basic;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Embeddable;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Id;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Version;
import org.netbeans.spi.editor.hints.ErrorDescription;

public class ValidAttributes
extends JPAClassRule {
    private static JPAEntityAttributeCheck[] attribChecks = new JPAEntityAttributeCheck[]{new ValidColumnName(), new ValidModifiers(), new ValidBasicType(), new RelationshipForEntityTypeAttrDefined(), new MVRelationshipForEntityTypeAttrDefined(), new ValidVersionType(), new GeneratedValueIsId(), new TemporalFieldsAnnotated()};

    public ValidAttributes() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.MAPPED_SUPERCLASS));
    }

    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        JPAProblemContext jpaCtx;
        ArrayList<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
        ArrayList<AttributeWrapper> attrs = new ArrayList<AttributeWrapper>();
        Basic[] basicFields = null;
        Id[] idFields = null;
        Version[] versionFields = null;
        if (ctx.getModelElement() instanceof Entity) {
            Entity entity = (Entity)ctx.getModelElement();
            basicFields = entity.getAttributes().getBasic();
            idFields = entity.getAttributes().getId();
            versionFields = entity.getAttributes().getVersion();
        } else if (ctx.getModelElement() instanceof Embeddable) {
            Embeddable embeddable = (Embeddable)ctx.getModelElement();
            basicFields = embeddable.getAttributes().getBasic();
        } else if (ctx.getModelElement() instanceof MappedSuperclass) {
            MappedSuperclass mappedSuperclass = (MappedSuperclass)ctx.getModelElement();
            basicFields = mappedSuperclass.getAttributes().getBasic();
            idFields = mappedSuperclass.getAttributes().getId();
            versionFields = mappedSuperclass.getAttributes().getVersion();
        }
        if (basicFields != null) {
            for (Basic basic : basicFields) {
                attrs.add(new AttributeWrapper(basic));
            }
        }
        if (idFields != null) {
            for (Basic basic : idFields) {
                attrs.add(new AttributeWrapper(basic));
            }
        }
        if (versionFields != null) {
            for (Basic basic : versionFields) {
                attrs.add(new AttributeWrapper(basic));
            }
        }
        if ((jpaCtx = (JPAProblemContext)ctx).getAccessType() == AccessType.INCONSISTENT) {
            JPAProblemFinder.LOG.fine("Skipping attribute checks due to inconsistent access type");
        } else {
            for (AttributeWrapper attr : attrs) {
                ModelUtils.resolveJavaElementFromModel(jpaCtx, attr);
                if (attr.getJavaElement() == null) {
                    JPAProblemFinder.LOG.severe("Failed to resolve java model element for JPA merged model element " + subject.getSimpleName() + "." + attr.getName());
                    continue;
                }
                for (JPAEntityAttributeCheck check : attribChecks) {
                    ErrorDescription[] attrProblems = check.check(jpaCtx, attr);
                    if (attrProblems == null) continue;
                    for (ErrorDescription err : attrProblems) {
                        problemsFound.add(err);
                    }
                }
            }
        }
        return problemsFound.toArray(new ErrorDescription[problemsFound.size()]);
    }
}

