/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.debugger.common2.debugger.Address;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.BreakpointModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisProgressPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.StateModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.InstructionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerImpl;
import org.netbeans.modules.cnd.debugger.gdb2.GdbFrame;
import org.netbeans.modules.cnd.support.ReadOnlySupport;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class Disassembly
implements StateModel.Listener,
DocumentListener {
    private final GdbDebuggerImpl debugger;
    private final List<Line> lines = new ArrayList<Line>();
    private String functionName = "";
    private String intFileName = "";
    private String resolvedFileName = "";
    private String address = "";
    private boolean withSource = true;
    private boolean opened = false;
    private boolean opening = false;
    private int disLength = 0;
    private final Map<Integer, String> regNames = new HashMap<Integer, String>();
    private final Map<Integer, String> regValues = new HashMap<Integer, String>();
    private final Set<Integer> regModified = new HashSet<Integer>();
    private static final String ADDRESS_HEADER = "address";
    private static final String FUNCTION_HEADER = "func-name";
    private static final String OFFSET_HEADER = "offset";
    private static final String INSTR_HEADER = "inst";
    private static final String LINE_HEADER = "line";
    private static final String FILE_HEADER = "file";
    private static final String NUMBER_HEADER = "number";
    private static final String VALUE_HEADER = "value";
    public static final String REGISTER_NAMES_HEADER = "^done,register-names=";
    public static final String REGISTER_VALUES_HEADER = "^done,register-values=";
    public static final String REGISTER_MODIFIED_HEADER = "^done,changed-registers=";
    public static final String RESPONSE_HEADER = "^done,asm_insns=";
    private static final String COMBINED_HEADER = "src_and_asm_line={";
    private static final String COMMENT_PREFIX = "!";
    private static FileObject fo = null;
    private static final Logger log = Logger.getLogger("gdb.logger");
    private boolean cancelled = false;
    private RequestMode requestMode = RequestMode.FILE;
    private final BreakpointModel breakpointModel;
    private final BreakpointModel.Listener breakpointListener = new BreakpointModel.Listener(){

        public void bptUpdated() {
            if (Disassembly.this.opened) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Disassembly.this.updateAnnotations(true);
                    }
                });
            }
        }
    };
    private final List<DebuggerAnnotation> annotations = new ArrayList<DebuggerAnnotation>();

    public Disassembly(GdbDebuggerImpl debugger, BreakpointModel breakpointModel) {
        this.debugger = debugger;
        this.breakpointModel = breakpointModel;
        breakpointModel.addListener(this.breakpointListener);
    }

    protected void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String msg) {
        assert (msg.contains(RESPONSE_HEADER)) : "Invalid asm response message";
        this.cancelled = false;
        Dialog dialog = null;
        GdbFrame frame = this.debugger.getCurrentFrame();
        if (frame == null) {
            return;
        }
        String currentAddr = this.debugger.getCurrentFrame().getCurrentPC();
        List<Line> list = this.lines;
        synchronized (list) {
            DataObject dobj;
            this.lines.clear();
            this.disLength = 0;
            try {
                dobj = DataObject.find((FileObject)Disassembly.getFileObject());
            }
            catch (DataObjectNotFoundException doe) {
                Exceptions.printStackTrace((Throwable)doe);
                return;
            }
            StyledDocument doc = ((DataEditorSupport)dobj.getCookie(OpenCookie.class)).getDocument();
            if (doc != null) {
                doc.removeDocumentListener(this);
                doc.addDocumentListener(this);
            }
            DisText text = new DisText();
            int pos = RESPONSE_HEADER.length();
            boolean nameSet = false;
            long start = System.currentTimeMillis();
            boolean dialogOpened = false;
            DisProgressPanel panel = null;
            while (!this.cancelled) {
                int combinedPos = msg.indexOf(COMBINED_HEADER, pos);
                int addressPos = msg.indexOf(ADDRESS_HEADER, pos);
                try {
                    if (panel != null) {
                        panel.setProgress(pos * 100 / msg.length());
                    }
                    if (!this.cancelled && !dialogOpened && System.currentTimeMillis() - start > 2000L) {
                        dialogOpened = true;
                        panel = new DisProgressPanel();
                        final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(Disassembly.class, (String)"DIS_PROGRESS_TITLE"));
                        dd.setOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
                        final Dialog dlg = dialog = DialogDisplayer.getDefault().createDialog(dd);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                dlg.setVisible(true);
                                if (dd.getValue() == DialogDescriptor.CANCEL_OPTION) {
                                    Disassembly.this.cancel();
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                if (addressPos == -1) break;
                if (combinedPos != -1 && combinedPos < addressPos) {
                    int lineIdx = Integer.valueOf(Disassembly.readValue(LINE_HEADER, msg, combinedPos));
                    if (lineIdx > 0) {
                        String fileStr = Disassembly.readValue(FILE_HEADER, msg, combinedPos);
                        if (this.resolvedFileName != null && CndPathUtilitities.getBaseName((String)this.resolvedFileName).equals(fileStr)) {
                            FileObject src_fo = CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)this.resolvedFileName));
                            if (src_fo != null && src_fo.isValid()) {
                                try {
                                    String lineText = ((LineCookie)DataObject.find((FileObject)src_fo).getCookie(LineCookie.class)).getLineSet().getCurrent(lineIdx - 1).getText();
                                    if (lineText != null && lineText.length() > 0) {
                                        text.addLine(COMMENT_PREFIX + lineText);
                                    }
                                }
                                catch (Exception ex) {}
                            } else {
                                text.addLine(COMMENT_PREFIX + NbBundle.getMessage(Disassembly.class, (String)"MSG_Source_Not_Found", (Object)fileStr, (Object)lineIdx));
                            }
                        }
                    }
                    pos = combinedPos + 1;
                    continue;
                }
                int idx = text.getLineNo();
                Line line = new Line(msg, addressPos, nameSet ? idx : idx + 1);
                if (!nameSet && currentAddr.equals(line.address)) {
                    this.functionName = line.function;
                    dobj.getNodeDelegate().setDisplayName(this.getHeader());
                    text.addLine(this.functionName + "()\n");
                    nameSet = true;
                }
                if (!nameSet || this.functionName.equals(line.function)) {
                    this.lines.add(line);
                    text.addLine(line + "\n");
                }
                pos = addressPos + 1;
            }
            if (!this.cancelled) {
                this.disLength = text.getLength();
                try {
                    text.save(Disassembly.getFileObject().getOutputStream());
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        if (dialog != null) {
            final Dialog dlg = dialog;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    dlg.setVisible(false);
                    dlg.dispose();
                }
            });
        }
        if (this.cancelled) {
            Disassembly.close();
            return;
        }
        if (this.lines.isEmpty() && this.withSource) {
            this.reloadDis(false, true);
        }
    }

    public void updateRegNames(String msg) {
        int end;
        assert (msg.startsWith(REGISTER_NAMES_HEADER)) : "Invalid asm response message";
        this.regNames.clear();
        int idx = 0;
        int pos = msg.indexOf("\"", REGISTER_NAMES_HEADER.length());
        while (pos != -1 && (end = msg.indexOf("\"", pos + 1)) != -1) {
            String value = msg.substring(pos + 1, end);
            this.regNames.put(idx++, value);
            pos = msg.indexOf("\"", end + 1);
        }
    }

    public void updateRegModified(String msg) {
        int end;
        assert (msg.startsWith(REGISTER_MODIFIED_HEADER)) : "Invalid asm response message";
        this.regModified.clear();
        int pos = msg.indexOf("\"", REGISTER_MODIFIED_HEADER.length());
        while (pos != -1 && (end = msg.indexOf("\"", pos + 1)) != -1) {
            String index = msg.substring(pos + 1, end);
            try {
                this.regModified.add(Integer.valueOf(index));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            pos = msg.indexOf("\"", end + 1);
        }
    }

    public void updateRegValues(String msg) {
        assert (msg.startsWith(REGISTER_VALUES_HEADER)) : "Invalid asm response message";
        this.regValues.clear();
        int pos = msg.indexOf(NUMBER_HEADER);
        while (pos != -1) {
            String idx = Disassembly.readValue(NUMBER_HEADER, msg, pos);
            String value = Disassembly.readValue(VALUE_HEADER, msg, pos);
            try {
                this.regValues.put(Integer.valueOf(idx), value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            pos = msg.indexOf(NUMBER_HEADER, pos + 1);
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        if (e.getOffset() + e.getLength() >= this.disLength) {
            final boolean dis = this.opening;
            this.opening = false;
            if (this.opened) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Disassembly.this.updateAnnotations(dis);
                    }
                });
            }
        }
    }

    private void updateAnnotations(boolean open) {
        NativeBreakpoint[] bs;
        this.debugger.annotateDis(false);
        for (DebuggerAnnotation debuggerAnnotation : this.annotations) {
            debuggerAnnotation.detach();
        }
        this.annotations.clear();
        for (NativeBreakpoint bpt : bs = this.breakpointModel.getBreakpoints()) {
            if (!(bpt instanceof InstructionBreakpoint)) continue;
            InstructionBreakpoint ibpt = (InstructionBreakpoint)bpt;
            try {
                int addressLine = this.getAddressLine(Address.parseAddr((String)ibpt.getAddress()));
                if (addressLine < 0) continue;
                DataObject dobj = DataObject.find((FileObject)Disassembly.getFileObject());
                org.openide.text.Line line = EditorBridge.lineNumberToLine((DataObject)dobj, (int)addressLine);
                this.annotations.add(new DebuggerAnnotation(null, ibpt.getAnnotationType(), line, true));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void removeUpdate(DocumentEvent e) {
    }

    public void stateUpdated() {
        this.reloadDis(true, false);
    }

    private void reloadDis(boolean withSource, boolean force) {
        this.withSource = withSource;
        if (!this.opened) {
            return;
        }
        GdbFrame frame = this.debugger.getCurrentFrame();
        if (frame == null) {
            return;
        }
        String curAddress = frame.getCurrentPC();
        if (curAddress == null || curAddress.length() == 0) {
            return;
        }
        if (!curAddress.equals(this.address)) {
            this.requestMode = RequestMode.FILE;
        }
        if (this.requestMode == RequestMode.NONE) {
            return;
        }
        if (force || this.getAddressLine(curAddress) == -1) {
            this.intFileName = null;
            this.resolvedFileName = frame.getFullPath();
            if ((this.intFileName == null || this.intFileName.length() == 0) && this.requestMode == RequestMode.FILE) {
                this.requestMode = RequestMode.ADDRESS;
            }
            switch (this.requestMode) {
                case FILE: {
                    this.debugger.disController().requestDis();
                    this.requestMode = RequestMode.ADDRESS;
                    break;
                }
                case ADDRESS: {
                    this.debugger.disController().requestDis();
                    this.requestMode = RequestMode.NONE;
                }
            }
        }
        this.address = curAddress;
    }

    public static FileObject getFileObject() {
        if (fo == null) {
            try {
                fo = FileUtil.createMemoryFileSystem().getRoot().createData("disasm", "s");
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLineAddress(int idx) {
        List<Line> list = this.lines;
        synchronized (list) {
            for (Line line : this.lines) {
                if (line.idx != idx) continue;
                return line.address;
            }
            return "";
        }
    }

    public static Disassembly getCurrent() {
        NativeDebugger currentDebugger = DebuggerManager.get().currentDebugger();
        if (currentDebugger instanceof GdbDebuggerImpl) {
            return ((GdbDebuggerImpl)currentDebugger).getDisassembly();
        }
        return null;
    }

    public static String getLineAddress(Disassembly dis, int idx) {
        if (dis != null) {
            return dis.getLineAddress(idx);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAddressLine(String address) {
        List<Line> list = this.lines;
        synchronized (list) {
            for (Line line : this.lines) {
                if (!line.address.equals(address)) continue;
                return line.idx;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAddressLine(long address) {
        List<Line> list = this.lines;
        synchronized (list) {
            for (Line line : this.lines) {
                try {
                    if (Address.parseAddr((String)line.address) != address) continue;
                    return line.idx;
                }
                catch (NumberFormatException e) {
                }
            }
            return -1;
        }
    }

    private static String readValue(String name, String msg, int pos) {
        int end;
        String paramHeader = name + "=\"";
        int start = msg.indexOf(paramHeader, pos);
        if (start != -1 && (end = msg.indexOf("\"", (start += paramHeader.length()) + 1)) != -1) {
            return msg.substring(start, end);
        }
        return "";
    }

    public static boolean isInDisasm() {
        if (Disassembly.getCurrent().opened) {
            FileObject fobj = EditorContextDispatcher.getDefault().getCurrentFile();
            if (fobj == null) {
                fobj = EditorContextDispatcher.getDefault().getMostRecentFile();
            }
            if (fobj != null) {
                try {
                    return DataObject.find((FileObject)fobj).equals(DataObject.find((FileObject)Disassembly.getFileObject()));
                }
                catch (DataObjectNotFoundException doe) {
                    Exceptions.printStackTrace((Throwable)doe);
                }
            }
        }
        return false;
    }

    public static boolean isDisasm(String url) {
        try {
            return Disassembly.getFileObject().getURL().toString().equals(url);
        }
        catch (FileStateInvalidException fsi) {
            Exceptions.printStackTrace((Throwable)fsi);
            return false;
        }
    }

    public static void open() {
        try {
            DataObject dobj = DataObject.find((FileObject)Disassembly.getFileObject());
            ReadOnlySupport ro = (ReadOnlySupport)dobj.getLookup().lookup(ReadOnlySupport.class);
            if (ro != null) {
                ro.setReadOnly(true);
            }
            dobj.getNodeDelegate().setDisplayName(NbBundle.getMessage(Disassembly.class, (String)"LBL_Disassembly_Window"));
            final EditorCookie editorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
            if (editorCookie instanceof EditorCookie.Observable) {
                ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("openedPanes".equals(evt.getPropertyName()) && editorCookie.getOpenedPanes() == null) {
                            Disassembly dis = Disassembly.getCurrent();
                            if (dis != null) {
                                dis.opened = false;
                            }
                            ((EditorCookie.Observable)editorCookie).removePropertyChangeListener((PropertyChangeListener)this);
                        }
                    }
                });
            }
            ((OpenCookie)dobj.getCookie(OpenCookie.class)).open();
            Disassembly dis = Disassembly.getCurrent();
            if (dis != null) {
                dis.opening = true;
                dis.opened = true;
                dis.reloadDis(true, false);
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private String getHeader() {
        String res = NbBundle.getMessage(Disassembly.class, (String)"LBL_Disassembly_Window");
        if (this.functionName.length() > 0) {
            res = res + "(" + this.functionName + ")";
        }
        return res;
    }

    public static void close() {
        try {
            DataObject dobj = DataObject.find((FileObject)Disassembly.getFileObject());
            ((CloseCookie)dobj.getCookie(CloseCookie.class)).close();
            Disassembly dis = Disassembly.getCurrent();
            if (dis != null) {
                dis.opened = false;
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private static class DisText {
        private int lineNo = 1;
        private int length = 0;
        private final StringBuilder data = new StringBuilder();

        private DisText() {
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public int getLength() {
            return this.length;
        }

        public void addLine(String line) {
            this.data.append(line);
            ++this.lineNo;
            this.length += line.length();
        }

        public void save(OutputStream out) throws IOException {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(this.data.toString());
            ((Writer)writer).close();
        }
    }

    private static class Line {
        private final String address;
        private final String function;
        private final int offset;
        private final String instruction;
        private final int idx;

        public Line(String msg, int pos, int idx) {
            this.address = Disassembly.readValue(Disassembly.ADDRESS_HEADER, msg, pos);
            this.function = Disassembly.readValue(Disassembly.FUNCTION_HEADER, msg, pos);
            int tmpoffset = 0;
            try {
                tmpoffset = Integer.valueOf(Disassembly.readValue(Disassembly.OFFSET_HEADER, msg, pos));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.offset = tmpoffset;
            this.instruction = Disassembly.readValue(Disassembly.INSTR_HEADER, msg, pos);
            this.idx = idx;
        }

        public String toString() {
            return this.function + "+" + this.offset + ": " + this.instruction;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RequestMode {
        FILE,
        ADDRESS,
        NONE;

    }
}

