/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermStream;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerImpl;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.ProgressManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.IOPack;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.Executor;
import org.netbeans.modules.cnd.debugger.common2.utils.FileMapper;
import org.netbeans.modules.cnd.debugger.common2.utils.PhasedProgress;
import org.netbeans.modules.cnd.debugger.gdb2.Catalog;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerImpl;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerInfo;
import org.netbeans.modules.cnd.debugger.gdb2.GdbEngineCapabilityProvider;
import org.netbeans.modules.cnd.debugger.gdb2.Log;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommand;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommandInjector;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIProxy;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class Gdb {
    protected final PhasedProgress.CancelListener cancelListener = new PhasedProgress.CancelListener(){

        public void cancelled() {
            Gdb.this.interrupt();
        }
    };
    private final StartProgressManager startProgressManager = new StartProgressManager();
    private GdbDebuggerImpl debugger;
    private IOPack ioPack;
    private Executor executor;
    private final Factory factory;
    private final Tap tap;
    private final MIProxy myMIProxy;
    private boolean connected;
    private volatile boolean signalled = false;
    private volatile boolean silentStop = false;
    static final String versionString = "GNU gdb";

    public StartProgressManager startProgressManager() {
        return this.startProgressManager;
    }

    private void initializeGdb(String version, FileMapper fmap) {
        if (Log.Start.debug) {
            System.out.printf("Gdb.initializeGdb()\n", new Object[0]);
        }
        this.debugger.setGdbVersion(version);
        this.debugger.initializeGdb(fmap);
        if (!this.debugger.willBeLoading()) {
            this.startProgressManager().finishProgress();
        }
    }

    private Gdb(Factory factory, boolean connectExisting, boolean remote) {
        this.factory = factory;
        this.tap = new Tap();
        this.myMIProxy = new MyMIProxy(this.tap, Gdb.getCharSetEncoding(remote));
        this.tap.setMiProxy(this.myMIProxy);
    }

    private static String getCharSetEncoding(boolean remote) {
        String encoding = remote ? ProcessUtils.getRemoteCharSet() : Charset.defaultCharset().name();
        return encoding;
    }

    private Factory factory() {
        return this.factory;
    }

    protected void setIOPack(IOPack ioPack) {
        this.ioPack = ioPack;
    }

    protected IOPack getIOPack() {
        return this.ioPack;
    }

    protected void setExecutor(Executor executor) {
        this.executor = executor;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    boolean isSignalled() {
        return this.signalled;
    }

    void resetSignalled() {
        this.signalled = false;
    }

    boolean isSilentStop() {
        return this.silentStop;
    }

    void resetSilentStop() {
        this.silentStop = false;
    }

    Tap tap() {
        return this.tap;
    }

    public boolean connected() {
        return this.connected;
    }

    public final void setDebugger(GdbDebuggerImpl debugger) {
        this.debugger = debugger;
        debugger.getNDI().setLoadSuccess(false);
    }

    void interrupt() {
        if (this.executor == null) {
            this.factory.cancelStartup();
            this.startProgressManager().finishProgress();
            return;
        }
        if (!this.executor.isAlive()) {
            this.factory.cancelStartup();
            this.startProgressManager().finishProgress();
            return;
        }
        try {
            this.executor.terminate();
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, "Sending kill signal to process group failed");
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    boolean pause(int pid, boolean silentStop) {
        if (this.debugger.state().isRunning && this.debugger.state().isProcess) {
            Executor signaller = Executor.getDefault((String)"signaller", (Host)this.factory.host, (int)0);
            try {
                this.signalled = true;
                this.silentStop = silentStop;
                signaller.interrupt(pid);
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Sending kill signal to process failed");
                ErrorManager.getDefault().notify((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static void dyingWords(String msg, IOPack ioPack) {
        Term term;
        JPanel panel = new JPanel();
        Catalog.setAccessibleDescription(panel, "ACSD_GdbsDyingWords");
        panel.setLayout(new BorderLayout(0, 12));
        panel.add((Component)new JLabel(msg), "North");
        if (ioPack != null && (term = ioPack.console().getTerm()) != null) {
            panel.add((Component)term, "Center");
            panel.setSize(600, 400);
            term.setSize(600, 400);
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)panel));
    }

    void sendCommand(MICommand cmd) {
        this.myMIProxy.send(cmd);
    }

    private class MyMIProxy
    extends MIProxy {
        private String version;
        private FileMapper fmap;
        private static final String SWITCHING_PREFIX = "[Switching to process ";

        public MyMIProxy(MICommandInjector injector, String encoding) {
            super(injector, "(gdb)", encoding);
            this.fmap = null;
        }

        protected void consoleStreamOutput(MIRecord record) {
            if (record.isStream() && record.stream().startsWith(SWITCHING_PREFIX)) {
                String msg = record.stream();
                try {
                    int end = SWITCHING_PREFIX.length();
                    while (Character.isDigit(msg.charAt(end))) {
                        ++end;
                    }
                    Gdb.this.debugger.session().setSessionEngine(GdbEngineCapabilityProvider.getGdbEngineType());
                    Gdb.this.debugger.session().setPid(Long.valueOf(msg.substring(SWITCHING_PREFIX.length(), end)).longValue());
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                String stream;
                super.consoleStreamOutput(record);
                if (record.isStream() && (stream = record.stream()).contains("configured") && stream.contains("mingw")) {
                    this.fmap = FileMapper.getDefault((FileMapper.Type)FileMapper.Type.MSYS);
                }
                if (this.version == null && record.isStream() && record.stream().startsWith(Gdb.versionString)) {
                    this.version = record.stream();
                    return;
                }
            }
        }

        protected void execAsyncOutput(MIRecord record) {
            if (record.token() == 0) {
                if (record.cls().equals("stopped")) {
                    Gdb.this.debugger.genericStopped(record);
                    this.clearMessages();
                } else if (record.cls().equals("running")) {
                    Gdb.this.debugger.genericRunning();
                    this.clearMessages();
                }
            } else {
                this.dispatch(record);
            }
        }

        protected void notifyAsyncOutput(MIRecord record) {
            if (record.token() == 0) {
                if (!(record.cls().equals("thread-group-added") || record.cls().equals("thread-group-removed") || record.cls().equals("thread-group-started") || record.cls().equals("thread-group-exited") || record.cls().equals("thread-created") || record.cls().equals("thread-exited") || record.cls().equals("thread-selected") || record.cls().equals("library-loaded") || !record.cls().equals("library-unloaded"))) {
                    // empty if block
                }
            } else {
                this.dispatch(record);
            }
        }

        protected void targetStreamOutput(MIRecord record) {
        }

        protected void logStreamOutput(MIRecord record) {
            super.logStreamOutput(record);
        }

        protected void connectionEstablished() {
            Gdb.this.connected = true;
            if (Log.Start.debug) {
                System.out.printf("MyMIProxy.connectionEstablished()\n", new Object[0]);
            }
            Gdb.this.factory.connectionAvailable(true, this.version, this.fmap);
        }

        protected void errorBadLine(String data) {
            if (!Log.Startup.nopty) {
                super.errorBadLine(data);
            }
        }
    }

    static class Tap
    extends TermStream
    implements MICommandInjector {
        private static final char char_NL = '\n';
        private static final char char_CR = '\r';
        private static final char char_ESC = '\u001b';
        private static final char char_BS = '\b';
        private static final char char_SP = ' ';
        private static final char[] bs_sequence = new char[]{'\b', ' ', '\b'};
        private static final char[] bold_sequence = new char[]{'\u001b', '[', '1', 'm'};
        private static final char[] bluebold_sequence = new char[]{'\u001b', '[', '1', ';', '3', '4', 'm'};
        private static final char[] red_sequence = new char[]{'\u001b', '[', '3', '1', 'm'};
        private static final char[] brown_sequence = new char[]{'\u001b', '[', '5', '0', 'm'};
        private static final char[] green_sequence = new char[]{'\u001b', '[', '5', '1', 'm'};
        private static final char[] log_sequence = new char[]{'\u001b', '[', '5', '2', 'm'};
        private static final char[] reset_sequence = new char[]{'\u001b', '[', '0', 'm'};
        private StringBuilder inputLine = new StringBuilder();
        private StringBuilder interceptBuffer = new StringBuilder();
        private LinkedList<String> interceptedLines = new LinkedList();
        StringBuilder putBuf = new StringBuilder();
        private MIProxy miProxy;
        private char[] send_buf = new char[64];
        private final RequestProcessor sendQueue = new RequestProcessor("GDB send queue", 1);
        private final RequestProcessor processingQueue = new RequestProcessor("GDB output processing", 1);

        public void flush() {
            this.toDTE.flush();
        }

        public void putChar(char c) {
            this.processChar(c);
            this.dispatchInterceptedLines();
        }

        public void putChars(char[] buf, int offset, int count) {
            for (int bx = 0; bx < count; ++bx) {
                this.processChar(buf[offset + bx]);
            }
            this.dispatchInterceptedLines();
        }

        private void sendLine() {
            int nchars = this.inputLine.length();
            if (nchars >= this.send_buf.length) {
                this.send_buf = new char[nchars + 1];
            }
            this.inputLine.getChars(0, nchars, this.send_buf, 0);
            this.toDCE.sendChars(this.send_buf, 0, nchars);
            this.inputLine.setLength(0);
        }

        public void sendChar(char c) {
            if (c == '\r') {
                this.toDTE.putChar(c);
                this.toDTE.flush();
                c = (char)10;
                this.toDTE.putChar(c);
                this.toDTE.flush();
                this.inputLine.append(c);
                this.sendLine();
            } else if (c == '\n') {
                this.toDTE.putChar('\r');
                this.toDTE.flush();
                this.toDTE.putChar(c);
                this.toDTE.flush();
                this.inputLine.append(c);
                this.sendLine();
            } else if (c == '\b') {
                int nchars = this.inputLine.length();
                if (nchars == 0) {
                    return;
                }
                char erased_char = ' ';
                try {
                    erased_char = this.inputLine.charAt(nchars - 1);
                }
                catch (Exception x) {
                    return;
                }
                int cwidth = this.getTerm().charWidth(erased_char);
                this.inputLine.delete(nchars - 1, nchars);
                while (--cwidth > 0) {
                    this.inputLine.append(' ');
                }
                this.toDTE.putChars(bs_sequence, 0, 3);
                this.toDTE.flush();
            } else {
                this.toDTE.putChars(bluebold_sequence, 0, bluebold_sequence.length);
                this.toDTE.putChar(c);
                this.toDTE.putChars(reset_sequence, 0, reset_sequence.length);
                this.toDTE.flush();
                this.inputLine.append(c);
            }
        }

        public void sendChars(char[] c, int offset, int count) {
            for (int cx = 0; cx < count; ++cx) {
                this.sendChar(c[offset + cx]);
            }
        }

        public void setMiProxy(MIProxy miProxy) {
            this.miProxy = miProxy;
        }

        public void inject(String cmd) {
            final char[] cmda = cmd.toCharArray();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Tap.this.toDTE.putChars(bold_sequence, 0, bold_sequence.length);
                    Tap.this.toDTE.putChars(cmda, 0, cmda.length);
                    Tap.this.toDTE.putChar('\r');
                    Tap.this.toDTE.putChars(reset_sequence, 0, reset_sequence.length);
                    Tap.this.toDTE.flush();
                    Tap.this.sendQueue.post(new Runnable(){

                        public void run() {
                            Tap.this.toDCE.sendChars(cmda, 0, cmda.length);
                        }
                    });
                }
            });
        }

        public void log(String cmd) {
            final char[] cmda = cmd.toCharArray();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Tap.this.toDTE.putChars(log_sequence, 0, log_sequence.length);
                    Tap.this.toDTE.putChars(cmda, 0, cmda.length);
                    Tap.this.toDTE.putChars(reset_sequence, 0, reset_sequence.length);
                    Tap.this.toDTE.flush();
                }
            });
        }

        private void processChar(char c) {
            this.appendChar(c);
            this.interceptBuffer.append(c);
            if (c == '\n') {
                this.appendChar('\r');
                String line = this.interceptBuffer.toString();
                this.interceptedLines.addLast(line);
                this.interceptBuffer = new StringBuilder();
                if (line.startsWith("~")) {
                    this.putBuf.insert(0, green_sequence);
                    this.putBuf.append(reset_sequence);
                } else if (line.startsWith("&")) {
                    this.putBuf.insert(0, brown_sequence);
                    this.putBuf.append(reset_sequence);
                } else {
                    int caretx = line.indexOf(94);
                    if (caretx != -1 && line.startsWith("^error,", caretx)) {
                        this.putBuf.insert(0, red_sequence);
                        this.putBuf.append(reset_sequence);
                    }
                }
                char[] chars = new char[this.putBuf.length()];
                this.putBuf.getChars(0, this.putBuf.length(), chars, 0);
                this.toDTE.putChars(chars, 0, this.putBuf.length());
                this.putBuf = new StringBuilder();
            }
        }

        private void appendChar(char c) {
            this.putBuf.append(c);
        }

        private void dispatchInterceptedLines() {
            while (!this.interceptedLines.isEmpty()) {
                final String line = this.interceptedLines.removeFirst();
                this.processingQueue.post(new Runnable(){

                    public void run() {
                        Tap.this.miProxy.processLine(line);
                    }
                });
            }
        }
    }

    static class Factory {
        private final Executor executor;
        private final String[] additionalArgv;
        private final Listener listener;
        private final boolean exec32;
        private final boolean shortNames;
        private final String gdbInitFile;
        private final Host host;
        private final boolean connectExisting;
        private Gdb tentativeGdb;
        private String gdbname;
        private String[] gdb_argv;
        private Map<String, String> additionalEnv;
        private IOPack ioPack;
        private boolean remote;
        private final String runDir;
        private NativeDebuggerInfo ndi;
        private final RequestProcessor START_RP = new RequestProcessor("GDB start", 5);

        public Factory(Executor executor, String[] additionalArgv, Listener listener, boolean exec32, boolean shortNames, String gdbInitFile, Host host, boolean connectExisting, String runDir, GdbDebuggerInfo gdi) {
            this.executor = executor;
            this.additionalArgv = additionalArgv;
            this.listener = listener;
            this.exec32 = exec32;
            this.shortNames = shortNames;
            this.gdbInitFile = gdbInitFile;
            this.host = host;
            this.connectExisting = connectExisting;
            this.runDir = runDir;
            this.ndi = gdi;
        }

        private Gdb getGdb(Factory factory, boolean connectExisting, boolean remote) {
            return new Gdb(factory, connectExisting, remote);
        }

        public boolean connectExisting() {
            return this.connectExisting;
        }

        public void start() {
            if (Log.Start.debug) {
                System.out.printf("Gdb.Factory.start() on thread %s\n", Thread.currentThread());
            }
            if (this.executor != null) assert (this.executor.host() == this.host);
            this.remote = this.host.isRemote();
            this.tentativeGdb = this.getGdb(this, this.connectExisting, this.host.isRemote());
            String hostName = null;
            if (this.remote) {
                hostName = this.host.getHostName();
            }
            this.tentativeGdb.startProgressManager().startProgress(null, this.shortNames, hostName);
            this.tentativeGdb.startProgressManager().setCancelListener();
            this.tentativeGdb.startProgressManager().updateProgress('>', 1, Catalog.get("StartingGdb"), 0, 0);
            this.ioPack = IOPack.create((boolean)this.remote, (NativeDebuggerInfo)this.ndi, (Executor)this.executor);
            this.tentativeGdb.setIOPack(this.ioPack);
            this.listener.assignIOPack(this.ioPack);
            if (Log.Startup.nopty) {
                // empty if block
            }
            this.START_RP.post(new Runnable(){

                public void run() {
                    Factory.this.startAsync();
                }
            });
        }

        private void startAsync() {
            if (!this.connectExisting) {
                this.gdbname = NativeDebuggerImpl.getDebuggerString((MakeConfiguration)((MakeConfiguration)this.ndi.getConfiguration()));
                if (this.gdbname == null) {
                    this.listener.connectFailed("gdb", Catalog.get("MSG_NoGgb"), null);
                    return;
                }
            }
            boolean havePio = false;
            if (!this.connectExisting) {
                havePio = this.ioPack.start();
            }
            if (!havePio) {
                // empty if block
            }
            if (!this.connectExisting) {
                ArrayList<String> avec = new ArrayList<String>();
                boolean use_ss_attach = false;
                if (Log.Start.capture_engine_startup) {
                    use_ss_attach = true;
                }
                if (use_ss_attach) {
                    avec.add("ss_attach");
                    avec.add("-v");
                    avec.add(this.gdbname);
                    this.gdbname = "ss_attach";
                } else {
                    avec.add(this.gdbname);
                }
                if (this.gdbInitFile != null) {
                    avec.add("-x");
                    avec.add(this.gdbInitFile);
                }
                avec.add("--interpreter");
                avec.add("mi");
                if (this.gdbInitFile != null) {
                    // empty if block
                }
                boolean ioInWindow = true;
                if (this.ioPack.getSlaveName() != null && ioInWindow) {
                    avec.add("-tty");
                    avec.add(this.ioPack.getSlaveName());
                }
                if (this.additionalArgv != null) {
                    for (int i = 1; i < this.additionalArgv.length; ++i) {
                        avec.add(this.additionalArgv[i]);
                    }
                }
                this.gdb_argv = new String[avec.size()];
                for (int vx = 0; vx < avec.size(); ++vx) {
                    this.gdb_argv[vx] = (String)avec.get(vx);
                }
                if (Log.Start.debug) {
                    System.out.printf("gdb being started with:\n", new Object[0]);
                    for (String arg : this.gdb_argv) {
                        System.out.printf("\t'%s'\n", arg);
                    }
                }
            }
            this.additionalEnv = new HashMap<String, String>();
            int pid = 0;
            if (!this.connectExisting) {
                this.ioPack.console().getTerm().pushStream((TermStream)this.tentativeGdb.tap());
                this.ioPack.console().getTerm().setCustomColor(0, Color.yellow.darker().darker());
                this.ioPack.console().getTerm().setCustomColor(1, Color.green.darker());
                this.ioPack.console().getTerm().setCustomColor(2, Color.red.darker());
                Map env = null;
                if (!this.executor.isRemote() && Utilities.isWindows()) {
                    env = this.ndi.getProfile().getEnvironment().getenvAsMap();
                }
                pid = this.executor.startEngine(this.gdbname, this.gdb_argv, env, this.runDir, this.ioPack.console(), false, false);
                if (Log.Start.debug) {
                    System.out.printf("CommonGdb.Factory.start(): startEngine -> pid %d\n", pid);
                }
                if (pid == 0) {
                    this.tentativeGdb.startProgressManager().finishProgress();
                    this.listener.connectFailed("gdb", this.executor.getStartError(), null);
                    return;
                }
                this.tentativeGdb.setExecutor(this.executor);
            }
            if (Log.Startup.nopty) {
                // empty if block
            }
            if (Log.Start.debug) {
                System.out.printf("CommonGdb.Factory.start(): remote %s\n", this.remote);
            }
            String hostName = null;
            if (this.remote) {
                hostName = this.host.getHostName();
            }
            this.tentativeGdb.startProgressManager().updateProgress('<', 1, null, 0, 0);
        }

        private void cancelStartup() {
        }

        private void connectionAvailable(boolean success, String version, FileMapper fmap) {
            this.tentativeGdb.startProgressManager().updateProgress('<', 1, null, 0, 0);
            this.cancelStartup();
            if (success) {
                this.listener.assignGdb(this.tentativeGdb);
                this.tentativeGdb.initializeGdb(version, fmap);
            }
        }

        public static interface Listener {
            public void connectFailed(String var1, String var2, IOPack var3);

            public void assignGdb(Gdb var1);

            public void assignIOPack(IOPack var1);
        }
    }

    protected class StartProgressManager
    extends ProgressManager {
        private final String[] levelLabels = new String[]{"", ""};

        protected String[] levelLabels() {
            return this.levelLabels;
        }

        void setCancelListener() {
            super.setCancelListener(Gdb.this.cancelListener);
        }

        void clearCancelListener() {
            super.setCancelListener(null);
        }

        public void startProgress(final PhasedProgress.CancelListener cancelListener, final boolean shortNames, final String hostname) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (StartProgressManager.super.startProgress(cancelListener, shortNames)) {
                        StartProgressManager.this.phasedProgress().setCancelMsg(Catalog.get("CancelNoted"));
                        String msg = hostname != null ? MessageFormat.format(Catalog.get("StartingDbgOn"), hostname) : Catalog.get("StartingDbg");
                        StartProgressManager.this.phasedProgress().setMessageFor(0, msg, 0);
                        StartProgressManager.this.phasedProgress().setVisible(true);
                    }
                }
            });
        }

        public void finishProgress() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StartProgressManager.super.finishProgress();
                }
            });
            StatusDisplayer.getDefault().setStatusText("");
        }

        public void updateProgress(final char beginEnd, final int level, final String message, final int count, final int total) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StartProgressManager.super.updateProgress(beginEnd, level, message, count, total);
                }
            });
            StatusDisplayer.getDefault().setStatusText(message);
        }
    }
}

