/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai.spi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.JLabel;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiProject;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class KenaiAccessor {
    public static final String PROP_LOGIN = "kenai.login.changed";

    public KenaiAccessor() {
        WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)new ActivatedTCListener());
    }

    public abstract KenaiProject[] getDashboardProjects();

    public abstract KenaiProject getKenaiProjectForRepository(String var1) throws IOException;

    public abstract KenaiProject getKenaiProject(String var1, String var2) throws IOException;

    public abstract boolean isLoggedIn(String var1);

    public abstract boolean showLogin();

    public abstract Collection<RepositoryUser> getProjectMembers(KenaiProject var1) throws IOException;

    public abstract PasswordAuthentication getPasswordAuthentication(String var1, boolean var2);

    public abstract JLabel createUserWidget(String var1, String var2, String var3);

    public abstract boolean isNetbeansKenaiRegistered();

    public abstract OwnerInfo getOwnerInfo(File var1);

    public abstract OwnerInfo getOwnerInfo(Node var1);

    public abstract void logKenaiUsage(Object ... var1);

    public abstract void addPropertyChangeListener(PropertyChangeListener var1, String var2);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1, String var2);

    private class ActivatedTCListener
    implements PropertyChangeListener {
        private ActivatedTCListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
            if ("activated".equals(evt.getPropertyName())) {
                TopComponent tc = registry.getActivated();
                BugtrackingManager.LOG.log(Level.FINER, "activated TC : {0}", tc);
                if (tc instanceof QueryTopComponent) {
                    QueryTopComponent qtc = (QueryTopComponent)tc;
                    Query query = qtc.getQuery();
                    if (query == null) {
                        return;
                    }
                    Repository repository = query.getRepository();
                    if (repository == null) {
                        return;
                    }
                    KenaiSupport support = (KenaiSupport)repository.getLookup().lookup(KenaiSupport.class);
                    if (support == null || query != support.getAllIssuesQuery(repository)) {
                        return;
                    }
                    KenaiProject kenaiProject = (KenaiProject)repository.getLookup().lookup(KenaiProject.class);
                    if (kenaiProject == null) {
                        return;
                    }
                    kenaiProject.fireQueryActivated(query);
                }
            }
        }
    }
}

