/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.Timer;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.search.PopupItem;

public final class ResultsModel
extends AbstractListModel
implements ActionListener {
    private static ResultsModel instance;
    private List<PopupItem> results;
    private Timer fireTimer;
    static final int COALESCE_TIME = 200;
    private Map<Repository, Set<Issue>> issuesCached = new HashMap<Repository, Set<Issue>>();

    private ResultsModel() {
    }

    public static ResultsModel getInstance() {
        if (instance == null) {
            instance = new ResultsModel();
        }
        return instance;
    }

    void setContent(List<PopupItem> results) {
        this.results = results;
        this.maybeFireChanges();
    }

    synchronized void cacheIssues(Repository repo, Issue[] issues) {
        HashSet<Issue> s = new HashSet<Issue>();
        for (Issue issue : issues) {
            assert (issue != null);
            s.add(issue);
        }
        this.issuesCached.put(repo, s);
    }

    synchronized Issue[] getCachedIssues(Repository repo) {
        Set<Issue> s;
        if (this.issuesCached != null && (s = this.issuesCached.get(repo)) != null) {
            return s.toArray(new Issue[s.size()]);
        }
        return new Issue[0];
    }

    @Override
    public int getSize() {
        if (this.results == null) {
            return 0;
        }
        return this.results.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (this.results == null) {
            return null;
        }
        return this.results.get(index);
    }

    private void maybeFireChanges() {
        if (this.fireTimer == null) {
            this.fireTimer = new Timer(200, this);
        }
        if (!this.fireTimer.isRunning()) {
            this.fireTimer.start();
        } else {
            this.fireTimer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireTimer.stop();
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

