/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.contextmenu;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.contextmenu.ContextMenu;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class ContextMenuRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ContextMenu menu = (ContextMenu)component;
        this.encodeMarkup(facesContext, menu);
        this.encodeScript(facesContext, menu);
    }

    protected void encodeScript(FacesContext facesContext, ContextMenu menu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)menu);
        String clientId = menu.getClientId(facesContext);
        String trigger = this.findTrigger(facesContext, menu);
        writer.startElement("script", (UIComponent)menu);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(var + " = new PrimeFaces.widget.ContextMenu('" + clientId + "',");
        writer.write("{trigger:" + trigger + "});");
        this.encodeMenuitems(facesContext, menu, var);
        writer.write(var + ".render(document.body);");
        writer.endElement("script");
    }

    protected String findTrigger(FacesContext facesContext, ContextMenu menu) {
        String trigger = null;
        String _for = menu.getFor();
        if (_for != null) {
            UIComponent forComponent = menu.findComponent(_for);
            if (forComponent == null) {
                throw new FacesException("Cannot find component '" + _for + "' in view.");
            }
            if (forComponent instanceof DataTable) {
                return this.createUniqueWidgetVar(facesContext, forComponent) + ".getTbodyEl()";
            }
            return "'" + forComponent.getClientId(facesContext) + "'";
        }
        trigger = "document";
        return trigger;
    }

    protected void encodeMenuitems(FacesContext facesContext, ContextMenu menu, String var) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean firstMenuitem = true;
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)menu);
        writer.write(var + ".addItems([");
        for (UIComponent child : menu.getChildren()) {
            if (!(child instanceof MenuItem) || !child.isRendered()) continue;
            MenuItem item = (MenuItem)child;
            String menuItemClientId = item.getClientId(facesContext);
            String onclick = item.getOnclick();
            if (!firstMenuitem) {
                writer.write(",");
            } else {
                firstMenuitem = false;
            }
            writer.write("{");
            writer.write("text:'" + (String)item.getValue() + "'");
            if (item.getUrl() != null) {
                writer.write(",url:'" + this.getResourceURL(facesContext, item.getUrl() + "'"));
                if (item.getTarget() != null) {
                    writer.write(",target:'" + item.getTarget() + "'");
                }
                if (onclick != null) {
                    writer.write(",onclick:{fn:function() {" + onclick + "}}");
                }
            } else {
                if (form == null) {
                    throw new FacesException("ContextMenu : '" + menu.getClientId(facesContext) + "' must be inside a form element");
                }
                String formClientId = form.getClientId(facesContext);
                String command = item.isAjax() ? this.buildAjaxRequest(facesContext, item, formClientId, menuItemClientId) : this.buildNonAjaxRequest(facesContext, (UIComponent)item, formClientId, menuItemClientId);
                command = onclick == null ? command : onclick + ";" + command;
                writer.write(",onclick:{fn: function() {" + command + "}}");
            }
            writer.write("}");
        }
        writer.write("]);");
    }

    protected void encodeMarkup(FacesContext facesContext, ContextMenu menu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)menu.getClientId(facesContext), "id");
        if (menu.getStyle() != null) {
            writer.writeAttribute("style", (Object)menu.getStyle(), "style");
        }
        if (menu.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)menu.getStyle(), "styleClass");
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

