/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dnd;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dashboard.Dashboard;
import org.primefaces.component.dnd.Draggable;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class DraggableRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Draggable draggable = (Draggable)component;
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)draggable);
        String clientId = draggable.getClientId(facesContext);
        String target = this.findTarget(facesContext, draggable);
        String dashboard = draggable.getDashboard();
        writer.startElement("script", (UIComponent)draggable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function() {");
        writer.write(var + " = new PrimeFaces.widget.Draggable('" + clientId + "',");
        writer.write("{");
        writer.write("target:'" + target + "'");
        writer.write(",cursor:'" + draggable.getCursor() + "'");
        if (draggable.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (draggable.getAxis() != null) {
            writer.write(",axis:'" + draggable.getAxis() + "'");
        }
        if (draggable.getContainment() != null) {
            writer.write(",containment:'" + draggable.getContainment() + "'");
        }
        if (draggable.getHelper() != null) {
            writer.write(",helper:'" + draggable.getHelper() + "'");
        }
        if (draggable.isRevert()) {
            writer.write(",revert:'invalid'");
        }
        if (draggable.getZindex() != -1) {
            writer.write(",zIndex:" + draggable.getZindex());
        }
        if (draggable.getHandle() != null) {
            writer.write(",handle:'" + draggable.getHandle() + "'");
        }
        if (draggable.getOpacity() != 1.0) {
            writer.write(",opacity:" + draggable.getOpacity());
        }
        if (draggable.getStack() != null) {
            writer.write(",stack:'" + draggable.getStack() + "'");
        }
        if (draggable.getGrid() != null) {
            writer.write(",grid:[" + draggable.getGrid() + "]");
        }
        if (draggable.getScope() != null) {
            writer.write(",scope:'" + draggable.getScope() + "'");
        }
        if (draggable.isSnap()) {
            writer.write(",snap:true");
            writer.write(",snapTolerance:" + draggable.getSnapTolerance());
            if (draggable.getSnapMode() != null) {
                writer.write(",snapMode:'" + draggable.getSnapMode() + "'");
            }
        }
        if (dashboard != null) {
            Dashboard db = (Dashboard)draggable.findComponent(dashboard);
            if (db == null) {
                throw new FacesException("Cannot find dashboard \"" + dashboard + "\" in view");
            }
            writer.write(",connectToSortable:'" + ComponentUtils.escapeJQueryId(db.getClientId(facesContext)) + " .ui-dashboard-column'");
        }
        writer.write("});");
        writer.write("});");
        writer.endElement("script");
    }

    protected String findTarget(FacesContext facesContext, Draggable draggable) {
        String _for = draggable.getFor();
        if (_for != null) {
            UIComponent component = draggable.findComponent(_for);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return component.getClientId(facesContext);
        }
        return draggable.getParent().getClientId(facesContext);
    }
}

