/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dnd;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dnd.Droppable;
import org.primefaces.event.DragDropEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class DroppableRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Droppable droppable;
        String clientId;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId = (droppable = (Droppable)component).getClientId(facesContext))) {
            String dragId = (String)params.get(clientId + "_dragId");
            String dropId = (String)params.get(clientId + "_dropId");
            droppable.queueEvent(new DragDropEvent((UIComponent)droppable, dragId, dropId));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Droppable droppable = (Droppable)component;
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)droppable);
        String target = this.findTarget(facesContext, droppable).getClientId(facesContext);
        String clientId = droppable.getClientId(facesContext);
        String onDropUpdate = droppable.getOnDropUpdate();
        writer.startElement("script", (UIComponent)droppable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(var + " = new PrimeFaces.widget.Droppable('" + clientId + "', {");
        writer.write("target:'" + target + "'");
        if (droppable.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (droppable.getHoverStyleClass() != null) {
            writer.write(",hoverClass:'" + droppable.getHoverStyleClass() + "'");
        }
        if (droppable.getActiveStyleClass() != null) {
            writer.write(",activeClass:'" + droppable.getActiveStyleClass() + "'");
        }
        if (droppable.getOnDrop() != null) {
            writer.write(",onDrop:" + droppable.getOnDrop());
        }
        if (droppable.getAccept() != null) {
            writer.write(",accept:'" + droppable.getAccept() + "'");
        }
        if (droppable.getScope() != null) {
            writer.write(",scope:'" + droppable.getScope() + "'");
        }
        if (droppable.getTolerance() != null) {
            writer.write(",tolerance:'" + droppable.getTolerance() + "'");
        }
        if (droppable.getDropListener() != null && onDropUpdate != null) {
            UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)droppable);
            if (form == null) {
                throw new FacesException("Droppable: '" + clientId + "' must be inside a form");
            }
            writer.write(",ajaxDrop:true");
            writer.write(",url:'" + this.getActionURL(facesContext) + "'");
            writer.write(",formId:'" + form.getClientId(facesContext) + "'");
            if (onDropUpdate != null) {
                writer.write(",onDropUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)droppable, onDropUpdate) + "'");
            }
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected UIComponent findTarget(FacesContext facesContext, Droppable droppable) {
        String _for = droppable.getFor();
        if (_for != null) {
            UIComponent component = droppable.findComponent(_for);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return component;
        }
        return droppable.getParent();
    }
}

