/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.layout;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.layout.Layout;
import org.primefaces.component.layout.LayoutUnit;
import org.primefaces.event.CloseEvent;
import org.primefaces.event.ResizeEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.model.Visibility;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class LayoutRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        String clientId;
        Layout layout = (Layout)component;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey((clientId = layout.getClientId(facesContext)) + "_toggled")) {
            boolean collapsed = Boolean.valueOf((String)params.get(clientId + "_collapsed"));
            LayoutUnit unit = layout.getLayoutUnitByPosition((String)params.get(clientId + "_unit"));
            Visibility visibility = collapsed ? Visibility.HIDDEN : Visibility.VISIBLE;
            unit.setCollapsed(collapsed);
            layout.queueEvent(new ToggleEvent((UIComponent)unit, visibility));
        }
        if (params.containsKey(clientId + "_closed")) {
            LayoutUnit unit = layout.getLayoutUnitByPosition((String)params.get(clientId + "_unit"));
            unit.setVisible(false);
            layout.queueEvent(new CloseEvent((UIComponent)unit));
        }
        if (params.containsKey(clientId + "_resized")) {
            LayoutUnit unit = layout.getLayoutUnitByPosition((String)params.get(clientId + "_unit"));
            int width = Integer.valueOf((String)params.get(clientId + "_unitWidth"));
            int height = Integer.valueOf((String)params.get(clientId + "_unitHeight"));
            unit.setWidth(width);
            unit.setHeight(height);
            layout.queueEvent(new ResizeEvent((UIComponent)unit, width, height));
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Layout layout = (Layout)component;
        String clientId = layout.getClientId(facesContext);
        if (!layout.isFullPage()) {
            writer.startElement("div", (UIComponent)layout);
            writer.writeAttribute("id", (Object)clientId, "id");
            if (layout.getStyle() != null) {
                writer.writeAttribute("style", (Object)layout.getStyle(), "style");
            }
            if (layout.getStyleClass() != null) {
                writer.writeAttribute("class", (Object)layout.getStyleClass(), "styleClass");
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Layout layout = (Layout)component;
        if (!layout.isFullPage()) {
            writer.endElement("div");
        }
        this.encodeScript(facesContext, layout);
    }

    protected void encodeScript(FacesContext facesContext, Layout layout) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = layout.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)layout);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (layout.isFullPage()) {
            writer.write(var + " = new PrimeFaces.widget.Layout({");
        } else {
            writer.write(var + " = new PrimeFaces.widget.Layout('" + clientId + "', {");
        }
        this.encodeUnits(facesContext, layout);
        this.encodeAjaxEventListeners(facesContext, layout);
        writer.write(",url:'" + this.getActionURL(facesContext) + "'");
        if (layout.isFullPage()) {
            writer.write(",clientId:'" + clientId + "'");
        }
        if (layout.getCloseTitle() != null) {
            writer.write(",closeTitle:'" + layout.getCloseTitle() + "'");
        }
        if (layout.getCollapseTitle() != null) {
            writer.write(",collapseTitle:'" + layout.getCollapseTitle() + "'");
        }
        if (layout.getExpandTitle() != null) {
            writer.write(",expandTitle:'" + layout.getExpandTitle() + "'");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeAjaxEventListeners(FacesContext facesContext, Layout layout) throws IOException {
        this.encodeAjaxEventListener(facesContext, layout, "onToggleUpdate", layout.getOnToggleUpdate(), "ajaxToggle", "onToggleComplete", layout.getOnToggleComplete());
        this.encodeAjaxEventListener(facesContext, layout, "onCloseUpdate", layout.getOnCloseUpdate(), "ajaxClose", "onCloseComplete", layout.getOnCloseComplete());
        this.encodeAjaxEventListener(facesContext, layout, "onResizeUpdate", layout.getOnResizeUpdate(), "ajaxResize", "onResizeComplete", layout.getOnResizeComplete());
    }

    protected void encodeAjaxEventListener(FacesContext facesContext, Layout layout, String updateParam, String update, String ajaxEventParam, String callbackName, String callback) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("," + ajaxEventParam + ":true");
        if (update != null) {
            writer.write("," + updateParam + ":'" + ComponentUtils.findClientIds(facesContext, (UIComponent)layout, update) + "'");
        }
        if (callback != null) {
            writer.write("," + callbackName + ":function(xhr, status, args) {" + callback + ";}");
        }
    }

    protected void encodeUnits(FacesContext facesContext, Layout layout) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("units:[");
        boolean firstUnitWritten = false;
        for (UIComponent child : layout.getChildren()) {
            if (!child.isRendered() || !(child instanceof LayoutUnit)) continue;
            LayoutUnit unit = (LayoutUnit)child;
            if (firstUnitWritten) {
                writer.write(",");
            } else {
                firstUnitWritten = true;
            }
            writer.write("{position:'" + unit.getPosition() + "'");
            writer.write(",body:'" + unit.getClientId(facesContext) + "'");
            writer.write(",gutter:'" + unit.getGutter() + "'");
            writer.write(",close:" + unit.isClosable());
            writer.write(",resize:" + unit.isResizable());
            writer.write(",collapse:" + unit.isCollapsible());
            writer.write(",visible:" + unit.isVisible());
            writer.write(",collapsed:" + unit.isCollapsed());
            if (unit.getScrollable() != null) {
                writer.write(",scroll:" + unit.getScrollable());
            }
            if (unit.getWidth() != -1) {
                writer.write(",width:" + unit.getWidth());
            }
            if (unit.getHeight() != -1) {
                writer.write(",height:" + unit.getHeight());
            }
            if (unit.getMinWidth() != -1) {
                writer.write(",minWidth:" + unit.getMinWidth());
            }
            if (unit.getMinHeight() != -1) {
                writer.write(",minHeight:" + unit.getMinHeight());
            }
            if (unit.getMaxWidth() != -1) {
                writer.write(",maxWidth:" + unit.getMaxWidth());
            }
            if (unit.getMaxHeight() != -1) {
                writer.write(",maxHeight:" + unit.getMaxHeight());
            }
            if (unit.getHeader() != null) {
                writer.write(",header:'" + unit.getHeader() + "'");
            }
            if (unit.getFooter() != null) {
                writer.write(",footer:'" + unit.getFooter() + "'");
            }
            if (unit.getZindex() != -1) {
                writer.write(",zIndex:" + unit.getZindex());
            }
            if (!unit.isProxyResize()) {
                writer.write(",proxy:false");
            }
            if (unit.getCollapseSize() != -1) {
                writer.write(",collapseSize:" + unit.getCollapseSize());
            }
            writer.write("}");
        }
        writer.write("]");
    }
}

