/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.linkbutton;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.linkbutton.LinkButton;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;

public class LinkButtonRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        LinkButton button = (LinkButton)component;
        this.encodeMarkup(facesContext, button);
        this.encodeScript(facesContext, button);
    }

    protected void encodeMarkup(FacesContext facesContext, LinkButton button) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = button.getClientId(facesContext);
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        if (button.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)button.getStyleClass(), "styleClass");
        }
        this.renderPassThruAttributes(facesContext, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        writer.writeAttribute("onclick", (Object)("window.location='" + button.getHref() + "'"), null);
        if (button.getValue() != null) {
            writer.write(button.getValue().toString());
        }
        writer.endElement("button");
    }

    protected void encodeScript(FacesContext facesContext, LinkButton button) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = button.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)button);
        boolean hasValue = button.getValue() != null;
        writer.startElement("script", (UIComponent)button);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.LinkButton('" + clientId + "', {");
        if (button.getImage() != null) {
            writer.write("text:" + hasValue);
            writer.write(",icons:{");
            writer.write("primary:'" + button.getImage() + "'");
            writer.write("}");
        }
        writer.write("});");
        writer.endElement("script");
    }
}

