/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menubutton;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menubutton.MenuButton;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class MenuButtonRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        MenuButton button = (MenuButton)component;
        if (button.shouldBuildFromModel()) {
            button.buildMenuFromModel();
        }
        this.encodeMarkup(facesContext, button);
        this.encodeScript(facesContext, button);
    }

    protected void encodeMarkup(FacesContext facesContext, MenuButton button) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = button.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)button);
        String buttonId = clientId + "_button";
        writer.startElement("span", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (button.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)button.getStyleClass(), "class");
        }
        if (button.getStyle() != null) {
            writer.writeAttribute("style", (Object)button.getStyle(), "style");
        }
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)buttonId, null);
        writer.writeAttribute("name", (Object)buttonId, null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("onclick", (Object)(widgetVar + ".showMenu()"), null);
        if (button.getValue() != null) {
            writer.write(button.getValue());
        }
        writer.endElement("button");
        writer.startElement("span", (UIComponent)button);
        writer.writeAttribute("id", (Object)(clientId + "_menuContainer"), "id");
        writer.endElement("span");
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext facesContext, MenuButton button) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = button.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)button);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)button);
        if (form == null) {
            throw new FacesException("MenuButton : \"" + clientId + "\" must be inside a form element");
        }
        String formClientId = form.getClientId(facesContext);
        writer.startElement("script", (UIComponent)button);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(var + " = new PrimeFaces.widget.MenuButton('" + clientId + "', {");
        boolean firstItem = true;
        writer.write("items:[");
        for (UIComponent child : button.getChildren()) {
            if (!(child instanceof MenuItem) || !child.isRendered()) continue;
            MenuItem item = (MenuItem)child;
            String itemClientId = item.getClientId(facesContext);
            if (!firstItem) {
                writer.write(",");
            } else {
                firstItem = false;
            }
            writer.write("{text:'" + item.getValue() + "'");
            if (item.getUrl() != null) {
                writer.write(",url:'" + this.getResourceURL(facesContext, item.getUrl()) + "'");
            } else {
                String onclick;
                String string = onclick = item.isAjax() ? this.buildAjaxRequest(facesContext, item, formClientId, itemClientId) : this.buildNonAjaxRequest(facesContext, (UIComponent)item, formClientId, itemClientId);
                if (item.getOnclick() != null) {
                    onclick = item.getOnclick() + ";" + onclick;
                }
                writer.write(",onclick:{fn:function() {" + onclick + "}}");
            }
            writer.write("}");
        }
        writer.write("]");
        if (button.isDisabled()) {
            writer.write(",disabled:true");
        }
        writer.write("});");
        writer.endElement("script");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

