/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.notificationbar;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.notificationbar.NotificationBar;
import org.primefaces.renderkit.CoreRenderer;

public class NotificationBarRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        NotificationBar bar = (NotificationBar)component;
        this.encodeMarkup(facesContext, bar);
        this.encodeScript(facesContext, bar);
    }

    private void encodeMarkup(FacesContext facesContext, NotificationBar bar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String styleClass = bar.getStyleClass() == null ? "ui-notificationbar" : "ui-notificationbar " + bar.getStyleClass();
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)bar);
        UIComponent close = bar.getFacet("close");
        writer.startElement("div", (UIComponent)bar);
        writer.writeAttribute("id", (Object)bar.getClientId(facesContext), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (bar.getStyle() != null) {
            writer.writeAttribute("style", (Object)bar.getStyle(), null);
        }
        if (close != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-notificationbar-close", null);
            writer.writeAttribute("onclick", (Object)(var + ".hide()"), null);
            this.renderChild(facesContext, close);
            writer.endElement("span");
        }
        this.renderChildren(facesContext, (UIComponent)bar);
        writer.endElement("div");
    }

    private void encodeScript(FacesContext facesContext, NotificationBar bar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = bar.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)bar);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(document).ready(function(){");
        writer.write(var + " = new PrimeFaces.widget.NotificationBar('" + clientId + "',{");
        writer.write("position:'" + bar.getPosition() + "'");
        writer.write(",effect:'" + bar.getEffect() + "'");
        writer.write(",effectSpeed:'" + bar.getEffectSpeed() + "'");
        if (bar.isAutoDisplay()) {
            writer.write(",autoDisplay:true");
        }
        writer.write("});});");
        writer.endElement("script");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

