/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.panel;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.Menu;
import org.primefaces.component.panel.Panel;
import org.primefaces.event.CloseEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.model.Visibility;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class PanelRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        String visibleParam;
        Panel panel = (Panel)component;
        String clientId = panel.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String collapsedParam = (String)params.get(clientId + "_collapsed");
        if (collapsedParam != null) {
            panel.setCollapsed(Boolean.valueOf(collapsedParam));
        }
        if ((visibleParam = (String)params.get(clientId + "_visible")) != null) {
            panel.setVisible(Boolean.valueOf(visibleParam));
        }
        if (params.containsKey(clientId + "_toggled")) {
            boolean collapsed = Boolean.valueOf(collapsedParam);
            panel.setCollapsed(collapsed);
            Visibility visibility = collapsed ? Visibility.HIDDEN : Visibility.VISIBLE;
            panel.queueEvent(new ToggleEvent((UIComponent)panel, visibility));
        }
        if (params.containsKey(clientId + "_closed")) {
            panel.setVisible(false);
            panel.queueEvent(new CloseEvent((UIComponent)panel));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Panel panel = (Panel)component;
        this.encodeMarkup(facesContext, panel);
        this.encodeScript(facesContext, panel);
    }

    protected void encodeScript(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = panel.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)panel);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(var + " = new PrimeFaces.widget.Panel('" + clientId + "', {");
        writer.write("visible:" + panel.isVisible());
        if (panel.isToggleable()) {
            writer.write(",toggleSpeed:" + panel.getToggleSpeed());
            writer.write(",collapsed:" + panel.isCollapsed());
            if (panel.getToggleListener() != null || panel.getOnToggleUpdate() != null) {
                writer.write(",ajaxToggle:true");
                if (panel.getOnToggleUpdate() != null) {
                    writer.write(",onToggleUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)panel, panel.getOnToggleUpdate()) + "'");
                }
            }
        }
        if (panel.isClosable()) {
            writer.write(",closeSpeed:" + panel.getCloseSpeed());
            if (panel.getOnCloseStart() != null) {
                writer.write(",onCloseStart:" + panel.getOnCloseStart());
            }
            if (panel.getOnCloseComplete() != null) {
                writer.write(",onCloseComplete:" + panel.getOnCloseComplete());
            }
            if (panel.getCloseListener() != null || panel.getOnCloseUpdate() != null) {
                writer.write(",ajaxClose:true");
                if (panel.getOnCloseUpdate() != null) {
                    writer.write(",onCloseUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)panel, panel.getOnCloseUpdate()) + "'");
                }
            }
        }
        if (panel.getToggleListener() != null || panel.getCloseListener() != null) {
            writer.write(",url:'" + this.getActionURL(facesContext) + "'");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = panel.getClientId(facesContext);
        Menu optionsMenu = panel.getOptionsMenu();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        String styleClass = panel.getStyleClass() != null ? "ui-panel ui-widget ui-widget-content ui-corner-all " + panel.getStyleClass() : "ui-panel ui-widget ui-widget-content ui-corner-all";
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (panel.getStyle() != null) {
            writer.writeAttribute("style", (Object)panel.getStyle(), "style");
        }
        this.encodeHeader(facesContext, panel);
        this.encodeContent(facesContext, panel);
        this.encodeFooter(facesContext, panel);
        if (panel.isToggleable()) {
            this.encodeStateHolder(facesContext, panel, clientId + "_collapsed", String.valueOf(panel.isCollapsed()));
        }
        if (panel.isClosable()) {
            this.encodeStateHolder(facesContext, panel, clientId + "_visible", String.valueOf(panel.isVisible()));
        }
        if (optionsMenu != null) {
            optionsMenu.setPosition("dynamic");
            optionsMenu.setContext("'" + clientId + "_menu','tl','bl'");
            optionsMenu.encodeAll(facesContext);
        }
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)panel);
        UIComponent header = panel.getFacet("header");
        String headerText = panel.getHeader();
        String clientId = panel.getClientId(facesContext);
        if (headerText == null && header == null) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId(facesContext) + "_header"), null);
        writer.writeAttribute("class", (Object)"ui-panel-titlebar ui-widget-header ui-corner-all ui-helper-clearfix", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-panel-title", null);
        if (header != null) {
            this.renderChild(facesContext, header);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        writer.endElement("span");
        if (panel.isClosable()) {
            this.encodeIcon(facesContext, panel, "ui-icon-closethick", widgetVar + ".close()", clientId + "_closer");
        }
        if (panel.isToggleable()) {
            String icon = panel.isCollapsed() ? "ui-icon-plusthick" : "ui-icon-minusthick";
            this.encodeIcon(facesContext, panel, icon, widgetVar + ".toggle()", clientId + "_toggler");
        }
        if (panel.getOptionsMenu() != null) {
            String menuVar = this.createUniqueWidgetVar(facesContext, (UIComponent)panel.getOptionsMenu());
            this.encodeIcon(facesContext, panel, "ui-icon-gear", menuVar + ".show()", clientId + "_menu");
        }
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId(facesContext) + "_content"), null);
        writer.writeAttribute("class", (Object)"ui-panel-content ui-widget-content", null);
        if (panel.isCollapsed()) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        this.renderChildren(facesContext, (UIComponent)panel);
        writer.endElement("div");
    }

    protected void encodeFooter(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent footer = panel.getFacet("footer");
        String footerText = panel.getFooter();
        if (footer != null || footerText != null) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(panel.getClientId(facesContext) + "_footer"), null);
            writer.writeAttribute("class", (Object)"ui-panel-footer ui-widget-content", null);
            if (footer != null) {
                this.renderChild(facesContext, footer);
            } else if (footerText != null) {
                writer.write(footerText);
            }
            writer.endElement("div");
        }
    }

    protected void encodeIcon(FacesContext facesContext, Panel panel, String iconClass, String onclick, String id) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String hover = "jQuery(this).toggleClass('ui-state-hover')";
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"javascript:void(0)", null);
        writer.writeAttribute("class", (Object)"ui-panel-titlebar-icon ui-corner-all ui-state-default", null);
        writer.writeAttribute("onmouseover", (Object)hover, null);
        writer.writeAttribute("onmouseout", (Object)hover, null);
        writer.startElement("span", null);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        writer.writeAttribute("class", (Object)("ui-icon " + iconClass), null);
        writer.writeAttribute("onclick", (Object)onclick, null);
        writer.endElement("span");
        writer.endElement("a");
    }

    protected void encodeOptionsControl(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = panel.getClientId(facesContext);
        String menuVar = this.createUniqueWidgetVar(facesContext, (UIComponent)panel.getOptionsMenu());
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_menu"), null);
        writer.writeAttribute("class", (Object)"pf-panel-options", null);
        writer.writeAttribute("onclick", (Object)(menuVar + ".show()"), null);
        writer.endElement("span");
    }

    protected void encodeStateHolder(FacesContext facesContext, Panel panel, String name, String value) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

