/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.poll;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.poll.Poll;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class PollRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Poll poll = (Poll)component;
        if (facesContext.getExternalContext().getRequestParameterMap().containsKey(poll.getClientId(facesContext))) {
            poll.queueEvent((FacesEvent)new ActionEvent((UIComponent)poll));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Poll poll = (Poll)component;
        String pollVar = this.createUniqueWidgetVar(facesContext, (UIComponent)poll);
        String clientId = poll.getClientId(facesContext);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)poll);
        if (form == null) {
            throw new FacesException("Poll:" + clientId + " needs to be enclosed in a form component");
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("YAHOO.util.Event.addListener(window, 'load', function() {");
        writer.write(pollVar + "= new PrimeFaces.widget.Poll('" + clientId + "', {");
        writer.write("frequency:" + poll.getInterval());
        writer.write(",autoStart:" + poll.isAutoStart());
        writer.write(",fn: function() {");
        writer.write(this.buildAjaxRequest(facesContext, poll, form.getClientId(facesContext), clientId));
        writer.write("}");
        writer.write("});});");
        writer.endElement("script");
    }
}

